/*
 * Decompiled with CFR 0.152.
 */
package com.swimap.iview.templates.textfield.ipaddress;

import java.util.StringTokenizer;

public class IPAddressUtil {
    public static boolean isValidIP(String string) {
        if (string == null || "".equals(string)) {
            return false;
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string, ".");
        int n = stringTokenizer.countTokens();
        if (n != 4) {
            return false;
        }
        while (stringTokenizer.hasMoreTokens()) {
            String string2 = stringTokenizer.nextToken();
            if (string2 != null && !"".equals(string2.trim())) continue;
            return false;
        }
        return true;
    }

    public static boolean isValidSubMask(String string) {
        int n = IPAddressUtil.translateIPtoInt(string);
        int n2 = 1;
        boolean bl = false;
        for (int i = 0; i < 32; ++i) {
            if ((n & n2) != 0) {
                if (!bl) {
                    bl = true;
                }
            } else if (bl) {
                return false;
            }
            n2 <<= 1;
        }
        return true;
    }

    public static boolean isValidIP(String string, String string2) {
        StringTokenizer stringTokenizer = new StringTokenizer(string, ".");
        String string3 = stringTokenizer.nextToken().trim();
        int n = Integer.parseInt(string3);
        return n != 127 && n < 224 && n != 0;
    }

    public static int translateIPtoInt(String string) {
        int n = 0;
        StringTokenizer stringTokenizer = new StringTokenizer(string, ".");
        int n2 = stringTokenizer.countTokens();
        for (int i = 0; i < n2; ++i) {
            String string2 = stringTokenizer.nextToken().trim();
            n |= Integer.parseInt(string2);
            if (i == n2 - 1) break;
            n <<= 8;
        }
        return n;
    }

    public static String translateIntToIP(int n) {
        int[] nArray = new int[]{-16777216, 0xFF0000, 65280, 255};
        StringBuffer stringBuffer = new StringBuffer(10);
        for (int i = 0; i < 4; ++i) {
            int n2 = n & nArray[i];
            stringBuffer.append(n2 >>>= 8 * (3 - i));
            if (i == 3) break;
            stringBuffer.append(".");
        }
        return stringBuffer.toString();
    }

    public static long translateIPtoLong(String string) {
        long l = 0L;
        StringTokenizer stringTokenizer = new StringTokenizer(string, ".");
        int n = stringTokenizer.countTokens();
        for (int i = 0; i < n; ++i) {
            String string2 = stringTokenizer.nextToken().trim();
            l |= (long)Integer.parseInt(string2);
            if (i == n - 1) break;
            l <<= 8;
        }
        return l;
    }

    public static String translateLongToIP(long l) {
        long[] lArray = new long[]{-16777216L, 0xFF0000L, 65280L, 255L};
        StringBuffer stringBuffer = new StringBuffer(10);
        for (int i = 0; i < 4; ++i) {
            long l2 = l & lArray[i];
            stringBuffer.append(l2 >>>= 8 * (3 - i));
            if (i == 3) break;
            stringBuffer.append(".");
        }
        return stringBuffer.toString();
    }

    public static String calculateStartIP(String string, String string2) {
        int n = IPAddressUtil.translateIPtoInt(string);
        int n2 = IPAddressUtil.translateIPtoInt(string2);
        return IPAddressUtil.translateIntToIP(n &= n2);
    }

    public static String calculateEndIP(String string, String string2) {
        int n = IPAddressUtil.translateIPtoInt(string);
        int n2 = IPAddressUtil.translateIPtoInt(string2);
        int n3 = n & n2 | ~n2;
        return IPAddressUtil.translateIntToIP(n3);
    }

    public static boolean verifyIPSeg(String string, String string2, String string3) {
        int n = IPAddressUtil.translateIPtoInt(string);
        int n2 = IPAddressUtil.translateIPtoInt(string2);
        int n3 = IPAddressUtil.translateIPtoInt(string3);
        return (n & n3) == (n2 & n3);
    }

    public static String convertIPAddress(String string) {
        StringTokenizer stringTokenizer = new StringTokenizer(string, ".");
        StringBuffer stringBuffer = new StringBuffer(8);
        while (stringTokenizer.hasMoreTokens()) {
            String string2 = stringTokenizer.nextToken();
            stringBuffer.append(string2.trim());
            stringBuffer.append(".");
        }
        return stringBuffer.toString().substring(0, stringBuffer.toString().length() - 1);
    }
}

