/*
 * Decompiled with CFR 0.152.
 */
package com.swimap.iview.templates.textfield.ipaddress;

import com.swimap.iview.templates.textfield.ipaddress.IPInputDocument;
import com.swimap.iview.templates.textfield.ipaddress.InValideIPAddressException;
import com.swimap.iview.util.log.IviewLogger;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.StringSelection;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.StringTokenizer;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.text.BadLocationException;

public class IPAddressTextField
extends JTextField {
    private static IviewLogger logger = IviewLogger.getLogger(IPAddressTextField.class, "IVIEW");
    private static final int IP_MAX_VALUE = 255;
    private static final String TWO_SPACE = "  ";
    private static final String ONE_SPACE = " ";
    private boolean isBackspace = false;
    private boolean isDelete = false;
    private IPInputDocument doc = new IPInputDocument(this);
    private int caretPositions = -1;
    private boolean isClearOrSet = false;
    private boolean isCellEditor = false;

    public IPAddressTextField() {
        this.setDocument(this.doc);
        this.setName("IPAddressTextField");
        super.setText("   .   .   .   ");
        this.addFocusListener(new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent focusEvent) {
                if ("   .   .   .   ".equals(IPAddressTextField.this.getText())) {
                    IPAddressTextField.this.setCaretPosition(0);
                }
            }
        });
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent mouseEvent) {
                IPAddressTextField.this.selectField(mouseEvent);
            }

            @Override
            public void mousePressed(MouseEvent mouseEvent) {
                if (SwingUtilities.isLeftMouseButton(mouseEvent)) {
                    IPAddressTextField.this.setCaretPositionAgain(IPAddressTextField.this.getCaretPosition());
                }
                IPAddressTextField.this.selectField(mouseEvent);
            }
        });
        this.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent keyEvent) {
                if (keyEvent.getKeyCode() == 39) {
                    IPAddressTextField.this.doc.processRIGHTKey(keyEvent);
                }
            }
        });
    }

    private void selectField(MouseEvent mouseEvent) {
        if (SwingUtilities.isLeftMouseButton(mouseEvent)) {
            if (mouseEvent.getClickCount() == 1) {
                this.caretPositions = this.getCaretPosition();
            } else if (mouseEvent.getClickCount() == 2) {
                int n = 0;
                int n2 = 0;
                if (this.caretPositions >= 0 && this.caretPositions <= 3) {
                    n = 0;
                    n2 = 3;
                } else if (this.caretPositions >= 4 && this.caretPositions <= 7) {
                    n = 4;
                    n2 = 7;
                } else if (this.caretPositions >= 8 && this.caretPositions <= 11) {
                    n = 8;
                    n2 = 11;
                } else if (this.caretPositions >= 12 && this.caretPositions <= 15) {
                    n = 12;
                    n2 = 15;
                }
                this.selectField(n, n2);
            }
        }
    }

    final void selectField(int n, int n2) {
        try {
            String string = this.getText(n, n2 - n);
            if (string != null) {
                n2 = n + string.trim().length();
            }
        }
        catch (BadLocationException badLocationException) {
            logger.trace(badLocationException.getMessage(), badLocationException);
        }
        this.setSelectionStart(n);
        this.setSelectionEnd(n2);
    }

    private void setCaretPositionAgain(int n) {
        String string = this.getText();
        int n2 = n - n % 4;
        try {
            int n3 = string.substring(n2, n2 + 3).trim().length() + n2;
            int n4 = n3 < n ? n3 : n;
            this.setCaretPosition(n4);
        }
        catch (Exception exception) {
            logger.trace(exception.getMessage(), exception);
        }
    }

    public ArrayList getValue() throws InValideIPAddressException {
        try {
            ArrayList<Integer> arrayList = new ArrayList<Integer>(16);
            StringTokenizer stringTokenizer = new StringTokenizer(this.getText(), ".");
            while (stringTokenizer.hasMoreElements()) {
                Integer n = Integer.valueOf(stringTokenizer.nextToken().trim());
                arrayList.add(n);
            }
            return arrayList;
        }
        catch (Exception exception) {
            throw new InValideIPAddressException("IPAddressTextField : InValide IP Address Input!");
        }
    }

    public void setValue(ArrayList arrayList) throws InValideIPAddressException {
        int n = arrayList.size();
        if (n < 4) {
            throw new InValideIPAddressException("IPAddressTextField : InValide IP Address Input!");
        }
        String string = "";
        String string2 = null;
        try {
            for (int i = 0; i < n - 1; ++i) {
                string2 = arrayList.get(i).toString().trim();
                int n2 = string2.length();
                if (n2 == 0) {
                    logger.trace("error = IPAddressTextField  setValue ( ArrayList value ) input para" + string2);
                }
                if (n2 == 1) {
                    string2 = string2 + TWO_SPACE;
                }
                if (n2 == 2) {
                    string2 = string2 + ONE_SPACE;
                }
                string = string + string2 + '.';
            }
            string2 = arrayList.get(n - 1).toString().trim();
            if (string2.length() == 0) {
                logger.trace("error = IPAddressTextField  setValue ( ArrayList value ) input para" + string2);
            } else {
                string = string + string2;
            }
            this.isClearOrSet = true;
            this.setCaretPosition(0);
            super.setText(string);
        }
        catch (Exception exception) {
            throw new InValideIPAddressException("IPAddressTextField : InValide IP Address Input!");
        }
        finally {
            this.isClearOrSet = false;
        }
    }

    @Override
    protected void processKeyEvent(KeyEvent keyEvent) {
        String string = null;
        if (keyEvent.getKeyChar() == '\b' && keyEvent.getID() == 401) {
            this.setIsBackspace(true);
        }
        if (keyEvent.isControlDown() && keyEvent.getKeyCode() == 67) {
            string = this.getSelectedText();
            this.copyToClipboard(string);
            return;
        }
        if (keyEvent.getKeyCode() == 127 && keyEvent.getID() == 401) {
            this.setIsDelete(true);
        }
        if (keyEvent.getID() == 401 && keyEvent.isControlDown() && keyEvent.getKeyCode() == 88) {
            string = this.getSelectedText();
            this.setIsDelete(true);
        }
        if (keyEvent.getKeyChar() == '.' || keyEvent.getKeyChar() == ' ') {
            this.setIsBackspace(false);
            this.setIsDelete(false);
        }
        super.processKeyEvent(keyEvent);
        if (keyEvent.getID() == 401 && keyEvent.isControlDown() && keyEvent.getKeyCode() == 88) {
            this.copyToClipboard(string);
        }
        if (keyEvent.getKeyCode() == 37 || keyEvent.getKeyCode() == 35) {
            this.doc.processLEFTKey(keyEvent);
        }
    }

    private void copyToClipboard(String string) {
        if (null == string) {
            return;
        }
        StringSelection stringSelection = new StringSelection(this.delSpace(string));
        Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
        clipboard.setContents(stringSelection, stringSelection);
    }

    private String delSpace(String string) {
        int n = string.length();
        StringBuffer stringBuffer = new StringBuffer(15);
        int n2 = -1;
        int n3 = 0;
        while (n3 < n && (n3 = string.indexOf(32, n3)) != -1) {
            stringBuffer.append(string.substring(n2 + 1, n3));
            n2 = n3++;
        }
        return stringBuffer.append(string.substring(n2 + 1, n)).toString();
    }

    public boolean isIsBackspace() {
        return this.isBackspace;
    }

    public boolean isIsDelete() {
        return this.isDelete;
    }

    public void setIsBackspace(boolean bl) {
        this.isBackspace = bl;
    }

    public void setIsDelete(boolean bl) {
        this.isDelete = bl;
    }

    public void setIsCellEditor(boolean bl) {
        this.isCellEditor = bl;
    }

    public boolean isCellEditor() {
        return this.isCellEditor;
    }

    @Override
    public void setText(String string) {
        this.setCaretPosition(0);
        if (this.isCellEditor) {
            this.isClearOrSet = true;
            if (string == null || string.length() == 0) {
                super.setText("   .   .   .   ");
            } else {
                string = this.trimeIPAddress(string);
                super.setText(string);
            }
        } else {
            try {
                ArrayList<Integer> arrayList = new ArrayList<Integer>(16);
                StringTokenizer stringTokenizer = new StringTokenizer(string, ".");
                while (stringTokenizer.hasMoreElements()) {
                    Integer n = Integer.valueOf(stringTokenizer.nextToken().trim());
                    if (n > 255) {
                        this.isClearOrSet = true;
                        super.setText("   .   .   .   ");
                        return;
                    }
                    arrayList.add(n);
                }
                this.setValue(arrayList);
            }
            catch (Exception exception) {
                logger.trace(exception.getMessage(), exception);
            }
        }
    }

    private String trimeIPAddress(String string) {
        StringTokenizer stringTokenizer = new StringTokenizer(string, ".");
        if (stringTokenizer.countTokens() != 4) {
            return "   .   .   .   ";
        }
        StringBuffer stringBuffer = new StringBuffer(15);
        Integer n = null;
        String string2 = null;
        while (stringTokenizer.hasMoreElements()) {
            string2 = stringTokenizer.nextToken().trim();
            if (string2.equals("")) {
                stringBuffer.append("   .");
                continue;
            }
            try {
                n = new Integer(string2);
                if (n > 255 || n < 0) {
                    return "   .   .   .   ";
                }
                stringBuffer.append(n);
                for (int i = n.toString().length(); i < 3; ++i) {
                    stringBuffer.append(ONE_SPACE);
                }
                stringBuffer.append(".");
            }
            catch (NumberFormatException numberFormatException) {
                logger.trace(numberFormatException.getMessage(), numberFormatException);
                return "   .   .   .   ";
            }
        }
        stringBuffer.setLength(15);
        return stringBuffer.toString();
    }

    public String getStrValue() {
        String string = this.getText();
        if ("   .   .   .   ".equals(string)) {
            return string;
        }
        return string.replaceAll("   ", "0");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clear() {
        try {
            this.isClearOrSet = true;
            super.setCaretPosition(0);
            super.setText("   .   .   .   ");
        }
        catch (Exception exception) {
            logger.trace(exception.getMessage(), exception);
        }
        finally {
            this.isClearOrSet = false;
        }
    }

    public String getTrimedAddress() throws InValideIPAddressException {
        StringBuffer stringBuffer = new StringBuffer(15);
        try {
            StringTokenizer stringTokenizer = new StringTokenizer(this.getText(), ".");
            int n = 0;
            while (stringTokenizer.hasMoreElements()) {
                Integer n2 = Integer.valueOf(stringTokenizer.nextToken().trim());
                stringBuffer.append(n2);
                if (n < 3) {
                    stringBuffer.append(".");
                }
                ++n;
            }
            return stringBuffer.toString();
        }
        catch (Exception exception) {
            throw new InValideIPAddressException("IPAddressTextField : InValide IP Address!");
        }
    }

    @Override
    public boolean isValid() {
        try {
            this.getValue();
        }
        catch (Exception exception) {
            return false;
        }
        return true;
    }

    public boolean isClearOrSet() {
        return this.isClearOrSet;
    }

    public void setIgnoreMaxValue(boolean bl) {
        if (this.doc != null) {
            this.doc.setIgnoreIPMAXUM(bl);
        }
    }
}

