/*
 * Decompiled with CFR 0.152.
 */
package com.swimap.iview.templates.textfield;

import com.swimap.iview.commstyle.resource.ResourceMng;
import com.swimap.iview.framework.util.FrameworkUtilities;
import com.swimap.iview.util.CommonUtil;
import com.swimap.iview.util.OptionPane;
import com.swimap.iview.util.log.IviewLogger;
import java.awt.Component;
import java.text.MessageFormat;
import java.util.ResourceBundle;
import javax.swing.SwingUtilities;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.PlainDocument;

public class ValidCharDocument
extends PlainDocument {
    private static IviewLogger logger = IviewLogger.getLogger(ValidCharDocument.class, "IVIEW");
    private static ResourceBundle res = ResourceMng.getInstance().getResourceBundleFromPropertyFile("mainfrm/iview/templates/textfield/Res");
    public static final String defaultInVaildFileNameChar = "`~!@#$%^&*()\":;?/\\,|{}[]<> '+=-";
    private String inValidChar = "`~!@#$%^&*()\":;?/\\,.|{}[]<> '+=-";
    private String validChar = null;
    private static final int DEFAULT_MAX_LENGTH = 50;
    private int maxLength = 50;
    private String[] infos = new String[4];
    private boolean isCheckFileName = false;
    private boolean isClickNewFolder = false;
    private boolean isSupportChinese = true;
    private boolean isLanguageRelative = false;
    private boolean isOk = false;
    private Component component = null;
    private boolean fileLengthByGBK = false;
    private boolean setErrorInfo = false;
    private boolean setDefaultErrorInfo = false;

    public ValidCharDocument() {
    }

    public ValidCharDocument(int n) {
        this.setMaxLength(n);
    }

    public ValidCharDocument(int n, String string) {
        this.setMaxLength(n);
        this.setInValidCharString(string);
    }

    public boolean getOk() {
        return this.isOk;
    }

    public void setOk(boolean bl) {
        this.isOk = bl;
    }

    public void setCheckFileName(boolean bl) {
        this.isCheckFileName = bl;
    }

    public void setIsClickNewFolder(boolean bl) {
        this.isClickNewFolder = bl;
    }

    public void setIsSupportChinese(boolean bl) {
        this.isSupportChinese = bl;
    }

    public void setLanguageRelative(boolean bl) {
        this.isLanguageRelative = bl;
    }

    public void setJudgeLengthByGBK(boolean bl) {
        this.fileLengthByGBK = bl;
    }

    public boolean isJudgeLengthByGBK() {
        return this.fileLengthByGBK;
    }

    @Override
    public void insertString(int n, String string, AttributeSet attributeSet) throws BadLocationException {
        if (this.doFileNamevalidation(n, string, attributeSet)) {
            this.insertValidString(n, string, attributeSet);
        }
    }

    void insertValidString(int n, String string, AttributeSet attributeSet) throws BadLocationException {
        super.insertString(n, string, attributeSet);
    }

    boolean doFileNamevalidation(int n, String string, AttributeSet attributeSet) throws BadLocationException {
        try {
            int n2;
            if (!this.isSupportChinese && string.getBytes().length != string.length()) {
                return false;
            }
            String string2 = this.getText(0, this.getLength());
            int n3 = 0;
            if (string2 != null) {
                if (this.isLanguageRelative) {
                    n3 = string2.getBytes().length;
                    if (this.isJudgeLengthByGBK()) {
                        n3 = CommonUtil.getUTFStringGBKLength(string2);
                    }
                } else {
                    n3 = string2.length();
                }
            }
            int n4 = 0;
            if (string != null) {
                if (this.isLanguageRelative) {
                    n4 = string.getBytes().length;
                    if (this.isJudgeLengthByGBK()) {
                        n4 = CommonUtil.getUTFStringGBKLength(string);
                    }
                } else {
                    n4 = string.length();
                }
            }
            if (n3 + n4 > this.maxLength) {
                if (this.infos[0] != null && this.infos[0].length() > 0) {
                    if (this.isClickNewFolder) {
                        this.isClickNewFolder = false;
                        return false;
                    }
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            OptionPane.showErrorDialog(ValidCharDocument.this.component == null ? FrameworkUtilities.getMainFrame() : ValidCharDocument.this.component, ValidCharDocument.this.infos[0]);
                            ValidCharDocument.this.isOk = true;
                        }
                    });
                }
                this.isClickNewFolder = false;
                return false;
            }
            this.isClickNewFolder = false;
            if (this.inValidChar != null && this.inValidChar.length() > 0) {
                n2 = string.length();
                for (int i = 0; i < n2; ++i) {
                    if (this.inValidChar.indexOf(String.valueOf(string.charAt(i))) < 0) continue;
                    if (this.infos[1] != null && this.infos[1].length() > 0) {
                        SwingUtilities.invokeLater(new Runnable(){

                            @Override
                            public void run() {
                                OptionPane.showErrorDialog(ValidCharDocument.this.component == null ? FrameworkUtilities.getMainFrame() : ValidCharDocument.this.component, ValidCharDocument.this.infos[1]);
                                ValidCharDocument.this.isOk = true;
                            }
                        });
                    }
                    return false;
                }
            } else if (this.validChar != null && this.validChar.length() > 0) {
                n2 = string.length();
                for (int i = 0; i < n2; ++i) {
                    if (this.validChar.indexOf(String.valueOf(string.charAt(i))) >= 0) continue;
                    if (this.infos[2] != null && this.infos[2].length() > 0) {
                        SwingUtilities.invokeLater(new Runnable(){

                            @Override
                            public void run() {
                                OptionPane.showErrorDialog(ValidCharDocument.this.component == null ? FrameworkUtilities.getMainFrame() : ValidCharDocument.this.component, ValidCharDocument.this.infos[2]);
                                ValidCharDocument.this.isOk = true;
                            }
                        });
                    }
                    return false;
                }
            }
            if (this.isCheckFileName) {
                String string3 = string2.substring(0, n) + string + string2.substring(n);
                if (string3.indexOf("\\\\\\") >= 0) {
                    if (this.infos[3] != null && this.infos[3].length() > 0) {
                        SwingUtilities.invokeLater(new Runnable(){

                            @Override
                            public void run() {
                                OptionPane.showErrorDialog(ValidCharDocument.this.component == null ? FrameworkUtilities.getMainFrame() : ValidCharDocument.this.component, ValidCharDocument.this.infos[3]);
                                ValidCharDocument.this.isOk = true;
                            }
                        });
                    }
                    return false;
                }
                if (string3.length() >= 2 && string3.substring(1).indexOf("\\\\") >= 0) {
                    if (this.infos[3] != null && this.infos[3].length() > 0) {
                        SwingUtilities.invokeLater(new Runnable(){

                            @Override
                            public void run() {
                                OptionPane.showErrorDialog(ValidCharDocument.this.component == null ? FrameworkUtilities.getMainFrame() : ValidCharDocument.this.component, ValidCharDocument.this.infos[3]);
                                ValidCharDocument.this.isOk = true;
                            }
                        });
                    }
                    return false;
                }
            }
        }
        catch (Exception exception) {
            logger.trace("file name is in valid or Location is not found  at" + exception);
            return false;
        }
        return true;
    }

    @Override
    public void remove(int n, int n2) throws BadLocationException {
        if (this.isCheckFileName) {
            String string = this.getText(0, n);
            String string2 = this.getText(n + n2, this.getLength() - n - n2);
            String string3 = string + string2;
            if (string3.indexOf("\\\\\\") >= 0) {
                if (this.infos[3] != null && this.infos[3].length() > 0) {
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            OptionPane.showErrorDialog(ValidCharDocument.this.component == null ? FrameworkUtilities.getMainFrame() : ValidCharDocument.this.component, ValidCharDocument.this.infos[3]);
                            ValidCharDocument.this.isOk = true;
                        }
                    });
                }
                return;
            }
            if (string3.indexOf("\\\\") > 0) {
                if (this.infos[3] != null && this.infos[3].length() > 0) {
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            OptionPane.showErrorDialog(ValidCharDocument.this.component == null ? FrameworkUtilities.getMainFrame() : ValidCharDocument.this.component, ValidCharDocument.this.infos[3]);
                            ValidCharDocument.this.isOk = true;
                        }
                    });
                }
                return;
            }
            if (string3.length() >= 2 && string3.substring(2, string3.length()).indexOf("\\\\") >= 0) {
                if (this.infos[3] != null && this.infos[3].length() > 0) {
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            OptionPane.showErrorDialog(ValidCharDocument.this.component == null ? FrameworkUtilities.getMainFrame() : ValidCharDocument.this.component, ValidCharDocument.this.infos[3]);
                            ValidCharDocument.this.isOk = true;
                        }
                    });
                }
                return;
            }
        }
        super.remove(n, n2);
    }

    public void setMaxLength(int n) {
        if (n <= 0) {
            throw new IllegalArgumentException("_maxLength can not less then 0");
        }
        this.maxLength = n;
        if (!this.setErrorInfo && this.setDefaultErrorInfo) {
            this.infos[0] = MessageFormat.format(res.getString("MaxCharLengthReached"), String.valueOf(this.maxLength));
        }
    }

    public void setInValidCharString(String string) {
        this.inValidChar = string;
        if (!this.setErrorInfo && this.setDefaultErrorInfo) {
            this.infos[1] = res.getString("InvalidChar") + this.inValidChar;
        }
    }

    public void setValidCharString(String string) {
        this.validChar = string;
        this.inValidChar = null;
        if (!this.setErrorInfo && this.setDefaultErrorInfo) {
            this.infos[2] = res.getString("NotAValidChar") + this.validChar;
        }
    }

    public int getMaxLength() {
        return this.maxLength;
    }

    public String getInValidCharString() {
        return this.inValidChar;
    }

    public static int isValidFilename(String string, int n) {
        return ValidCharDocument.isValidFilename(string, n, defaultInVaildFileNameChar);
    }

    public static int isValidFilename(String string, int n, String string2) {
        if (string == null) {
            return 1;
        }
        if ((string = string.trim()).length() == 0 || string.length() > n) {
            return 2;
        }
        if (string.charAt(0) == '.') {
            return 3;
        }
        if (string.lastIndexOf(".") > 0 && string.substring(0, string.lastIndexOf(".")).endsWith(".")) {
            return 3;
        }
        if (string2 != null && string2.length() > 0) {
            int n2 = string.length();
            for (int i = 0; i < n2; ++i) {
                if (string2.indexOf(String.valueOf(string.charAt(i))) < 0) continue;
                return 4;
            }
        }
        return 0;
    }

    public String getValidCharString() {
        return this.validChar;
    }

    public void setErrorInfo(String string, String string2, String string3, String string4) {
        this.setDefaultErrorInfo = false;
        this.setErrorInfo = true;
        this.infos[0] = string;
        this.infos[1] = string2;
        this.infos[2] = string3;
        this.infos[3] = string4;
    }

    public void setDefaultErrorInfo() {
        this.setDefaultErrorInfo = true;
        this.setErrorInfo = false;
        this.infos[0] = MessageFormat.format(res.getString("MaxCharLengthReached"), String.valueOf(this.maxLength));
        this.infos[1] = res.getString("InvalidChar") + this.inValidChar;
        this.infos[2] = res.getString("NotAValidChar") + this.validChar;
        this.infos[3] = res.getString("MoreSlashes");
    }

    public void setParentComponent(Component component) {
        this.component = component;
    }
}

