/*
 * Decompiled with CFR 0.152.
 */
package com.swimap.iview.templates.textfield;

import com.swimap.iview.templates.utils.timer.IviewSwingTimer;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.image.BufferedImage;
import java.util.StringTokenizer;
import javax.swing.JComponent;
import javax.swing.JLayeredPane;
import javax.swing.JRootPane;
import javax.swing.JTextArea;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.text.JTextComponent;

public class TipComponent
extends JComponent {
    protected JTextComponent editor;
    private Point oldPos = null;
    private static final int WIDTH = 10;
    private static final int HEIGHT = 21;
    private static final int MAX_WIDTH = 250;
    private static final int DEFAULT_DELAY_TIME = 6000;
    private int tipWidth = 10;
    private int tipHeight = 21;
    private FontMetrics metric = null;
    private IviewSwingTimer timer = null;

    public TipComponent() {
        this.setBorder(new PopupBorder());
        this.setLayout(new BorderLayout());
        this.setDoubleBuffered(true);
        this.setBackground(UIManager.getColor("ToolTip.background"));
        this.setCursor(Cursor.getPredefinedCursor(13));
        this.editor = this.createTextComponent();
        this.editor.setBackground(UIManager.getColor("ToolTip.background"));
        this.editor.setForeground(UIManager.getColor("ToolTip.foreground"));
        this.editor.setFont(UIManager.getFont("ToolTip.font"));
        this.editor.setBorder(null);
        this.editor.setFocusable(false);
        this.add(this.editor);
        BufferedImage bufferedImage = new BufferedImage(10, 10, 2);
        Graphics graphics = ((Image)bufferedImage).getGraphics();
        this.metric = graphics.getFontMetrics(UIManager.getFont("ToolTip.font"));
        this.enableEvents(16L);
        this.timer = new IviewSwingTimer(6000, new TipActionListener());
    }

    @Override
    public boolean isFocusTraversable() {
        return false;
    }

    public void dispose() {
        if (this.getParent() != null) {
            this.setVisible(false);
            this.getParent().remove(this);
        }
    }

    public void disposeLater() {
        this.timer.restart();
    }

    public void setInvoker(Component component) {
        int n;
        JRootPane jRootPane = SwingUtilities.getRootPane(component);
        if (jRootPane == null) {
            return;
        }
        JLayeredPane jLayeredPane = jRootPane.getLayeredPane();
        Rectangle rectangle = SwingUtilities.convertRectangle(component.getParent(), component.getBounds(), jLayeredPane);
        Dimension dimension = jLayeredPane.getSize();
        int n2 = rectangle.y + rectangle.height + 5;
        if (n2 + this.tipHeight > dimension.height && (n2 = rectangle.y - this.tipHeight - 5) < 0 && (n2 = rectangle.y) + this.tipHeight > dimension.height) {
            n2 = dimension.height - this.tipHeight;
        }
        if ((n = rectangle.x + 10) + this.tipWidth > dimension.width && (n = rectangle.x - this.tipWidth - 5) < 0 && (n = rectangle.x) + this.tipWidth > dimension.width) {
            n = dimension.width - this.tipWidth;
        }
        this.setBounds(n, n2, this.tipWidth, this.tipHeight);
        jLayeredPane.add(this, JLayeredPane.POPUP_LAYER, 0);
        this.setVisible(false);
    }

    protected JTextComponent createTextComponent() {
        JTextArea jTextArea = new JTextArea();
        jTextArea.setLineWrap(true);
        jTextArea.setWrapStyleWord(true);
        jTextArea.setEditable(false);
        return jTextArea;
    }

    public void setText(String string) {
        string = string.trim();
        char[] cArray = string.toCharArray();
        int n = 1;
        this.tipWidth = this.metric.charsWidth(cArray, 0, cArray.length) + 10;
        if (this.tipWidth > 250) {
            this.tipWidth = 250;
            n = this.getLineCount(string);
        }
        int n2 = this.metric.getHeight();
        Insets insets = this.getInsets();
        this.tipHeight = n * n2 + insets.bottom + insets.top - this.metric.getLeading();
        this.editor.setText(string);
    }

    private int getLineCount(String string) {
        int n = 1;
        int n2 = 0;
        StringTokenizer stringTokenizer = new StringTokenizer(string, " ", true);
        StringBuffer stringBuffer = new StringBuffer(45);
        if (stringTokenizer.countTokens() == 1) {
            return this.lineCountWitoutSpace(string);
        }
        while (stringTokenizer.hasMoreTokens()) {
            String string2 = stringTokenizer.nextToken();
            stringBuffer.append(string2);
            if (this.metric.stringWidth(stringBuffer.toString()) <= 240) continue;
            ++n;
            stringBuffer.delete(0, stringBuffer.length());
            stringBuffer.append(string2);
            n2 = this.metric.stringWidth(string2) - 240;
            if (n2 <= 0) continue;
            int n3 = this.lineCountWitoutSpace(stringBuffer.toString());
            n = n + n3 - 1;
        }
        return n;
    }

    private int lineCountWitoutSpace(String string) {
        int n = 1;
        int n2 = this.metric.stringWidth(string.toString());
        if (n2 > 240) {
            int n3 = n2 % 240;
            n = n2 / 240;
            if (n3 == 0) {
                return n;
            }
            return ++n;
        }
        return n;
    }

    public void setDisplayTime(int n) {
        this.timer.setInitialDelay(n);
    }

    @Override
    public void processMouseEvent(MouseEvent mouseEvent) {
        if (mouseEvent.getID() == 501) {
            this.oldPos = mouseEvent.getPoint();
        } else if (mouseEvent.getID() == 502) {
            Container container = this.getParent();
            Point point = new Point(mouseEvent.getX() - this.oldPos.x, mouseEvent.getY() - this.oldPos.y);
            point = SwingUtilities.convertPoint(this, point, container);
            int n = point.x + this.tipWidth;
            int n2 = point.y + this.tipHeight;
            if (n <= 0) {
                point.x = -1 * this.tipWidth + 2;
            } else if (point.x >= container.getWidth()) {
                point.x = container.getWidth() - 2;
            }
            if (n2 <= 0) {
                point.y = -1 * this.tipHeight + 2;
            } else if (point.y >= container.getHeight()) {
                point.y = container.getHeight() - 2;
            }
            this.setLocation(point);
        }
    }

    @Override
    public void addMouseListener(MouseListener mouseListener) {
        this.editor.addMouseListener(mouseListener);
        super.addMouseListener(mouseListener);
    }

    @Override
    public void addMouseMotionListener(MouseMotionListener mouseMotionListener) {
        this.editor.addMouseMotionListener(mouseMotionListener);
        super.addMouseMotionListener(mouseMotionListener);
    }

    private class TipActionListener
    implements ActionListener {
        private TipActionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            TipComponent.this.dispose();
            TipComponent.this.timer.stop();
        }
    }

    private class PopupBorder
    implements Border {
        private Insets insets = new Insets(1, 4, 5, 5);

        private PopupBorder() {
        }

        @Override
        public Insets getBorderInsets(Component component) {
            return this.insets;
        }

        @Override
        public boolean isBorderOpaque() {
            return true;
        }

        @Override
        public void paintBorder(Component component, Graphics graphics, int n, int n2, int n3, int n4) {
            graphics.setColor(Color.black);
            graphics.drawRect(0, 0, n3 - 3, n4 - 3);
            graphics.setColor(component.getBackground());
            graphics.drawRect(1, 1, n3 - 5, n4 - 5);
            graphics.drawRect(2, 2, n3 - 7, n4 - 7);
            graphics.drawRect(3, 3, n3 - 9, n4 - 9);
        }
    }
}

