/*
 * Decompiled with CFR 0.152.
 */
package com.swimap.iview.templates.textfield;

import com.swimap.iview.util.log.IviewLogger;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyEvent;
import java.util.StringTokenizer;
import javax.swing.FocusManager;
import javax.swing.JFormattedTextField;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.text.BadLocationException;
import javax.swing.text.MaskFormatter;

public class MACAddressTextField
extends JPanel {
    private static IviewLogger logger = IviewLogger.getLogger(MACAddressTextField.class, "IVIEW");
    private static final String DEFAULT_VALUE = "00-00-00-00-00-00";
    private static final String DEFAULT_VALUE_FORMAT4VALUES = "0000-0000-0000-0000-0000-0000";
    private JTextField[] field = null;
    private JLabel[] label = null;
    private boolean isBackward = false;
    private boolean isForward = false;
    private String separatorStr = "-";
    private String maskFormatter = "HH";

    private void initTextField() {
        try {
            int n = this.field.length;
            MaskFormatter maskFormatter = null;
            Dimension dimension = null;
            for (int i = 0; i < n; ++i) {
                maskFormatter = new MaskFormatter(this.maskFormatter);
                maskFormatter.setAllowsInvalid(false);
                this.field[i] = new MACField(maskFormatter, i != this.field.length - 1, i != 0);
                dimension = this.field[i].getPreferredSize();
                this.field[i].setPreferredSize(new Dimension(dimension.height, dimension.width + 10));
                this.field[i].setBorder(null);
            }
        }
        catch (Exception exception) {
            logger.trace(exception.getMessage(), exception);
        }
    }

    private void initLabel() {
        for (int i = 0; i < this.label.length; ++i) {
            this.label[i] = new JLabel(this.separatorStr + ' ', 0);
            this.label[i].setForeground(UIManager.getColor("TextField.foreground"));
        }
    }

    @Override
    public void setName(String string) {
        int n;
        super.setName(string);
        StringBuffer stringBuffer = new StringBuffer(16);
        stringBuffer.append(string).append("_label_");
        for (n = 0; n < this.label.length; ++n) {
            if (this.label[n] == null) continue;
            this.label[n].setName(stringBuffer.toString() + n);
        }
        stringBuffer = new StringBuffer(16);
        stringBuffer.append(string).append("_field_");
        for (n = 0; n < this.field.length; ++n) {
            if (this.field[n] == null) continue;
            this.field[n].setName(stringBuffer.toString() + n);
        }
    }

    public MACAddressTextField(String string) {
        this(string, '-');
    }

    public MACAddressTextField(String string, char c) {
        String string2;
        this.setLayout(new GridBagLayout());
        this.separatorStr = Character.toString(c);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 10;
        gridBagConstraints.fill = 0;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.insets = new Insets(0, 0, 0, 0);
        gridBagConstraints.ipadx = 0;
        gridBagConstraints.ipady = 0;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        GridBagConstraints gridBagConstraints2 = new GridBagConstraints();
        gridBagConstraints2.anchor = 10;
        gridBagConstraints2.fill = 1;
        gridBagConstraints2.gridheight = 1;
        gridBagConstraints2.gridwidth = 1;
        gridBagConstraints2.gridy = 0;
        gridBagConstraints2.insets = new Insets(0, 0, 0, 0);
        gridBagConstraints2.ipadx = 0;
        gridBagConstraints2.ipady = 0;
        gridBagConstraints2.weightx = 0.25;
        gridBagConstraints2.weighty = 0.0;
        StringTokenizer stringTokenizer = new StringTokenizer(string, this.separatorStr);
        int n = stringTokenizer.countTokens();
        if (stringTokenizer.hasMoreElements()) {
            string2 = stringTokenizer.nextToken();
            this.maskFormatter = 4 == string2.length() ? "HHHH" : "HH";
        }
        string2 = string;
        if (n < 2) {
            string2 = "HH".equals(this.maskFormatter) ? DEFAULT_VALUE : DEFAULT_VALUE_FORMAT4VALUES;
            stringTokenizer = new StringTokenizer(string2, this.separatorStr);
            n = stringTokenizer.countTokens();
        }
        logger.debug("address = " + string2 + "; size = " + n);
        this.field = new JTextField[n];
        this.label = new JLabel[n - 1];
        this.initTextField();
        this.initLabel();
        int n2 = this.label.length;
        for (int i = 0; i < n2; ++i) {
            this.add((Component)this.field[i], gridBagConstraints2);
            this.add((Component)this.label[i], gridBagConstraints);
        }
        this.add((Component)this.field[n2], gridBagConstraints2);
        this.setMinimumSize(this.getPreferredSize());
        this.setForeground(UIManager.getColor("TextField.foreground"));
        this.setBackground(UIManager.getColor("TextField.background"));
        this.setBorder(UIManager.getBorder("TextField.border"));
        this.setMACAddress(string2);
        this.setName("MACAddressTextField");
    }

    public MACAddressTextField() {
        this(DEFAULT_VALUE);
    }

    public void setSeparator(char c) {
        this.separatorStr = String.valueOf(c);
        if (null != this.label) {
            for (int i = 0; i < this.label.length; ++i) {
                this.label[i].setText(this.separatorStr + ' ');
            }
        }
    }

    public char getSeparator() {
        return this.separatorStr.charAt(0);
    }

    public void setEditable(boolean bl) {
        for (int i = 0; i < this.label.length; ++i) {
            this.field[i].setEditable(bl);
            this.label[i].setForeground(this.field[i].getForeground());
        }
        this.field[this.field.length - 1].setEditable(bl);
        this.setBackground(this.field[0].getBackground());
    }

    public boolean isEditable() {
        return this.field[0].isEditable();
    }

    public String getMACAddress() {
        StringBuffer stringBuffer = new StringBuffer(16);
        for (int i = 0; i < this.label.length; ++i) {
            stringBuffer.append(this.field[i].getText()).append(this.separatorStr);
        }
        stringBuffer.append(this.field[this.label.length].getText());
        return stringBuffer.toString();
    }

    public void setMACAddress(String string) {
        Object object;
        if (string == null) {
            return;
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string, this.separatorStr);
        boolean bl = stringTokenizer.hasMoreElements();
        if (bl && ((String)(object = stringTokenizer.nextToken())).length() != this.maskFormatter.length()) {
            return;
        }
        object = new StringTokenizer(string, this.separatorStr);
        int n = 0;
        boolean bl2 = ((StringTokenizer)object).hasMoreElements();
        while (bl2) {
            this.field[n].setText(((StringTokenizer)object).nextToken().trim());
            ++n;
            bl2 = ((StringTokenizer)object).hasMoreElements();
        }
    }

    private class MACField
    extends JFormattedTextField
    implements FocusListener {
        private boolean next;
        private boolean prev;

        public MACField(JFormattedTextField.AbstractFormatter abstractFormatter, boolean bl, boolean bl2) {
            super(abstractFormatter);
            this.next = bl;
            this.prev = bl2;
            this.addFocusListener(this);
        }

        @Override
        protected void processKeyEvent(KeyEvent keyEvent) {
            String string;
            String string2;
            String string3;
            int n;
            int n2;
            if (!FocusManager.isFocusManagerEnabled()) {
                return;
            }
            if (keyEvent.getID() == 401) {
                n2 = keyEvent.getKeyCode();
                n = this.getCaretPosition();
                if (this.next && n2 == 39) {
                    if (n == this.getText().length()) {
                        MACAddressTextField.this.isForward = true;
                        FocusManager.getCurrentManager().focusNextComponent(this);
                        return;
                    }
                } else if (n2 == 37 || n2 == 8) {
                    if (n == 0 && this.prev) {
                        MACAddressTextField.this.isBackward = true;
                        FocusManager.getCurrentManager().focusPreviousComponent(this);
                        keyEvent.consume();
                        return;
                    }
                    if (n2 == 8 && n != 0) {
                        int n3 = MACAddressTextField.this.maskFormatter.length();
                        string3 = this.getText();
                        try {
                            string2 = string3.substring(0, n - 1);
                            string = string3.substring(n, n3);
                            String string4 = string2.concat(string);
                            string4 = string4.trim();
                            this.getDocument().insertString(0, string4, null);
                            this.getDocument().remove(string4.length(), n3 - string4.length());
                            keyEvent.consume();
                            this.setCaretPosition(n - 1);
                        }
                        catch (BadLocationException badLocationException) {
                            logger.error("BadLocationException !");
                            logger.trace(badLocationException.getMessage(), badLocationException);
                        }
                    }
                }
            } else if (this.next && keyEvent.getID() == 400) {
                char c = keyEvent.getKeyChar();
                if (this.isValid(c)) {
                    String string5 = this.getText();
                    if (string5.equals("")) {
                        this.setValue("  ");
                        string5 = this.getText();
                    }
                    char c2 = string5.charAt(1);
                    char c3 = string5.charAt(0);
                    if (c2 == ' ' && this.getCaretPosition() == 0) {
                        try {
                            this.getDocument().remove(1, 2);
                            string5 = "" + c3;
                            this.getDocument().insertString(1, string5, null);
                            this.getDocument().remove(0, 1);
                            this.setCaretPosition(0);
                        }
                        catch (Exception exception) {
                            logger.error("BadLocationException !");
                            logger.trace(exception.getMessage(), exception);
                        }
                    }
                }
                super.processKeyEvent(keyEvent);
                if (keyEvent.getModifiers() == 0 && this.isValid(c)) {
                    int n4 = MACAddressTextField.this.maskFormatter.length();
                    if (this.getText().length() == n4 && this.getCaretPosition() == n4) {
                        FocusManager.getCurrentManager().focusNextComponent(this);
                    }
                }
                return;
            }
            super.processKeyEvent(keyEvent);
            if (keyEvent.getID() == 401 && keyEvent.getKeyCode() == 127) {
                n2 = this.getCaretPosition();
                n = MACAddressTextField.this.maskFormatter.length();
                String string6 = this.getText();
                try {
                    string3 = string6.substring(0, n2 - 1);
                    string2 = string6.substring(n2, n);
                    string = string3.concat(string2);
                    string = string.trim();
                    this.getDocument().insertString(0, string, null);
                    this.getDocument().remove(string.length(), n - string.length());
                    this.setCaretPosition(n2 - 1);
                }
                catch (Exception exception) {
                    logger.error("BadLocationException !");
                    logger.trace(exception.getMessage(), exception);
                }
            }
        }

        @Override
        public Object getValue() {
            return this.getText();
        }

        private boolean isValid(char c) {
            return c >= '0' && c <= '9' || c >= 'a' && c <= 'f' || c >= 'A' && c <= 'F';
        }

        @Override
        public void focusGained(FocusEvent focusEvent) {
            if (MACAddressTextField.this.isBackward || MACAddressTextField.this.isForward) {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        if (MACAddressTextField.this.isBackward) {
                            MACField.this.setCaretPosition(MACField.this.getText().trim().length());
                            MACAddressTextField.this.isBackward = false;
                        } else {
                            MACField.this.setCaretPosition(0);
                            MACAddressTextField.this.isForward = false;
                        }
                    }
                });
                return;
            }
            this.setCaretPosition(0);
        }

        @Override
        public void focusLost(FocusEvent focusEvent) {
        }
    }
}

