/*
 * Decompiled with CFR 0.152.
 */
package com.swimap.iview.templates.textfield;

import com.swimap.iview.commstyle.resource.ResourceMng;
import com.swimap.iview.templates.textfield.InputInvalidListener;
import com.swimap.iview.templates.textfield.IntegerDocument;
import com.swimap.iview.templates.textfield.TipComponent;
import java.awt.Color;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.text.MessageFormat;
import java.util.ResourceBundle;
import javax.swing.BorderFactory;
import javax.swing.JTextField;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;
import javax.swing.border.LineBorder;

public class IntegerTextField
extends JTextField
implements FocusListener {
    private static ResourceBundle res = ResourceMng.getInstance().getResourceBundleFromPropertyFile("mainfrm/iview/templates/textfield/Res");
    private IntegerDocument doc = null;
    protected TipComponent tip = null;
    private boolean tooltipEnabled = false;
    private int minRange = 0;
    private int maxRange = Integer.MAX_VALUE;
    private int beforeValue;
    public static Border FOCUS_BORDER = BorderFactory.createCompoundBorder(new EmptyBorder(1, 1, 1, 1), new LineBorder(UIManager.getColor("Table.gridColor")));
    private boolean isBeforeValueSet = false;
    public static Border ERROR_BORDER = BorderFactory.createCompoundBorder(new EmptyBorder(1, 1, 1, 1), new LineBorder(Color.red));
    public static Border NORMAL_BORDER = null;

    public IntegerTextField(int n, int n2) {
        this.minRange = n;
        this.maxRange = n2;
        this.tip = new TipComponent();
        this.tip.setDisplayTime(2000);
        this.doc = new IntegerDocument(n, n2);
        super.setDocument(this.doc);
        this.setToolTipText("[" + n + ',' + n2 + ']');
        this.addFocusListener(this);
        this.doc.addInputValidListener(new InvalidInputString());
        this.setName("IntegerTextField");
        NORMAL_BORDER = this.getBorder();
    }

    public void setTooltipEnabled(boolean bl) {
        this.tooltipEnabled = bl;
    }

    public boolean isTooltipEnabled() {
        return this.tooltipEnabled;
    }

    public int getValue() {
        return Integer.parseInt(this.getText());
    }

    public void setRange(int n, int n2) {
        this.doc.setRange(n, n2);
        this.minRange = n;
        this.maxRange = n2;
        this.setToolTipText("[" + n + ',' + n2 + ']');
    }

    @Override
    public boolean isValid() {
        if (null != this.doc) {
            return this.doc.isInRange(this.getText());
        }
        return super.isValid();
    }

    @Override
    public void focusGained(FocusEvent focusEvent) {
        String string = this.getText();
        if (null != string && !string.isEmpty()) {
            this.beforeValue = Integer.parseInt(string);
        }
        if (this.isValid()) {
            this.highlightTextField(true);
            this.isBeforeValueSet = true;
        } else if (!string.isEmpty()) {
            this.highlightTextField(false);
        }
    }

    @Override
    public void focusLost(FocusEvent focusEvent) {
        this.setBorder(NORMAL_BORDER);
        if (this.isValid()) {
            String string = this.getText();
            if (string.length() >= 2 && (string.charAt(0) == '0' || string.startsWith("-"))) {
                this.setText(Integer.parseInt(this.getText()) + "");
            }
        } else {
            if (this.isBeforeValueSet) {
                this.setText(this.beforeValue + "");
            } else {
                this.setText("");
            }
            this.isBeforeValueSet = false;
        }
        this.tip.dispose();
    }

    private void highlightTextField(boolean bl) {
        if (bl) {
            this.setBorder(FOCUS_BORDER);
        } else {
            this.setBorder(ERROR_BORDER);
        }
    }

    private void showTipForNumber() {
        if (this.isTooltipEnabled()) {
            this.tip.setText(this.getToolTipTextForNumber());
            this.tip.setInvoker(this);
            this.tip.setVisible(true);
            this.tip.disposeLater();
        }
    }

    public String getTooltipTextForRange() {
        return res.getString("IntegerTextField.tooltip.number");
    }

    public String getToolTipTextForNumber() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(this.getTooltipTextForRange());
        if (this.minRange == this.maxRange) {
            stringBuffer.append("{");
            stringBuffer.append(this.minRange);
            stringBuffer.append("}");
        } else {
            stringBuffer.append("[");
            stringBuffer.append(this.minRange);
            stringBuffer.append(", ");
            stringBuffer.append(this.maxRange);
            stringBuffer.append("]");
        }
        return stringBuffer.toString();
    }

    private void showTipForChar(String string) {
        if (this.isTooltipEnabled()) {
            this.tip.setText(this.getTooltipTextForChar(string));
            this.tip.setInvoker(this);
            this.tip.setVisible(true);
            this.tip.disposeLater();
        }
    }

    public String getTooltipTextForChar(String string) {
        return MessageFormat.format(res.getString("IntegerTextField.tooltip.char"), string);
    }

    private void showTipForString(String string) {
        if (this.isTooltipEnabled()) {
            this.tip.setText(this.getTooltipTextForString(string));
            this.tip.setInvoker(this);
            this.tip.setVisible(true);
            this.tip.disposeLater();
        }
    }

    public String getTooltipTextForString(String string) {
        return MessageFormat.format(res.getString("IntegerTextField.tooltip.string"), string);
    }

    private class InvalidInputString
    implements InputInvalidListener {
        private InvalidInputString() {
        }

        @Override
        public void inputInvalid(int n, Object object) {
            if (n == 6) {
                IntegerTextField.this.highlightTextField(true);
            } else if (n == 1) {
                IntegerTextField.this.showTipForNumber();
            } else if (n == 5) {
                IntegerTextField.this.highlightTextField(false);
                IntegerTextField.this.showTipForNumber();
            } else if (n != 0) {
                if (n == 2) {
                    IntegerTextField.this.showTipForString((String)object);
                } else if (n == 3) {
                    IntegerTextField.this.showTipForChar((String)object);
                }
            }
        }
    }
}

