/*
 * Decompiled with CFR 0.152.
 */
package com.swimap.iview.templates.textfield;

import com.swimap.iview.templates.textfield.InputInvalidListener;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.PlainDocument;

public class IntegerDocument
extends PlainDocument {
    private int min = 0;
    private int max = 0;
    private StringBuffer tempBuffer = new StringBuffer(16);
    private boolean isInputNegtaiveValue = false;

    public IntegerDocument(int n, int n2) {
        this.setRange(n, n2);
    }

    @Override
    public void insertString(int n, String string, AttributeSet attributeSet) throws BadLocationException {
        try {
            if (this.min >= 0 && string != null && string.indexOf("-") != -1) {
                this.fireInValidString(3, string);
                return;
            }
            String string2 = this.getText(0, this.getLength());
            String string3 = string2.substring(0, n);
            String string4 = string2.substring(n);
            this.tempBuffer.delete(0, this.tempBuffer.length());
            this.tempBuffer.append(string3).append(string).append(string4);
            String string5 = this.tempBuffer.toString();
            boolean bl = false;
            if (this.min < 0 && string5.length() > 0 && string5.charAt(0) == '-') {
                if ("-2147483648".equals(string5)) {
                    bl = true;
                }
                if ((string5 = string5.replaceFirst("-", "0")).startsWith("00") || -1 != string5.indexOf(45)) {
                    this.fireInValidString(2, string);
                    return;
                }
                this.isInputNegtaiveValue = true;
            } else {
                if (string5.length() > 1 && string5.charAt(0) == '0' || string5.length() > 1 && string5.charAt(1) == '-') {
                    this.fireInValidString(2, string);
                    return;
                }
                this.isInputNegtaiveValue = false;
            }
            int n2 = 0;
            if (bl) {
                n2 = Integer.MIN_VALUE;
            } else {
                n2 = Integer.parseInt(string5);
                if (this.isInputNegtaiveValue) {
                    n2 = -n2;
                }
            }
            if (this.min >= 1) {
                if (n2 > this.max || n2 < 0) {
                    this.fireInValidString(1, "");
                    return;
                }
                if (!this.isInRange(n2)) {
                    super.insertString(n, string, attributeSet);
                    this.fireInValidString(5, "");
                    return;
                }
            } else if (this.max <= -1) {
                if (n2 > 0 || n2 < this.min) {
                    this.fireInValidString(1, "");
                    return;
                }
            } else if (!this.isInRange(n2)) {
                this.fireInValidString(1, "");
                return;
            }
        }
        catch (Exception exception) {
            int n3 = string.length();
            boolean bl = true;
            while (n3 > 0) {
                if (Character.isDigit(string.charAt(--n3))) continue;
                bl = this.isInputNegtaiveValue && n3 == 0 && (Character.isDigit(string.charAt(n3)) || string.charAt(n3) == '-');
                break;
            }
            if (!bl) {
                this.fireInValidString(2, string);
                return;
            }
            this.fireInValidString(1, "");
            return;
        }
        super.insertString(n, string, attributeSet);
        this.fireInValidString(6, string);
    }

    @Override
    public void remove(int n, int n2) throws BadLocationException {
        super.remove(n, n2);
        String string = this.getText(0, this.getLength());
        if (string != null && !string.isEmpty()) {
            if (!this.isInRange(string)) {
                this.fireInValidString(5, "");
            }
        } else {
            this.fireInValidString(6, string);
        }
    }

    public void setRange(int n, int n2) {
        if (n2 < n) {
            throw new IllegalArgumentException("max can not less then min");
        }
        this.min = n;
        this.max = n2;
    }

    public int getMax() {
        return this.max;
    }

    public int getMin() {
        return this.min;
    }

    public boolean isInRange(int n) {
        return n <= this.max && n >= this.min;
    }

    public boolean isInRange(String string) {
        try {
            if (string == null) {
                return false;
            }
            if ((string = string.trim()).length() == 0) {
                return false;
            }
            int n = Integer.parseInt(string);
            return this.isInRange(n);
        }
        catch (Exception exception) {
            return false;
        }
    }

    public void addInputValidListener(InputInvalidListener inputInvalidListener) {
        this.listenerList.add(InputInvalidListener.class, inputInvalidListener);
    }

    public void removeInputValidListener(InputInvalidListener inputInvalidListener) {
        this.listenerList.remove(InputInvalidListener.class, inputInvalidListener);
    }

    private void fireInValidString(int n, Object object) {
        Object[] objectArray = this.listenerList.getListenerList();
        for (int i = objectArray.length - 2; i >= 0; i -= 2) {
            if (objectArray[i] != InputInvalidListener.class) continue;
            ((InputInvalidListener)objectArray[i + 1]).inputInvalid(n, object);
        }
    }
}

