/*
 * Decompiled with CFR 0.152.
 */
package com.swimap.iview.templates.textfield;

import com.swimap.iview.commstyle.resource.ResourceMng;
import com.swimap.iview.commstyle.resource.i18n.ResourceUtil;
import com.swimap.iview.templates.textfield.InputValidListener;
import com.swimap.iview.templates.textfield.TipComponent;
import com.swimap.iview.templates.textfield.ValueChangedListener;
import com.swimap.iview.util.CommonUtil;
import com.swimap.iview.util.log.IviewLogger;
import java.awt.Color;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.text.MessageFormat;
import java.util.ResourceBundle;
import javax.swing.BorderFactory;
import javax.swing.JTextField;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;
import javax.swing.border.LineBorder;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.PlainDocument;

public class CharInputTextField
extends JTextField
implements FocusListener {
    private static IviewLogger logger = IviewLogger.getLogger(CharInputTextField.class, "IVIEW");
    private static ResourceBundle res = ResourceMng.getInstance().getResourceBundleFromPropertyFile("mainfrm/iview/templates/textfield/Res");
    public static final String DEFAULT = "default";
    public static final String NOTALLOWCHAR = "~!@#$^%&*{}[]+=<>?";
    private String[] invalidStrings = new String[0];
    private volatile boolean isLanguageRelative = false;
    private int minLength = 0;
    private int maxLength = Integer.MAX_VALUE;
    private char[] invalidChars = null;
    private String validString = null;
    protected TipComponent tip;
    private String oldValue = null;
    public static Border FOCUS_BORDER = BorderFactory.createCompoundBorder(new EmptyBorder(1, 1, 1, 1), new LineBorder(UIManager.getColor("Table.gridColor")));
    private boolean tooltipEnabled = true;
    public static Border ERROR_BORDER = BorderFactory.createCompoundBorder(new EmptyBorder(1, 1, 1, 1), new LineBorder(Color.red));
    public static final String HEX_CHARS = "0123456789ABCDEFabcdef";
    public static final int DEFAULT_CASE = 0;
    public static final int LOWER_CASE = 1;
    public static final int UPPER_CASE = 2;
    private int textCase = 0;
    private boolean onlyEnglishValid = false;
    private boolean fileLengthByGBK = false;
    private boolean isShowToolTipOnfocus = true;

    public static CharInputTextField getInstance() {
        return CharInputTextField.getInstance(DEFAULT);
    }

    public static CharInputTextField getInstance(String string) {
        int n = CharInputTextField.getMinLength();
        int n2 = CharInputTextField.getMaxLength();
        String string2 = CharInputTextField.getInvalidString();
        return new CharInputTextField(n, n2, string2);
    }

    private static int getMinLength() {
        return 0;
    }

    private static int getMaxLength() {
        return Integer.MAX_VALUE;
    }

    private static String getInvalidString() {
        return "";
    }

    public CharInputTextField(int n, int n2, String string) {
        String string2 = string;
        if (null == string2) {
            string2 = NOTALLOWCHAR;
        }
        this.setLengthRange(n, n2);
        this.invalidChars = string2.toCharArray();
        this.setDocument(new TextDocument());
        this.setText("");
        this.addFocusListener(this);
        this.tip = new TipComponent();
        this.addInputValidListener(new InputValidTooltipListener());
        this.setName("CharInputTextField");
    }

    public CharInputTextField(int n, int n2) {
        this(n, n2, NOTALLOWCHAR);
    }

    public CharInputTextField() {
        this(0, Integer.MAX_VALUE, NOTALLOWCHAR);
    }

    public void addInputValidListener(InputValidListener inputValidListener) {
        this.listenerList.add(InputValidListener.class, inputValidListener);
    }

    public void addValueChangedListener(ValueChangedListener valueChangedListener) {
        this.listenerList.add(ValueChangedListener.class, valueChangedListener);
    }

    public void setTooltipEnabled(boolean bl) {
        this.tooltipEnabled = bl;
    }

    public boolean isTooltipEnabled() {
        return this.tooltipEnabled;
    }

    public void ignoreTooltipOnFocus() {
        this.isShowToolTipOnfocus = false;
    }

    @Override
    public void focusGained(FocusEvent focusEvent) {
        if (this.isShowToolTipOnfocus) {
            this.showTipForNumber();
        }
    }

    @Override
    public void focusLost(FocusEvent focusEvent) {
        this.tip.dispose();
    }

    public boolean setValue(String string) {
        if (this.validString(string)) {
            this.oldValue = string;
            this.setText(string);
            if (this.getText().equals(string)) {
                this.setCaretPosition(string.length());
                return true;
            }
        } else {
            this.setText("");
        }
        return false;
    }

    public String getValue() {
        return this.getText();
    }

    public void setLengthRange(int n, int n2) {
        if (n > n2) {
            n2 = n;
        }
        if (n >= 0) {
            this.minLength = n;
        }
        if (n2 > 0) {
            this.maxLength = n2;
        }
    }

    public void setInvalidChars(String string) {
        if (null == string) {
            return;
        }
        this.invalidChars = string.toCharArray();
    }

    public String getInvalidChars() {
        return String.valueOf(this.invalidChars);
    }

    public void setValidChars(String string) {
        this.validString = string;
    }

    public String getValidChars() {
        return this.validString;
    }

    public void setInvalidStrings(String[] stringArray) {
        if (null == stringArray) {
            return;
        }
        this.invalidStrings = stringArray;
    }

    public String[] getInvalidStrings() {
        return this.invalidStrings;
    }

    public void setLanguageRelative(boolean bl) {
        this.isLanguageRelative = bl;
    }

    public void setOnlyEnglishValid(boolean bl) {
        this.onlyEnglishValid = bl;
    }

    public boolean isOnlyEnglishValid() {
        return this.onlyEnglishValid;
    }

    public void setTextCase(int n) {
        this.textCase = n == 0 || n == 2 || n == 1 ? n : 0;
    }

    public int getTextCase() {
        return this.textCase;
    }

    private void fireStringValidChanged(boolean bl) {
        Object[] objectArray = this.listenerList.getListenerList();
        for (int i = objectArray.length - 2; i >= 0; i -= 2) {
            if (objectArray[i] != InputValidListener.class) continue;
            ((InputValidListener)objectArray[i + 1]).inputValidChanged(bl);
        }
    }

    private void fireValueChanged(boolean bl) {
        Object[] objectArray = this.listenerList.getListenerList();
        for (int i = objectArray.length - 2; i >= 0; i -= 2) {
            if (objectArray[i] != ValueChangedListener.class) continue;
            ((ValueChangedListener)objectArray[i + 1]).ValueChanged(bl);
        }
    }

    private boolean validString(String string) {
        if (string == null) {
            logger.debug("Value set in CharInputTextField is null.");
            return false;
        }
        boolean bl = this.isInValidRange(string.length());
        if (this.isLanguageRelative) {
            int n = string.getBytes().length;
            if (this.isJudgeLengthByGBK()) {
                n = CommonUtil.getUTFStringGBKLength(string);
            }
            bl = this.isInValidRange(n);
        }
        if (bl) {
            if (this.oldValue == null || this.oldValue.length() == 0) {
                this.fireValueChanged(true);
                this.oldValue = string;
            } else {
                this.fireValueChanged(!ResourceUtil.areEquals(this.oldValue, string));
                this.oldValue = string;
            }
        }
        this.fireStringValidChanged(bl);
        return bl;
    }

    private boolean isInValidRange(int n) {
        return n >= this.minLength && n <= this.maxLength;
    }

    public void setJudgeLengthByGBK(boolean bl) {
        this.fileLengthByGBK = bl;
    }

    public boolean isJudgeLengthByGBK() {
        return this.fileLengthByGBK;
    }

    public String getToolTipTextForNumber() {
        StringBuffer stringBuffer = new StringBuffer(32);
        stringBuffer.append(this.getTooltipTextForRange());
        if (this.minLength == this.maxLength) {
            stringBuffer.append("{");
            stringBuffer.append(this.minLength);
            stringBuffer.append("}");
        } else {
            stringBuffer.append("[");
            stringBuffer.append(this.minLength);
            stringBuffer.append(", ");
            stringBuffer.append(this.maxLength);
            stringBuffer.append("]");
        }
        return stringBuffer.toString();
    }

    public String getTooltipTextForRange() {
        return res.getString("CharInputNumberTextField.tooltip.number");
    }

    public String getTooltipTextForChar(String string) {
        return MessageFormat.format(res.getString("CharInputNumberTextField.tooltip.char"), string);
    }

    public String getTooltipTextForString(String string) {
        return MessageFormat.format(res.getString("CharInputNumberTextField.tooltip.string"), string);
    }

    private String getTooltipTextForInvalidString(String[] stringArray) {
        StringBuffer stringBuffer = new StringBuffer(res.getString("CharInputNumberTextField.tooltip.string"));
        for (int i = 0; i < stringArray.length - 1; ++i) {
            stringBuffer.append(" ,\"{" + (i + 1) + "}\"");
        }
        return MessageFormat.format(stringBuffer.toString(), stringArray);
    }

    private void showTipForNumber() {
        if (this.isTooltipEnabled()) {
            this.tip.setText(this.getToolTipTextForNumber());
            this.tip.setInvoker(this);
            this.tip.setVisible(true);
            this.tip.disposeLater();
        }
    }

    private void showTipForChar(char c) {
        if (this.isTooltipEnabled()) {
            String string = String.valueOf(c);
            this.tip.setText(this.getTooltipTextForChar(string));
            this.tip.setInvoker(this);
            this.tip.setVisible(true);
            this.tip.disposeLater();
        }
    }

    private void showTipForInvalidChars(char[] cArray) {
        if (this.isTooltipEnabled()) {
            String string = String.valueOf(cArray);
            String string2 = this.getTooltipTextForChar(string).replaceFirst("'", " ");
            String string3 = string2.substring(0, string2.length() - 1);
            this.tip.setText(string3);
            this.tip.setInvoker(this);
            this.tip.setVisible(true);
            this.tip.disposeLater();
        }
    }

    private void showTipForString(String string) {
        if (this.isTooltipEnabled()) {
            this.tip.setText(this.getTooltipTextForInvalidString(this.invalidStrings));
            this.tip.setInvoker(this);
            this.tip.setVisible(true);
            this.tip.disposeLater();
        }
    }

    private class InputValidTooltipListener
    implements InputValidListener {
        private InputValidTooltipListener() {
        }

        @Override
        public void inputValidChanged(boolean bl) {
            if (!bl && CharInputTextField.this.isFocusOwner()) {
                CharInputTextField.this.showTipForNumber();
            } else {
                CharInputTextField.this.tip.dispose();
            }
        }
    }

    private class TextDocument
    extends PlainDocument {
        public int getLength(int n) {
            n = this.getLength();
            try {
                if (CharInputTextField.this.isJudgeLengthByGBK()) {
                    return CommonUtil.getUTFStringGBKLength(this.getText(0, n));
                }
                return this.getText(0, n).getBytes().length;
            }
            catch (BadLocationException badLocationException) {
                return 0;
            }
        }

        @Override
        public void insertString(int n, String string, AttributeSet attributeSet) throws BadLocationException {
            int n2;
            int n3;
            int n4;
            switch (CharInputTextField.this.textCase) {
                case 1: {
                    string = string.toLowerCase();
                    break;
                }
                case 2: {
                    string = string.toUpperCase();
                    break;
                }
            }
            if (CharInputTextField.this.onlyEnglishValid) {
                n4 = string.length();
                for (n3 = 0; n3 < n4; ++n3) {
                    char c = string.charAt(n3);
                    if (c >>> 7 == 0) continue;
                    CharInputTextField.this.showTipForChar(c);
                    return;
                }
            }
            n3 = this.getLength(this.getLength());
            if (CharInputTextField.this.isLanguageRelative) {
                if (n3 >= CharInputTextField.this.maxLength) {
                    CharInputTextField.this.showTipForNumber();
                    return;
                }
            } else if (this.getLength() >= CharInputTextField.this.maxLength) {
                CharInputTextField.this.showTipForNumber();
                return;
            }
            n4 = 0;
            String string2 = this.getCombinedString(n, string);
            for (n2 = 0; n2 < CharInputTextField.this.invalidStrings.length; ++n2) {
                if (CharInputTextField.this.invalidStrings[n2].length() == 0 || (n4 = string2.indexOf(CharInputTextField.this.invalidStrings[n2])) == -1) continue;
                CharInputTextField.this.showTipForString(CharInputTextField.this.invalidStrings[n2]);
                return;
            }
            if (CharInputTextField.this.validString != null) {
                for (n2 = 0; n2 < string.length(); ++n2) {
                    if (CharInputTextField.this.validString.indexOf(string.charAt(n2)) != -1) continue;
                    CharInputTextField.this.showTipForChar(string.charAt(n2));
                    return;
                }
            } else {
                for (n2 = 0; n2 < CharInputTextField.this.invalidChars.length; ++n2) {
                    n4 = string.indexOf(CharInputTextField.this.invalidChars[n2]);
                    if (n4 == -1) continue;
                    CharInputTextField.this.showTipForInvalidChars(CharInputTextField.this.invalidChars);
                    return;
                }
            }
            for (n2 = 0; n2 < CharInputTextField.this.invalidStrings.length; ++n2) {
                if (CharInputTextField.this.invalidStrings[n2].length() == 0 || (n4 = string.indexOf(CharInputTextField.this.invalidStrings[n2])) == -1) continue;
                CharInputTextField.this.showTipForString(CharInputTextField.this.invalidStrings[n2]);
                return;
            }
            CharInputTextField.this.validString(this.getCombinedString(n, string));
            if (CharInputTextField.this.isLanguageRelative) {
                String string3 = System.getProperty("file.encoding");
                int n5 = string.getBytes().length;
                if (CharInputTextField.this.isJudgeLengthByGBK()) {
                    n5 = CommonUtil.getUTFStringGBKLength(string);
                }
                if (n3 + n5 > CharInputTextField.this.maxLength) {
                    int n6 = CharInputTextField.this.maxLength - n3;
                    byte[] byArray = string.getBytes();
                    char[] cArray = string.toCharArray();
                    int n7 = 0;
                    for (int i = 0; i < cArray.length; ++i) {
                        if (null != string3 && "utf-8".equals(string3.toLowerCase()) && CharInputTextField.this.isJudgeLengthByGBK()) {
                            if (String.valueOf(cArray[i]).getBytes().length == 3) {
                                n7 += 3;
                                ++n6;
                            } else {
                                n7 += String.valueOf(cArray[i]).getBytes().length;
                            }
                            if (n7 > n6) {
                                CharInputTextField.this.showTipForNumber();
                                n7 -= String.valueOf(cArray[i]).getBytes().length;
                                break;
                            }
                            if (n7 != n6) continue;
                            break;
                        }
                        if (String.valueOf(cArray[i]).getBytes().length == 1) {
                            ++n7;
                        } else {
                            ++n7;
                            ++n7;
                        }
                        if (n7 > n6) {
                            CharInputTextField.this.showTipForNumber();
                            --n7;
                            --n7;
                            break;
                        }
                        if (n7 == n6) break;
                    }
                    String string4 = new String(byArray, 0, n7);
                    super.insertString(n, string4, attributeSet);
                    return;
                }
            } else if (this.getLength() + string.length() >= CharInputTextField.this.maxLength) {
                n2 = CharInputTextField.this.maxLength - this.getLength();
                String string5 = string.substring(0, n2);
                super.insertString(n, string5, attributeSet);
                return;
            }
            super.insertString(n, string, attributeSet);
        }

        @Override
        public void remove(int n, int n2) throws BadLocationException {
            String string = this.getText(n, n2);
            super.remove(n, n2);
            String string2 = this.getText(0, this.getLength());
            int n3 = 0;
            for (int i = 0; i < CharInputTextField.this.invalidStrings.length; ++i) {
                if (CharInputTextField.this.invalidStrings[i].length() == 0 || (n3 = string2.indexOf(CharInputTextField.this.invalidStrings[i])) == -1) continue;
                super.insertString(n, string, null);
                CharInputTextField.this.showTipForString(CharInputTextField.this.invalidStrings[i]);
                return;
            }
            CharInputTextField.this.validString(this.getText(0, this.getLength()));
        }

        private String getCombinedString(int n, String string) throws BadLocationException {
            String string2 = this.getText(0, this.getLength());
            return string2.substring(0, n) + string + string2.substring(n, this.getLength());
        }
    }
}

