/*
 * Decompiled with CFR 0.152.
 */
package com.swimap.iview.templates.textfield;

import com.swimap.iview.commstyle.resource.ResourceMng;
import com.swimap.iview.templates.textfield.InputValidListener;
import com.swimap.iview.templates.textfield.TipComponent;
import com.swimap.iview.templates.textfield.ValueChangedListener;
import java.awt.Color;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.util.HashSet;
import java.util.Iterator;
import java.util.ResourceBundle;
import javax.swing.BorderFactory;
import javax.swing.JTextField;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;
import javax.swing.border.LineBorder;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.PlainDocument;

public class BoundedNumberTextField
extends JTextField
implements FocusListener {
    private static ResourceBundle res = ResourceMng.getInstance().getResourceBundleFromPropertyFile("mainfrm/iview/templates/textfield/Res");
    public static final String DEFAULTKEY = "DEFAULT";
    public static final int SMALLVALUEINDEX = 0;
    public static final int BIGVALUEINDEX = 1;
    private TipComponent tip = new TipComponent();
    private boolean setDefault = false;
    private long defaultValue = 0L;
    public static Border FOCUS_BORDER = BorderFactory.createCompoundBorder(new EmptyBorder(1, 1, 1, 1), new LineBorder(UIManager.getColor("Table.gridColor")));
    public static Border ERROR_BORDER = BorderFactory.createCompoundBorder(new EmptyBorder(1, 1, 1, 1), new LineBorder(Color.red));
    private boolean isBeforeValueSet = false;
    private int beforeValue;
    private long[][] numRange = null;
    private long oldValue = 0L;
    private boolean isShowToolTipOnfocus = true;

    public static BoundedNumberTextField getBoundedNumberTextFieldInstance(String string) {
        return new BoundedNumberTextField(BoundedNumberTextField.getColumn(), BoundedNumberTextField.getNumberRange());
    }

    public static BoundedNumberTextField getBoundedNumberTextFieldInstance() {
        return BoundedNumberTextField.getBoundedNumberTextFieldInstance(DEFAULTKEY);
    }

    private static int getColumn() {
        return 0;
    }

    private static long[][] getNumberRange() {
        return new long[][]{{-5L, 5L}, {200L, 999L}};
    }

    public BoundedNumberTextField(int n, long[][] lArray) {
        super(n);
        this.setDocument(new NumberDocument());
        this.setRange(lArray);
        this.addFocusListener(this);
        this.addInputValidListener(new InputValidTooltipListener());
        this.setName("BoundedNumberTextField");
    }

    public BoundedNumberTextField(long[][] lArray) {
        this(0, lArray);
    }

    public void setRange(long[][] lArray) {
        this.assertValidRange(lArray);
        this.numRange = this.removeDuplicateRange(lArray);
    }

    public long[][] getRange() {
        return this.numRange;
    }

    public boolean setValue(long l) {
        if (this.validValue(l)) {
            this.oldValue = l;
            this.setText(String.valueOf(l));
            this.setCaretPosition(this.getDocument().getLength());
            return true;
        }
        return false;
    }

    public long getValue() {
        try {
            return Long.parseLong(this.getText());
        }
        catch (Exception exception) {
            return 0L;
        }
    }

    public void addInputValidListener(InputValidListener inputValidListener) {
        this.listenerList.add(InputValidListener.class, inputValidListener);
    }

    public void addValueChangedListener(ValueChangedListener valueChangedListener) {
        this.listenerList.add(ValueChangedListener.class, valueChangedListener);
    }

    @Override
    public void focusGained(FocusEvent focusEvent) {
        String string;
        if (this.isShowToolTipOnfocus) {
            this.showTipComponent(true);
        }
        if (null != (string = this.getText()) && !string.isEmpty()) {
            try {
                this.beforeValue = Integer.parseInt(string);
                if (this.validValue(this.beforeValue)) {
                    this.isBeforeValueSet = true;
                }
            }
            catch (NumberFormatException numberFormatException) {
                this.isBeforeValueSet = false;
            }
        }
    }

    public void ignoreTooltipOnFocus() {
        this.isShowToolTipOnfocus = false;
    }

    @Override
    public void focusLost(FocusEvent focusEvent) {
        block7: {
            this.showTipComponent(false);
            try {
                long l = Long.parseLong(this.getText());
                if (!this.validValue(l)) {
                    if (this.setDefault) {
                        this.setValue(this.defaultValue);
                    } else {
                        if (this.isBeforeValueSet) {
                            this.setText(this.beforeValue + "");
                        } else {
                            this.setText("");
                        }
                        this.isBeforeValueSet = false;
                    }
                }
            }
            catch (Exception exception) {
                if (!this.setDefault) break block7;
                this.setValue(this.defaultValue);
            }
        }
    }

    public void setDefaultValue(long l) {
        if (this.validValue(l)) {
            this.setDefault = true;
            this.defaultValue = l;
        }
    }

    public long getDefaultValue() {
        return this.defaultValue;
    }

    @Override
    public String getToolTipText() {
        int n = this.numRange.length;
        StringBuffer stringBuffer = new StringBuffer(22);
        stringBuffer.append(this.getTooltipTextForRange());
        for (int i = 0; i < n; ++i) {
            if (this.numRange[i][0] == this.numRange[i][1]) {
                stringBuffer.append("{");
                stringBuffer.append(this.numRange[i][0]);
                stringBuffer.append("}, ");
                continue;
            }
            stringBuffer.append("[");
            stringBuffer.append(this.numRange[i][0]);
            stringBuffer.append(", ");
            stringBuffer.append(this.numRange[i][1]);
            stringBuffer.append("], ");
        }
        stringBuffer.deleteCharAt(stringBuffer.lastIndexOf(", "));
        return stringBuffer.toString();
    }

    public String getTooltipTextForRange() {
        return res.getString("RangeError.tooltip");
    }

    public String getTooltipTextForNumber() {
        return res.getString("NumberError.tooltip");
    }

    private boolean validValue(long l) {
        int n = this.numRange.length;
        long l2 = 0L;
        long l3 = 0L;
        for (int i = 0; i < n; ++i) {
            l2 = this.numRange[i][0];
            l3 = this.numRange[i][1];
            if (l < l2 || l > l3) continue;
            return true;
        }
        return false;
    }

    private void assertValidRange(long[][] lArray) {
        if (null == lArray) {
            return;
        }
        long l = 0L;
        for (int i = 0; i < lArray.length; ++i) {
            if (lArray[i][0] <= lArray[i][1]) continue;
            l = lArray[i][1];
            lArray[i][1] = lArray[i][0];
            lArray[i][0] = l;
        }
    }

    private long[][] removeDuplicateRange(long[][] lArray) {
        if (null == lArray || 0 == lArray.length) {
            return lArray;
        }
        HashSet<String> hashSet = new HashSet<String>(lArray.length);
        for (int i = 0; i < lArray.length; ++i) {
            hashSet.add(lArray[i][0] + ":" + lArray[i][1]);
        }
        if (lArray.length == hashSet.size()) {
            return lArray;
        }
        long[][] lArray2 = new long[hashSet.size()][2];
        Iterator iterator = hashSet.iterator();
        int n = 0;
        String string = null;
        String[] stringArray = null;
        boolean bl = iterator.hasNext();
        while (bl) {
            string = (String)iterator.next();
            stringArray = string.split(":");
            lArray2[n][0] = Long.parseLong(stringArray[0]);
            lArray2[n][1] = Long.parseLong(stringArray[1]);
            ++n;
            bl = iterator.hasNext();
        }
        return lArray2;
    }

    private long getMinumInRange() {
        int n = this.numRange.length;
        long l = Long.MAX_VALUE;
        for (int i = 0; i < n; ++i) {
            if (l <= this.numRange[i][0]) continue;
            l = this.numRange[i][0];
        }
        return l;
    }

    private long getMaxumInRange() {
        int n = this.numRange.length;
        long l = Long.MIN_VALUE;
        for (int i = 0; i < n; ++i) {
            if (l >= this.numRange[i][1]) continue;
            l = this.numRange[i][1];
        }
        return l;
    }

    private boolean validRange(long l) {
        long l2 = this.getMinumInRange();
        long l3 = this.getMaxumInRange();
        return l >= l2 && l <= l3;
    }

    private void fireNumberValidChanged(boolean bl) {
        Object[] objectArray = this.listenerList.getListenerList();
        for (int i = objectArray.length - 2; i >= 0; i -= 2) {
            if (objectArray[i] != InputValidListener.class) continue;
            ((InputValidListener)objectArray[i + 1]).inputValidChanged(bl);
        }
    }

    private void fireValueChanged(boolean bl) {
        Object[] objectArray = this.listenerList.getListenerList();
        for (int i = objectArray.length - 2; i >= 0; i -= 2) {
            if (objectArray[i] != ValueChangedListener.class) continue;
            ((ValueChangedListener)objectArray[i + 1]).ValueChanged(bl);
        }
    }

    private void showTipComponent(boolean bl) {
        this.tip.setText(this.getToolTipText());
        this.tip.setInvoker(this);
        this.tip.setVisible(bl);
        if (bl) {
            this.tip.disposeLater();
        }
    }

    private void showTipForNumber() {
        this.tip.setText(this.getTooltipTextForNumber());
        this.tip.setInvoker(this);
        this.tip.setVisible(true);
        this.tip.disposeLater();
    }

    private class InputValidTooltipListener
    implements InputValidListener {
        private InputValidTooltipListener() {
        }

        @Override
        public void inputValidChanged(boolean bl) {
            BoundedNumberTextField.this.showTipComponent(!bl);
        }
    }

    private class NumberDocument
    extends PlainDocument {
        @Override
        public void insertString(int n, String string, AttributeSet attributeSet) throws BadLocationException {
            long l;
            String string2;
            block15: {
                string2 = this.getCombinedString(n, string = string.trim());
                if ("-".equals(string2)) {
                    if (0L > BoundedNumberTextField.this.getMinumInRange()) {
                        super.insertString(n, string, attributeSet);
                    } else {
                        BoundedNumberTextField.this.showTipForNumber();
                    }
                    return;
                }
                if (string2.startsWith("-0")) {
                    BoundedNumberTextField.this.showTipForNumber();
                    return;
                }
                if (2 <= string2.length() && string2.charAt(0) == '0') {
                    BoundedNumberTextField.this.showTipForNumber();
                    return;
                }
                l = 0L;
                try {
                    l = Long.parseLong(string2);
                }
                catch (NumberFormatException numberFormatException) {
                    if (!BoundedNumberTextField.this.isFocusOwner()) break block15;
                    BoundedNumberTextField.this.showTipForNumber();
                    return;
                }
            }
            if (BoundedNumberTextField.this.getMinumInRange() >= 1L) {
                if (l > BoundedNumberTextField.this.getMaxumInRange() || l < 1L) {
                    BoundedNumberTextField.this.showTipComponent(true);
                    return;
                }
            } else if (BoundedNumberTextField.this.getMaxumInRange() <= -1L) {
                if (l > 0L || l < BoundedNumberTextField.this.getMinumInRange()) {
                    BoundedNumberTextField.this.showTipComponent(true);
                    return;
                }
            } else if (!BoundedNumberTextField.this.validRange(l)) {
                BoundedNumberTextField.this.showTipComponent(true);
                return;
            }
            if (this.validNumber(string2)) {
                super.insertString(n, string, attributeSet);
            }
        }

        @Override
        public void remove(int n, int n2) throws BadLocationException {
            super.remove(n, n2);
            this.validNumber(this.getText(0, this.getLength()));
        }

        private String getCombinedString(int n, String string) throws BadLocationException {
            String string2 = this.getText(0, this.getLength());
            return string2.substring(0, n) + string + string2.substring(n, this.getLength());
        }

        private boolean validNumber(String string) {
            try {
                long l = Long.parseLong(string);
                boolean bl = BoundedNumberTextField.this.validValue(l);
                if (bl) {
                    BoundedNumberTextField.this.fireValueChanged(l != BoundedNumberTextField.this.oldValue);
                }
                BoundedNumberTextField.this.fireNumberValidChanged(bl);
                return true;
            }
            catch (Exception exception) {
                BoundedNumberTextField.this.fireNumberValidChanged(false);
                return false;
            }
        }
    }
}

