/*
 * Decompiled with CFR 0.152.
 */
package com.swimap.iview.templates.textfield;

import com.swimap.iview.commstyle.resource.ResourceMng;
import com.swimap.iview.templates.textfield.InputValidListener;
import com.swimap.iview.templates.textfield.TipComponent;
import com.swimap.iview.templates.textfield.ValueChangedListener;
import java.awt.Color;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.util.HashSet;
import java.util.Iterator;
import java.util.ResourceBundle;
import javax.swing.BorderFactory;
import javax.swing.JTextField;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;
import javax.swing.border.LineBorder;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.PlainDocument;

public class BoundedDoubleNumberTextField
extends JTextField
implements FocusListener {
    private static ResourceBundle res = ResourceMng.getInstance().getResourceBundleFromPropertyFile("mainfrm/iview/templates/textfield/Res");
    public static final String DEFAULTKEY = "DEFAULT";
    public static final int SMALLVALUEINDEX = 0;
    public static final int BIGVALUEINDEX = 1;
    private static final int MAX_PRECISION = 15;
    private static final int DEFAULT_PRECISION = 5;
    private int precision = 5;
    private TipComponent tip = new TipComponent();
    private String invalidChar = "abcedfABCDEF";
    private boolean setDefault = false;
    private double defaultValue = 0.0;
    private double[][] numRange = null;
    private double oldValue = 0.0;
    public static Border FOCUS_BORDER = BorderFactory.createCompoundBorder(new EmptyBorder(1, 1, 1, 1), new LineBorder(UIManager.getColor("Table.gridColor")));
    public static Border ERROR_BORDER = BorderFactory.createCompoundBorder(new EmptyBorder(1, 1, 1, 1), new LineBorder(Color.red));
    private boolean isShowToolTipOnfocus = true;
    private boolean isBeforeValueSet = false;
    private int beforeValue;

    public static BoundedDoubleNumberTextField getBoundedNumberTextFieldInstance(String string) {
        return new BoundedDoubleNumberTextField(BoundedDoubleNumberTextField.getColumn(), BoundedDoubleNumberTextField.getNumberRange());
    }

    public static BoundedDoubleNumberTextField getBoundedNumberTextFieldInstance() {
        return BoundedDoubleNumberTextField.getBoundedNumberTextFieldInstance(DEFAULTKEY);
    }

    private static int getColumn() {
        return 0;
    }

    private static double[][] getNumberRange() {
        return new double[][]{{0.0, 1.0}, {10.2, 1441.99}};
    }

    public BoundedDoubleNumberTextField(int n, double[][] dArray) {
        super(n);
        this.setDocument(new NumberDocument());
        this.setRange(dArray);
        this.addFocusListener(this);
        this.addInputValidListener(new InputValidTooltipListener());
        this.setName("BoundedDoubleNumberTextField");
    }

    public BoundedDoubleNumberTextField(double[][] dArray) {
        this(0, dArray);
    }

    public void setRange(double[][] dArray) {
        this.assertValidRange(dArray);
        this.numRange = this.removeDuplicateRange(dArray);
    }

    public double[][] getRange() {
        return this.numRange;
    }

    public boolean setValue(double d) {
        if (this.validValue(d)) {
            this.oldValue = d;
            this.setText(String.valueOf(d));
            this.setCaretPosition(this.getDocument().getLength());
            return true;
        }
        return false;
    }

    public double getValue() {
        try {
            return Double.parseDouble(this.getText());
        }
        catch (Exception exception) {
            return 0.0;
        }
    }

    public void setPrecision(int n) {
        this.precision = n < 0 ? 0 : (n > 15 ? 15 : n);
    }

    public int getPrecision() {
        return this.precision;
    }

    public String getTooltipTextForRange() {
        return res.getString("RangeError.tooltip");
    }

    public String getTooltipTextForPrecision() {
        StringBuffer stringBuffer = new StringBuffer(res.getString("PrecisionError.tooltip"));
        stringBuffer.append(this.precision);
        return stringBuffer.toString();
    }

    public String getTooltipTextForNumber() {
        return res.getString("NumberError.tooltip");
    }

    public void addInputValidListener(InputValidListener inputValidListener) {
        this.listenerList.add(InputValidListener.class, inputValidListener);
    }

    public void addValueChangedListener(ValueChangedListener valueChangedListener) {
        this.listenerList.add(ValueChangedListener.class, valueChangedListener);
    }

    @Override
    public void focusGained(FocusEvent focusEvent) {
        String string;
        if (this.isShowToolTipOnfocus) {
            this.showTipComponent(true);
        }
        if (null != (string = this.getText()) && !string.isEmpty()) {
            try {
                this.beforeValue = Integer.parseInt(string);
                if (this.validValue(this.beforeValue)) {
                    this.isBeforeValueSet = true;
                }
            }
            catch (NumberFormatException numberFormatException) {
                this.isBeforeValueSet = false;
            }
        }
    }

    public void ignoreTooltipOnFocus() {
        this.isShowToolTipOnfocus = false;
    }

    @Override
    public void focusLost(FocusEvent focusEvent) {
        block7: {
            this.showTipComponent(false);
            try {
                double d = Double.parseDouble(this.getText());
                if (!this.validValue(d)) {
                    if (this.setDefault) {
                        this.setValue(this.defaultValue);
                    } else {
                        if (this.isBeforeValueSet) {
                            this.setText(this.beforeValue + "");
                        } else {
                            this.setText("");
                        }
                        this.isBeforeValueSet = false;
                    }
                }
            }
            catch (Exception exception) {
                if (!this.setDefault) break block7;
                this.setValue(this.defaultValue);
            }
        }
    }

    public void setDefaultValue(double d) {
        if (this.validValue(d)) {
            this.setDefault = true;
            this.defaultValue = d;
        }
    }

    public double getDefaultValue() {
        return this.defaultValue;
    }

    @Override
    public String getToolTipText() {
        int n = this.numRange.length;
        StringBuffer stringBuffer = new StringBuffer(22);
        stringBuffer.append(this.getTooltipTextForRange());
        for (int i = 0; i < n; ++i) {
            if (this.numRange[i][0] == this.numRange[i][1]) {
                stringBuffer.append("{");
                stringBuffer.append(this.numRange[i][0]);
                stringBuffer.append("}, ");
                continue;
            }
            stringBuffer.append("[");
            stringBuffer.append(this.numRange[i][0]);
            stringBuffer.append(", ");
            stringBuffer.append(this.numRange[i][1]);
            stringBuffer.append("], ");
        }
        stringBuffer.deleteCharAt(stringBuffer.lastIndexOf(", "));
        return stringBuffer.toString();
    }

    private boolean validValue(double d) {
        int n = this.numRange.length;
        double d2 = 0.0;
        double d3 = 0.0;
        for (int i = 0; i < n; ++i) {
            d2 = this.numRange[i][0];
            d3 = this.numRange[i][1];
            if (!(d >= d2) || !(d <= d3)) continue;
            return true;
        }
        return false;
    }

    private void assertValidRange(double[][] dArray) {
        if (null == dArray) {
            return;
        }
        double d = 0.0;
        for (int i = 0; i < dArray.length; ++i) {
            if (!(dArray[i][0] > dArray[i][1])) continue;
            d = dArray[i][1];
            dArray[i][1] = dArray[i][0];
            dArray[i][0] = d;
        }
    }

    private double[][] removeDuplicateRange(double[][] dArray) {
        if (null == dArray || 0 == dArray.length) {
            return dArray;
        }
        HashSet<String> hashSet = new HashSet<String>(dArray.length);
        for (int i = 0; i < dArray.length; ++i) {
            hashSet.add(dArray[i][0] + "," + dArray[i][1]);
        }
        if (dArray.length == hashSet.size()) {
            return dArray;
        }
        double[][] dArray2 = new double[hashSet.size()][2];
        Iterator iterator = hashSet.iterator();
        int n = 0;
        String string = null;
        String[] stringArray = null;
        boolean bl = iterator.hasNext();
        while (bl) {
            string = (String)iterator.next();
            stringArray = string.split(",");
            dArray2[n][0] = Double.parseDouble(stringArray[0]);
            dArray2[n][1] = Double.parseDouble(stringArray[1]);
            ++n;
            bl = iterator.hasNext();
        }
        return dArray2;
    }

    private double getMinumInRange() {
        int n = this.numRange.length;
        double d = Double.MAX_VALUE;
        for (int i = 0; i < n; ++i) {
            if (!(d > this.numRange[i][0])) continue;
            d = this.numRange[i][0];
        }
        return d;
    }

    private double getMaxumInRange() {
        int n = this.numRange.length;
        double d = Double.MIN_VALUE;
        for (int i = 0; i < n; ++i) {
            if (!(d < this.numRange[i][1])) continue;
            d = this.numRange[i][1];
        }
        return d;
    }

    private boolean validRange(double d) {
        double d2 = this.getMinumInRange();
        double d3 = this.getMaxumInRange();
        return d >= d2 && d <= d3;
    }

    private void fireNumberValidChanged(boolean bl) {
        Object[] objectArray = this.listenerList.getListenerList();
        for (int i = objectArray.length - 2; i >= 0; i -= 2) {
            if (objectArray[i] != InputValidListener.class) continue;
            ((InputValidListener)objectArray[i + 1]).inputValidChanged(bl);
        }
    }

    private void fireValueChanged(boolean bl) {
        Object[] objectArray = this.listenerList.getListenerList();
        for (int i = objectArray.length - 2; i >= 0; i -= 2) {
            if (objectArray[i] != ValueChangedListener.class) continue;
            ((ValueChangedListener)objectArray[i + 1]).ValueChanged(bl);
        }
    }

    private void showTipComponent(boolean bl) {
        this.tip.setText(this.getToolTipText());
        this.tip.setInvoker(this);
        this.tip.setVisible(bl);
        if (bl) {
            this.tip.disposeLater();
        }
    }

    private void showTipForNumber() {
        this.tip.setText(this.getTooltipTextForNumber());
        this.tip.setInvoker(this);
        this.tip.setVisible(true);
        this.tip.disposeLater();
    }

    private void showTipForPrecision() {
        this.tip.setText(this.getTooltipTextForPrecision());
        this.tip.setInvoker(this);
        this.tip.setVisible(true);
        this.tip.disposeLater();
    }

    private class InputValidTooltipListener
    implements InputValidListener {
        private InputValidTooltipListener() {
        }

        @Override
        public void inputValidChanged(boolean bl) {
            BoundedDoubleNumberTextField.this.showTipComponent(!bl);
        }
    }

    private class NumberDocument
    extends PlainDocument {
        @Override
        public void insertString(int n, String string, AttributeSet attributeSet) throws BadLocationException {
            double d;
            String string2;
            block18: {
                int n2;
                string = string.trim();
                int n3 = BoundedDoubleNumberTextField.this.invalidChar.indexOf(string);
                if (n3 != -1) {
                    BoundedDoubleNumberTextField.this.showTipForNumber();
                    return;
                }
                if (BoundedDoubleNumberTextField.this.precision == 0 && ".".equalsIgnoreCase(string)) {
                    BoundedDoubleNumberTextField.this.showTipForNumber();
                    return;
                }
                string2 = this.getCombinedString(n, string);
                if ("-".equals(string2) || "-0".equals(string2)) {
                    if (0.0 > BoundedDoubleNumberTextField.this.getMinumInRange()) {
                        super.insertString(n, string, attributeSet);
                    } else {
                        BoundedDoubleNumberTextField.this.showTipForNumber();
                    }
                    return;
                }
                if (string2.startsWith("-0") && 3 <= string2.length() && !string2.startsWith("-0.")) {
                    BoundedDoubleNumberTextField.this.showTipForNumber();
                    return;
                }
                if (2 <= string2.length() && string2.charAt(0) == '0' && !string2.startsWith("0.")) {
                    BoundedDoubleNumberTextField.this.showTipForNumber();
                    return;
                }
                int n4 = string2.length();
                int n5 = string2.indexOf(46);
                if (n5 == -1) {
                    n5 = n4;
                }
                if ((n2 = n4 - n5 - 1) > BoundedDoubleNumberTextField.this.precision) {
                    BoundedDoubleNumberTextField.this.showTipForPrecision();
                    return;
                }
                d = 0.0;
                try {
                    d = Double.parseDouble(string2);
                }
                catch (NumberFormatException numberFormatException) {
                    if (!BoundedDoubleNumberTextField.this.isFocusOwner()) break block18;
                    BoundedDoubleNumberTextField.this.showTipForNumber();
                    return;
                }
            }
            if (BoundedDoubleNumberTextField.this.getMinumInRange() >= 1.0 && (d > BoundedDoubleNumberTextField.this.getMaxumInRange() || d < 1.0)) {
                BoundedDoubleNumberTextField.this.showTipComponent(true);
                return;
            }
            if (BoundedDoubleNumberTextField.this.getMaxumInRange() <= -1.0 && (d > 0.0 || d < BoundedDoubleNumberTextField.this.getMinumInRange())) {
                BoundedDoubleNumberTextField.this.showTipComponent(true);
                return;
            }
            if (!BoundedDoubleNumberTextField.this.validRange(d)) {
                BoundedDoubleNumberTextField.this.showTipComponent(true);
                if (d > BoundedDoubleNumberTextField.this.getMaxumInRange()) {
                    return;
                }
                if (Math.abs(d) > Math.abs(BoundedDoubleNumberTextField.this.getMinumInRange())) {
                    return;
                }
                if (d < BoundedDoubleNumberTextField.this.getMinumInRange() && string2.length() >= Double.toString(BoundedDoubleNumberTextField.this.getMinumInRange()).length()) {
                    return;
                }
            }
            if (this.validNumber(string2)) {
                super.insertString(n, string, attributeSet);
            }
        }

        @Override
        public void remove(int n, int n2) throws BadLocationException {
            super.remove(n, n2);
            this.validNumber(this.getText(0, this.getLength()));
        }

        private String getCombinedString(int n, String string) throws BadLocationException {
            int n2 = this.getLength();
            String string2 = this.getText(0, n2);
            StringBuffer stringBuffer = new StringBuffer(16);
            stringBuffer.append(string2.substring(0, n)).append(string).append(string2.substring(n, n2));
            return stringBuffer.toString();
        }

        private boolean validNumber(String string) {
            try {
                double d = Double.parseDouble(string);
                boolean bl = BoundedDoubleNumberTextField.this.validValue(d);
                if (bl) {
                    BoundedDoubleNumberTextField.this.fireValueChanged(d > BoundedDoubleNumberTextField.this.oldValue || d < BoundedDoubleNumberTextField.this.oldValue);
                    BoundedDoubleNumberTextField.this.oldValue = d;
                }
                BoundedDoubleNumberTextField.this.fireNumberValidChanged(bl);
                return true;
            }
            catch (NumberFormatException numberFormatException) {
                BoundedDoubleNumberTextField.this.fireNumberValidChanged(false);
                return false;
            }
        }
    }
}

