/*
 * Decompiled with CFR 0.152.
 */
package com.swimap.iview.templates.textfield;

import com.swimap.iview.templates.textfield.AssnPopup;
import com.swimap.iview.util.CommonUtil;
import com.swimap.iview.util.log.IviewLogger;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Vector;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;

public class BasicAssnTextField
extends JTextField {
    private static IviewLogger logger = IviewLogger.getLogger(BasicAssnTextField.class, "IVIEW");
    protected AssnPopup popup = null;
    public static final int DEFAULT_HISTORY_SIZE = 10;
    protected int maxRecordNo = 10;
    protected Vector historyDatas = null;
    protected String fileName = null;
    protected boolean isDoubleClick = false;

    public BasicAssnTextField(String string) {
        this(string, 10);
    }

    public BasicAssnTextField(String string, int n) {
        this.fileName = string;
        if (n >= 0) {
            this.maxRecordNo = n;
        }
        this.init();
    }

    protected void init() {
        this.popup = new AssnPopup(this);
        this.getDocument().addDocumentListener(new DocumentListenerAdapter());
        this.addPropertyChangeListener("document", new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                BasicAssnTextField.this.getDocument().addDocumentListener(new DocumentListenerAdapter());
            }
        });
        this.addMouseListener(new MouseAdapterHold());
        this.addKeyListener(new KeyAdapterHolder());
        this.historyDatas = this.getHistoryDatas(this.fileName);
        this.setName("BasicAssnTextField");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Vector getHistoryDatas(String string) {
        Vector<String> vector;
        block20: {
            vector = new Vector<String>(10);
            File file = new File(string = CommonUtil.getAbsolutePath(string));
            File file2 = file.getParentFile();
            if (!file2.exists()) {
                file2.mkdir();
            }
            BufferedReader bufferedReader = null;
            try {
                if (!file.exists()) {
                    if (!file.createNewFile()) {
                        Vector<String> vector2 = vector;
                        return vector2;
                    }
                    break block20;
                }
                bufferedReader = new BufferedReader(new FileReader(string));
                String string2 = null;
                for (int i = 0; i < this.maxRecordNo; ++i) {
                    string2 = bufferedReader.readLine();
                    if (string2 == null) {
                        break;
                    }
                    vector.add(string2);
                }
            }
            catch (Exception exception) {
                logger.trace(exception.getMessage(), exception);
            }
            finally {
                if (bufferedReader != null) {
                    try {
                        bufferedReader.close();
                    }
                    catch (IOException iOException) {
                        logger.trace(iOException.getMessage(), iOException);
                    }
                }
            }
        }
        return vector;
    }

    public void saveInput() {
        String string = this.getText();
        if (string != null && !"".equals(string)) {
            if (this.historyDatas.contains(string)) {
                this.historyDatas.remove(string);
            }
            this.historyDatas.add(0, string);
            this.writeDataToFile(this.fileName, this.historyDatas);
        }
    }

    public void setDoubleClick(boolean bl) {
        this.isDoubleClick = bl;
    }

    protected void valueChangeProcess(String string) {
    }

    protected void keyEventProcess(KeyEvent keyEvent) {
    }

    protected void mouseEventProcess(MouseEvent mouseEvent) {
        if (mouseEvent.getClickCount() >= 2 && this.isDoubleClick && this.isShowing()) {
            this.popup.setListData(this.historyDatas);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeDataToFile(String string, Vector vector) {
        PrintWriter printWriter = null;
        try {
            string = CommonUtil.getAbsolutePath(string);
            File file = new File(string);
            File file2 = file.getParentFile();
            if (null != file2 && !file2.exists()) {
                file2.mkdirs();
            }
            printWriter = new PrintWriter(new BufferedWriter(new FileWriter(file)));
            StringBuffer stringBuffer = new StringBuffer(10);
            int n = Math.min(this.maxRecordNo, vector.size());
            for (int i = 0; i < n; ++i) {
                stringBuffer.append((String)vector.get(i) + System.getProperty("line.separator"));
            }
            printWriter.write(stringBuffer.toString());
        }
        catch (Exception exception) {
            logger.trace(exception.getMessage(), exception);
        }
        finally {
            if (printWriter != null) {
                try {
                    printWriter.close();
                }
                catch (Exception exception) {
                    logger.trace(exception.getMessage(), exception);
                }
            }
        }
    }

    private final class KeyAdapterHolder
    extends KeyAdapter {
        private KeyAdapterHolder() {
        }

        @Override
        public void keyPressed(KeyEvent keyEvent) {
            BasicAssnTextField.this.keyEventProcess(keyEvent);
        }
    }

    private final class MouseAdapterHold
    extends MouseAdapter {
        private MouseAdapterHold() {
        }

        @Override
        public void mouseClicked(MouseEvent mouseEvent) {
            BasicAssnTextField.this.mouseEventProcess(mouseEvent);
        }
    }

    private final class DocumentListenerAdapter
    implements DocumentListener {
        private DocumentListenerAdapter() {
        }

        @Override
        public void insertUpdate(DocumentEvent documentEvent) {
            BasicAssnTextField.this.valueChangeProcess(BasicAssnTextField.this.getText());
        }

        @Override
        public void removeUpdate(DocumentEvent documentEvent) {
            BasicAssnTextField.this.valueChangeProcess(BasicAssnTextField.this.getText());
        }

        @Override
        public void changedUpdate(DocumentEvent documentEvent) {
        }
    }
}

