/*
 * Decompiled with CFR 0.152.
 */
package com.swimap.iview.templates.textfield;

import com.swimap.iview.templates.textfield.BasicAssnTextField;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.JList;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.ListCellRenderer;
import javax.swing.ListModel;
import javax.swing.UIManager;
import javax.swing.event.ListDataListener;

public class AssnPopup
extends JPopupMenu {
    static final ListModel EmptyListModel = new ListModel(){

        @Override
        public int getSize() {
            return 0;
        }

        public Object getElementAt(int n) {
            return null;
        }

        @Override
        public void addListDataListener(ListDataListener listDataListener) {
        }

        @Override
        public void removeListDataListener(ListDataListener listDataListener) {
        }
    };
    private BasicAssnTextField textField;
    private JList list;
    private JScrollPane scroller;
    private static final int DEFAULT_SHOW_ROW_COUNT = 6;
    private static final int DEFAULT_HEIGHT = 100;
    private static final int INCREASE_HEIGHT = 17;

    public AssnPopup(BasicAssnTextField basicAssnTextField) {
        this.textField = basicAssnTextField;
        this.textField.setName("AssnPopup_textField");
        this.list = new JList();
        this.list.setName("AssnPopup_list");
        this.configureList();
        this.scroller = new JScrollPane(this.list, 20, 30);
        this.scroller.setName("AssnPopup_scroller");
        this.configureScroller();
        this.configurePopup();
    }

    protected void configureList() {
        this.list.setFont(this.textField.getFont());
        this.list.setForeground(this.textField.getForeground());
        this.list.setBackground(this.textField.getBackground());
        this.list.setSelectionForeground(UIManager.getColor("TextField.selectionForeground"));
        this.list.setSelectionBackground(UIManager.getColor("TextField.selectionBackground"));
        this.list.setBorder(null);
        this.list.setFocusable(false);
        this.list.setSelectionMode(0);
        this.installListListeners();
    }

    private void configureScroller() {
        this.scroller.setFocusable(false);
        this.scroller.getVerticalScrollBar().setFocusable(false);
        this.scroller.getHorizontalScrollBar().setFocusable(false);
        this.scroller.setBorder(null);
    }

    private void configurePopup() {
        this.setLayout(new BoxLayout(this, 1));
        this.setBorderPainted(true);
        this.setBorder(BorderFactory.createLineBorder(Color.black));
        this.setOpaque(false);
        this.add(this.scroller);
        this.setDoubleBuffered(true);
        this.setFocusable(false);
    }

    @Override
    public void show() {
        if (this.isVisible()) {
            this.setVisible(false);
        }
        this.calculateSize();
        this.show(this.textField, 0, this.textField.getSize().height);
        this.list.ensureIndexIsVisible(0);
    }

    private void calculateSize() {
        Dimension dimension = this.textField.getSize();
        dimension.setSize(dimension.width, this.getPopupHeightForRowCount(6));
        this.scroller.setPreferredSize(dimension);
        this.scroller.setMaximumSize(dimension);
        this.scroller.setMinimumSize(dimension);
        this.list.revalidate();
    }

    private int getPopupHeightForRowCount(int n) {
        int n2 = Math.min(n, this.list.getModel().getSize());
        int n3 = 0;
        ListCellRenderer<Object> listCellRenderer = this.list.getCellRenderer();
        Object e = null;
        Component component = null;
        int n4 = 0;
        for (int i = 0; i < n2; ++i) {
            e = this.list.getModel().getElementAt(i);
            component = listCellRenderer.getListCellRendererComponent(this.list, e, i, false, false);
            Dimension dimension = component.getPreferredSize();
            n3 += dimension.height;
            if (n4 >= dimension.width) continue;
            n4 = dimension.width;
        }
        if (n4 > this.textField.getSize().width) {
            return n3 == 0 ? 100 : n3 + 17;
        }
        return n3 == 0 ? 100 : n3;
    }

    public void setListData(Vector vector) {
        if (vector == null || vector.size() == 0 || vector.size() == 1 && vector.contains(this.textField.getText())) {
            this.list.setModel(EmptyListModel);
            this.list.revalidate();
            this.setVisible(false);
        } else {
            this.list.setListData(vector);
            this.list.revalidate();
            this.show();
        }
    }

    private void installListListeners() {
        this.list.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseReleased(MouseEvent mouseEvent) {
                AssnPopup.this.textField.setText(AssnPopup.this.list.getSelectedValue().toString());
                AssnPopup.this.setVisible(false);
            }
        });
        this.list.addMouseMotionListener(new MouseMotionAdapter(){

            @Override
            public void mouseMoved(MouseEvent mouseEvent) {
                Point point = mouseEvent.getPoint();
                Rectangle rectangle = new Rectangle();
                AssnPopup.this.list.computeVisibleRect(rectangle);
                if (rectangle.contains(point)) {
                    AssnPopup.this.updateListBoxSelectionForEvent(mouseEvent);
                }
            }
        });
    }

    public void processNavigationKey(int n) {
        if (!this.isVisible()) {
            return;
        }
        if (n == 38) {
            this.scrollUp();
        } else {
            this.scrollDown();
        }
        String string = (String)this.list.getSelectedValue();
        if (string != null) {
            this.textField.setText(string);
        }
    }

    private void scrollDown() {
        int n;
        int n2 = this.list.getSelectedIndex();
        if (n2 < (n = this.list.getModel().getSize() - 1)) {
            this.list.setSelectedIndex(n2 + 1);
            this.list.ensureIndexIsVisible(n2 + 1);
        }
    }

    private void scrollUp() {
        int n = this.list.getSelectedIndex();
        if (n > 0) {
            this.list.setSelectedIndex(n - 1);
            this.list.ensureIndexIsVisible(n - 1);
        }
    }

    private void updateListBoxSelectionForEvent(MouseEvent mouseEvent) {
        int n = 0;
        Point point = mouseEvent.getPoint();
        if (this.list == null) {
            return;
        }
        n = this.list.locationToIndex(point);
        if (n != -1 && this.list.getSelectedIndex() != n) {
            this.list.setSelectedIndex(n);
            this.list.ensureIndexIsVisible(n);
        }
    }
}

