/*
 * Decompiled with CFR 0.152.
 */
package com.swimap.iview.templates.table;

import com.swimap.iview.templates.table.ITableStyleInterface;
import com.swimap.iview.templates.table.TableStyleInformation;
import com.swimap.iview.templates.table.xml.BackgroundColor;
import com.swimap.iview.templates.table.xml.ColumnHeaderCallbacks;
import com.swimap.iview.templates.table.xml.ColumnProperty;
import com.swimap.iview.templates.table.xml.CommonColumnProperties;
import com.swimap.iview.templates.table.xml.ForegroundColor;
import com.swimap.iview.templates.table.xml.IViewTable;
import com.swimap.iview.templates.table.xml.IViewTableCallbacks;
import com.swimap.iview.templates.table.xml.IViewTableProperties;
import com.swimap.iview.templates.table.xml.IndividualColumnProperties;
import com.swimap.iview.templates.table.xml.TableCallbacks;
import com.swimap.iview.util.CommonUtil;
import com.swimap.iview.util.log.IviewLogger;
import java.io.File;
import java.io.IOException;
import java.net.URL;

public class TableXMLFileReader {
    private static IviewLogger logger = IviewLogger.getLogger(TableXMLFileReader.class, "IVIEW");
    private static final String debugTracerFile = "./table_xml_traces.txt";
    private static final String errorMessageFile = "./table_xml_errors.err";
    private boolean validity = false;
    public TableStyleInformation theTableStyleInformation = null;

    public boolean readXMLFile(String string) throws IOException {
        try {
            string = CommonUtil.getAbsolutePath(string);
            IViewTable iViewTable = null;
            File file = new File(string);
            URL uRL = file.toURL();
            iViewTable = IViewTable.unmarshal(uRL);
            this.validity = iViewTable.isValid();
            if (this.validity) {
                IViewTableProperties iViewTableProperties = iViewTable.getIViewTableProperties();
                CommonColumnProperties commonColumnProperties = iViewTableProperties.getCommonColumnProperties();
                BackgroundColor backgroundColor = commonColumnProperties.getBackgroundColor();
                ForegroundColor foregroundColor = commonColumnProperties.getForegroundColor();
                IndividualColumnProperties individualColumnProperties = iViewTableProperties.getIndividualColumnProperties();
                ColumnProperty[] columnPropertyArray = individualColumnProperties.getColumnProperty();
                IViewTableCallbacks iViewTableCallbacks = iViewTable.getIViewTableCallbacks();
                ColumnHeaderCallbacks columnHeaderCallbacks = iViewTableCallbacks.getColumnHeaderCallbacks();
                TableCallbacks tableCallbacks = iViewTableCallbacks.getTableCallbacks();
                int n = individualColumnProperties.getColumnPropertyCount();
                String[] stringArray = new String[n];
                String[] stringArray2 = new String[n];
                String[] stringArray3 = new String[n];
                String[] stringArray4 = new String[n];
                String[] stringArray5 = new String[n];
                String[] stringArray6 = new String[n];
                String[] stringArray7 = new String[n];
                String[] stringArray8 = new String[n];
                for (int i = 0; i < n; ++i) {
                    stringArray[i] = columnPropertyArray[i].getColumnName();
                    stringArray2[i] = columnPropertyArray[i].getColumnWidth();
                    stringArray3[i] = columnPropertyArray[i].getMinimumColumnWidth();
                    stringArray4[i] = columnPropertyArray[i].getMaximumColumnWidth();
                    stringArray5[i] = columnPropertyArray[i].getColumnResizable();
                    stringArray6[i] = columnPropertyArray[i].getCellRenderer();
                    stringArray7[i] = columnPropertyArray[i].getCellEditor();
                    stringArray8[i] = columnPropertyArray[i].getSortingAllowed();
                }
                this.theTableStyleInformation = new TableStyleInformation();
                if (backgroundColor != null) {
                    String[] stringArray9 = new String[]{backgroundColor.getR(), backgroundColor.getG(), backgroundColor.getB()};
                    this.theTableStyleInformation.setBackgroundColor(stringArray9);
                }
                if (foregroundColor != null) {
                    String[] stringArray10 = new String[]{foregroundColor.getR(), foregroundColor.getG(), foregroundColor.getB()};
                    this.theTableStyleInformation.setForegroundColor(stringArray10);
                }
                String[] stringArray11 = new String[]{tableCallbacks.getClickActionObject(), tableCallbacks.getClickActionFunction()};
                String[] stringArray12 = new String[]{tableCallbacks.getDoubleClickActionObject(), tableCallbacks.getDoubleClickActionFunction()};
                String[] stringArray13 = new String[]{tableCallbacks.getRightClickActionObject(), tableCallbacks.getRightClickActionFunction()};
                String[] stringArray14 = new String[]{columnHeaderCallbacks.getClickActionObject(), columnHeaderCallbacks.getClickActionFunction()};
                String[] stringArray15 = new String[]{columnHeaderCallbacks.getDoubleClickActionObject(), columnHeaderCallbacks.getDoubleClickActionFunction()};
                String[] stringArray16 = new String[]{columnHeaderCallbacks.getRightClickActionObject(), columnHeaderCallbacks.getRightClickActionFunction()};
                this.theTableStyleInformation.setColumnAutoResizeAllowed(commonColumnProperties.getColumnAutoresize());
                this.theTableStyleInformation.setHorizontalLinesVisible(commonColumnProperties.getHorizontalLinesVisible());
                this.theTableStyleInformation.setVerticalLinesVisible(commonColumnProperties.getVerticalLinesVisible());
                this.theTableStyleInformation.setRowHeight(commonColumnProperties.getRowHeight());
                this.theTableStyleInformation.setRowMargin(commonColumnProperties.getRowMargin());
                this.theTableStyleInformation.setRowSelectionAllowed(commonColumnProperties.getRowSelectionAllowed());
                this.theTableStyleInformation.setMultipleRowSelectionAllowed(commonColumnProperties.getMultipleRowSelectionAllowed());
                this.theTableStyleInformation.setColumnSelectionAllowed(commonColumnProperties.getColumnSelectionAllowed());
                this.theTableStyleInformation.setColumnCount(n);
                this.theTableStyleInformation.setColumnLabels(stringArray);
                this.theTableStyleInformation.setPreferredColumnWidths(stringArray2);
                this.theTableStyleInformation.setMinimumColumnWidths(stringArray3);
                this.theTableStyleInformation.setMaximumColumnWidths(stringArray4);
                this.theTableStyleInformation.setSortingAllowed(stringArray8);
                this.theTableStyleInformation.setColumnResizeAllowed(stringArray5);
                this.theTableStyleInformation.setMouseClickAction(stringArray11);
                this.theTableStyleInformation.setDoubleClickAction(stringArray12);
                this.theTableStyleInformation.setRightClickAction(stringArray13);
                this.theTableStyleInformation.setMouseClickOnHeaderAction(stringArray14);
                this.theTableStyleInformation.setDoubleClickOnHeaderAction(stringArray15);
                this.theTableStyleInformation.setRightClickOnHeaderAction(stringArray16);
                this.theTableStyleInformation.setModel(commonColumnProperties.getModel());
                this.theTableStyleInformation.setCellRenderer(stringArray6);
                this.theTableStyleInformation.setCellEditor(stringArray7);
                if (this.theTableStyleInformation.isReflectionError()) {
                    logger.trace("Errors were encountered while reading the XML file. However, the style information object has been created. Check the Log files (./table_xml_traces.txt  and  ./table_xml_errors.err) for mode details");
                }
            }
        }
        catch (NumberFormatException numberFormatException) {
            logger.trace(numberFormatException.getMessage(), numberFormatException);
            this.validity = false;
            logger.error("Exception while reading style information object: " + numberFormatException);
        }
        catch (Exception exception) {
            this.validity = false;
            logger.trace(exception.getMessage(), exception);
            logger.error("Exception while reading style information object: " + exception);
        }
        return this.validity;
    }

    public boolean isInformationValid() {
        return this.validity;
    }

    public boolean saveInformation(ITableStyleInterface iTableStyleInterface) {
        boolean bl = iTableStyleInterface != null & this.theTableStyleInformation != null;
        if (bl) {
            try {
                iTableStyleInterface.saveInformation(this.theTableStyleInformation);
            }
            catch (Exception exception) {
                bl = false;
                logger.error("Exception while saving style information object: " + exception);
            }
        }
        return bl;
    }

    public TableStyleInformation getTableInfoFromXML(String string) {
        boolean bl = false;
        try {
            bl = this.readXMLFile(string);
        }
        catch (Exception exception) {
            logger.trace(exception.getMessage(), exception);
            bl = false;
        }
        if (bl) {
            return this.theTableStyleInformation;
        }
        return null;
    }
}

