/*
 * Decompiled with CFR 0.152.
 */
package com.swimap.iview.templates.table;

import com.swimap.iview.templates.table.IDataSorter;
import com.swimap.iview.templates.table.ITableRowFilter;
import com.swimap.iview.util.log.IviewLogger;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Vector;
import javax.swing.JTable;
import javax.swing.ListSelectionModel;
import javax.swing.table.DefaultTableModel;

public class TableTemplateModel
extends DefaultTableModel {
    private static IviewLogger logger = IviewLogger.getLogger(TableTemplateModel.class, "IVIEW");
    private ArrayList sortedOrder = new ArrayList(20);
    private boolean enableSort = false;
    private ITableRowFilter membrane = null;
    private ArrayList rowOrder = new ArrayList(20);
    private boolean enableFilter = false;
    private boolean scrollLock = false;
    private int scrollLockStartRow = 0;
    private int frozenRowCount = 0;
    private boolean[] columnsConfigable = null;
    private int iColCount = -1;
    private JTable table = null;
    private boolean[] m_isbColumnVisible = null;
    private String[] columnsName = null;
    private int[] sortColumns = null;
    private IDataSorter dataSorter = null;
    private boolean sortAscending = false;

    public TableTemplateModel() {
        logger.error("Do not call this constructor");
    }

    public TableTemplateModel(int n, int n2) {
        super(n, n2);
        for (int i = this.getColumnCount() - 1; i >= 0; --i) {
            this.setColumnVisible(i, true);
            this.initColumnsConfigable();
        }
    }

    @Override
    public Object getValueAt(int n, int n2) throws ArrayIndexOutOfBoundsException {
        Object object = null;
        try {
            object = super.getValueAt(this.getActualRowNumber(n), n2);
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            logger.error(arrayIndexOutOfBoundsException.getMessage());
            throw arrayIndexOutOfBoundsException;
        }
        return object;
    }

    @Override
    public int getRowCount() {
        return this.scrollLock ? this.frozenRowCount : (this.enableFilter ? this.rowOrder.size() : super.getRowCount());
    }

    private void saveSortInformation(int[] nArray, IDataSorter iDataSorter, boolean bl) {
        this.sortColumns = nArray;
        this.dataSorter = iDataSorter;
        this.sortAscending = bl;
    }

    public void sortTable(int[] nArray, IDataSorter iDataSorter, boolean bl) {
        this.saveSortInformation(nArray, iDataSorter, bl);
        Object[] objectArray = this.getDataVector().toArray();
        Object[][] objectArray2 = new Object[objectArray.length][];
        for (int i = 0; i < objectArray2.length; ++i) {
            objectArray2[i] = ((Vector)objectArray[i]).toArray();
        }
        this.sortedOrder = iDataSorter.getSortedRowIndex(objectArray2, nArray, bl);
        if (null == this.sortedOrder) {
            this.sortedOrder = new ArrayList(10);
        }
        this.enableSort = true;
        if (this.enableFilter) {
            this.rowOrder.clear();
            this.filterRows();
        }
    }

    public boolean isScrollLocked() {
        return this.scrollLock;
    }

    public void setScrollLock(boolean bl) {
        this.scrollLock = bl;
        if (!bl) {
            this.scrollLockStartRow = 0;
            this.frozenRowCount = 0;
        }
    }

    public int getScrollLockStartRow() {
        return this.scrollLockStartRow;
    }

    public void setScrollLockStartRow(int n) {
        this.scrollLockStartRow = n;
    }

    public int getFrozenRowCount() {
        return this.frozenRowCount;
    }

    public void setFrozenRowCount(int n) {
        int n2 = super.getRowCount();
        this.frozenRowCount = n < 0 || n2 <= this.scrollLockStartRow + n ? n2 - this.scrollLockStartRow : n;
    }

    public boolean isFilterEnabled() {
        return this.enableFilter;
    }

    public void setFilterEnabled(boolean bl, ITableRowFilter iTableRowFilter) {
        this.membrane = iTableRowFilter;
        this.rowOrder.clear();
        if (bl) {
            this.filterRows();
        }
        this.enableFilter = bl;
    }

    private void filterRows() {
        int n = super.getRowCount();
        int n2 = 0;
        Object[] objectArray = new Object[this.getColumnCount()];
        int n3 = 0;
        for (int i = 0; i < n; ++i) {
            n2 = this.enableSort ? (Integer)this.sortedOrder.get(i) : i;
            for (n3 = 0; n3 < objectArray.length; ++n3) {
                objectArray[n3] = super.getValueAt(n2, n3);
            }
            if (!this.membrane.filter(objectArray)) continue;
            this.rowOrder.add(n2);
        }
    }

    public void insertActualRow(int n, Vector vector) throws ArrayIndexOutOfBoundsException {
        super.insertRow(n, vector);
        if (this.scrollLock && this.scrollLockStartRow >= n) {
            ++this.scrollLockStartRow;
        }
        this.newRowInserted(n);
    }

    public void insertRow(int n, Vector vector) throws ArrayIndexOutOfBoundsException {
        this.insertActualRow(this.getActualRowNumber(n), vector);
    }

    public void removeActualRow(int n) throws ArrayIndexOutOfBoundsException {
        this.rowRemoved(n);
        super.removeRow(n);
        if (this.scrollLock && this.scrollLockStartRow >= n) {
            --this.scrollLockStartRow;
        }
    }

    @Override
    public void removeRow(int n) throws ArrayIndexOutOfBoundsException {
        int n2;
        BitSet bitSet = null;
        if (null != this.table) {
            int n3;
            n2 = this.getRowCount();
            bitSet = new BitSet(n2);
            for (n3 = 0; n3 < n2; ++n3) {
                bitSet.set(n3, this.table.getSelectionModel().isSelectedIndex(n3));
            }
            for (n3 = n + 1; n3 < n2; ++n3) {
                if (bitSet.get(n3)) {
                    bitSet.set(n3 - 1, true);
                    continue;
                }
                bitSet.clear(n3 - 1);
            }
        }
        n2 = this.getActualRowNumber(n);
        this.removeActualRow(n2);
        if (null != bitSet) {
            ListSelectionModel listSelectionModel = this.table.getSelectionModel();
            int n4 = listSelectionModel.getSelectionMode();
            listSelectionModel.clearSelection();
            listSelectionModel.setSelectionMode(2);
            int n5 = this.getRowCount();
            for (int i = 0; i < n5; ++i) {
                if (!bitSet.get(i)) continue;
                listSelectionModel.addSelectionInterval(i, i);
            }
            listSelectionModel.setSelectionMode(n4);
        }
    }

    public void setTable(JTable jTable) {
        this.table = jTable;
    }

    private void newRowInserted(int n) {
        int n2;
        int n3;
        int n4 = 0;
        if (this.enableSort) {
            n3 = this.sortedOrder.size();
            for (n2 = 0; n2 < n3; ++n2) {
                n4 = (Integer)this.sortedOrder.get(n2);
                if (n4 < n) continue;
                this.sortedOrder.set(n2, n4 + 1);
            }
            this.sortedOrder.add(n);
        }
        if (this.enableFilter) {
            n3 = this.rowOrder.size();
            for (n2 = 0; n2 < n3; ++n2) {
                n4 = (Integer)this.rowOrder.get(n2);
                if (n4 < n) continue;
                this.rowOrder.set(n2, n4 + 1);
            }
            Object[] objectArray = new Object[this.getColumnCount()];
            for (int i = 0; i < objectArray.length; ++i) {
                objectArray[i] = super.getValueAt(n, i);
            }
            if (this.membrane.filter(objectArray)) {
                if (n < n3) {
                    this.rowOrder.add(n, n);
                } else {
                    this.rowOrder.add(n);
                }
            }
        }
    }

    private void rowRemoved(int n) {
        int n2;
        int n3;
        int n4 = 0;
        if (this.enableSort) {
            n4 = this.sortedOrder.indexOf(n);
            this.sortedOrder.remove(n4);
            n3 = this.sortedOrder.size();
            for (n2 = 0; n2 < n3; ++n2) {
                n4 = (Integer)this.sortedOrder.get(n2);
                if (n4 < n) continue;
                this.sortedOrder.set(n2, n4 - 1);
            }
        }
        if (this.enableFilter) {
            n4 = this.rowOrder.indexOf(n);
            if (n4 >= 0) {
                this.rowOrder.remove(n4);
            }
            n3 = this.rowOrder.size();
            for (n2 = 0; n2 < n3; ++n2) {
                n4 = (Integer)this.rowOrder.get(n2);
                if (n4 < n) continue;
                this.rowOrder.set(n2, n4 - 1);
            }
        }
    }

    @Override
    public void setValueAt(Object object, int n, int n2) throws ArrayIndexOutOfBoundsException {
        try {
            int n3 = this.getActualRowNumber(n);
            super.setValueAt(object, n3, n2);
            this.fireTableCellUpdated(n, n2);
            if (this.enableFilter) {
                int n4;
                Object[] objectArray = new Object[this.getColumnCount()];
                for (n4 = 0; n4 < objectArray.length; ++n4) {
                    objectArray[n4] = super.getValueAt(n3, n4);
                }
                n4 = this.membrane.filter(objectArray) ? 1 : 0;
                Integer n5 = n3;
                boolean bl = this.rowOrder.contains(n5);
                if (n4 != 0 && !bl) {
                    this.rowOrder.add(n5);
                } else if (n4 == 0 && bl) {
                    this.rowOrder.remove(n5);
                }
            }
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            logger.error(arrayIndexOutOfBoundsException.getMessage());
        }
    }

    public void addRow(Vector vector) {
        super.addRow(vector);
        if (this.enableFilter && vector != null && this.membrane.filter(vector.toArray())) {
            this.rowOrder.add(super.getRowCount() - 1);
        }
    }

    public void setDataVector(Object[][] objectArray) {
        this.setDataVector(TableTemplateModel.convertToVector(objectArray));
    }

    public void setDataVector(Vector vector) {
        int n;
        this.rowOrder.clear();
        this.membrane = null;
        this.enableFilter = false;
        this.scrollLock = false;
        this.disableSorting();
        int n2 = this.getRowCount();
        for (n = n2 - 1; n >= 0; --n) {
            this.removeRow(n);
        }
        n2 = vector.size();
        for (n = 0; n < n2; ++n) {
            this.addRow((Vector)vector.elementAt(n));
        }
        if (this.sortColumns != null) {
            this.sortTable(this.sortColumns, this.dataSorter, this.sortAscending);
        }
    }

    public void disableSorting() {
        this.enableSort = false;
        this.sortedOrder.clear();
    }

    public Object getActualValueAt(int n, int n2) {
        return super.getValueAt(n, n2);
    }

    public void setActualValueAt(Object object, int n, int n2) {
        super.setValueAt(object, n, n2);
    }

    public int getActualRowCount() {
        return super.getRowCount();
    }

    private int getActualRowNumber(int n) {
        int n2 = -1;
        if (this.scrollLock) {
            n += this.scrollLockStartRow;
        }
        n2 = this.enableFilter ? (Integer)this.rowOrder.get(n) : (this.enableSort && this.sortedOrder.size() > n ? (Integer)this.sortedOrder.get(n) : n);
        return n2;
    }

    public boolean[] getColumnsVisible() {
        if (this.m_isbColumnVisible == null) {
            this.AssertColumnVisible();
        }
        return this.m_isbColumnVisible;
    }

    public boolean[] getColumnsConfigable() {
        if (this.columnsConfigable == null) {
            this.initColumnsConfigable();
        } else {
            this.checkColumns();
        }
        return this.columnsConfigable;
    }

    public void setColumnsVisible(boolean[] blArray) {
        if (blArray.length == this.getColumnCount()) {
            this.m_isbColumnVisible = blArray;
        }
    }

    public String[] getColumnsName() {
        if (this.columnsName == null || this.columnsName.length != this.getColumnCount()) {
            this.columnsName = new String[this.getColumnCount()];
            for (int i = 0; i < this.columnsName.length; ++i) {
                this.columnsName[i] = this.getColumnName(i);
            }
        }
        return this.columnsName;
    }

    public void setColConfigable(int n, boolean bl) {
        this.iColCount = this.getColumnCount();
        if (n >= this.iColCount || n <= -1) {
            return;
        }
        if (this.columnsConfigable == null) {
            this.initColumnsConfigable();
        } else {
            this.checkColumns();
        }
        this.columnsConfigable[n] = bl;
    }

    public void setColsConfigable(boolean[] blArray) {
        if (blArray.length == this.getColumnCount()) {
            this.columnsConfigable = blArray;
        }
    }

    public void initColumnsConfigable() {
        if (this.columnsConfigable == null) {
            this.columnsConfigable = new boolean[this.getColumnCount()];
            for (int i = 0; i < this.columnsConfigable.length; ++i) {
                this.columnsConfigable[i] = true;
            }
        }
    }

    public void checkColumns() {
        if (this.columnsConfigable.length != this.getColumnCount()) {
            this.iColCount = this.getColumnCount();
            boolean[] blArray = new boolean[this.iColCount];
            int n = this.columnsConfigable.length < this.iColCount ? this.columnsConfigable.length : this.iColCount;
            System.arraycopy(this.columnsConfigable, 0, blArray, 0, n);
            this.columnsConfigable = blArray;
        }
    }

    public void setColumnVisible(int n, boolean bl) {
        this.AssertColumnVisible();
        if (this.iColCount == -1) {
            this.iColCount = this.getColumnCount();
        }
        if (n >= this.iColCount) {
            return;
        }
        this.m_isbColumnVisible[n] = bl;
    }

    public void AssertColumnVisible() {
        if (this.m_isbColumnVisible == null) {
            this.m_isbColumnVisible = new boolean[this.getColumnCount()];
            for (int i = this.m_isbColumnVisible.length - 1; i >= 0; --i) {
                this.m_isbColumnVisible[i] = true;
            }
        } else if (this.m_isbColumnVisible.length != this.getColumnCount()) {
            int n = this.getColumnCount();
            boolean[] blArray = new boolean[n];
            int n2 = this.m_isbColumnVisible.length < n ? this.m_isbColumnVisible.length : n;
            System.arraycopy(this.m_isbColumnVisible, 0, blArray, 0, n2);
            this.m_isbColumnVisible = blArray;
        }
    }
}

