/*
 * Decompiled with CFR 0.152.
 */
package com.swimap.iview.templates.table;

import com.swimap.iview.commstyle.resource.ResourceMng;
import com.swimap.iview.framework.util.FrameworkUtilities;
import com.swimap.iview.templates.table.DefaultSorter;
import com.swimap.iview.templates.table.IDataSorter;
import com.swimap.iview.templates.table.ITableRowFilter;
import com.swimap.iview.templates.table.ITableStyleInterface;
import com.swimap.iview.templates.table.SaveAndPrintFile;
import com.swimap.iview.templates.table.ShowColumnSetDialog;
import com.swimap.iview.templates.table.SortHeaderRenderer;
import com.swimap.iview.templates.table.TableStyleInformation;
import com.swimap.iview.templates.table.TableTemplateModel;
import com.swimap.iview.templates.utils.MouseClickActions;
import com.swimap.iview.util.ScreenToolKit;
import com.swimap.iview.util.log.IviewLogger;
import java.awt.Container;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.datatransfer.StringSelection;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.IOException;
import java.util.ResourceBundle;
import java.util.Vector;
import javax.swing.ImageIcon;
import javax.swing.JFrame;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JViewport;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.TableModelEvent;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;

public class TableTemplate
extends JTable {
    private static IviewLogger logger = IviewLogger.getLogger(TableTemplate.class, "IVIEW");
    public static ResourceBundle res = ResourceMng.getInstance().getResourceBundleFromPropertyFile("mainfrm/iview/templates/table/Res");
    public static final char columnDelimiter = '\t';
    public static final char rowDelimiter = '\n';
    private TableStyleInformation theTableStyleInformation = null;
    public static final ImageIcon CAN_SORT_ICON = new ImageIcon(TableTemplate.class.getResource("sortable.gif"));
    public static final ImageIcon ASCENDING_ICON = new ImageIcon(TableTemplate.class.getResource("upsorted.gif"));
    public static final ImageIcon DESCENDING_ICON = new ImageIcon(TableTemplate.class.getResource("downsorted.gif"));
    int currentlySortedOn = -1;
    private ViewportListener viewportListener = new ViewportListener();
    private transient IDataSorter defaultSorter = new DefaultSorter();
    private IDataSorter customSorter = null;
    private SaveAndPrintFile saveAndPrintFile = null;
    private JPopupMenu commonPopupMenu = null;
    private JMenuItem columnMenuItem = null;
    private JFrame mainFrame = FrameworkUtilities.getMainFrame();
    private boolean isShowConfig = true;
    private TableColumn[] temp = null;
    private static final int ROW_HEIGHT = 20;

    public TableTemplate() {
        this.setRowHeight(20);
        this.registerListeners();
    }

    public TableTemplate(int n, int n2) {
        super(n, n2);
        this.setRowHeight(20);
        this.registerListeners();
    }

    public TableTemplate(ITableStyleInterface iTableStyleInterface) throws ClassCastException, ClassNotFoundException, IOException, SecurityException {
        super(0, 1);
        this.setRowHeight(20);
        try {
            this.setInformation(iTableStyleInterface.loadInformation());
        }
        catch (ClassCastException classCastException) {
            logger.error("Error while loading persisted object: " + classCastException);
            throw classCastException;
        }
        catch (ClassNotFoundException classNotFoundException) {
            logger.error("Error while loading persisted object: " + classNotFoundException);
            throw classNotFoundException;
        }
        catch (IOException iOException) {
            logger.error("Error while loading persisted object: " + iOException);
            throw iOException;
        }
        catch (SecurityException securityException) {
            logger.error("Error while loading persisted object: " + securityException);
            throw securityException;
        }
        catch (Exception exception) {
            logger.error("Error while loading persisted object: " + exception);
            throw new IllegalArgumentException("Error while loading persisted object");
        }
        this.registerListeners();
    }

    public TableTemplate(TableStyleInformation tableStyleInformation) {
        super(0, 1);
        this.setRowHeight(20);
        if (tableStyleInformation == null) {
            logger.error("table style information object is null");
            throw new NullPointerException("table style information object is null");
        }
        this.setInformation(tableStyleInformation);
        this.registerListeners();
    }

    @Override
    public void setModel(TableModel tableModel) {
        if (tableModel != null && tableModel instanceof TableTemplateModel) {
            ((TableTemplateModel)tableModel).setTable(this);
        }
        super.setModel(tableModel);
    }

    public TableStyleInformation getInformation() {
        return this.theTableStyleInformation;
    }

    public void setInformation(TableStyleInformation tableStyleInformation) {
        int n;
        int n2;
        this.theTableStyleInformation = tableStyleInformation;
        int n3 = this.theTableStyleInformation.getColumnCount();
        TableModel tableModel = this.theTableStyleInformation.getModel();
        if (tableModel == null) {
            tableModel = new TableTemplateModel(0, n3);
        }
        this.setModel(tableModel);
        TableColumnModel tableColumnModel = this.getColumnModel();
        if (this.theTableStyleInformation.getBackgroundColor() != null) {
            this.setBackground(this.theTableStyleInformation.getBackgroundColor());
        }
        if (this.theTableStyleInformation.getForegroundColor() != null) {
            this.setForeground(this.theTableStyleInformation.getForegroundColor());
        }
        this.setShowHorizontalLines(this.theTableStyleInformation.isHorizontalLinesVisible());
        this.setShowVerticalLines(this.theTableStyleInformation.isVerticalLinesVisible());
        int n4 = this.theTableStyleInformation.getRowHeight();
        if (n4 > 0) {
            this.setRowHeight(n4);
        }
        if ((n2 = this.theTableStyleInformation.getRowMargin()) > 0) {
            this.setRowMargin(n2);
        }
        this.setRowSelectionAllowed(this.theTableStyleInformation.isRowSelectionAllowed());
        this.setColumnSelectionAllowed(this.theTableStyleInformation.isColumnSelectionAllowed());
        boolean bl = this.theTableStyleInformation.isMultipleRowSelectionAllowed();
        this.getSelectionModel().setSelectionMode(bl ? 1 : 0);
        boolean bl2 = this.theTableStyleInformation.isColumnAutoResizeAllowed();
        this.setAutoResizeMode(bl2 ? 4 : 0);
        int[] nArray = this.theTableStyleInformation.getPreferredColumnWidths();
        int[] nArray2 = this.theTableStyleInformation.getMinimumColumnWidths();
        int[] nArray3 = this.theTableStyleInformation.getMaximumColumnWidths();
        boolean[] blArray = this.theTableStyleInformation.isColumnResizeAllowed();
        boolean[] blArray2 = this.theTableStyleInformation.isSortingAllowed();
        TableCellRenderer[] tableCellRendererArray = this.theTableStyleInformation.getCellRenderer();
        TableCellEditor[] tableCellEditorArray = this.theTableStyleInformation.getCellEditor();
        Object[] objectArray = this.theTableStyleInformation.getColumnLabels();
        if (tableModel instanceof DefaultTableModel) {
            ((DefaultTableModel)tableModel).setColumnIdentifiers(objectArray);
        }
        int n5 = tableColumnModel.getColumnCount();
        TableColumn tableColumn = null;
        SortHeaderRenderer sortHeaderRenderer = null;
        for (n = 0; n < n3; ++n) {
            if (n >= n5) {
                tableColumn = new TableColumn();
                tableColumnModel.addColumn(tableColumn);
            } else {
                tableColumn = tableColumnModel.getColumn(n);
            }
            tableColumn.setHeaderValue(objectArray[n]);
            tableColumn.setResizable(blArray[n]);
            if (tableCellRendererArray != null && tableCellRendererArray[n] != null) {
                tableColumn.setCellRenderer(tableCellRendererArray[n]);
            }
            if (tableCellEditorArray != null && tableCellEditorArray[n] != null) {
                tableColumn.setCellEditor(tableCellEditorArray[n]);
            }
            tableColumn.setPreferredWidth(nArray[n]);
            tableColumn.setMinWidth(nArray2[n]);
            tableColumn.setMaxWidth(nArray3[n]);
            if (!blArray2[n] || !(tableModel instanceof TableTemplateModel)) continue;
            sortHeaderRenderer = new SortHeaderRenderer();
            tableColumn.setHeaderRenderer(sortHeaderRenderer);
        }
        if (n5 > n3) {
            for (n = n3; n < n5; ++n) {
                tableColumnModel.removeColumn(tableColumnModel.getColumn(n));
            }
        }
        MouseClickActions mouseClickActions = new MouseClickActions(this.theTableStyleInformation.getMouseClickAction(), this.theTableStyleInformation.getDoubleClickAction(), this.theTableStyleInformation.getRightClickAction());
        mouseClickActions.setSource(this);
        this.addMouseListener(mouseClickActions);
        MouseClickActions mouseClickActions2 = new MouseClickActions(this.theTableStyleInformation.getMouseClickOnHeaderAction(), this.theTableStyleInformation.getDoubleClickOnHeaderAction(), this.theTableStyleInformation.getRightClickOnHeaderAction());
        this.getTableHeader().addMouseListener(mouseClickActions2);
        this.updateUI();
    }

    public void setShowConfig(boolean bl) {
        this.isShowConfig = bl;
    }

    public boolean isShowConfig() {
        return this.isShowConfig;
    }

    protected void registerListeners() {
        String[] stringArray = new String[]{"com.swimap.iview.templates.table.DefaultListeners", "tableHeaderDoubleClicked"};
        String[] stringArray2 = new String[]{"com.swimap.iview.templates.table.DefaultListeners", "tableHeaderClicked"};
        String[] stringArray3 = new String[]{"com.swimap.iview.templates.table.DefaultListeners", ""};
        this.saveAndPrintFile = new SaveAndPrintFile(this);
        this.getTableHeader().addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent mouseEvent) {
                if (SwingUtilities.isRightMouseButton(mouseEvent) && TableTemplate.this.isShowConfig() && TableTemplate.this.getModel() instanceof TableTemplateModel) {
                    TableTemplate.this.showCommonMenu(mouseEvent);
                }
            }
        });
        MouseClickActions mouseClickActions = new MouseClickActions(stringArray2, stringArray, stringArray3);
        mouseClickActions.setSource(this);
        this.getTableHeader().addMouseListener(mouseClickActions);
        ActionListener actionListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                TableTemplate.this.copySelectedDataToClipboard();
            }
        };
        KeyStroke keyStroke = KeyStroke.getKeyStroke(67, 2, false);
        this.registerKeyboardAction(actionListener, "Copy", keyStroke, 0);
    }

    private void showCommonMenu(MouseEvent mouseEvent) {
        if (this.columnMenuItem == null || this.commonPopupMenu == null) {
            this.columnMenuItem = new JMenuItem(res.getString("Config"));
            this.columnMenuItem.setMnemonic('C');
            this.commonPopupMenu = new JPopupMenu();
            this.columnMenuItem.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    TableTemplate.this.configMenuItem_Action();
                }
            });
            this.commonPopupMenu.add(this.columnMenuItem);
        }
        ScreenToolKit.showPopupMenu(this.commonPopupMenu, mouseEvent);
    }

    private void configMenuItem_Action() {
        this.confirmVisibleColumn();
        ShowColumnSetDialog showColumnSetDialog = new ShowColumnSetDialog(this, this.mainFrame);
        ScreenToolKit.centerLocateToScreen(showColumnSetDialog);
        showColumnSetDialog.show();
    }

    public void removeAllRows() {
        TableModel tableModel = this.getModel();
        if (tableModel instanceof TableTemplateModel) {
            TableTemplateModel tableTemplateModel = (TableTemplateModel)tableModel;
            this.freezeTable(false);
            this.removeFilter();
            tableTemplateModel.disableSorting();
            for (int i = tableTemplateModel.getRowCount() - 1; i >= 0; --i) {
                tableTemplateModel.removeRow(i);
            }
        } else {
            logger.warn("Model is not an instance of TableTemplateModel.Ignoring method call...");
        }
    }

    public void sortTable(int[] nArray, boolean bl) {
        TableModel tableModel = this.getModel();
        if (tableModel instanceof TableTemplateModel && this.verifySortRequest(nArray)) {
            this.updateTableHeaderIcons(nArray, bl);
            int[] nArray2 = new int[nArray.length];
            for (int i = 0; i < nArray.length; ++i) {
                nArray2[i] = this.convertColumnIndexToModel(nArray[i]);
            }
            if (this.customSorter == null) {
                ((TableTemplateModel)tableModel).sortTable(nArray2, this.defaultSorter, bl);
            } else {
                ((TableTemplateModel)tableModel).sortTable(nArray2, this.customSorter, bl);
            }
            this.tableChanged(new TableModelEvent(tableModel));
            this.updateUI();
        } else {
            logger.warn("Sort request cannot be fulfilled.Ignoring method call...");
        }
    }

    public void sortTable(int[] nArray, IDataSorter iDataSorter, boolean bl) {
        TableModel tableModel = this.getModel();
        if (tableModel instanceof TableTemplateModel && this.verifySortRequest(nArray)) {
            this.updateTableHeaderIcons(nArray, bl);
            int[] nArray2 = new int[nArray.length];
            for (int i = 0; i < nArray.length; ++i) {
                nArray2[i] = this.convertColumnIndexToModel(nArray[i]);
            }
            ((TableTemplateModel)tableModel).sortTable(nArray2, iDataSorter, bl);
            this.tableChanged(new TableModelEvent(tableModel));
            this.updateUI();
        } else {
            logger.warn("Sort request cannot be fulfilled. Ignoring method call...");
        }
    }

    private boolean verifySortRequest(int[] nArray) {
        boolean bl = true;
        try {
            boolean[] blArray = this.theTableStyleInformation.isSortingAllowed();
            for (int i = 0; i < nArray.length; ++i) {
                if (nArray[i] >= blArray.length) continue;
                bl &= blArray[nArray[i]];
            }
        }
        catch (NullPointerException nullPointerException) {
            bl = false;
        }
        return bl;
    }

    private void updateTableHeaderIcons(int[] nArray, boolean bl) {
        TableColumnModel tableColumnModel = this.getColumnModel();
        TableColumn tableColumn = null;
        SortHeaderRenderer sortHeaderRenderer = null;
        int n = tableColumnModel.getColumnCount();
        for (int i = 0; i < n; ++i) {
            tableColumn = tableColumnModel.getColumn(i);
            TableCellRenderer tableCellRenderer = tableColumn.getHeaderRenderer();
            if (tableCellRenderer == null || !(tableCellRenderer instanceof SortHeaderRenderer)) continue;
            sortHeaderRenderer = (SortHeaderRenderer)tableCellRenderer;
            sortHeaderRenderer.setSortOrder(0);
        }
        tableColumn = tableColumnModel.getColumn(nArray[0]);
        sortHeaderRenderer = (SortHeaderRenderer)tableColumn.getHeaderRenderer();
        sortHeaderRenderer.setSortOrder(bl ? 1 : 2);
        this.getTableHeader().repaint();
        this.currentlySortedOn = nArray[0];
    }

    public boolean freezeTable(boolean bl) {
        boolean bl2 = false;
        TableModel tableModel = this.getModel();
        if (tableModel instanceof TableTemplateModel) {
            Container container = this.getParent();
            if (container instanceof JViewport) {
                TableTemplateModel tableTemplateModel = (TableTemplateModel)tableModel;
                JViewport jViewport = (JViewport)container;
                JScrollPane jScrollPane = (JScrollPane)container.getParent();
                if (bl) {
                    jScrollPane.setVerticalScrollBarPolicy(21);
                    Rectangle rectangle = jViewport.getViewRect();
                    tableTemplateModel.setScrollLockStartRow(this.rowAtPoint(new Point(rectangle.x, rectangle.y)));
                    this.setFrozenRowCount();
                    jViewport.addChangeListener(this.viewportListener);
                } else {
                    jScrollPane.setVerticalScrollBarPolicy(20);
                    jViewport.removeChangeListener(this.viewportListener);
                }
                tableTemplateModel.setScrollLock(bl);
                bl2 = true;
            } else {
                logger.error("Parent of this table is not a viewport. can't freeze table scrolling");
                bl2 = false;
            }
        } else {
            logger.warn("Model is not an instance of TableTemplateModel. Ignoring method call...");
        }
        return bl2;
    }

    public void applyFilter(ITableRowFilter iTableRowFilter) {
        TableModel tableModel = this.getModel();
        if (tableModel instanceof TableTemplateModel) {
            ((TableTemplateModel)tableModel).setFilterEnabled(true, iTableRowFilter);
            this.tableChanged(new TableModelEvent(tableModel));
            this.updateUI();
        } else {
            logger.warn("Model is not an instance of TableTemplateModel. Ignoring method call...");
        }
    }

    public void removeFilter() {
        TableModel tableModel = this.getModel();
        if (tableModel instanceof TableTemplateModel) {
            ((TableTemplateModel)tableModel).setFilterEnabled(false, null);
            this.tableChanged(new TableModelEvent(tableModel));
            this.updateUI();
        } else {
            logger.warn("Model is not an instance of TableTemplateModel. Ignoring method call...");
        }
    }

    protected void copySelectedDataToClipboard() {
        String string = this.getSelectedContents().toString();
        if (string != null && !"".equals(string.trim())) {
            StringSelection stringSelection = new StringSelection(string);
            Toolkit.getDefaultToolkit().getSystemClipboard().setContents(stringSelection, stringSelection);
        }
    }

    private StringBuffer getSelectedContents() {
        int n;
        StringBuffer stringBuffer = new StringBuffer(80);
        int n2 = this.getSelectedColumnCount();
        int n3 = this.getSelectedRowCount();
        int[] nArray = this.getSelectedRows();
        int[] nArray2 = this.getSelectedColumns();
        if (this.getRowSelectionAllowed()) {
            n2 = this.getColumnCount();
            nArray2 = new int[n2];
            for (n = 0; n < n2; ++n) {
                nArray2[n] = n;
            }
        }
        for (n = 0; n < n3; ++n) {
            for (int i = 0; i < n2; ++i) {
                stringBuffer.append(this.getValueAt(nArray[n], nArray2[i]));
                if (i >= n2 - 1) continue;
                stringBuffer.append('\t');
            }
            stringBuffer.append('\n');
        }
        return stringBuffer;
    }

    private void setFrozenRowCount() {
        TableModel tableModel = this.getModel();
        if (tableModel instanceof TableTemplateModel) {
            TableTemplateModel tableTemplateModel = (TableTemplateModel)tableModel;
            Rectangle rectangle = ((JViewport)this.getParent()).getViewRect();
            Point point = new Point(rectangle.x, rectangle.y + rectangle.height - 1);
            int n = this.rowAtPoint(point);
            int n2 = -1;
            for (int i = 0; i < 10; ++i) {
                point.setLocation(rectangle.x + i, rectangle.y);
                n2 = this.rowAtPoint(point);
                if (n2 < 0) break;
            }
            if (n2 >= 0) {
                if (n <= n2) {
                    n = n2 + rectangle.height / (this.getRowHeight() + this.getRowMargin());
                }
                tableTemplateModel.setFrozenRowCount(n - n2 + 1);
            }
        } else {
            logger.warn("Model is not an instance of TableTemplateModel.Ignoring method call...");
        }
    }

    public void resizeColumnWidthToFit(int n) {
        TableColumn tableColumn = this.getColumnModel().getColumn(n);
        tableColumn.sizeWidthToFit();
        this.updateUI();
    }

    public void setCustomSorter(IDataSorter iDataSorter) {
        this.customSorter = iDataSorter;
    }

    public IDataSorter getCustomSorter() {
        return this.customSorter;
    }

    public SaveAndPrintFile getSaveAsFile() {
        return this.saveAndPrintFile;
    }

    public void setFileTitle(String string) {
        this.saveAndPrintFile.setTitle(string);
    }

    public boolean saveAs() {
        return this.saveAs("", "", "");
    }

    public boolean saveAs(String string) {
        return this.saveAs(string, "");
    }

    public boolean saveAs(String string, String string2) {
        return this.saveMultiRows(string, string2, "", "", 0, this.getRowCount() - 1);
    }

    public boolean saveAs(String string, String string2, String string3) {
        return this.saveMultiRows(null, string, string2, string3, 0, this.getRowCount() - 1);
    }

    public boolean saveSelectRows(String string, String string2, String string3, String string4) {
        int[] nArray = this.getSelectedRows();
        if (nArray != null && nArray.length > 0) {
            return this.saveMultiRows(string, string2, string3, string4, nArray);
        }
        return false;
    }

    private boolean saveMultiRows(String string, String string2, String string3, String string4, int[] nArray) {
        this.stopCellEdit();
        return this.saveAndPrintFile.saveFile(string, string2, string3, string4, nArray);
    }

    public boolean saveMultiRows(String string, String string2, String string3, String string4, int n, int n2) {
        if (n >= 0 && n2 >= n && n2 < this.getRowCount()) {
            int[] nArray = new int[n2 - n + 1];
            for (int i = 0; i < nArray.length; ++i) {
                nArray[i] = n++;
            }
            return this.saveMultiRows(string, string2, string3, string4, nArray);
        }
        return false;
    }

    public boolean printTable() {
        return this.printTable("", "", "");
    }

    public boolean printTable(String string, String string2, String string3) {
        return this.printMultiRows(string, string2, string3, 0, this.getRowCount() - 1);
    }

    public boolean printSelectRows(String string, String string2, String string3) {
        int[] nArray = this.getSelectedRows();
        if (nArray != null && nArray.length > 0) {
            return this.printMultiRows(string, string2, string3, nArray);
        }
        return false;
    }

    private boolean printMultiRows(String string, String string2, String string3, int[] nArray) {
        this.stopCellEdit();
        return this.saveAndPrintFile.printFile(string, string2, string3, nArray);
    }

    public boolean printMultiRows(String string, String string2, String string3, int n, int n2) {
        if (n >= 0 && n2 >= n && n2 < this.getRowCount()) {
            int[] nArray = new int[n2 - n + 1];
            for (int i = 0; i < nArray.length; ++i) {
                nArray[i] = n++;
            }
            return this.printMultiRows(string, string2, string3, nArray);
        }
        return false;
    }

    private void stopCellEdit() {
        if (this.isEditing()) {
            this.getCellEditor().stopCellEditing();
        }
    }

    private void confirmVisibleColumn() {
        int n;
        boolean[] blArray = ((TableTemplateModel)this.getModel()).getColumnsVisible();
        String[] stringArray = ((TableTemplateModel)this.getModel()).getColumnsName();
        TableColumnModel tableColumnModel = this.getColumnModel();
        int n2 = tableColumnModel.getColumnCount();
        Vector<Object> vector = new Vector<Object>(n2);
        for (n = 0; n < n2; ++n) {
            TableColumn tableColumn = tableColumnModel.getColumn(n);
            vector.add(tableColumn.getHeaderValue());
        }
        for (n = stringArray.length - 1; n >= 0; --n) {
            blArray[n] = vector.contains(stringArray[n]);
        }
        ((TableTemplateModel)this.getModel()).setColumnsVisible(blArray);
    }

    public void setMainFrame(JFrame jFrame) {
        this.mainFrame = jFrame;
        this.saveAndPrintFile.setMainFrame(jFrame);
    }

    public void setColumnShowingEnable(boolean[] blArray, int[] nArray) {
        TableColumnModel tableColumnModel = this.getColumnModel();
        this.temp = new TableColumn[tableColumnModel.getColumnCount()];
        int n = tableColumnModel.getColumnCount();
        for (int i = 0; i < n; ++i) {
            if (i != nArray[i]) continue;
            this.temp[i] = tableColumnModel.getColumn(i);
        }
        this.setColumnShowingEnable(blArray);
    }

    public void setColumnShowingEnable(boolean[] blArray) {
        String[] stringArray;
        if (blArray == null || blArray.length == 0) {
            return;
        }
        TableColumnModel tableColumnModel = this.getColumnModel();
        while (0 != tableColumnModel.getColumnCount()) {
            stringArray = tableColumnModel.getColumn(0);
            tableColumnModel.removeColumn((TableColumn)stringArray);
        }
        stringArray = ((TableTemplateModel)this.getModel()).getColumnsName();
        if (this.theTableStyleInformation == null) {
            TableColumn tableColumn = null;
            for (int i = 0; i < blArray.length; ++i) {
                if (!blArray[i]) continue;
                tableColumn = new TableColumn(i);
                tableColumn.setHeaderValue(stringArray[i]);
                tableColumnModel.addColumn(tableColumn);
            }
        } else {
            int[] nArray = this.theTableStyleInformation.getPreferredColumnWidths();
            int[] nArray2 = this.theTableStyleInformation.getMinimumColumnWidths();
            int[] nArray3 = this.theTableStyleInformation.getMaximumColumnWidths();
            boolean[] blArray2 = this.theTableStyleInformation.isColumnResizeAllowed();
            boolean[] blArray3 = this.theTableStyleInformation.isSortingAllowed();
            TableCellRenderer[] tableCellRendererArray = this.theTableStyleInformation.getCellRenderer();
            TableCellEditor[] tableCellEditorArray = this.theTableStyleInformation.getCellEditor();
            this.theTableStyleInformation.getColumnLabels();
            SortHeaderRenderer sortHeaderRenderer = null;
            TableColumn tableColumn = null;
            for (int i = 0; i < blArray.length; ++i) {
                if (!blArray[i]) continue;
                tableColumn = new TableColumn(i);
                tableColumn.setHeaderValue(stringArray[i]);
                if (blArray2 != null && blArray2.length > i) {
                    tableColumn.setResizable(blArray2[i]);
                }
                if (tableCellRendererArray != null && tableCellRendererArray.length > i && tableCellRendererArray[i] != null) {
                    tableColumn.setCellRenderer(tableCellRendererArray[i]);
                }
                if (tableCellEditorArray != null && tableCellEditorArray.length > i && tableCellEditorArray[i] != null) {
                    tableColumn.setCellEditor(tableCellEditorArray[i]);
                }
                if (nArray != null && nArray.length > i) {
                    tableColumn.setPreferredWidth(nArray[i]);
                }
                if (nArray2 != null && nArray2.length > i) {
                    tableColumn.setMinWidth(nArray2[i]);
                }
                if (nArray3 != null && nArray3.length > i) {
                    tableColumn.setMaxWidth(nArray3[i]);
                }
                if (blArray3 != null && blArray3.length > i && blArray3[i]) {
                    sortHeaderRenderer = new SortHeaderRenderer();
                    tableColumn.setHeaderRenderer(sortHeaderRenderer);
                }
                tableColumnModel.addColumn(tableColumn);
            }
        }
        this.updateUI();
    }

    @Override
    public int getSelectedRow() {
        return this.getRowCount() == 0 ? -1 : super.getSelectedRow();
    }

    public static void cleanupWhileOSGIExit() {
        res = null;
    }

    private final class ViewportListener
    implements ChangeListener {
        private ViewportListener() {
        }

        @Override
        public void stateChanged(ChangeEvent changeEvent) {
            TableTemplate.this.setFrozenRowCount();
        }
    }
}

