/*
 * Decompiled with CFR 0.152.
 */
package com.swimap.iview.templates.table;

import com.swimap.iview.util.ReflectionUtilities;
import com.swimap.iview.util.log.IviewLogger;
import java.awt.Color;
import java.io.Serializable;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableModel;

public class TableStyleInformation
implements Serializable {
    private static final long serialVersionUID = -6145631901464782282L;
    private static IviewLogger logger = IviewLogger.getLogger(TableStyleInformation.class, "IVIEW");
    private boolean columnAutoResizeAllowed = false;
    private boolean horizontalLinesVisible = false;
    private boolean verticalLinesVisible = false;
    private int rowHeight = 0;
    private int rowMargin = 0;
    private boolean rowSelectionAllowed = false;
    private boolean columnSelectionAllowed = false;
    private int columnCount = 0;
    private int[] preferredColumnWidths = null;
    private int[] minimumColumnWidths = null;
    private int[] maximumColumnWidths = null;
    private boolean[] columnResizeAllowed = null;
    private boolean[] sortingAllowed = null;
    private boolean multipleRowSelectionAllowed = false;
    private String[] columnLabels = null;
    private String[] mouseClickAction = null;
    private String[] rightClickAction = null;
    private String[] mouseClickOnHeaderAction = null;
    private String[] doubleClickAction = null;
    private String[] rightClickOnHeaderAction = null;
    private String[] doubleClickOnHeaderAction = null;
    private String[] cellRendererNames = null;
    private transient TableCellRenderer[] cellRenderers = null;
    private String[] cellEditorNames = null;
    private transient TableCellEditor[] cellEditors = null;
    private String modelName = null;
    private transient TableModel model = null;
    private Color backgroundColor = null;
    private Color foregroundColor = null;
    private transient boolean reflectionError = false;

    public boolean isColumnAutoResizeAllowed() {
        return this.columnAutoResizeAllowed;
    }

    public boolean isHorizontalLinesVisible() {
        return this.horizontalLinesVisible;
    }

    public boolean isVerticalLinesVisible() {
        return this.verticalLinesVisible;
    }

    public int getRowHeight() {
        return this.rowHeight;
    }

    public int getRowMargin() {
        return this.rowMargin;
    }

    public boolean isRowSelectionAllowed() {
        return this.rowSelectionAllowed;
    }

    public boolean isColumnSelectionAllowed() {
        return this.columnSelectionAllowed;
    }

    public int getColumnCount() {
        return this.columnCount;
    }

    public String[] getColumnLabels() {
        return this.columnLabels;
    }

    public int[] getPreferredColumnWidths() {
        return this.preferredColumnWidths;
    }

    public int[] getMinimumColumnWidths() {
        return this.minimumColumnWidths;
    }

    public int[] getMaximumColumnWidths() {
        return this.maximumColumnWidths;
    }

    public String[] getRightClickAction() {
        return this.rightClickAction;
    }

    public String[] getMouseClickAction() {
        return this.mouseClickAction;
    }

    public String[] getDoubleClickAction() {
        return this.doubleClickAction;
    }

    public String[] getRightClickOnHeaderAction() {
        return this.rightClickOnHeaderAction;
    }

    public String[] getMouseClickOnHeaderAction() {
        return this.mouseClickOnHeaderAction;
    }

    public String[] getDoubleClickOnHeaderAction() {
        return this.doubleClickOnHeaderAction;
    }

    public TableCellRenderer[] getCellRenderer() {
        if (this.cellRenderers == null && this.cellRendererNames != null) {
            this.instantiateCellRenderer(this.cellRendererNames);
        }
        return this.cellRenderers;
    }

    public TableCellEditor[] getCellEditor() {
        if (this.cellEditors == null && this.cellEditorNames != null) {
            this.instantiateCellEditor(this.cellEditorNames);
        }
        return this.cellEditors;
    }

    public TableModel getModel() {
        if (this.model == null && this.modelName != null && !"".equals(this.modelName)) {
            this.instantiateModel(this.modelName);
        }
        return this.model;
    }

    public Color getBackgroundColor() {
        return this.backgroundColor;
    }

    public Color getForegroundColor() {
        return this.foregroundColor;
    }

    public void setColumnAutoResizeAllowed(String string) {
        this.columnAutoResizeAllowed = "true".equalsIgnoreCase(string.trim());
    }

    public void setHorizontalLinesVisible(String string) {
        this.horizontalLinesVisible = "true".equalsIgnoreCase(string.trim());
    }

    public void setVerticalLinesVisible(String string) {
        this.verticalLinesVisible = "true".equalsIgnoreCase(string.trim());
    }

    public void setRowHeight(String string) {
        try {
            this.rowHeight = Integer.parseInt(string);
        }
        catch (NumberFormatException numberFormatException) {
            logger.warn("NumberFormatException encountered while parsing rowHeight. " + string + " is not a valid integer." + " The exception is\n" + numberFormatException);
            this.rowHeight = 0;
            throw numberFormatException;
        }
    }

    public void setRowMargin(String string) {
        try {
            this.rowMargin = Integer.parseInt(string);
            if (this.rowHeight - this.rowMargin < 8) {
                logger.debug("The row margin should be distinctively smaller than row height. With the current settings of row height = " + this.rowHeight + "and row margin = " + this.rowMargin + ", the table row data might not be visible." + " It is advicable that the difference between" + " the row height and row margin be increased");
            }
        }
        catch (NumberFormatException numberFormatException) {
            logger.warn("NumberFormatException encountered while parsingrowMargin. " + string + " is not a valid integer." + " The exception is\n" + numberFormatException);
            this.rowMargin = 0;
            throw numberFormatException;
        }
    }

    public void setMultipleRowSelectionAllowed(String string) {
        this.multipleRowSelectionAllowed = "true".equalsIgnoreCase(string.trim());
    }

    public void setColumnSelectionAllowed(String string) {
        this.columnSelectionAllowed = "true".equalsIgnoreCase(string.trim());
    }

    public void setColumnCount(int n) {
        this.columnCount = n;
    }

    public void setColumnLabels(String[] stringArray) {
        this.columnLabels = stringArray;
    }

    public void setPreferredColumnWidths(String[] stringArray) {
        this.preferredColumnWidths = new int[stringArray.length];
        try {
            for (int i = 0; i < this.preferredColumnWidths.length; ++i) {
                this.preferredColumnWidths[i] = Integer.parseInt(stringArray[i]);
            }
        }
        catch (NumberFormatException numberFormatException) {
            logger.warn("NumberFormatException encountered while parsing the preferred column widths" + numberFormatException);
            this.preferredColumnWidths = null;
            throw numberFormatException;
        }
    }

    public void setMinimumColumnWidths(String[] stringArray) {
        this.minimumColumnWidths = new int[stringArray.length];
        try {
            for (int i = 0; i < this.minimumColumnWidths.length; ++i) {
                this.minimumColumnWidths[i] = Integer.parseInt(stringArray[i]);
            }
        }
        catch (NumberFormatException numberFormatException) {
            logger.warn("NumberFormatException encountered while parsing the minimum column widths" + numberFormatException);
            this.minimumColumnWidths = null;
            throw numberFormatException;
        }
    }

    public void setMaximumColumnWidths(String[] stringArray) {
        this.maximumColumnWidths = new int[stringArray.length];
        try {
            for (int i = 0; i < this.maximumColumnWidths.length; ++i) {
                this.maximumColumnWidths[i] = Integer.parseInt(stringArray[i]);
            }
        }
        catch (NumberFormatException numberFormatException) {
            logger.warn("NumberFormatException encountered while parsing the maximum column widths" + numberFormatException);
            this.maximumColumnWidths = null;
            throw numberFormatException;
        }
    }

    public void setRightClickAction(String[] stringArray) {
        this.rightClickAction = stringArray;
    }

    public void setMouseClickAction(String[] stringArray) {
        this.mouseClickAction = stringArray;
    }

    public void setDoubleClickAction(String[] stringArray) {
        this.doubleClickAction = stringArray;
    }

    public void setRightClickOnHeaderAction(String[] stringArray) {
        this.rightClickOnHeaderAction = stringArray;
    }

    public void setMouseClickOnHeaderAction(String[] stringArray) {
        this.mouseClickOnHeaderAction = stringArray;
    }

    public void setDoubleClickOnHeaderAction(String[] stringArray) {
        this.doubleClickOnHeaderAction = stringArray;
    }

    public void setCellRenderer(String[] stringArray) {
        this.instantiateCellRenderer(stringArray);
        this.cellRendererNames = stringArray;
    }

    private void instantiateCellRenderer(String[] stringArray) {
        this.cellRenderers = new TableCellRenderer[stringArray.length];
        for (int i = 0; i < this.cellRenderers.length; ++i) {
            if (stringArray[i] == null || "".equals(stringArray[i].trim())) {
                this.cellRenderers[i] = null;
                continue;
            }
            try {
                this.cellRenderers[i] = (TableCellRenderer)ReflectionUtilities.instantiateTheClass(stringArray[i]);
                continue;
            }
            catch (ClassCastException classCastException) {
                logger.warn("ClassCastException encountered whileinstantiating the table cell renderer named \"" + stringArray[i] + '\"' + ". DefaultCellRenderer will be used for" + " column " + i + "\nDetails of the exception is \n" + classCastException);
                this.cellRenderers[i] = null;
                this.reflectionError = true;
                continue;
            }
            catch (Exception exception) {
                logger.warn("Exception encountered while instantiating the table cell renderer named \"" + stringArray[i] + '\"' + ". DefaultCellRenderer will be used for" + " column " + i + "\nDetails of the exception is \n" + exception);
                this.cellRenderers[i] = null;
                this.reflectionError = true;
            }
        }
    }

    public void setCellEditor(String[] stringArray) {
        this.instantiateCellEditor(stringArray);
        this.cellEditorNames = stringArray;
    }

    private void instantiateCellEditor(String[] stringArray) {
        this.cellEditors = new TableCellEditor[stringArray.length];
        for (int i = 0; i < this.cellEditors.length; ++i) {
            if (stringArray[i] == null || "".equals(stringArray[i].trim())) {
                this.cellEditors[i] = null;
                continue;
            }
            try {
                this.cellEditors[i] = (TableCellEditor)ReflectionUtilities.instantiateTheClass(stringArray[i]);
                continue;
            }
            catch (ClassCastException classCastException) {
                logger.warn("Exception encountered while instantiating the table cell editor named \"" + stringArray[i] + '\"' + ". DefaultCellEditor will be used for column " + i + "\nDetails of the exception is \n" + classCastException);
                this.cellEditors[i] = null;
                this.reflectionError = true;
                continue;
            }
            catch (Exception exception) {
                logger.warn("Exception encountered while instantiating thetable cell editor named \"" + stringArray[i] + '\"' + ". DefaultCellEditor will be used for column " + i + "\nDetails of the exception is \n" + exception);
                this.cellEditors[i] = null;
                this.reflectionError = true;
            }
        }
    }

    public void setModel(String string) throws Exception {
        this.instantiateModel(string);
        this.modelName = string;
    }

    private void instantiateModel(String string) {
        if (string == null || "".equals(string.trim())) {
            this.model = null;
        } else {
            try {
                this.model = (TableModel)ReflectionUtilities.instantiateTheClass(string);
            }
            catch (ClassCastException classCastException) {
                logger.warn("Exception encountered while instantiating the table model named \"" + string + '\"' + ". DefaultTableModel will be used" + "\nDetails of the exception is \n" + classCastException);
                this.model = null;
                this.reflectionError = true;
            }
            catch (Exception exception) {
                logger.warn("Exception encountered while instantiating the table  model named \"" + string + '\"' + ". DefaultTableModel will be used" + "\nDetails of the exception is \n" + exception);
                this.model = null;
                this.reflectionError = true;
            }
        }
    }

    public void setBackgroundColor(String[] stringArray) {
        try {
            this.backgroundColor = new Color(Integer.parseInt(stringArray[0]), Integer.parseInt(stringArray[1]), Integer.parseInt(stringArray[2]));
        }
        catch (NumberFormatException numberFormatException) {
            logger.warn("NumberFormatException occurred while parsing the r, g and b values of background color. Error message obtained is\n " + numberFormatException);
            this.backgroundColor = null;
            throw numberFormatException;
        }
    }

    public void setForegroundColor(String[] stringArray) {
        try {
            this.foregroundColor = new Color(Integer.parseInt(stringArray[0]), Integer.parseInt(stringArray[1]), Integer.parseInt(stringArray[2]));
        }
        catch (NumberFormatException numberFormatException) {
            logger.warn("NumberFormatException occurred while parsing the r, g and b values of foreground color. Error message obtained is\n " + numberFormatException);
            this.foregroundColor = null;
            throw numberFormatException;
        }
    }

    public boolean[] isColumnResizeAllowed() {
        return this.columnResizeAllowed;
    }

    public boolean[] isSortingAllowed() {
        return this.sortingAllowed;
    }

    public void setSortingAllowed(String[] stringArray) {
        this.sortingAllowed = new boolean[stringArray.length];
        for (int i = 0; i < this.sortingAllowed.length; ++i) {
            this.sortingAllowed[i] = stringArray[i] == null ? false : "true".equalsIgnoreCase(stringArray[i].trim());
        }
    }

    public void setColumnResizeAllowed(String[] stringArray) {
        this.columnResizeAllowed = new boolean[stringArray.length];
        for (int i = 0; i < this.columnResizeAllowed.length; ++i) {
            this.columnResizeAllowed[i] = "true".equalsIgnoreCase(stringArray[i].trim());
        }
    }

    public boolean isMultipleRowSelectionAllowed() {
        return this.multipleRowSelectionAllowed & this.rowSelectionAllowed;
    }

    public void setRowSelectionAllowed(String string) {
        this.rowSelectionAllowed = "true".equalsIgnoreCase(string.trim());
    }

    public boolean isReflectionError() {
        return this.reflectionError;
    }
}

