/*
 * Decompiled with CFR 0.152.
 */
package com.swimap.iview.templates.table;

import com.swimap.iview.templates.filtertreetable.TreeTableView;
import com.swimap.iview.util.log.IviewLogger;
import java.awt.Component;
import java.awt.FontMetrics;
import java.awt.Graphics;
import javax.swing.JFrame;
import javax.swing.JTable;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;

public class TableFitColumnToWidth
extends JFrame {
    private static IviewLogger logger = IviewLogger.getLogger(TableFitColumnToWidth.class, "IVIEW");
    private static final int INCREMENT = 10;
    private static final int TREE_TABLE_HEADER_INCREMENT = 150;

    public static void setFitWidthToTreeTableColumn(TreeTableView treeTableView) {
        if (treeTableView == null || treeTableView.getColumnCount() == 0 || treeTableView.getRowCount() == 0) {
            return;
        }
        try {
            JTableHeader jTableHeader = treeTableView.getTableHeader();
            Graphics graphics = jTableHeader.getGraphics();
            FontMetrics fontMetrics = graphics.getFontMetrics();
            int n = 0;
            int n2 = treeTableView.getColumnCount();
            TableColumn tableColumn = null;
            String string = null;
            int n3 = 0;
            int n4 = 0;
            int n5 = 0;
            for (int i = 0; i < n2; ++i) {
                tableColumn = treeTableView.getColumn(treeTableView.getColumnName(i));
                string = treeTableView.getColumnName(i);
                n3 = fontMetrics.stringWidth(string);
                int n6 = n5 = n3 > (n4 = TableFitColumnToWidth.widestCellInColumn(treeTableView, tableColumn)) ? n3 : n4;
                n5 = i == 0 ? (n5 += 150) : (n5 += 10);
                tableColumn.setMinWidth(n5);
                if (treeTableView.getParent().getWidth() >= (n += n5)) continue;
                treeTableView.setAutoResizeMode(0);
            }
        }
        catch (Exception exception) {
            logger.trace(exception.getMessage(), exception);
        }
    }

    public static void setFitWidthToColumn(JTable jTable) {
        if (jTable == null || jTable.getColumnCount() == 0 || jTable.getRowCount() == 0) {
            return;
        }
        try {
            JTableHeader jTableHeader = jTable.getTableHeader();
            Graphics graphics = jTableHeader.getGraphics();
            FontMetrics fontMetrics = graphics.getFontMetrics();
            int n = 0;
            int n2 = jTable.getColumnCount();
            TableColumn tableColumn = null;
            String string = null;
            int n3 = 0;
            int n4 = 0;
            int n5 = 0;
            for (int i = 0; i < n2; ++i) {
                tableColumn = jTable.getColumn(jTable.getColumnName(i));
                string = jTable.getColumnName(i);
                n3 = fontMetrics.stringWidth(string);
                n5 = n3 > (n4 = TableFitColumnToWidth.widestCellInColumn(jTable, tableColumn)) ? n3 : n4;
                tableColumn.setMinWidth(n5 += 10);
                n += n5;
            }
            if (jTable.getParent().getWidth() < n) {
                jTable.setAutoResizeMode(0);
            }
        }
        catch (Exception exception) {
            logger.trace(exception);
        }
    }

    private static int colHeaderWidth(JTable jTable, TableColumn tableColumn) {
        TableCellRenderer tableCellRenderer = tableColumn.getHeaderRenderer();
        Component component = tableCellRenderer.getTableCellRendererComponent(jTable, tableColumn.getHeaderValue(), false, false, 0, 0);
        return component.getPreferredSize().width;
    }

    private static int widestCellInColumn(JTable jTable, TableColumn tableColumn) {
        int n = tableColumn.getModelIndex();
        int n2 = 0;
        int n3 = 0;
        int n4 = jTable.getRowCount();
        TableCellRenderer tableCellRenderer = null;
        for (int i = 0; i < n4; ++i) {
            tableCellRenderer = jTable.getCellRenderer(i, n);
            Component component = tableCellRenderer.getTableCellRendererComponent(jTable, jTable.getValueAt(i, n), false, false, i, n);
            n2 = component.getPreferredSize().width;
            n3 = n2 > n3 ? n2 : n3;
        }
        return n3;
    }
}

