/*
 * Decompiled with CFR 0.152.
 */
package com.swimap.iview.templates.table;

import com.swimap.iview.framework.lookandfeel.button.SwimapButtonWithouBGUI;
import com.swimap.iview.templates.table.TableTemplate;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JTable;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.table.TableCellRenderer;

public class SortHeaderRenderer
extends JButton
implements TableCellRenderer {
    public static final int CAN_SORT = 0;
    public static final int ASCENDING = 1;
    public static final int DESCENDING = 2;
    public static final ImageIcon CAN_SORT_ICON = new ImageIcon(TableTemplate.class.getResource("sortable.gif"));
    public static final ImageIcon ASCENDING_ICON = new ImageIcon(TableTemplate.class.getResource("upsorted.gif"));
    public static final ImageIcon DESCENDING_ICON = new ImageIcon(TableTemplate.class.getResource("downsorted.gif"));
    private int sortOrder = -1;

    public SortHeaderRenderer() {
        this.setLookAndFeel();
        this.setHorizontalTextPosition(2);
        this.setIcon(CAN_SORT_ICON);
        this.sortOrder = 0;
    }

    @Override
    public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
        SortHeaderRenderer sortHeaderRenderer = this;
        sortHeaderRenderer.setText(object == null ? "" : object.toString());
        sortHeaderRenderer.setUI(new SwimapButtonWithouBGUI());
        return sortHeaderRenderer;
    }

    public int getSortOrder() {
        return this.sortOrder;
    }

    public void setSortOrder(int n) {
        switch (n) {
            case 0: {
                this.setIcon(CAN_SORT_ICON);
                this.sortOrder = 0;
                break;
            }
            case 1: {
                this.setIcon(ASCENDING_ICON);
                this.sortOrder = 1;
                break;
            }
            case 2: {
                this.setIcon(DESCENDING_ICON);
                this.sortOrder = 2;
                break;
            }
        }
    }

    private void setLookAndFeel() {
        this.setBorder((Border)UIManager.get("TableHeader.cellBorder"));
        this.setBackground((Color)UIManager.get("TableHeader.background"));
        this.setForeground((Color)UIManager.get("TableHeader.foreground"));
        this.setFont((Font)UIManager.get("TableHeader.font"));
    }
}

