/*
 * Decompiled with CFR 0.152.
 */
package com.swimap.iview.templates.table;

import com.swimap.iview.commstyle.resource.ResourceMng;
import com.swimap.iview.framework.util.FrameworkUtilities;
import com.swimap.iview.templates.print.PrintSupportor;
import com.swimap.iview.templates.print.tools.TablePrintable;
import com.swimap.iview.templates.progressdialog.IStop;
import com.swimap.iview.templates.progressdialog.ProgressDialogTemplate;
import com.swimap.iview.templates.table.TableTemplate;
import com.swimap.iview.util.FileChooser;
import com.swimap.iview.util.FileChooserFilter;
import com.swimap.iview.util.SaveFileChooser;
import com.swimap.iview.util.ScreenToolKit;
import com.swimap.iview.util.log.IviewLogger;
import java.awt.Frame;
import java.awt.Window;
import java.util.ResourceBundle;
import java.util.Vector;
import javax.swing.JFrame;
import javax.swing.SwingUtilities;

public class SaveAndPrintFile {
    private static IviewLogger logger = IviewLogger.getLogger(SaveAndPrintFile.class, "IVIEW");
    private static ResourceBundle res = ResourceMng.getInstance().getResourceBundleFromPropertyFile("mainfrm/iview/templates/extendedtable/Res");
    private SaveFileChooser m_oFileChooser = null;
    private TableTemplate m_oTable = null;
    private String m_szTitle = "";
    private static String Csv_Surfix = ".csv";
    private static String Xls_Surfix = ".xls";
    private static String Xlsx_Surfix = ".xlsx";
    private static String Txt_Surfix = ".txt";
    private static String Pdf_Surfix = ".pdf";
    private String fileName = "";
    private String userName = "";
    private String summary = "";
    private JFrame mainFrame = FrameworkUtilities.getMainFrame();
    private boolean running = false;
    private IStop cancelListener = null;
    private TablePrintable printable = null;
    private ProgressDialogTemplate blockDialog = null;
    private static final int SHOW_DIALOG_THRESHOLD = 5000;
    private final int showDialogThreshold = 5000;
    private boolean isSuccess = true;

    SaveAndPrintFile(TableTemplate tableTemplate) {
        this.m_oTable = tableTemplate;
    }

    private String getFileName(String string) {
        StringBuffer stringBuffer = new StringBuffer(15);
        this.m_oFileChooser = new SaveFileChooser(System.getProperty("user.dir") + System.getProperty("file.separator"));
        this.m_oFileChooser.setAcceptAllFileFilterUsed(false);
        this.m_oFileChooser.setEncodingEnabled(true);
        this.m_oFileChooser.addChoosableFileFilter(FileChooser.TXT_FILECHOOSERFILTER);
        this.m_oFileChooser.addChoosableFileFilter(FileChooser.HTML_FILECHOOSERFILTER);
        this.m_oFileChooser.addChoosableFileFilter(FileChooser.CSV_FILECHOOSERFILTER);
        this.m_oFileChooser.addChoosableFileFilter(FileChooser.PDF_FILECHOOSERFILTER);
        this.m_oFileChooser.addChoosableFileFilter(FileChooser.XLSX_FILECHOOSERFILTER);
        this.m_oFileChooser.addChoosableFileFilter(FileChooser.XLS_FILECHOOSERFILTER);
        this.m_oFileChooser.getTextField(this.m_oFileChooser).setText(string);
        JFrame jFrame = this.mainFrame != null ? this.mainFrame : (Frame)SwingUtilities.getAncestorOfClass(Frame.class, this.m_oTable);
        int n = this.m_oFileChooser.showSaveDialog(jFrame);
        if (n == 0) {
            String string2 = this.m_oFileChooser.getSelectedFile().getPath();
            if (null != string2 && 0 != string2.length()) {
                stringBuffer.append(string2);
                FileChooserFilter fileChooserFilter = (FileChooserFilter)this.m_oFileChooser.getFileFilter();
                String string3 = '.' + (String)fileChooserFilter.getAllFilters().get(0);
                if (!stringBuffer.toString().toLowerCase().endsWith(string3)) {
                    stringBuffer.append(string3);
                }
                return stringBuffer.toString();
            }
            return string2;
        }
        return null;
    }

    private void createBlockDialog(String string) {
        this.blockDialog = new ProgressDialogTemplate(this.getMainFrame(), string, "", null);
        this.cancelListener = new IStop(){

            @Override
            public void stop() {
                SaveAndPrintFile.this.running = false;
                SaveAndPrintFile.this.isSuccess = false;
                SaveAndPrintFile.this.printable.setDataOver(true);
                SaveAndPrintFile.this.printable.setSaveCanceled(true);
                SaveAndPrintFile.this.blockDialog.dispose();
            }
        };
        this.blockDialog.setStop(this.cancelListener);
    }

    public boolean saveFile(String string, String string2, String string3, String string4, int[] nArray) {
        int n = nArray.length;
        this.fileName = this.getFileName(string);
        if (this.fileName == null) {
            return false;
        }
        this.m_szTitle = string2 == null ? "" : string2;
        this.userName = string3 == null ? "" : string3;
        String string5 = this.summary = string4 == null ? "" : string4;
        if (n <= 5000) {
            String[] stringArray = this.getColumnNames();
            Vector vector = this.getTablePartData(nArray, 0, nArray.length);
            this.printable = new TablePrintable(this.m_szTitle, this.userName, this.summary, stringArray, vector, n, true);
            return PrintSupportor.saveToFileNoCheck(this.getMainFrame(), this.fileName, this.printable, this.getFileType(this.fileName), this.m_oFileChooser.getUserEncoding());
        }
        this.createBlockDialog(res.getString("Saving"));
        SaveAndPrintTask saveAndPrintTask = new SaveAndPrintTask(nArray, true);
        saveAndPrintTask.start();
        ScreenToolKit.centerLocateToScreen(this.blockDialog);
        this.blockDialog.show();
        return this.isSuccess;
    }

    public boolean printFile(String string, String string2, String string3, int[] nArray) {
        int n = nArray.length;
        this.m_szTitle = string == null ? "" : string;
        this.userName = string2 == null ? "" : string2;
        this.summary = string3 == null ? "" : string3;
        String[] stringArray = this.getColumnNames();
        Vector vector = null;
        if (n <= 5000) {
            vector = this.getTablePartData(nArray, 0, nArray.length);
            this.printable = new TablePrintable(this.m_szTitle, this.userName, this.summary, stringArray, vector, n, false);
            return PrintSupportor.print(this.getMainFrame(), this.printable, this.printable.getPageCount());
        }
        this.printable = new TablePrintable(this.m_szTitle, this.userName, this.summary, stringArray, vector, n, false);
        boolean bl = PrintSupportor.print(this.getMainFrame(), this.printable, this.printable.getPageCount());
        if (bl) {
            this.createBlockDialog(res.getString("Printing"));
            SaveAndPrintTask saveAndPrintTask = new SaveAndPrintTask(nArray, false);
            saveAndPrintTask.start();
            ScreenToolKit.centerLocateToScreen(this.blockDialog);
            this.blockDialog.show();
            return this.isSuccess;
        }
        return false;
    }

    public String[] getColumnNames() {
        String[] stringArray = new String[this.m_oTable.getColumnCount()];
        for (int i = 0; i < stringArray.length; ++i) {
            stringArray[i] = this.m_oTable.getColumnName(i);
        }
        return stringArray;
    }

    private Vector getTablePartData(int[] nArray, int n, int n2) {
        Vector vector = new Vector(n2);
        Vector<String> vector2 = null;
        int n3 = 0;
        int n4 = n + n2;
        Object object = null;
        for (int i = n; i < n4; ++i) {
            n3 = this.m_oTable.getColumnModel().getColumnCount();
            vector2 = new Vector<String>(n3);
            for (int j = 0; j < n3; ++j) {
                object = this.m_oTable.getValueAt(nArray[i], j);
                vector2.add(object == null ? "  " : object.toString());
            }
            vector.add(vector2);
        }
        return vector;
    }

    private String getFileType(String string) {
        if (string.endsWith(Txt_Surfix)) {
            return "txt";
        }
        if (string.endsWith(Csv_Surfix)) {
            return "csv";
        }
        if (string.endsWith(Xls_Surfix)) {
            return "xls";
        }
        if (string.endsWith(Xlsx_Surfix)) {
            return "xlsx";
        }
        if (string.endsWith(Pdf_Surfix)) {
            return "pdf";
        }
        return "html";
    }

    public void setTitle(String string) {
        if (string != null) {
            this.m_szTitle = string;
        }
    }

    public JFrame getMainFrame() {
        Window window;
        if (this.mainFrame == null && (window = SwingUtilities.windowForComponent(this.m_oTable)) instanceof Frame) {
            this.mainFrame = (JFrame)window;
        }
        return this.mainFrame;
    }

    public void setMainFrame(JFrame jFrame) {
        this.mainFrame = jFrame;
    }

    class SaveAndPrintTask
    extends Thread {
        private static final int ONCE_SAVE_SIZE = 2000;
        private int[] rows = null;
        private boolean flag = true;

        public SaveAndPrintTask(int[] nArray, boolean bl) {
            this.rows = nArray;
            this.flag = bl;
        }

        @Override
        public void run() {
            Vector vector = null;
            String[] stringArray = SaveAndPrintFile.this.getColumnNames();
            boolean bl = false;
            int n = this.rows.length;
            if (this.flag) {
                vector = new Vector(2);
                SaveAndPrintFile.this.printable = new TablePrintable(SaveAndPrintFile.this.m_szTitle, SaveAndPrintFile.this.userName, SaveAndPrintFile.this.summary, stringArray, vector, n, this.flag);
                bl = PrintSupportor.saveToFileNoCheck(SaveAndPrintFile.this.getMainFrame(), SaveAndPrintFile.this.fileName, SaveAndPrintFile.this.printable, SaveAndPrintFile.this.getFileType(SaveAndPrintFile.this.fileName), SaveAndPrintFile.this.m_oFileChooser.getUserEncoding());
            } else {
                vector = new Vector(50);
                bl = true;
            }
            if (bl) {
                if (SaveAndPrintFile.this.blockDialog != null) {
                    SaveAndPrintFile.this.blockDialog.getProgressBar().setStringPainted(true);
                    SaveAndPrintFile.this.blockDialog.getProgressBar().setMinimum(0);
                    SaveAndPrintFile.this.blockDialog.getProgressBar().setMaximum(n);
                    SaveAndPrintFile.this.blockDialog.setCurrentValue(0);
                }
                SaveAndPrintFile.this.running = true;
                SaveAndPrintFile.this.isSuccess = true;
                int n2 = 0;
                try {
                    for (int i = 0; SaveAndPrintFile.this.running && i < this.rows.length && !SaveAndPrintFile.this.printable.isOver(); i += n2) {
                        n2 = Math.min(n - i, 2000);
                        vector = SaveAndPrintFile.this.getTablePartData(this.rows, i, n2);
                        SaveAndPrintFile.this.printable.append(vector, true);
                        if (SaveAndPrintFile.this.blockDialog == null) continue;
                        SaveAndPrintFile.this.blockDialog.incrementValue(vector.size());
                    }
                }
                catch (Exception exception) {
                    logger.trace(exception.getMessage(), exception);
                    SaveAndPrintFile.this.running = false;
                    SaveAndPrintFile.this.isSuccess = false;
                    SaveAndPrintFile.this.printable.setDataOver(true);
                }
            } else {
                SaveAndPrintFile.this.isSuccess = false;
            }
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    if (SaveAndPrintFile.this.blockDialog != null) {
                        SaveAndPrintFile.this.blockDialog.setCurrentValue(0);
                        SaveAndPrintFile.this.blockDialog.dispose();
                        SaveAndPrintFile.this.blockDialog = null;
                    }
                }
            });
            SaveAndPrintFile.this.printable = null;
        }
    }
}

