/*
 * Decompiled with CFR 0.152.
 */
package com.swimap.iview.templates.tabbedpane;

import com.swimap.iview.commstyle.resource.ResourceMng;
import com.swimap.iview.templates.tabbedpane.CloseableMetalTabbedPaneUI;
import com.swimap.iview.templates.tabbedpane.CloseableTabbedPane;
import com.swimap.iview.util.ScreenToolKit;
import com.swimap.iview.util.log.IviewLogger;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.ResourceBundle;
import javax.swing.AbstractAction;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.SwingUtilities;

class TabPanePopupSupport
extends MouseAdapter {
    private static IviewLogger logger = IviewLogger.getLogger(TabPanePopupSupport.class, "IVIEW");
    private static ResourceBundle res = ResourceMng.getInstance().getResourceBundleFromPropertyFile("mainfrm/iview/templates/tabbedpane/Res");
    private static String CLOSE = res.getString("Close");
    private static String CLOSEOTHERS = res.getString("CloseOthers");
    private static String CLOSEALL = res.getString("CloseAll");
    private CloseableTabbedPane tabPane = null;

    TabPanePopupSupport(CloseableTabbedPane closeableTabbedPane) {
        this.tabPane = closeableTabbedPane;
    }

    @Override
    public void mouseClicked(MouseEvent mouseEvent) {
        this.checkShowPopup(mouseEvent);
    }

    private void checkShowPopup(MouseEvent mouseEvent) {
        if (!SwingUtilities.isRightMouseButton(mouseEvent) || !this.tabPane.getTabMenuEnabled()) {
            return;
        }
        if (!(this.tabPane.getUI() instanceof CloseableMetalTabbedPaneUI)) {
            return;
        }
        CloseableMetalTabbedPaneUI closeableMetalTabbedPaneUI = (CloseableMetalTabbedPaneUI)this.tabPane.getUI();
        int n = mouseEvent.getX();
        int n2 = mouseEvent.getY();
        int n3 = -1;
        for (int i = 0; i < closeableMetalTabbedPaneUI.getRects().length; ++i) {
            if (!closeableMetalTabbedPaneUI.getRects()[i].contains(n, n2)) continue;
            n3 = i;
        }
        if (n3 == -1) {
            return;
        }
        mouseEvent.consume();
        this.showPopup(mouseEvent, n3);
    }

    private void showPopup(MouseEvent mouseEvent, int n) {
        JPopupMenu jPopupMenu = new JPopupMenu();
        ArrayList arrayList = this.getMenus();
        for (int i = 0; i < arrayList.size(); ++i) {
            JMenuItem jMenuItem = (JMenuItem)arrayList.get(i);
            jPopupMenu.add(jMenuItem);
        }
        try {
            ScreenToolKit.showPopupMenu(jPopupMenu, mouseEvent);
        }
        catch (Exception exception) {
            logger.trace(exception.getMessage(), exception);
            jPopupMenu.setVisible(false);
            jPopupMenu.show(mouseEvent.getComponent(), mouseEvent.getX(), mouseEvent.getY());
        }
    }

    private ArrayList getMenus() {
        ArrayList<JMenuItem> arrayList = new ArrayList<JMenuItem>();
        JMenuItem jMenuItem = this.createCloseMenu();
        JMenuItem jMenuItem2 = this.createCloseOthersMenu();
        JMenuItem jMenuItem3 = this.createCloseAllMenu();
        arrayList.add(jMenuItem);
        arrayList.add(jMenuItem2);
        arrayList.add(jMenuItem3);
        return arrayList;
    }

    private JMenuItem createCloseMenu() {
        JMenuItem jMenuItem = new JMenuItem(new AbstractAction(CLOSE){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                TabPanePopupSupport.this.closefireEvents(TabPanePopupSupport.this.tabPane.getSelectedIndex());
                if (TabPanePopupSupport.this.tabPane.getTabLayoutPolicy() == 1 && TabPanePopupSupport.this.tabPane.getTabPlacement() == 1) {
                    TabPanePopupSupport.this.tabPane.autoScrollMovement();
                }
            }
        });
        if (null == this.tabPane.getCloseIconAt(this.tabPane.getSelectedIndex())) {
            jMenuItem.setEnabled(false);
        }
        jMenuItem.setMnemonic('C');
        return jMenuItem;
    }

    private JMenuItem createCloseOthersMenu() {
        JMenuItem jMenuItem = new JMenuItem(new AbstractAction(CLOSEOTHERS){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                int n = TabPanePopupSupport.this.tabPane.getSelectedIndex();
                Component component = TabPanePopupSupport.this.tabPane.getSelectedComponent();
                int n2 = TabPanePopupSupport.this.tabPane.getTabCount();
                for (int i = n2 - 1; i >= 0; --i) {
                    if (i == n || null == TabPanePopupSupport.this.tabPane.getCloseIconAt(i)) continue;
                    TabPanePopupSupport.this.closefireEvents(i);
                }
                try {
                    TabPanePopupSupport.this.tabPane.setSelectedComponent(component);
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    logger.trace(illegalArgumentException.getMessage(), illegalArgumentException);
                }
            }
        });
        int n = 0;
        int n2 = this.tabPane.getTabCount();
        int n3 = this.tabPane.getSelectedIndex();
        while (--n2 >= 0) {
            if (n2 == n3 || null == this.tabPane.getCloseIconAt(n2)) continue;
            ++n;
        }
        if (n <= 0) {
            jMenuItem.setEnabled(false);
        }
        jMenuItem.setMnemonic('O');
        return jMenuItem;
    }

    private JMenuItem createCloseAllMenu() {
        JMenuItem jMenuItem = new JMenuItem(new AbstractAction(CLOSEALL){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                int n = TabPanePopupSupport.this.tabPane.getTabCount();
                for (int i = n - 1; i >= 0; --i) {
                    if (null == TabPanePopupSupport.this.tabPane.getCloseIconAt(i)) continue;
                    TabPanePopupSupport.this.closefireEvents(i);
                }
            }
        });
        int n = 0;
        int n2 = this.tabPane.getTabCount();
        while (--n2 >= 0) {
            if (null == this.tabPane.getCloseIconAt(n2)) continue;
            ++n;
        }
        if (n <= 0) {
            jMenuItem.setEnabled(false);
        }
        jMenuItem.setMnemonic('A');
        return jMenuItem;
    }

    private void closefireEvents(int n) {
        Component component = this.tabPane.getComponentAt(n);
        if (this.tabPane.fireClosingTab(component)) {
            this.tabPane.removeTabAt(n);
            this.tabPane.fireClosedTab(component);
        }
    }
}

