/*
 * Decompiled with CFR 0.152.
 */
package com.swimap.iview.templates.tabbedpane;

import com.swimap.iview.commstyle.resource.ResourceMng;
import com.swimap.iview.commstyle.resource.i18n.ResourceUtil;
import com.swimap.iview.framework.lookandfeel.TabbedPaneEclipseStyleUI;
import com.swimap.iview.templates.tabbedpane.CloseableMetalTabbedPaneUI;
import com.swimap.iview.templates.tabbedpane.CloseableTabbedPaneListener;
import com.swimap.iview.templates.tabbedpane.TabbedPaneClosedListener;
import com.swimap.iview.templates.utils.MultiRowToolTip;
import com.swimap.iview.templates.utils.ScrollPopupMenu;
import com.swimap.iview.util.CloseIcon;
import com.swimap.iview.util.CommonUtil;
import com.swimap.iview.util.IconCloseListener;
import com.swimap.iview.util.log.IviewLogger;
import java.awt.Component;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.io.Serializable;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.ResourceBundle;
import java.util.Vector;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JTabbedPane;
import javax.swing.JToolTip;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.event.ChangeListener;
import javax.swing.event.EventListenerList;
import javax.swing.plaf.TabbedPaneUI;
import javax.swing.plaf.basic.BasicTabbedPaneUI;

public class CloseableTabbedPane
extends JTabbedPane {
    private static IviewLogger logger = IviewLogger.getLogger(CloseableTabbedPane.class, "IVIEW");
    private static final int TITLE_MAX_LENGTH = 32;
    private int titleMaxLength = 32;
    private static final String OMIT_SYMBOL = "...";
    private EventListenerList eventListenerList = new EventListenerList();
    protected Vector exPages = new Vector(1);
    private static final String UI_CLASS_ID = "CloseableMetalTabbedPaneUI";
    private boolean isTabbedPaneClosable = false;
    private String m_closeIconToolTip;
    private String m_parentCloseIconTip;
    private MouseListener panelToTabDelegator = null;
    private boolean tabMenuEnabled = false;
    public static final int TAB_SCROLL_AS_NEEDED = 0;
    public static final int TAB_SCROLL_NEVER = 1;
    public static final int TAB_SCROLL_ALWAYS = 2;
    public static final int TAB_LIST_AS_NEEDED = 0;
    public static final int TAB_LIST_NEVER = 1;
    public static final int TAB_LIST_ALWAYS = 2;
    private int tabScrollPolicy = 0;
    private int tabListPolicy = 1;
    private boolean tabListSorted = false;
    private JPopupMenu popup = null;
    private int mousePressedTabIndex = -1;

    public CloseableTabbedPane() {
        this(1, 0);
    }

    @Override
    protected void processMouseEvent(MouseEvent mouseEvent) {
        int n = mouseEvent.getID();
        if (501 == n) {
            closeableTabCloseIcon closeableTabCloseIcon2;
            TabbedPaneUI tabbedPaneUI = this.getUI();
            this.mousePressedTabIndex = tabbedPaneUI.tabForCoordinate(this, mouseEvent.getX(), mouseEvent.getY());
            if (this.mousePressedTabIndex >= 0 && this.isEnabledAt(this.mousePressedTabIndex) && null != (closeableTabCloseIcon2 = (closeableTabCloseIcon)this.getCloseIconAt(this.mousePressedTabIndex)) && closeableTabCloseIcon2.isCloseIcon(mouseEvent)) {
                closeableTabCloseIcon2.setMousePressed(true);
                return;
            }
        }
        super.processMouseEvent(mouseEvent);
    }

    public CloseableTabbedPane(int n) {
        this(n, 0);
    }

    public CloseableTabbedPane(int n, int n2) {
        super(n, n2);
    }

    public void setTabbedPaneClosable() {
        if (this.isTabbedPaneClosable) {
            return;
        }
        if (1 == this.getTabPlacement()) {
            this.isTabbedPaneClosable = true;
            if (this.ui instanceof CloseableMetalTabbedPaneUI) {
                ((CloseableMetalTabbedPaneUI)this.getUI()).initCloseIcon(this);
            }
            this.updateUI();
        }
    }

    public boolean setClosableIconToolTip(String string, String string2) {
        if (this.isTabbedPaneClosable) {
            this.firePropertyChange("CloseIconToolTipChange", this.m_closeIconToolTip, string);
            this.firePropertyChange("ParentCloseIconToolTipChange", this.m_parentCloseIconTip, string2);
            this.m_closeIconToolTip = string;
            this.m_parentCloseIconTip = string2;
            return true;
        }
        return false;
    }

    public String getClosableIconToolTip() {
        return this.m_closeIconToolTip;
    }

    public boolean isTabbedPaneClosable() {
        return this.isTabbedPaneClosable;
    }

    @Override
    public void updateUI() {
        if (null == this.getUI() || !(UIManager.getUI(this) instanceof TabbedPaneEclipseStyleUI)) {
            this.panelToTabDelegator = null;
            this.setUI(UIManager.getUI(this));
        }
        this.firePropertyChange("CloseIconToolTipChange", null, this.m_closeIconToolTip);
        this.firePropertyChange("ParentCloseIconToolTipChange", null, this.m_parentCloseIconTip);
    }

    @Override
    public String getUIClassID() {
        return UI_CLASS_ID;
    }

    public void addCloseableTabbedPaneListener(CloseableTabbedPaneListener closeableTabbedPaneListener) {
        this.eventListenerList.add(CloseableTabbedPaneListener.class, closeableTabbedPaneListener);
    }

    public void removeCloseableTabbedPaneListener(CloseableTabbedPaneListener closeableTabbedPaneListener) {
        this.eventListenerList.remove(CloseableTabbedPaneListener.class, closeableTabbedPaneListener);
    }

    public void addTabbedPaneClosedListener(TabbedPaneClosedListener tabbedPaneClosedListener) {
        this.eventListenerList.add(TabbedPaneClosedListener.class, tabbedPaneClosedListener);
    }

    public void removeTabbedPaneClosedListener(TabbedPaneClosedListener tabbedPaneClosedListener) {
        this.eventListenerList.remove(TabbedPaneClosedListener.class, tabbedPaneClosedListener);
    }

    @Override
    public void removeTabAt(int n) {
        super.removeTabAt(n);
        ExPage exPage = (ExPage)this.exPages.get(n);
        Icon icon = exPage.closeIcon;
        if (icon instanceof CloseIcon) {
            ((CloseIcon)icon).setEnabled(false);
        }
        this.exPages.removeElementAt(n);
        CommonUtil.hideShowTooltip();
    }

    @Override
    public void insertTab(String string, Icon icon, Component component, String string2, int n) {
        this.insertTab(string, icon, component, string2, n, true);
    }

    public void insertTab(String string, Icon icon, Component component, String string2, int n, boolean bl) {
        Icon icon2 = null;
        if (bl) {
            icon2 = this.initCloseIcon(string2);
        }
        this.insertTab(string, icon, icon2, component, string2, n);
    }

    public void addCloseableTab(String string, Component component, boolean bl) {
        this.insertTab(string, null, component, null, this.exPages.size(), bl);
    }

    public void setTabCloseable(int n, boolean bl) {
        if (0 > n || this.getTabCount() <= n) {
            logger.trace("index is not valid");
            return;
        }
        String string = this.getTitleAt(n);
        Component component = this.getComponentAt(n);
        Icon icon = this.getIconAt(n);
        String string2 = this.getToolTipTextAt(n);
        int n2 = this.getSelectedIndex();
        this.remove(n);
        this.insertTab(string, icon, component, string2, n, bl);
        if (n2 == n) {
            this.setSelectedIndex(n);
        }
    }

    public Icon getCloseIconAt(int n) {
        if ((ExPage)this.exPages.elementAt(n) != null) {
            return ((ExPage)this.exPages.elementAt((int)n)).closeIcon;
        }
        return null;
    }

    public String getRealTitleAt(int n) {
        if ((ExPage)this.exPages.elementAt(n) != null) {
            return ((ExPage)this.exPages.elementAt((int)n)).realTitle;
        }
        return null;
    }

    @Override
    public void setToolTipTextAt(int n, String string) {
        ExPage exPage = (ExPage)this.exPages.elementAt(n);
        exPage.realTip = string;
        super.setToolTipTextAt(n, string);
        if (this.getCloseIconAt(n) instanceof closeableTabCloseIcon) {
            ((closeableTabCloseIcon)this.getCloseIconAt(n)).setInitialToolTip(string);
        }
    }

    @Override
    public JToolTip createToolTip() {
        MultiRowToolTip multiRowToolTip = new MultiRowToolTip();
        multiRowToolTip.setComponent(this);
        return multiRowToolTip;
    }

    @Override
    public void setTitleAt(int n, String string) {
        ExPage exPage = (ExPage)this.exPages.elementAt(n);
        String string2 = string;
        String string3 = exPage.realTip;
        if (string.length() > this.titleMaxLength) {
            if (string3 == null) {
                string3 = string;
            }
            super.setToolTipTextAt(n, string3);
            string = CloseableTabbedPane.getAbbString(string, this.titleMaxLength - OMIT_SYMBOL.length()) + OMIT_SYMBOL;
        }
        if (exPage.closeIcon instanceof closeableTabCloseIcon) {
            ((closeableTabCloseIcon)exPage.closeIcon).setInitialToolTip(string3);
        }
        exPage.realTitle = string2;
        super.setTitleAt(n, string);
    }

    public void setTitleMaxLength(int n) {
        this.titleMaxLength = n;
    }

    protected Icon initCloseIcon(String string) {
        Object object;
        closeableTabCloseIcon closeableTabCloseIcon2 = null;
        if ("1.4".equals(System.getProperty("java.version").substring(0, 3)) && this.getTabLayoutPolicy() == 1) {
            if (this.getUI() instanceof CloseableMetalTabbedPaneUI) {
                closeableTabCloseIcon2 = !(this.getLayout() instanceof CloseableMetalTabbedPaneUI.ClosableScrollableLayout) ? new closeableTabCloseIcon(this.getScrollableTabPanel("tabScroller"), string) : new closeableTabCloseIcon(this.getScrollableTabPanel("closeTabScroller"), string);
            }
        } else if (this.getTabLayoutPolicy() == 1) {
            if (this.getUI() instanceof CloseableMetalTabbedPaneUI) {
                if (!(this.getLayout() instanceof CloseableMetalTabbedPaneUI.ClosableScrollableLayout)) {
                    object = this.getScrollableTabPanel("tabScroller");
                    closeableTabCloseIcon2 = new closeableTabCloseIcon((JComponent)object, string);
                } else {
                    object = this.getScrollableTabPanel("closeTabScroller");
                    closeableTabCloseIcon2 = new closeableTabCloseIcon((JComponent)object, string);
                }
                if (null == this.panelToTabDelegator) {
                    this.panelToTabDelegator = this.createPanelToTabDelegator((JPanel)object);
                    ((Component)object).addMouseListener(this.panelToTabDelegator);
                    ((Component)object).addMouseMotionListener((MouseMotionListener)((Object)this.panelToTabDelegator));
                }
            }
        } else {
            closeableTabCloseIcon2 = new closeableTabCloseIcon(this, string);
        }
        object = new IconCloseListener(){

            @Override
            public void close() {
                CloseableTabbedPane closeableTabbedPane = CloseableTabbedPane.this;
                Component component = closeableTabbedPane.getComponentAt(closeableTabbedPane.mousePressedTabIndex);
                if (closeableTabbedPane.fireClosingTab(component)) {
                    closeableTabbedPane.remove(closeableTabbedPane.mousePressedTabIndex);
                    closeableTabbedPane.fireClosedTab(component);
                    if (closeableTabbedPane.getTabLayoutPolicy() == 1 && closeableTabbedPane.getTabPlacement() == 1) {
                        CloseableTabbedPane.this.autoScrollMovement();
                    }
                    closeableTabbedPane.mousePressedTabIndex = -1;
                    CommonUtil.hideShowTooltip();
                }
            }
        };
        if (null != closeableTabCloseIcon2) {
            closeableTabCloseIcon2.addIconCloseListener((IconCloseListener)object);
        }
        return closeableTabCloseIcon2;
    }

    void autoScrollMovement() {
        CloseableTabbedPane closeableTabbedPane = this;
        int n = closeableTabbedPane.mousePressedTabIndex;
        TabbedPaneUI tabbedPaneUI = closeableTabbedPane.getUI();
        if (tabbedPaneUI instanceof CloseableMetalTabbedPaneUI) {
            ((CloseableMetalTabbedPaneUI)this.getUI()).forwardTab(n);
        }
    }

    protected boolean fireClosingTab(Component component) {
        boolean bl = true;
        Object[] objectArray = this.eventListenerList.getListenerList();
        for (int i = objectArray.length - 2; i >= 0; i -= 2) {
            if (objectArray[i] != CloseableTabbedPaneListener.class || ((CloseableTabbedPaneListener)objectArray[i + 1]).tabClosing(component)) continue;
            bl = false;
            break;
        }
        return bl;
    }

    protected void fireClosedTab(Component component) {
        Object[] objectArray = this.eventListenerList.getListenerList();
        for (int i = 0; i < objectArray.length; ++i) {
            if (objectArray[i] != CloseableTabbedPaneListener.class) continue;
            ((CloseableTabbedPaneListener)objectArray[i + 1]).tabClosed(component);
        }
    }

    final TabbedPaneClosedListener[] getTabbedPaneClosedListener() {
        return (TabbedPaneClosedListener[])this.eventListenerList.getListeners(TabbedPaneClosedListener.class);
    }

    final CloseableTabbedPaneListener[] getCloseableTabbedPaneListener() {
        return (CloseableTabbedPaneListener[])this.eventListenerList.getListeners(CloseableTabbedPaneListener.class);
    }

    private void insertTab(String string, Icon icon, Icon icon2, Component component, String string2, int n) {
        int n2 = n;
        int n3 = this.indexOfComponent(component);
        if (component != null && n3 != -1 && n2 > n3) {
            --n2;
        }
        this.exPages.insertElementAt(new ExPage(icon2, string, string2), n2);
        if (null != string && string.length() > this.titleMaxLength) {
            if (string2 == null) {
                string2 = string;
            }
            string = CloseableTabbedPane.getAbbString(string, this.titleMaxLength - OMIT_SYMBOL.length()) + OMIT_SYMBOL;
        }
        if (icon2 instanceof closeableTabCloseIcon) {
            ((closeableTabCloseIcon)icon2).setInitialToolTip(string2);
        }
        super.insertTab(string, icon, component, string2, n);
        if (this.ui instanceof CloseableMetalTabbedPaneUI) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    ((CloseableMetalTabbedPaneUI)CloseableTabbedPane.this.ui).checkEnablity();
                }
            });
        }
    }

    private int indexOfCloseIcon(Icon icon) {
        Icon icon2 = null;
        int n = this.getTabCount();
        for (int i = 0; i < n; ++i) {
            icon2 = this.getCloseIconAt(i);
            if ((icon2 == null || !icon2.equals(icon)) && (icon2 != null || null != icon)) continue;
            return i;
        }
        return -1;
    }

    JPanel getScrollableTabPanel(String string) {
        BasicTabbedPaneUI basicTabbedPaneUI = null;
        JPanel jPanel = null;
        if (this.getUI() instanceof BasicTabbedPaneUI) {
            basicTabbedPaneUI = (BasicTabbedPaneUI)this.getUI();
            ChangeListener changeListener = (ChangeListener)CloseableTabbedPane.getField(basicTabbedPaneUI.getClass(), basicTabbedPaneUI, string);
            jPanel = (JPanel)CloseableTabbedPane.getField(changeListener.getClass(), changeListener, "tabPanel");
        }
        return jPanel;
    }

    private static Object getField(Class clazz, Object object, String string) {
        Field field = null;
        try {
            field = clazz.getDeclaredField(string);
            field.setAccessible(true);
        }
        catch (SecurityException securityException) {
            return null;
        }
        catch (NoSuchFieldException noSuchFieldException) {
            Class clazz2 = clazz.getSuperclass();
            if (clazz2 != null && clazz2 != clazz) {
                clazz = clazz2;
                return CloseableTabbedPane.getField(clazz, object, string);
            }
            return null;
        }
        try {
            return field.get(object);
        }
        catch (IllegalAccessException illegalAccessException) {
            return null;
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return null;
        }
    }

    private static String getAbbString(String string, int n) {
        if (null == string || string.length() <= (n + 1) / 2) {
            return "";
        }
        String string2 = string.substring(0, (n + 1) / 2);
        int n2 = string2.length();
        if (n2 == n) {
            return string2;
        }
        if (n2 == n + 1) {
            return string.substring(0, n / 2);
        }
        return string2 + CloseableTabbedPane.getAbbString(string.substring((n + 1) / 2), n - n2);
    }

    private MouseListener createPanelToTabDelegator(final JPanel jPanel) {
        MouseAdapter mouseAdapter = new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent mouseEvent) {
                this.delegateEvent(mouseEvent);
            }

            @Override
            public void mousePressed(MouseEvent mouseEvent) {
                this.delegateEvent(mouseEvent);
            }

            @Override
            public void mouseEntered(MouseEvent mouseEvent) {
                this.delegateEvent(mouseEvent);
            }

            @Override
            public void mouseExited(MouseEvent mouseEvent) {
                this.delegateEvent(mouseEvent);
            }

            @Override
            public void mouseMoved(MouseEvent mouseEvent) {
                this.delegateEvent(mouseEvent);
            }

            private void delegateEvent(MouseEvent mouseEvent) {
                Point point = SwingUtilities.convertPoint(jPanel, mouseEvent.getPoint(), CloseableTabbedPane.this);
                CloseableTabbedPane.this.dispatchEvent(new MouseEvent(CloseableTabbedPane.this, mouseEvent.getID(), mouseEvent.getWhen(), mouseEvent.getModifiers(), point.x, point.y, mouseEvent.getClickCount(), mouseEvent.isPopupTrigger()));
            }
        };
        return mouseAdapter;
    }

    public void setTabMenuEnabled(boolean bl) {
        this.tabMenuEnabled = bl;
    }

    public boolean getTabMenuEnabled() {
        return this.tabMenuEnabled;
    }

    public int getTabScrollPolicy() {
        return this.tabScrollPolicy;
    }

    public void setTabScrollPolicy(int n) {
        switch (n) {
            case 0: 
            case 1: 
            case 2: {
                break;
            }
            default: {
                throw new IllegalArgumentException("invalid tab scroll policy");
            }
        }
        this.tabScrollPolicy = n;
        this.revalidate();
        this.repaint();
    }

    public int getTabListPolicy() {
        return this.tabListPolicy;
    }

    public void setTabListPolicy(int n) {
        switch (n) {
            case 0: 
            case 1: 
            case 2: {
                break;
            }
            default: {
                throw new IllegalArgumentException("invalid tab list policy");
            }
        }
        this.tabListPolicy = n;
        this.revalidate();
        this.repaint();
    }

    public void setTabListSorted(boolean bl) {
        this.tabListSorted = bl;
    }

    public boolean isTabListSorted() {
        return this.tabListSorted;
    }

    void showDropDownList(JComponent jComponent) {
        this.popup = new ScrollPopupMenu();
        this.popup.setName("CloseableTabbedPane_popuptabmenu");
        PopupMenuItem popupMenuItem = null;
        ArrayList<PopupMenuItem> arrayList = new ArrayList<PopupMenuItem>(8);
        int n = this.getTabCount();
        for (int i = 0; i < n; ++i) {
            popupMenuItem = this.getNewPopupMenuItem(i);
            arrayList.add(popupMenuItem);
        }
        Collections.sort(arrayList, new PopupMenuItemComparator(this.isTabListSorted()));
        for (PopupMenuItem popupMenuItem2 : arrayList) {
            this.popup.add(popupMenuItem2);
        }
        this.popup.show(jComponent, jComponent.getSize().width - this.popup.getPreferredSize().width, jComponent.getSize().height);
    }

    private PopupMenuItem getNewPopupMenuItem(int n) {
        String string = this.getTitleAt(n);
        String string2 = this.getRealTitleAt(n);
        PopupMenuItem popupMenuItem = new PopupMenuItem(string, n, this.getIconAt(n));
        if (!string.equals(string2)) {
            popupMenuItem.setToolTipText(string2);
        }
        if (this.getSelectedIndex() == n) {
            Font font = popupMenuItem.getFont();
            popupMenuItem.setFont(new Font(font.getName(), 1, font.getSize()));
        }
        popupMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                int n = ((PopupMenuItem)actionEvent.getSource()).getTabIndex();
                if (n != CloseableTabbedPane.this.getSelectedIndex()) {
                    CloseableTabbedPane.this.setSelectedIndex(n);
                }
                ((CloseableMetalTabbedPaneUI)CloseableTabbedPane.this.getUI()).scrollToSelectedTab();
                CloseableTabbedPane.this.popup = null;
            }
        });
        return popupMenuItem;
    }

    static {
        if (null == UIManager.get(UI_CLASS_ID)) {
            UIManager.put(UI_CLASS_ID, "com.swimap.iview.templates.tabbedpane.CloseableMetalTabbedPaneUI");
        }
    }

    private class PopupMenuItemComparator
    implements Comparator<PopupMenuItem> {
        private boolean sortByName = false;

        PopupMenuItemComparator(boolean bl) {
            this.sortByName = bl;
        }

        @Override
        public int compare(PopupMenuItem popupMenuItem, PopupMenuItem popupMenuItem2) {
            if (this.sortByName) {
                return this.compareByName(popupMenuItem, popupMenuItem2);
            }
            return this.compareByIndex(popupMenuItem, popupMenuItem2);
        }

        private int compareByName(PopupMenuItem popupMenuItem, PopupMenuItem popupMenuItem2) {
            return popupMenuItem.getTitle().compareToIgnoreCase(popupMenuItem2.getTitle());
        }

        private int compareByIndex(PopupMenuItem popupMenuItem, PopupMenuItem popupMenuItem2) {
            int n;
            int n2 = 0;
            int n3 = popupMenuItem.getTabIndex();
            n2 = n3 < (n = popupMenuItem2.getTabIndex()) ? -1 : (n3 > n ? 1 : 0);
            return n2;
        }
    }

    private class PopupMenuItem
    extends JMenuItem {
        private int tabIndex;
        private String title;

        PopupMenuItem(String string, int n, Icon icon) {
            super(string);
            this.tabIndex = 0;
            this.title = null;
            this.title = string;
            this.tabIndex = n;
            this.setIcon(icon);
        }

        public int getTabIndex() {
            return this.tabIndex;
        }

        public String getTitle() {
            return this.title;
        }
    }

    private class closeableTabCloseIcon
    extends CloseIcon {
        private ResourceBundle res;
        private String close;
        private String initialToolTip;
        private int bound_x;
        private int bound_y;
        private static final int BORDER_SIZE = 12;

        public closeableTabCloseIcon(JComponent jComponent) {
            super(jComponent);
            this.res = ResourceMng.getInstance().getResourceBundleFromPropertyFile("mainfrm/iview/util/Res");
            this.close = this.res.getString("CloseIcon_ToolTip");
        }

        public closeableTabCloseIcon(JComponent jComponent, String string) {
            this(jComponent);
            this.initialToolTip = string;
        }

        @Override
        public void paintIcon(Component component, Graphics graphics, int n, int n2) {
            super.paintIcon(component, graphics, n, n2);
            this.bound_x = n;
            this.bound_y = n2;
        }

        @Override
        protected void setParentToolTip(String string) {
            int n = 0;
            try {
                n = CloseableTabbedPane.this.indexOfCloseIcon(this);
            }
            catch (NullPointerException nullPointerException) {
                return;
            }
            if (n < 0) {
                return;
            }
            String string2 = CloseableTabbedPane.this.getToolTipTextAt(n);
            if (string == null ? string2 == null : ResourceUtil.areEquals(string, string2)) {
                return;
            }
            ExPage exPage = (ExPage)CloseableTabbedPane.this.exPages.get(n);
            if (exPage.realTip != null) {
                CloseableTabbedPane.this.setToolTipTextAt(n, string);
            } else {
                CloseableTabbedPane.super.setToolTipTextAt(n, string);
            }
        }

        @Override
        protected String getParentToolTip() {
            return this.initialToolTip;
        }

        private void setInitialToolTip(String string) {
            if (!ResourceUtil.areEquals(this.close, string)) {
                this.initialToolTip = string;
            }
        }

        @Override
        protected Rectangle getMouseBounds() {
            return new Rectangle(this.bound_x - 2, this.bound_y - 2, 12, 12);
        }
    }

    private class ExPage
    implements Serializable {
        Icon closeIcon;
        String realTitle;
        String realTip;

        ExPage(Icon icon, String string, String string2) {
            this.closeIcon = icon;
            this.realTitle = string;
            this.realTip = string2;
        }
    }
}

