/*
 * Decompiled with CFR 0.152.
 */
package com.swimap.iview.templates.tabbedpane;

import com.swimap.iview.framework.lookandfeel.SwImapMetalTabbedPaneUI;
import com.swimap.iview.templates.tabbedpane.CloseableTabbedPane;
import com.swimap.iview.templates.tabbedpane.CloseableTabbedPaneListener;
import com.swimap.iview.templates.tabbedpane.TabPanePopupSupport;
import com.swimap.iview.templates.tabbedpane.TabbedPaneClosedListener;
import com.swimap.iview.util.CloseIcon;
import com.swimap.iview.util.IconCloseListener;
import com.swimap.iview.util.ScreenToolKit;
import com.swimap.iview.util.log.IviewLogger;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Point;
import java.awt.Polygon;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.AbstractAction;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.JViewport;
import javax.swing.SwingConstants;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.UIResource;
import javax.swing.plaf.basic.BasicArrowButton;
import javax.swing.plaf.basic.BasicTabbedPaneUI;
import javax.swing.plaf.metal.MetalTabbedPaneUI;
import javax.swing.text.View;

public class CloseableMetalTabbedPaneUI
extends SwImapMetalTabbedPaneUI {
    private static IviewLogger logger = IviewLogger.getLogger(CloseableMetalTabbedPaneUI.class, "IVIEW");
    private static final int CROP_SEGMENT = 12;
    protected static final int CLOSE_ICON_HORIZONTAL_INSETS = 10;
    private int[] xCropLen = new int[]{1, 1, 0, 0, 1, 1, 2, 2};
    private int[] yCropLen = new int[]{0, 3, 3, 6, 6, 9, 9, 12};
    protected CloseScrollableTabSupport closeTabScroller = null;
    protected CloseTabSelectionHandler m_TabSelectionHandler = null;
    protected CloseMouseHandler m_mouseHandler = null;
    protected CloseFocusHandler m_focusHandler = null;
    protected CloseIconHandler closeIconHandler = null;
    protected PropertyHandler m_propertyHandler = null;
    protected ActionListener m_forwardBtnAction = null;
    protected ActionListener m_backwardBtnAction = null;
    protected ActionListener dropDownListBtnAction = null;
    protected int m_iconStartingY = 10;
    private CloseIcon tabbedPaneCloseIcon = null;
    private String m_CloseIconToolTip;
    private String m_parentCloseIconTip;
    private TabPanePopupSupport popupSupport = null;
    private int tabScrollPolicy = 0;
    private int tabListPolicy = 1;
    private boolean isLastTab = false;
    private boolean viewPortScrolled = false;

    public static ComponentUI createUI(JComponent jComponent) {
        return new CloseableMetalTabbedPaneUI();
    }

    @Override
    protected LayoutManager createLayoutManager() {
        if (!(this.tabPane instanceof CloseableTabbedPane)) {
            return super.createLayoutManager();
        }
        if (this.tabPane.getTabLayoutPolicy() == 1) {
            if (this.tabPane.getTabPlacement() == 1) {
                return new ClosableScrollableLayout();
            }
            return super.createLayoutManager();
        }
        if (this.isTabbedPaneCustomizable()) {
            return new CloseTabWrapLayout();
        }
        return super.createLayoutManager();
    }

    void checkEnablity() {
        if (null != this.closeTabScroller && this.closeTabScroller.scrollBackwardButton.isVisible() && !this.closeTabScroller.scrollForwardButton.isEnabled() && this.isLastTab) {
            int n;
            ClosableScrollableTabViewport closableScrollableTabViewport = this.closeTabScroller.getViewPort();
            Rectangle rectangle = closableScrollableTabViewport.getViewRect();
            int n2 = 0;
            int n3 = this.tabPane.getTabCount();
            int n4 = n3 - 1;
            if (n4 >= 0 && n4 == this.rects.length - 1 && (n2 = this.rects[n4].x - rectangle.x + this.rects[n4].width) > (n = this.closeTabScroller.scrollBackwardButton.getBounds().x)) {
                this.closeTabScroller.scrollForwardButton.setEnabled(true);
                this.isLastTab = false;
            }
        }
        this.isLastTab = false;
    }

    private boolean isCloseable() {
        if (this.tabPane instanceof CloseableTabbedPane) {
            return ((CloseableTabbedPane)this.tabPane).isTabbedPaneClosable();
        }
        return false;
    }

    protected boolean isTabbedPaneCustomizable() {
        return this.isCloseable() && this.tabPane.getTabPlacement() == 1;
    }

    @Override
    public void installUI(JComponent jComponent) {
        super.installUI(jComponent);
        if (jComponent instanceof CloseableTabbedPane) {
            boolean bl = this.isTabbedPaneCustomizable();
            boolean bl2 = this.isScrollableAndTop();
            boolean bl3 = this.isScrollableAndBottom();
            if (bl) {
                this.initCloseIcon((CloseableTabbedPane)jComponent);
            }
            if (bl2) {
                this.installScrollComponents();
                this.installCloseScrollListeners();
                this.installButtonActions();
            }
            if (bl3) {
                if (this.mouseListener != null) {
                    this.tabPane.removeMouseListener(this.mouseListener);
                }
                this.tabPane.addMouseListener(new BottomCloseMouseListener());
            }
            if ((bl || bl2) && this.m_propertyHandler == null) {
                this.m_propertyHandler = new PropertyHandler();
                this.tabPane.addPropertyChangeListener(this.m_propertyHandler);
            }
            this.installPopupListeners();
        }
    }

    protected void installPopupListeners() {
        CloseableTabbedPane closeableTabbedPane = (CloseableTabbedPane)this.tabPane;
        CloseIcon closeIcon = (CloseIcon)closeableTabbedPane.initCloseIcon("");
        closeIcon.setEnabled(false);
        this.popupSupport = new TabPanePopupSupport(closeableTabbedPane);
        if (closeableTabbedPane.getTabLayoutPolicy() == 0) {
            closeableTabbedPane.addMouseListener(this.popupSupport);
        } else if (!(this.tabPane.getLayout() instanceof ClosableScrollableLayout)) {
            JPanel jPanel = closeableTabbedPane.getScrollableTabPanel("tabScroller");
            jPanel.addMouseListener(this.popupSupport);
        } else {
            JPanel jPanel = closeableTabbedPane.getScrollableTabPanel("closeTabScroller");
            jPanel.addMouseListener(this.popupSupport);
        }
    }

    protected void installScrollComponents() {
        if (this.closeTabScroller == null) {
            this.closeTabScroller = new CloseScrollableTabSupport(this.tabPane.getTabPlacement());
            this.tabPane.add(this.closeTabScroller.viewport);
            this.tabPane.add(this.closeTabScroller.scrollForwardButton);
            this.tabPane.add(this.closeTabScroller.scrollBackwardButton);
            this.tabPane.add(this.closeTabScroller.tabListButton);
        }
    }

    protected void installButtonActions() {
        if (this.m_forwardBtnAction == null) {
            this.m_forwardBtnAction = new CloseScrollTabsForwardAction();
            this.closeTabScroller.scrollForwardButton.addActionListener(this.m_forwardBtnAction);
        }
        if (this.m_backwardBtnAction == null) {
            this.m_backwardBtnAction = new CloseScrollTabsBackwardAction();
            this.closeTabScroller.scrollBackwardButton.addActionListener(this.m_backwardBtnAction);
        }
        if (null == this.dropDownListBtnAction) {
            this.dropDownListBtnAction = new DropDownListBtnAction();
            this.closeTabScroller.tabListButton.addActionListener(this.dropDownListBtnAction);
        }
    }

    protected void installCloseScrollListeners() {
        if (this.propertyChangeListener != null) {
            this.tabPane.removePropertyChangeListener(this.propertyChangeListener);
        }
        if (this.tabChangeListener != null) {
            this.tabPane.removeChangeListener(this.tabChangeListener);
        }
        if (this.mouseListener != null) {
            this.tabPane.removeMouseListener(this.mouseListener);
        }
        if (this.focusListener != null) {
            this.tabPane.removeFocusListener(this.focusListener);
        }
        if (this.m_TabSelectionHandler == null) {
            this.m_TabSelectionHandler = new CloseTabSelectionHandler();
            this.tabPane.addChangeListener(this.m_TabSelectionHandler);
        }
        if (this.m_mouseHandler == null) {
            this.m_mouseHandler = new CloseMouseHandler();
            this.closeTabScroller.tabPanel.addMouseListener(this.m_mouseHandler);
        }
        if (this.m_focusHandler == null) {
            this.m_focusHandler = new CloseFocusHandler();
            this.tabPane.addFocusListener(this.m_focusHandler);
        }
    }

    protected void initCloseIcon(CloseableTabbedPane closeableTabbedPane) {
        if (this.tabbedPaneCloseIcon != null) {
            this.tabbedPaneCloseIcon.setEnabled(false);
        }
        this.tabbedPaneCloseIcon = new CloseIcon(closeableTabbedPane){
            private int boundX;
            private int boundY;

            @Override
            public void paintIcon(Component component, Graphics graphics, int n, int n2) {
                super.paintIcon(component, graphics, n, n2);
                this.boundX = n;
                this.boundY = n2;
            }

            @Override
            protected Rectangle getMouseBounds() {
                return new Rectangle(this.boundX, this.boundY, this.getIconWidth(), this.getIconHeight());
            }

            @Override
            protected String getIconToolTip() {
                return CloseableMetalTabbedPaneUI.this.m_CloseIconToolTip;
            }

            @Override
            protected String getParentToolTip() {
                return CloseableMetalTabbedPaneUI.this.m_parentCloseIconTip;
            }
        };
        if (this.closeIconHandler == null) {
            this.closeIconHandler = new CloseIconHandler();
            this.tabbedPaneCloseIcon.addIconCloseListener(this.closeIconHandler);
        }
        if (this.m_propertyHandler == null) {
            this.m_propertyHandler = new PropertyHandler();
            this.tabPane.addPropertyChangeListener(this.m_propertyHandler);
        }
    }

    protected void uninstallPopupListener() {
        if (null == this.popupSupport) {
            return;
        }
        CloseableTabbedPane closeableTabbedPane = (CloseableTabbedPane)this.tabPane;
        if (this.tabPane.getLayout() instanceof MetalTabbedPaneUI.TabbedPaneLayout) {
            closeableTabbedPane.removeMouseListener(this.popupSupport);
        } else if (!(this.tabPane.getLayout() instanceof ClosableScrollableLayout)) {
            JPanel jPanel = closeableTabbedPane.getScrollableTabPanel("tabScroller");
            jPanel.removeMouseListener(this.popupSupport);
        } else {
            JPanel jPanel = closeableTabbedPane.getScrollableTabPanel("closeTabScroller");
            jPanel.removeMouseListener(this.popupSupport);
        }
    }

    protected void uninstallCloseScrollListeners() {
        if (this.m_focusHandler != null) {
            this.tabPane.removeFocusListener(this.m_focusHandler);
            this.m_focusHandler = null;
        }
        if (this.m_mouseHandler != null) {
            this.tabPane.removeMouseListener(this.m_mouseHandler);
            this.m_mouseHandler = null;
        }
        if (this.m_TabSelectionHandler != null) {
            this.tabPane.removeChangeListener(this.m_TabSelectionHandler);
            this.m_TabSelectionHandler = null;
        }
        if (this.m_backwardBtnAction != null) {
            if (this.closeTabScroller != null && this.closeTabScroller.scrollBackwardButton != null) {
                this.closeTabScroller.scrollBackwardButton.removeActionListener(this.m_backwardBtnAction);
            }
            this.m_backwardBtnAction = null;
        }
        if (null != this.dropDownListBtnAction) {
            if (this.closeTabScroller != null && this.closeTabScroller.tabListButton != null) {
                this.closeTabScroller.tabListButton.removeActionListener(this.dropDownListBtnAction);
            }
            this.dropDownListBtnAction = null;
        }
        if (this.m_forwardBtnAction != null) {
            if (this.closeTabScroller != null && this.closeTabScroller.scrollForwardButton != null) {
                this.closeTabScroller.scrollForwardButton.removeActionListener(this.m_forwardBtnAction);
            }
            this.m_forwardBtnAction = null;
        }
    }

    protected void uninstallcloseComponent() {
        if (this.tabPane != null && this.closeTabScroller != null) {
            this.tabPane.remove(this.closeTabScroller.viewport);
            this.tabPane.remove(this.closeTabScroller.scrollForwardButton);
            this.tabPane.remove(this.closeTabScroller.scrollBackwardButton);
            this.tabPane.remove(this.closeTabScroller.tabListButton);
        }
        this.closeTabScroller = null;
    }

    @Override
    public Rectangle getTabBounds(JTabbedPane jTabbedPane, int n) {
        if (n >= this.tabPane.getTabCount()) {
            return new Rectangle();
        }
        if (this.isScrollableAndTop()) {
            this.ensureCurrentLayout();
            Rectangle rectangle = new Rectangle();
            return this.getTabBounds(n, rectangle);
        }
        return super.getTabBounds(jTabbedPane, n);
    }

    @Override
    protected void uninstallListeners() {
        if (this.tabPane instanceof CloseableTabbedPane) {
            try {
                this.uninstallPopupListener();
            }
            catch (Exception exception) {
                this.popupSupport = null;
                logger.trace(exception.getMessage(), exception);
            }
            CloseableTabbedPaneListener[] closeableTabbedPaneListenerArray = ((CloseableTabbedPane)this.tabPane).getCloseableTabbedPaneListener();
            if (closeableTabbedPaneListenerArray != null) {
                for (int i = 0; i < closeableTabbedPaneListenerArray.length; ++i) {
                    ((CloseableTabbedPane)this.tabPane).removeCloseableTabbedPaneListener(closeableTabbedPaneListenerArray[i]);
                }
            }
            if (this.closeIconHandler != null) {
                if (this.tabbedPaneCloseIcon != null) {
                    this.tabbedPaneCloseIcon.removeIconCloseListener(this.closeIconHandler);
                }
                this.closeIconHandler = null;
            }
            if (null != this.tabbedPaneCloseIcon) {
                this.tabbedPaneCloseIcon.setEnabled(false);
                this.tabbedPaneCloseIcon = null;
            }
            if (null != this.m_propertyHandler) {
                this.tabPane.removePropertyChangeListener(this.m_propertyHandler);
                this.m_propertyHandler = null;
            }
            this.uninstallCloseScrollListeners();
            this.uninstallcloseComponent();
        }
        super.uninstallListeners();
    }

    protected Icon getCloseIconForTab(int n) {
        if (this.tabPane instanceof CloseableTabbedPane) {
            return ((CloseableTabbedPane)this.tabPane).getCloseIconAt(n);
        }
        return null;
    }

    @Override
    protected int calculateTabWidth(int n, int n2, FontMetrics fontMetrics) {
        Icon icon = this.getCloseIconForTab(n2);
        int n3 = super.calculateTabWidth(n, n2, fontMetrics);
        if (icon != null) {
            n3 += icon.getIconWidth() + this.textIconGap;
        }
        return n3;
    }

    @Override
    protected void paintText(Graphics graphics, int n, Font font, FontMetrics fontMetrics, int n2, String string, Rectangle rectangle, boolean bl) {
        Rectangle rectangle2 = this.rects[n2];
        int n3 = 0;
        n3 = null == this.tabPane.getIconAt(n2) ? rectangle2.width - this.tabInsets.left - this.tabInsets.right : rectangle2.width - this.tabInsets.left - this.tabInsets.right - this.tabPane.getIconAt(n2).getIconWidth() - this.textIconGap - 3;
        if (n3 < 0) {
            n3 = 0;
        }
        String string2 = ScreenToolKit.getAbbreviatoryString(string, n3, font, 0);
        super.paintText(graphics, n, font, fontMetrics, n2, string2, rectangle, bl);
    }

    @Override
    protected int calculateTabHeight(int n, int n2, int n3) {
        Icon icon = this.getCloseIconForTab(n2);
        int n4 = super.calculateTabHeight(n, n2, n3);
        if (icon != null) {
            n4 = Math.max(n4, icon.getIconHeight() + this.tabInsets.top + this.tabInsets.bottom + 2);
        }
        return n4;
    }

    @Override
    protected void paintTab(Graphics graphics, int n, Rectangle[] rectangleArray, int n2, Rectangle rectangle, Rectangle rectangle2) {
        int n3;
        Object object;
        Rectangle rectangle3 = new Rectangle();
        if (this.isScrollableAndTop() && null != this.closeTabScroller) {
            Object object2;
            object = rectangleArray[n2];
            n3 = this.tabPane.getSelectedIndex() == n2 ? 1 : 0;
            Graphics2D graphics2D = null;
            int n4 = 0;
            int n5 = 0;
            Shape shape = null;
            Polygon polygon = null;
            if (graphics instanceof Graphics2D) {
                graphics2D = (Graphics2D)graphics;
                object2 = this.closeTabScroller.viewport.getViewRect();
                switch (n) {
                    case 2: 
                    case 4: {
                        int n6 = ((Rectangle)object2).y + ((Rectangle)object2).height;
                        if (((Rectangle)object).y >= n6 || ((Rectangle)object).y + ((Rectangle)object).height <= n6) break;
                        polygon = this.createCroppedTabClip(n, (Rectangle)object, n6);
                        n5 = ((Rectangle)object).x;
                        n4 = n6 - 1;
                        break;
                    }
                    default: {
                        int n6 = ((Rectangle)object2).x + ((Rectangle)object2).width;
                        if (((Rectangle)object).x >= n6 || ((Rectangle)object).x + ((Rectangle)object).width <= n6) break;
                        polygon = this.createCroppedTabClip(n, (Rectangle)object, n6);
                        n5 = n6 - 1;
                        n4 = ((Rectangle)object).y;
                    }
                }
                if (polygon != null) {
                    shape = graphics2D.getClip();
                    graphics2D.clip(polygon);
                }
            }
            this.paintTabBackground(graphics, n, n2, ((Rectangle)object).x, ((Rectangle)object).y, ((Rectangle)object).width, ((Rectangle)object).height, n3 != 0);
            this.paintTabBorder(graphics, n, n2, ((Rectangle)object).x, ((Rectangle)object).y, ((Rectangle)object).width, ((Rectangle)object).height, n3 != 0);
            object2 = this.getIconForTab(n2);
            String string = this.tabPane.getTitleAt(n2);
            Font font = this.tabPane.getFont();
            FontMetrics fontMetrics = graphics.getFontMetrics(font);
            this.layoutLabel(n, fontMetrics, n2, string, (Icon)object2, (Rectangle)object, rectangle, rectangle2, n3 != 0);
            this.paintText(graphics, n, font, fontMetrics, n2, string, rectangle2, n3 != 0);
            this.paintIcon(graphics, n, n2, (Icon)object2, rectangle, n3 != 0);
            this.paintFocusIndicator(graphics, n, rectangleArray, n2, rectangle, rectangle2, n3 != 0);
            if (polygon != null) {
                this.paintCroppedTabEdge(graphics, n, n2, n3 != 0, n5, n4);
                graphics2D.setClip(shape);
            }
        } else {
            super.paintTab(graphics, n, rectangleArray, n2, rectangle, rectangle2);
        }
        object = this.getCloseIconForTab(n2);
        if (object != null) {
            n3 = this.tabPane.getSelectedIndex();
            boolean bl = n3 == n2;
            this.layoutCloseIcon(n, n2, rectangle, rectangle2, rectangle3, bl);
            this.paintIcon(graphics, n, n2, (Icon)object, rectangle3, bl);
        }
    }

    private Polygon createCroppedTabClip(int n, Rectangle rectangle, int n2) {
        int n3 = 0;
        int n4 = 0;
        int n5 = 0;
        int n6 = 0;
        switch (n) {
            case 2: 
            case 4: {
                n3 = rectangle.width;
                n4 = rectangle.x;
                n5 = rectangle.x + rectangle.width;
                n6 = rectangle.y;
                break;
            }
            default: {
                n3 = rectangle.height;
                n4 = rectangle.y;
                n5 = rectangle.y + rectangle.height;
                n6 = rectangle.x;
            }
        }
        int n7 = n3 / 12;
        if (n3 % 12 > 0) {
            ++n7;
        }
        int n8 = 2 + n7 * 8;
        int[] nArray = new int[n8];
        int[] nArray2 = new int[n8];
        int n9 = 0;
        nArray[n9] = n6;
        nArray2[n9++] = n5;
        nArray[n9] = n6;
        nArray2[n9++] = n4;
        block3: for (int i = 0; i < n7; ++i) {
            for (int j = 0; j < this.xCropLen.length; ++j) {
                nArray[n9] = n2 - this.xCropLen[j];
                nArray2[n9] = n4 + i * 12 + this.yCropLen[j];
                if (nArray2[n9] >= n5) {
                    nArray2[n9] = n5;
                    ++n9;
                    continue block3;
                }
                ++n9;
            }
        }
        if (n == 1 || n == 3) {
            return new Polygon(nArray, nArray2, n9);
        }
        return new Polygon(nArray2, nArray, n9);
    }

    private void ensureCurrentLayout() {
        if (!this.tabPane.isValid()) {
            this.tabPane.validate();
        }
        if (!this.tabPane.isValid()) {
            MetalTabbedPaneUI.TabbedPaneLayout tabbedPaneLayout = (MetalTabbedPaneUI.TabbedPaneLayout)this.tabPane.getLayout();
            tabbedPaneLayout.calculateLayoutInfo();
        }
    }

    @Override
    public int tabForCoordinate(JTabbedPane jTabbedPane, int n, int n2) {
        if (this.isScrollableAndTop()) {
            this.ensureCurrentLayout();
            Point point = new Point(n, n2);
            this.translatePointToTabPanel(n, n2, point);
            int n3 = this.tabPane.getTabCount();
            for (int i = 0; i < n3; ++i) {
                if (!this.rects[i].contains(point.x, point.y) || !this.isValidCorrdinate(n)) continue;
                return i;
            }
            return -1;
        }
        return super.tabForCoordinate(jTabbedPane, n, n2);
    }

    private boolean isValidCorrdinate(int n) {
        int n2 = this.rects[this.tabPane.getTabCount() - 1].x + this.rects[this.tabPane.getTabCount() - 1].width;
        return n >= n2 || this.tabPane.getComponentAt(n, 0) instanceof ClosableScrollableTabViewport;
    }

    private void paintCroppedTabEdge(Graphics graphics, int n, int n2, boolean bl, int n3, int n4) {
        switch (n) {
            case 2: 
            case 4: {
                graphics.setColor(this.shadow);
                for (int i = n3; i <= n3 + this.rects[n2].width; i += 12) {
                    for (int j = 0; j < this.xCropLen.length; j += 2) {
                        graphics.drawLine(i + this.yCropLen[j], n4 - this.xCropLen[j], i + this.yCropLen[j + 1] - 1, n4 - this.xCropLen[j + 1]);
                    }
                }
                break;
            }
            default: {
                graphics.setColor(this.shadow);
                for (int i = n4; i <= n4 + this.rects[n2].height; i += 12) {
                    for (int j = 0; j < this.xCropLen.length; j += 2) {
                        graphics.drawLine(n3 - this.xCropLen[j], i + this.yCropLen[j], n3 - this.xCropLen[j + 1], i + this.yCropLen[j + 1] - 1);
                    }
                }
            }
        }
    }

    @Override
    protected void selectAdjacentRunTab(int n, int n2, int n3) {
        if (this.isScrollableAndTop()) {
            int n4;
            if (this.runCount < 2) {
                return;
            }
            Rectangle rectangle = this.rects[n2];
            switch (n) {
                case 2: 
                case 4: {
                    n4 = this.getTabAtLocation(rectangle.x + rectangle.width / 2 + n3, rectangle.y + rectangle.height / 2);
                    break;
                }
                default: {
                    n4 = this.getTabAtLocation(rectangle.x + rectangle.width / 2, rectangle.y + rectangle.height / 2 + n3);
                }
            }
            if (n4 != -1) {
                while (!this.tabPane.isEnabledAt(n4) && n4 != n2) {
                    n4 = this.getNextTabIndex(n4);
                }
                this.tabPane.setSelectedIndex(n4);
            }
        } else {
            super.selectAdjacentRunTab(n, n2, n3);
        }
    }

    @Override
    protected Rectangle getTabBounds(int n, Rectangle rectangle) {
        if (this.isScrollableAndTop()) {
            rectangle.width = this.rects[n].width;
            rectangle.height = this.rects[n].height;
            if (this.closeTabScroller == null || this.closeTabScroller.viewport == null) {
                return super.getTabBounds(n, rectangle);
            }
            Point point = this.closeTabScroller.viewport.getLocation();
            Point point2 = this.closeTabScroller.viewport.getViewPosition();
            rectangle.x = this.rects[n].x + point.x - point2.x;
            rectangle.y = this.rects[n].y + point.y - point2.y;
            return rectangle;
        }
        return super.getTabBounds(n, rectangle);
    }

    public boolean isClosableScrollable() {
        return this.isTabbedPaneCustomizable() && this.tabPane.getTabLayoutPolicy() == 1;
    }

    private boolean isScrollableAndTop() {
        return this.tabPane.getTabLayoutPolicy() == 1 && this.tabPane.getTabPlacement() == 1 && this.tabPane instanceof CloseableTabbedPane;
    }

    private boolean isScrollableAndBottom() {
        return this.tabPane.getTabLayoutPolicy() == 1 && this.tabPane.getTabPlacement() == 3 && this.tabPane instanceof CloseableTabbedPane;
    }

    private int getTabAtLocation(int n, int n2) {
        int n3 = this.tabPane.getTabCount();
        for (int i = 0; i < n3; ++i) {
            if (!this.rects[i].contains(n, n2)) continue;
            return i;
        }
        return -1;
    }

    private Point translatePointToTabPanel(int n, int n2, Point point) {
        Point point2 = this.closeTabScroller.viewport.getLocation();
        Point point3 = this.closeTabScroller.viewport.getViewPosition();
        point.x = n + point2.x + point3.x;
        point.y = n2 + point2.y + point3.y;
        return point;
    }

    void scrollToSelectedTab() {
        Rectangle rectangle = this.closeTabScroller.tabPanel.getVisibleRect();
        int n = this.tabPane.getSelectedIndex();
        if (this.rects != null && this.rects.length >= n) {
            Rectangle rectangle2 = this.rects[n];
            boolean bl = rectangle.isEmpty();
            boolean bl2 = rectangle.contains(rectangle2);
            for (int i = this.tabPane.getTabCount(); !bl && !bl2 && i >= 1; --i) {
                this.closeTabScroller.viewport.doLayout();
                if (rectangle2.x > rectangle.x) {
                    this.closeTabScroller.scrollForward(this.tabPane.getTabPlacement());
                } else {
                    this.closeTabScroller.scrollBackward(this.tabPane.getTabPlacement());
                }
                rectangle = this.closeTabScroller.tabPanel.getVisibleRect();
                bl = rectangle.isEmpty();
                bl2 = rectangle.contains(rectangle2);
            }
            if (n == this.tabPane.getTabCount() - 1) {
                this.isLastTab = true;
            }
        }
    }

    private static JTabbedPane getTabbedPane(ActionEvent actionEvent) {
        JTabbedPane jTabbedPane = null;
        Object object = actionEvent.getSource();
        if (object instanceof JTabbedPane) {
            jTabbedPane = (JTabbedPane)object;
        } else if (object instanceof ClosableScrollableTabButton) {
            jTabbedPane = (JTabbedPane)((ClosableScrollableTabButton)object).getParent();
        } else {
            return null;
        }
        return jTabbedPane;
    }

    protected void layoutCloseIcon(int n, int n2, Rectangle rectangle, Rectangle rectangle2, Rectangle rectangle3, boolean bl) {
        int n3 = Math.min(rectangle.y, rectangle2.y);
        int n4 = Math.max(rectangle.y + rectangle.height, rectangle2.y + rectangle2.height) - n3;
        Icon icon = this.getCloseIconForTab(n2);
        if (icon != null) {
            rectangle3.width = icon.getIconWidth();
            rectangle3.height = icon.getIconHeight();
        } else {
            rectangle3.width = 0;
            rectangle3.height = 0;
        }
        int n5 = this.getCloseIconForTab(n2) == null ? 0 : this.textIconGap;
        rectangle3.y = n4 / 2 - rectangle3.height / 2 + n3;
        rectangle3.x = this.rects[n2].x + this.rects[n2].width - rectangle3.width - n5;
    }

    @Override
    protected void layoutLabel(int n, FontMetrics fontMetrics, int n2, String string, Icon icon, Rectangle rectangle, Rectangle rectangle2, Rectangle rectangle3, boolean bl) {
        Icon icon2 = this.getCloseIconForTab(n2);
        boolean bl2 = icon2 == null;
        int n3 = bl2 ? 0 : this.textIconGap;
        int n4 = bl2 ? 0 : icon2.getIconWidth();
        Rectangle rectangle4 = new Rectangle(rectangle.x, rectangle.y, rectangle.width - n4 - n3, rectangle.height);
        rectangle3.x = 0;
        rectangle3.y = 0;
        rectangle2.x = 0;
        rectangle2.y = 0;
        View view = this.getTextViewForTab(n2);
        if (view != null) {
            this.tabPane.putClientProperty("html", view);
        }
        SwingUtilities.layoutCompoundLabel(this.tabPane, fontMetrics, string, icon, 0, 0, 0, 11, rectangle4, rectangle2, rectangle3, this.textIconGap);
        this.tabPane.putClientProperty("html", null);
        int n5 = this.getTabLabelShiftX(n, n2, bl);
        int n6 = this.getTabLabelShiftY(n, n2, bl);
        rectangle2.x += n5;
        rectangle2.y += n6;
        rectangle3.x += n5;
        rectangle3.y += n6;
    }

    @Override
    public void paint(Graphics graphics, JComponent jComponent) {
        this.ensureCurrentLayout();
        if (this.isScrollableAndTop()) {
            int n;
            int n2;
            int n3 = this.tabPane.getTabPlacement();
            Insets insets = jComponent.getInsets();
            Dimension dimension = jComponent.getSize();
            if (this.tabPane.isOpaque()) {
                graphics.setColor(jComponent.getBackground());
                switch (n3) {
                    case 2: {
                        graphics.fillRect(insets.left, insets.top, this.calculateTabAreaWidth(n3, this.runCount, this.maxTabWidth), dimension.height - insets.bottom - insets.top);
                        break;
                    }
                    case 3: {
                        n2 = this.calculateTabAreaHeight(n3, this.runCount, this.maxTabHeight);
                        graphics.fillRect(insets.left, dimension.height - insets.bottom - n2, dimension.width - insets.left - insets.right, n2);
                        break;
                    }
                    case 4: {
                        n = this.calculateTabAreaWidth(n3, this.runCount, this.maxTabWidth);
                        graphics.fillRect(dimension.width - insets.right - n, insets.top, n, dimension.height - insets.top - insets.bottom);
                        break;
                    }
                    default: {
                        graphics.fillRect(insets.left, insets.top, dimension.width - insets.right - insets.left, this.calculateTabAreaHeight(n3, this.runCount, this.maxTabHeight));
                        this.paintHighlightBelowTab();
                    }
                }
            }
            this.tabPane.getTabCount();
            n2 = this.tabPane.getSelectedIndex();
            n = this.tabPane.getTabPlacement();
            this.ensureCurrentLayout();
            this.paintContentBorder(graphics, n, n2);
            if (this.tabPane.getTabCount() > 0 && this.isCloseable()) {
                int n4 = this.tabPane.getWidth() - this.tabbedPaneCloseIcon.getIconWidth() - 10;
                int n5 = this.m_iconStartingY;
                this.tabbedPaneCloseIcon.paintIcon(jComponent, graphics, n4, n5);
            }
        } else {
            super.paint(graphics, jComponent);
            if (this.isTabbedPaneCustomizable() && this.tabPane.getTabCount() > 0) {
                int n = this.tabPane.getWidth() - this.tabbedPaneCloseIcon.getIconWidth() - 10;
                int n6 = this.m_iconStartingY;
                this.tabbedPaneCloseIcon.paintIcon(jComponent, graphics, n, n6);
            }
        }
    }

    private void initializePolicies() {
        if (!(this.tabPane instanceof CloseableTabbedPane)) {
            return;
        }
        CloseableTabbedPane closeableTabbedPane = (CloseableTabbedPane)this.tabPane;
        this.tabScrollPolicy = closeableTabbedPane.getTabScrollPolicy();
        this.tabListPolicy = closeableTabbedPane.getTabListPolicy();
    }

    private boolean isAnyPolicyAlways() {
        return this.tabScrollPolicy == 2 || this.tabListPolicy == 2;
    }

    private boolean isBtnVisible(ClosableScrollableTabButton closableScrollableTabButton, boolean bl) {
        if (closableScrollableTabButton instanceof DownListButton) {
            if (this.tabListPolicy != 1) {
                return bl || this.tabListPolicy == 2;
            }
            return false;
        }
        if (this.tabScrollPolicy != 1) {
            return bl || this.tabScrollPolicy == 2;
        }
        return false;
    }

    private int getBtnIndex(ClosableScrollableTabButton closableScrollableTabButton, boolean bl) {
        int n;
        int n2 = 0;
        int n3 = n = closableScrollableTabButton.scrollsForward() ? 3 : 7;
        if (closableScrollableTabButton instanceof DownListButton) {
            n2 = 1;
        } else if (this.tabListPolicy == 1) {
            n2 = n == 3 ? 1 : 2;
        } else if (this.tabListPolicy == 0 && bl) {
            n2 = n == 3 ? 2 : 3;
        } else if (this.tabListPolicy == 0) {
            n2 = n == 3 ? 1 : 2;
        } else if (this.tabListPolicy == 2) {
            n2 = n == 3 ? 2 : 3;
        }
        return n2;
    }

    private int getScrollButtonSize(boolean bl) {
        int n = 0;
        switch (this.tabScrollPolicy) {
            case 0: {
                if (!bl) break;
                n += 2;
                break;
            }
            case 2: {
                n += 2;
                break;
            }
        }
        switch (this.tabListPolicy) {
            case 0: {
                if (!bl) break;
                ++n;
                break;
            }
            case 2: {
                ++n;
                break;
            }
        }
        return n;
    }

    Rectangle[] getRects() {
        return this.rects;
    }

    void forwardTab(int n) {
        ClosableScrollableTabViewport closableScrollableTabViewport = this.closeTabScroller.getViewPort();
        Rectangle rectangle = closableScrollableTabViewport.getViewRect();
        int n2 = 0;
        int n3 = 0;
        if (this.closeTabScroller.scrollBackwardButton.isVisible()) {
            int n4 = n - 1;
            if (n4 >= 0 && n == this.rects.length - 1) {
                n2 = this.rects[n4].x - rectangle.x + this.rects[n4].width;
                int n5 = this.closeTabScroller.scrollBackwardButton.getBounds().x;
                n3 = n5 - n2;
                if (this.tabPane.getSelectedIndex() == n4) {
                    n3 -= 26;
                }
            } else {
                n3 = this.rects[n].x >= rectangle.x ? this.rects[n].width : this.rects[n].width - (rectangle.x - this.rects[n].x);
            }
            if (n3 > 0) {
                Point point = closableScrollableTabViewport.getViewPosition();
                int n6 = point.x - n3;
                if (n6 > 0) {
                    closableScrollableTabViewport.setViewPosition(new Point(n6, point.y));
                }
            }
        }
    }

    protected class PropertyHandler
    implements PropertyChangeListener {
        protected PropertyHandler() {
        }

        @Override
        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            JTabbedPane jTabbedPane = (JTabbedPane)propertyChangeEvent.getSource();
            String string = propertyChangeEvent.getPropertyName();
            if ("CloseIconToolTipChange".equals(string)) {
                String string2 = (String)propertyChangeEvent.getNewValue();
                CloseableMetalTabbedPaneUI.this.m_CloseIconToolTip = string2;
            }
            if ("ParentCloseIconToolTipChange".equals(string)) {
                CloseableMetalTabbedPaneUI.this.m_parentCloseIconTip = (String)propertyChangeEvent.getNewValue();
            }
            if ("tabPlacement".equals(string)) {
                CloseableMetalTabbedPaneUI.this.uninstallUI(jTabbedPane);
                CloseableMetalTabbedPaneUI.this.installUI(jTabbedPane);
            }
        }
    }

    protected class CloseIconHandler
    implements IconCloseListener {
        protected CloseIconHandler() {
        }

        @Override
        public void close() {
            TabbedPaneClosedListener[] tabbedPaneClosedListenerArray = ((CloseableTabbedPane)CloseableMetalTabbedPaneUI.this.tabPane).getTabbedPaneClosedListener();
            if (null != tabbedPaneClosedListenerArray) {
                for (int i = 0; i < tabbedPaneClosedListenerArray.length; ++i) {
                    tabbedPaneClosedListenerArray[i].tabbedPaneClosed();
                }
            }
        }
    }

    public class CloseFocusHandler
    extends FocusAdapter {
        @Override
        public void focusGained(FocusEvent focusEvent) {
            JTabbedPane jTabbedPane = (JTabbedPane)focusEvent.getSource();
            int n = jTabbedPane.getTabCount();
            int n2 = jTabbedPane.getSelectedIndex();
            if (n2 != -1 && n > 0 && n == CloseableMetalTabbedPaneUI.this.rects.length) {
                jTabbedPane.repaint(CloseableMetalTabbedPaneUI.this.getTabBounds(jTabbedPane, n2));
            }
        }

        @Override
        public void focusLost(FocusEvent focusEvent) {
            JTabbedPane jTabbedPane = (JTabbedPane)focusEvent.getSource();
            int n = jTabbedPane.getTabCount();
            int n2 = jTabbedPane.getSelectedIndex();
            if (n2 != -1 && n > 0 && n == CloseableMetalTabbedPaneUI.this.rects.length) {
                jTabbedPane.repaint(CloseableMetalTabbedPaneUI.this.getTabBounds(jTabbedPane, n2));
            }
        }
    }

    public class CloseMouseHandler
    extends MouseAdapter {
        @Override
        public void mousePressed(MouseEvent mouseEvent) {
            if (!CloseableMetalTabbedPaneUI.this.tabPane.isEnabled()) {
                return;
            }
            int n = CloseableMetalTabbedPaneUI.this.getTabAtLocation(mouseEvent.getX(), mouseEvent.getY());
            if (n >= 0 && CloseableMetalTabbedPaneUI.this.tabPane.isEnabledAt(n)) {
                if (n == CloseableMetalTabbedPaneUI.this.tabPane.getSelectedIndex()) {
                    if (CloseableMetalTabbedPaneUI.this.tabPane.isRequestFocusEnabled()) {
                        CloseableMetalTabbedPaneUI.this.tabPane.requestFocus();
                        CloseableMetalTabbedPaneUI.this.tabPane.repaint(CloseableMetalTabbedPaneUI.this.getTabBounds(CloseableMetalTabbedPaneUI.this.tabPane, n));
                    }
                } else {
                    CloseIcon closeIcon = (CloseIcon)((CloseableTabbedPane)CloseableMetalTabbedPaneUI.this.tabPane).getCloseIconAt(n);
                    if (null != closeIcon && closeIcon.isCloseIcon(mouseEvent)) {
                        return;
                    }
                    CloseableMetalTabbedPaneUI.this.tabPane.setSelectedIndex(n);
                }
            }
        }
    }

    public class CloseTabSelectionHandler
    implements ChangeListener {
        @Override
        public void stateChanged(ChangeEvent changeEvent) {
            JTabbedPane jTabbedPane = (JTabbedPane)changeEvent.getSource();
            jTabbedPane.revalidate();
            jTabbedPane.repaint();
            if (jTabbedPane.getTabLayoutPolicy() == 1) {
                int n = jTabbedPane.getSelectedIndex();
                if (n < CloseableMetalTabbedPaneUI.this.rects.length && n != -1) {
                    CloseableMetalTabbedPaneUI.this.closeTabScroller.tabPanel.scrollRectToVisible(new Rectangle(CloseableMetalTabbedPaneUI.this.rects[n]));
                }
                this.setScrollButtonsVisibility(jTabbedPane);
            }
        }

        private void setScrollButtonsVisibility(JTabbedPane jTabbedPane) {
            if (jTabbedPane.getTabPlacement() == 1) {
                boolean bl = jTabbedPane.getTabCount() > 0;
                CloseableMetalTabbedPaneUI.this.closeTabScroller.scrollBackwardButton.setVisible(bl);
                CloseableMetalTabbedPaneUI.this.closeTabScroller.scrollForwardButton.setVisible(bl);
                CloseableMetalTabbedPaneUI.this.closeTabScroller.tabListButton.setVisible(bl);
            }
        }
    }

    private class DownListButton
    extends ClosableScrollableTabButton {
        DownListButton(int n) {
            super(n);
        }

        @Override
        public void paintTriangle(Graphics graphics, int n, int n2, int n3, int n4, boolean bl) {
            super.paintTriangle(graphics, n, n2, n3, 5, bl);
        }
    }

    private class ClosableScrollableTabPanel
    extends JPanel
    implements UIResource {
        @Override
        public void paintComponent(Graphics graphics) {
            super.paintComponent(graphics);
            CloseableMetalTabbedPaneUI.this.paintTabArea(graphics, CloseableMetalTabbedPaneUI.this.tabPane.getTabPlacement(), CloseableMetalTabbedPaneUI.this.tabPane.getSelectedIndex());
        }

        public ClosableScrollableTabPanel() {
            this.setLayout(null);
        }
    }

    private class ClosableScrollableTabButton
    extends BasicArrowButton
    implements UIResource,
    SwingConstants {
        public boolean scrollsForward() {
            return 5 == this.direction || 3 == this.direction;
        }

        public ClosableScrollableTabButton(int n) {
            super(n, UIManager.getColor("TabbedPane.selected"), UIManager.getColor("TabbedPane.shadow"), UIManager.getColor("TabbedPane.darkShadow"), UIManager.getColor("TabbedPane.highlight"));
        }
    }

    private class ClosableScrollableTabViewport
    extends JViewport
    implements UIResource {
        public ClosableScrollableTabViewport() {
            this.setScrollMode(0);
        }
    }

    private class CloseScrollableTabSupport
    implements ChangeListener {
        private Point tabViewPosition = new Point(0, 0);
        public ClosableScrollableTabPanel tabPanel;
        public ClosableScrollableTabButton scrollBackwardButton;
        public ClosableScrollableTabButton scrollForwardButton;
        public int leadingTabIndex;
        public DownListButton tabListButton;
        public ClosableScrollableTabViewport viewport;

        CloseScrollableTabSupport(int n) {
            this.viewport = new ClosableScrollableTabViewport();
            this.tabPanel = new ClosableScrollableTabPanel();
            this.viewport.setView(this.tabPanel);
            this.viewport.addChangeListener(this);
            if (n == 1 || n == 3) {
                this.scrollForwardButton = new ClosableScrollableTabButton(3);
                this.scrollBackwardButton = new ClosableScrollableTabButton(7);
            } else {
                this.scrollForwardButton = new ClosableScrollableTabButton(5);
                this.scrollBackwardButton = new ClosableScrollableTabButton(1);
            }
            if (n == 1) {
                this.tabListButton = new DownListButton(-1);
            }
        }

        public void scrollForward(int n) {
            Dimension dimension = this.viewport.getViewSize();
            Rectangle rectangle = this.viewport.getViewRect();
            if (n == 1 || n == 3 ? rectangle.width > dimension.width - rectangle.x : rectangle.height >= dimension.height - rectangle.y) {
                return;
            }
            this.setLeadingTabIndex(n, this.leadingTabIndex + 1);
        }

        public void scrollBackward(int n) {
            if (this.leadingTabIndex == 0) {
                if (this.viewport.getViewRect().x != 0) {
                    this.setLeadingTabIndex(n, 0);
                }
                return;
            }
            this.setLeadingTabIndex(n, this.leadingTabIndex - 1);
        }

        @Override
        public void stateChanged(ChangeEvent changeEvent) {
            JViewport jViewport = (JViewport)changeEvent.getSource();
            int n = CloseableMetalTabbedPaneUI.this.tabPane.getTabPlacement();
            int n2 = CloseableMetalTabbedPaneUI.this.tabPane.getTabCount();
            Rectangle rectangle = jViewport.getViewRect();
            Dimension dimension = jViewport.getViewSize();
            Rectangle rectangle2 = jViewport.getBounds();
            this.leadingTabIndex = this.getClosestTab(rectangle.x, rectangle.y);
            if (this.leadingTabIndex + 1 < n2) {
                switch (n) {
                    case 1: 
                    case 3: {
                        if (((CloseableMetalTabbedPaneUI)CloseableMetalTabbedPaneUI.this).rects[this.leadingTabIndex].x >= rectangle.x) break;
                        ++this.leadingTabIndex;
                        break;
                    }
                    case 2: 
                    case 4: {
                        if (((CloseableMetalTabbedPaneUI)CloseableMetalTabbedPaneUI.this).rects[this.leadingTabIndex].y >= rectangle.y) break;
                        ++this.leadingTabIndex;
                    }
                }
            }
            Insets insets = CloseableMetalTabbedPaneUI.this.getContentBorderInsets(n);
            switch (n) {
                case 2: {
                    CloseableMetalTabbedPaneUI.this.tabPane.repaint(rectangle2.x + rectangle2.width, rectangle2.y, insets.left, rectangle2.height);
                    this.scrollBackwardButton.setEnabled(rectangle.y > 0);
                    this.scrollForwardButton.setEnabled(this.leadingTabIndex < n2 - 1 && dimension.height - rectangle.y > rectangle.height);
                    break;
                }
                case 4: {
                    CloseableMetalTabbedPaneUI.this.tabPane.repaint(rectangle2.x - insets.right, rectangle2.y, insets.right, rectangle2.height);
                    this.scrollBackwardButton.setEnabled(rectangle.y > 0);
                    this.scrollForwardButton.setEnabled(this.leadingTabIndex < n2 - 1 && dimension.height - rectangle.y > rectangle.height);
                    break;
                }
                case 3: {
                    CloseableMetalTabbedPaneUI.this.tabPane.repaint(rectangle2.x, rectangle2.y - insets.bottom, rectangle2.width, insets.bottom);
                    this.scrollBackwardButton.setEnabled(rectangle.x > 0);
                    this.scrollForwardButton.setEnabled(this.leadingTabIndex < n2 - 1 && dimension.width - rectangle.x > rectangle.width);
                    break;
                }
                default: {
                    CloseableMetalTabbedPaneUI.this.tabPane.repaint(rectangle2.x, rectangle2.y + rectangle2.height, rectangle2.width, insets.top);
                    this.scrollBackwardButton.setEnabled(rectangle.x > 0);
                    this.scrollForwardButton.setEnabled(this.leadingTabIndex < n2 - 1 && dimension.width - rectangle.x > rectangle.width);
                }
            }
        }

        public void setLeadingTabIndex(int n, int n2) {
            this.leadingTabIndex = n2;
            Dimension dimension = this.viewport.getViewSize();
            Rectangle rectangle = this.viewport.getViewRect();
            switch (n) {
                case 1: 
                case 3: {
                    int n3 = this.tabViewPosition.x = this.leadingTabIndex == 0 ? 0 : ((CloseableMetalTabbedPaneUI)CloseableMetalTabbedPaneUI.this).rects[this.leadingTabIndex].x;
                    if (dimension.width - this.tabViewPosition.x >= rectangle.width) break;
                    Dimension dimension2 = new Dimension(dimension.width - this.tabViewPosition.x, rectangle.height);
                    this.viewport.setExtentSize(dimension2);
                    break;
                }
                case 2: 
                case 4: {
                    int n4 = this.tabViewPosition.y = this.leadingTabIndex == 0 ? 0 : ((CloseableMetalTabbedPaneUI)CloseableMetalTabbedPaneUI.this).rects[this.leadingTabIndex].y;
                    if (dimension.height - this.tabViewPosition.y >= rectangle.height) break;
                    Dimension dimension3 = new Dimension(rectangle.width, dimension.height - this.tabViewPosition.y);
                    this.viewport.setExtentSize(dimension3);
                }
            }
            this.viewport.setViewPosition(this.tabViewPosition);
        }

        private int getClosestTab(int n, int n2) {
            int n3;
            int n4 = Math.min(CloseableMetalTabbedPaneUI.this.rects.length, CloseableMetalTabbedPaneUI.this.tabPane.getTabCount());
            int n5 = 0;
            int n6 = n4;
            int n7 = CloseableMetalTabbedPaneUI.this.tabPane.getTabPlacement();
            boolean bl = n7 == 1 || n7 == 3;
            int n8 = n3 = bl ? n : n2;
            while (n5 != n6) {
                int n9;
                int n10;
                int n11 = (n6 + n5) / 2;
                if (bl) {
                    n10 = ((CloseableMetalTabbedPaneUI)CloseableMetalTabbedPaneUI.this).rects[n11].x;
                    n9 = n10 + ((CloseableMetalTabbedPaneUI)CloseableMetalTabbedPaneUI.this).rects[n11].width;
                } else {
                    n10 = ((CloseableMetalTabbedPaneUI)CloseableMetalTabbedPaneUI.this).rects[n11].y;
                    n9 = n10 + ((CloseableMetalTabbedPaneUI)CloseableMetalTabbedPaneUI.this).rects[n11].height;
                }
                if (n3 < n10) {
                    n6 = n11;
                    if (n5 != n6) continue;
                    return Math.max(0, n11 - 1);
                }
                if (n3 >= n9) {
                    n5 = n11;
                    if (n6 - n5 > 1) continue;
                    return Math.max(n11 + 1, n4 - 1);
                }
                return n11;
            }
            return n5;
        }

        public String toString() {
            return "viewport.viewSize=" + this.viewport.getViewSize() + "\n" + "viewport.viewRectangle=" + this.viewport.getViewRect() + "\n" + "leadingTabIndex=" + this.leadingTabIndex + "\n" + "tabViewPosition=" + this.tabViewPosition;
        }

        private ClosableScrollableTabViewport getViewPort() {
            return this.viewport;
        }
    }

    protected class ClosableScrollableLayout
    extends MetalTabbedPaneUI.TabbedPaneLayout {
        protected ClosableScrollableLayout() {
            super(CloseableMetalTabbedPaneUI.this);
        }

        @Override
        protected int preferredTabAreaHeight(int n, int n2) {
            return CloseableMetalTabbedPaneUI.this.calculateMaxTabHeight(n);
        }

        @Override
        protected int preferredTabAreaWidth(int n, int n2) {
            return CloseableMetalTabbedPaneUI.this.calculateMaxTabWidth(n);
        }

        @Override
        public void layoutContainer(Container container) {
            CloseableMetalTabbedPaneUI.this.initializePolicies();
            int n = 0;
            if (CloseableMetalTabbedPaneUI.this.isCloseable()) {
                if (CloseableMetalTabbedPaneUI.this.rects != null && CloseableMetalTabbedPaneUI.this.rects.length > 0 && CloseableMetalTabbedPaneUI.this.rects[0] != null) {
                    Rectangle rectangle = new Rectangle();
                    rectangle = CloseableMetalTabbedPaneUI.this.rects[0];
                    CloseableMetalTabbedPaneUI.this.m_iconStartingY = rectangle.y + (rectangle.height - CloseableMetalTabbedPaneUI.this.tabbedPaneCloseIcon.getIconHeight()) / 2;
                    if (CloseableMetalTabbedPaneUI.this.m_iconStartingY < 0) {
                        CloseableMetalTabbedPaneUI.this.m_iconStartingY = 0;
                    }
                }
                n = CloseableMetalTabbedPaneUI.this.tabbedPaneCloseIcon.getIconWidth() + 20;
            }
            int n2 = CloseableMetalTabbedPaneUI.this.tabPane.getSelectedIndex();
            Component component = CloseableMetalTabbedPaneUI.this.getVisibleComponent();
            int n3 = CloseableMetalTabbedPaneUI.this.tabPane.getTabPlacement();
            int n4 = CloseableMetalTabbedPaneUI.this.tabPane.getTabCount();
            Insets insets = CloseableMetalTabbedPaneUI.this.tabPane.getInsets();
            this.calculateLayoutInfo();
            if (n2 < 0) {
                Component[] componentArray = CloseableMetalTabbedPaneUI.this.tabPane.getComponents();
                for (int i = 0; i < componentArray.length; ++i) {
                    if (!(componentArray[i] instanceof ClosableScrollableTabButton)) continue;
                    componentArray[i].setVisible(false);
                }
                if (null != component) {
                    CloseableMetalTabbedPaneUI.this.setVisibleComponent(null);
                }
            } else {
                Component component2 = CloseableMetalTabbedPaneUI.this.tabPane.getComponentAt(n2);
                boolean bl = false;
                if (null != component2) {
                    if (component2 != component && component != null && SwingUtilities.findFocusOwner(component) != null) {
                        bl = true;
                    }
                    CloseableMetalTabbedPaneUI.this.setVisibleComponent(component2);
                }
                Insets insets2 = CloseableMetalTabbedPaneUI.this.getContentBorderInsets(n3);
                Rectangle rectangle = CloseableMetalTabbedPaneUI.this.tabPane.getBounds();
                int n5 = CloseableMetalTabbedPaneUI.this.tabPane.getComponentCount();
                if (n5 > 0) {
                    int n6;
                    int n7;
                    int n8;
                    int n9;
                    int n10;
                    int n11;
                    int n12;
                    int n13;
                    switch (n3) {
                        case 2: {
                            n13 = CloseableMetalTabbedPaneUI.this.calculateTabAreaWidth(n3, CloseableMetalTabbedPaneUI.this.runCount, CloseableMetalTabbedPaneUI.this.maxTabWidth);
                            n12 = rectangle.height - insets.top - insets.bottom;
                            n11 = insets.left;
                            n10 = insets.top;
                            n9 = n11 + n13 + insets2.left;
                            n8 = n10 + insets2.top;
                            n7 = rectangle.width - insets.left - insets.right - n13 - insets2.left - insets2.right;
                            n6 = rectangle.height - insets.top - insets.bottom - insets2.top - insets2.bottom;
                            break;
                        }
                        case 4: {
                            n13 = CloseableMetalTabbedPaneUI.this.calculateTabAreaWidth(n3, CloseableMetalTabbedPaneUI.this.runCount, CloseableMetalTabbedPaneUI.this.maxTabWidth);
                            n12 = rectangle.height - insets.top - insets.bottom;
                            n11 = rectangle.width - insets.right - n13;
                            n10 = insets.top;
                            n9 = insets.left + insets2.left;
                            n8 = insets.top + insets2.top;
                            n7 = rectangle.width - insets.left - insets.right - n13 - insets2.left - insets2.right;
                            n6 = rectangle.height - insets.top - insets.bottom - insets2.top - insets2.bottom;
                            break;
                        }
                        case 3: {
                            n13 = rectangle.width - insets.left - insets.right;
                            n12 = CloseableMetalTabbedPaneUI.this.calculateTabAreaHeight(n3, CloseableMetalTabbedPaneUI.this.runCount, CloseableMetalTabbedPaneUI.this.maxTabHeight);
                            n11 = insets.left;
                            n10 = rectangle.height - insets.bottom - n12;
                            n9 = insets.left + insets2.left;
                            n8 = insets.top + insets2.top;
                            n7 = rectangle.width - insets.left - insets.right - insets2.left - insets2.right;
                            n6 = rectangle.height - insets.top - insets.bottom - n12 - insets2.top - insets2.bottom;
                            break;
                        }
                        default: {
                            n13 = rectangle.width - insets.left - insets.right - n;
                            n12 = CloseableMetalTabbedPaneUI.this.calculateTabAreaHeight(n3, CloseableMetalTabbedPaneUI.this.runCount, CloseableMetalTabbedPaneUI.this.maxTabHeight);
                            if (CloseableMetalTabbedPaneUI.this.isCloseable()) {
                                n12 = Math.max(n12, CloseableMetalTabbedPaneUI.this.tabbedPaneCloseIcon.getIconHeight());
                            }
                            n11 = insets.left;
                            n10 = insets.top;
                            n9 = n11 + insets2.left;
                            n8 = n10 + n12 + insets2.top;
                            n7 = rectangle.width - insets.left - insets.right - insets2.left - insets2.right;
                            n6 = rectangle.height - insets.top - insets.bottom - n12 - insets2.top - insets2.bottom;
                        }
                    }
                    for (int i = 0; i < n5; ++i) {
                        int n14;
                        int n15;
                        int n16;
                        int n17;
                        int n18;
                        Cloneable cloneable;
                        JComponent jComponent;
                        Component component3 = CloseableMetalTabbedPaneUI.this.tabPane.getComponent(i);
                        if (component3 instanceof ClosableScrollableTabViewport) {
                            jComponent = (JViewport)component3;
                            cloneable = ((JViewport)jComponent).getViewRect();
                            n18 = n13;
                            n17 = n12;
                            switch (n3) {
                                case 2: 
                                case 4: {
                                    n16 = ((CloseableMetalTabbedPaneUI)CloseableMetalTabbedPaneUI.this).rects[n4 - 1].y + ((CloseableMetalTabbedPaneUI)CloseableMetalTabbedPaneUI.this).rects[n4 - 1].height;
                                    if (n16 <= n12 || n16 - cloneable.y > (n17 = Math.max(n12 - 36, 36))) break;
                                    n17 = n16 - cloneable.y;
                                    break;
                                }
                                default: {
                                    n15 = ((CloseableMetalTabbedPaneUI)CloseableMetalTabbedPaneUI.this).rects[n4 - 1].x + ((CloseableMetalTabbedPaneUI)CloseableMetalTabbedPaneUI.this).rects[n4 - 1].width;
                                    if (n15 > n13) {
                                        if (n15 > n13 != n15 > n13 - (n14 = CloseableMetalTabbedPaneUI.this.getScrollButtonSize(true)) * 18) {
                                            n14 = CloseableMetalTabbedPaneUI.this.getScrollButtonSize(n15 > n13 - n14 * 18);
                                        }
                                        if (n15 - cloneable.x > (n18 = Math.max(n13 - n14 * 18, n14 * 18))) break;
                                        n18 = n15 - cloneable.x;
                                        break;
                                    }
                                    if (!CloseableMetalTabbedPaneUI.this.isAnyPolicyAlways()) break;
                                    n14 = CloseableMetalTabbedPaneUI.this.getScrollButtonSize(false);
                                    if (n14 > 0 && n15 > n13 - n14 * 16) {
                                        n14 = CloseableMetalTabbedPaneUI.this.getScrollButtonSize(true);
                                    }
                                    n18 = Math.max(n13 - n14 * 16, n14 * 16);
                                    if (n15 <= n13 - n14 * 16 || n15 - cloneable.x > n18) break;
                                    n18 = n15 - cloneable.x;
                                }
                            }
                            component3.setBounds(n11, n10, n18, n17);
                            continue;
                        }
                        if (component3 instanceof ClosableScrollableTabButton) {
                            jComponent = (ClosableScrollableTabButton)component3;
                            cloneable = ((BasicArrowButton)jComponent).getPreferredSize();
                            n18 = 0;
                            n17 = 0;
                            n16 = ((Dimension)cloneable).width;
                            n15 = ((Dimension)cloneable).height;
                            n14 = 0;
                            switch (n3) {
                                case 2: 
                                case 4: {
                                    int n19 = ((CloseableMetalTabbedPaneUI)CloseableMetalTabbedPaneUI.this).rects[n4 - 1].y + ((CloseableMetalTabbedPaneUI)CloseableMetalTabbedPaneUI.this).rects[n4 - 1].height;
                                    if (n19 <= n12) break;
                                    int n20 = ((ClosableScrollableTabButton)jComponent).scrollsForward() ? 5 : 1;
                                    ((BasicArrowButton)jComponent).setDirection(n20);
                                    n14 = 1;
                                    n18 = n3 == 2 ? n11 + n13 - ((Dimension)cloneable).width : n11;
                                    n17 = n20 == 5 ? rectangle.height - insets.bottom - ((Dimension)cloneable).height : rectangle.height - insets.bottom - 2 * ((Dimension)cloneable).height;
                                    break;
                                }
                                default: {
                                    int n21;
                                    int n22;
                                    int n23;
                                    int n20 = ((CloseableMetalTabbedPaneUI)CloseableMetalTabbedPaneUI.this).rects[n4 - 1].x + ((CloseableMetalTabbedPaneUI)CloseableMetalTabbedPaneUI.this).rects[n4 - 1].width;
                                    if (n20 > n13 && CloseableMetalTabbedPaneUI.this.isBtnVisible((ClosableScrollableTabButton)jComponent, true)) {
                                        n14 = 1;
                                        int n24 = ((ClosableScrollableTabButton)jComponent).scrollsForward() ? 3 : 7;
                                        ((BasicArrowButton)jComponent).setDirection(n24);
                                        n18 = rectangle.width - insets.left;
                                        n23 = CloseableMetalTabbedPaneUI.this.getBtnIndex((ClosableScrollableTabButton)jComponent, true);
                                        n18 -= n23 * ((Dimension)cloneable).width;
                                        n17 = n3 == 1 ? n10 + n12 - ((Dimension)cloneable).height : n10;
                                        break;
                                    }
                                    if (CloseableMetalTabbedPaneUI.this.isAnyPolicyAlways() && CloseableMetalTabbedPaneUI.this.isBtnVisible((ClosableScrollableTabButton)jComponent, false)) {
                                        n14 = 1;
                                        n23 = CloseableMetalTabbedPaneUI.this.getScrollButtonSize(n20 > n13);
                                        n22 = ((ClosableScrollableTabButton)jComponent).scrollsForward() ? 3 : 7;
                                        ((BasicArrowButton)jComponent).setDirection(n22);
                                        n18 = rectangle.width - insets.left;
                                        n21 = CloseableMetalTabbedPaneUI.this.getBtnIndex((ClosableScrollableTabButton)jComponent, n20 > n13 - n23 * 16);
                                        n18 -= n21 * ((Dimension)cloneable).width;
                                        n17 = n3 == 1 ? n10 + n12 - ((Dimension)cloneable).height : n10;
                                        break;
                                    }
                                    if (!CloseableMetalTabbedPaneUI.this.isAnyPolicyAlways() || !CloseableMetalTabbedPaneUI.this.isBtnVisible((ClosableScrollableTabButton)jComponent, n20 > n13 - (n23 = CloseableMetalTabbedPaneUI.this.getScrollButtonSize(n20 > n13)) * 16)) break;
                                    n14 = 1;
                                    n22 = ((ClosableScrollableTabButton)jComponent).scrollsForward() ? 3 : 7;
                                    ((BasicArrowButton)jComponent).setDirection(n22);
                                    n18 = rectangle.width - insets.left;
                                    n21 = CloseableMetalTabbedPaneUI.this.getBtnIndex((ClosableScrollableTabButton)jComponent, n20 > n13 - n23 * 16);
                                    n18 -= n21 * ((Dimension)cloneable).width;
                                    n17 = n3 == 1 ? n10 + n12 - ((Dimension)cloneable).height : n10;
                                }
                            }
                            component3.setVisible(n14 != 0);
                            if (n14 == 0) continue;
                            component3.setBounds(n18 - n, n17, n16, n15);
                            continue;
                        }
                        component3.setBounds(n9, n8, n7, n6);
                    }
                    if (bl && !this.requestFocusForVisibleComponent()) {
                        CloseableMetalTabbedPaneUI.this.tabPane.requestFocus();
                    }
                }
            }
        }

        boolean requestFocusForVisibleComponent() {
            Component component = CloseableMetalTabbedPaneUI.this.getVisibleComponent();
            if (component.isFocusTraversable()) {
                component.requestFocus();
                return true;
            }
            return component instanceof JComponent && ((JComponent)component).requestDefaultFocus();
        }

        @Override
        protected void calculateTabRects(int n, int n2) {
            FontMetrics fontMetrics = CloseableMetalTabbedPaneUI.this.getFontMetrics();
            Dimension dimension = CloseableMetalTabbedPaneUI.this.tabPane.getSize();
            Insets insets = CloseableMetalTabbedPaneUI.this.tabPane.getInsets();
            Insets insets2 = CloseableMetalTabbedPaneUI.this.getTabAreaInsets(n);
            int n3 = fontMetrics.getHeight();
            int n4 = 0;
            boolean bl = n == 2 || n == 4;
            boolean bl2 = CloseableMetalTabbedPaneUI.this.tabPane.getComponentOrientation().isLeftToRight();
            if (3 == n || 1 == n) {
                CloseableMetalTabbedPaneUI.this.maxTabHeight = CloseableMetalTabbedPaneUI.this.calculateMaxTabHeight(n);
            } else {
                CloseableMetalTabbedPaneUI.this.maxTabWidth = CloseableMetalTabbedPaneUI.this.calculateMaxTabWidth(n);
            }
            CloseableMetalTabbedPaneUI.this.selectedRun = -1;
            CloseableMetalTabbedPaneUI.this.runCount = 0;
            if (0 == n2) {
                return;
            }
            CloseableMetalTabbedPaneUI.this.runCount = 1;
            CloseableMetalTabbedPaneUI.this.selectedRun = 0;
            int n5 = 0;
            int n6 = 0;
            int n7 = insets2.top;
            int n8 = insets2.left;
            for (n4 = 0; n4 < n2; ++n4) {
                Rectangle rectangle = CloseableMetalTabbedPaneUI.this.rects[n4];
                if (!bl) {
                    if (n4 > 0) {
                        rectangle.x = ((CloseableMetalTabbedPaneUI)CloseableMetalTabbedPaneUI.this).rects[n4 - 1].x + ((CloseableMetalTabbedPaneUI)CloseableMetalTabbedPaneUI.this).rects[n4 - 1].width;
                    } else {
                        ((CloseableMetalTabbedPaneUI)CloseableMetalTabbedPaneUI.this).tabRuns[0] = 0;
                        CloseableMetalTabbedPaneUI.this.maxTabWidth = 0;
                        n5 += CloseableMetalTabbedPaneUI.this.maxTabHeight;
                        rectangle.x = n8;
                    }
                    rectangle.width = CloseableMetalTabbedPaneUI.this.calculateTabWidth(n, n4, fontMetrics);
                    n6 = rectangle.x + rectangle.width;
                    CloseableMetalTabbedPaneUI.this.maxTabWidth = Math.max(CloseableMetalTabbedPaneUI.this.maxTabWidth, rectangle.width);
                    rectangle.y = n7;
                    rectangle.height = CloseableMetalTabbedPaneUI.this.maxTabHeight;
                    continue;
                }
                if (n4 > 0) {
                    rectangle.y = ((CloseableMetalTabbedPaneUI)CloseableMetalTabbedPaneUI.this).rects[n4 - 1].y + ((CloseableMetalTabbedPaneUI)CloseableMetalTabbedPaneUI.this).rects[n4 - 1].height;
                } else {
                    ((CloseableMetalTabbedPaneUI)CloseableMetalTabbedPaneUI.this).tabRuns[0] = 0;
                    CloseableMetalTabbedPaneUI.this.maxTabHeight = 0;
                    n6 = CloseableMetalTabbedPaneUI.this.maxTabWidth;
                    rectangle.y = n7;
                }
                rectangle.height = CloseableMetalTabbedPaneUI.this.calculateTabHeight(n, n4, n3);
                n5 = rectangle.y + rectangle.height;
                CloseableMetalTabbedPaneUI.this.maxTabHeight = Math.max(CloseableMetalTabbedPaneUI.this.maxTabHeight, rectangle.height);
                rectangle.x = n8;
                rectangle.width = CloseableMetalTabbedPaneUI.this.maxTabWidth;
            }
            if (!bl2 && !bl) {
                int n9 = dimension.width - (insets.right + insets2.right);
                for (n4 = 0; n4 < n2; ++n4) {
                    ((CloseableMetalTabbedPaneUI)CloseableMetalTabbedPaneUI.this).rects[n4].x = n9 - ((CloseableMetalTabbedPaneUI)CloseableMetalTabbedPaneUI.this).rects[n4].x - ((CloseableMetalTabbedPaneUI)CloseableMetalTabbedPaneUI.this).rects[n4].width;
                }
            }
            CloseableMetalTabbedPaneUI.this.closeTabScroller.tabPanel.setPreferredSize(new Dimension(n6, n5));
        }
    }

    public class TabSelectionHandler
    implements ChangeListener {
        @Override
        public void stateChanged(ChangeEvent changeEvent) {
            int n;
            JTabbedPane jTabbedPane = (JTabbedPane)changeEvent.getSource();
            jTabbedPane.revalidate();
            jTabbedPane.repaint();
            if (jTabbedPane.getTabLayoutPolicy() == 1 && (n = jTabbedPane.getSelectedIndex()) < CloseableMetalTabbedPaneUI.this.rects.length && n != -1) {
                CloseableMetalTabbedPaneUI.this.closeTabScroller.tabPanel.scrollRectToVisible(CloseableMetalTabbedPaneUI.this.rects[n]);
            }
        }
    }

    protected class CloseTabWrapLayout
    extends MetalTabbedPaneUI.TabbedPaneLayout {
        protected CloseTabWrapLayout() {
            super(CloseableMetalTabbedPaneUI.this);
        }

        @Override
        protected void calculateTabRects(int n, int n2) {
            int n3;
            Rectangle rectangle;
            int n4;
            int n5;
            int n6;
            int n7;
            Insets insets = CloseableMetalTabbedPaneUI.this.tabPane.getInsets();
            Dimension dimension = CloseableMetalTabbedPaneUI.this.tabPane.getSize();
            Insets insets2 = CloseableMetalTabbedPaneUI.this.getTabAreaInsets(n);
            boolean bl = n == 2 || n == 4;
            boolean bl2 = true;
            FontMetrics fontMetrics = CloseableMetalTabbedPaneUI.this.getFontMetrics();
            switch (n) {
                case 4: {
                    CloseableMetalTabbedPaneUI.this.maxTabWidth = CloseableMetalTabbedPaneUI.this.calculateMaxTabWidth(n);
                    n7 = dimension.width - insets.right - insets2.right - CloseableMetalTabbedPaneUI.this.maxTabWidth;
                    n6 = insets.top + insets2.top;
                    n5 = dimension.height - (insets.bottom + insets2.bottom);
                    break;
                }
                case 2: {
                    CloseableMetalTabbedPaneUI.this.maxTabWidth = CloseableMetalTabbedPaneUI.this.calculateMaxTabWidth(n);
                    n7 = insets.left + insets2.left;
                    n6 = insets.top + insets2.top;
                    n5 = dimension.height - (insets.bottom + insets2.bottom);
                    break;
                }
                case 3: {
                    CloseableMetalTabbedPaneUI.this.maxTabHeight = CloseableMetalTabbedPaneUI.this.calculateMaxTabHeight(n);
                    n7 = insets.left + insets2.left;
                    n6 = dimension.height - insets.bottom - insets2.bottom - CloseableMetalTabbedPaneUI.this.maxTabHeight;
                    n5 = dimension.width - (insets.right + insets2.right);
                    break;
                }
                default: {
                    n4 = 0;
                    n4 = CloseableMetalTabbedPaneUI.this.tabbedPaneCloseIcon.getIconWidth() + 10;
                    CloseableMetalTabbedPaneUI.this.maxTabHeight = CloseableMetalTabbedPaneUI.this.calculateMaxTabHeight(n);
                    n7 = insets.left + insets2.left;
                    n6 = insets.top + insets2.top;
                    n5 = dimension.width - (insets.right + insets2.right) - n4;
                    CloseableMetalTabbedPaneUI.this.m_iconStartingY = (CloseableMetalTabbedPaneUI.this.maxTabHeight - CloseableMetalTabbedPaneUI.this.tabbedPaneCloseIcon.getIconHeight()) / 2;
                }
            }
            int n8 = CloseableMetalTabbedPaneUI.this.getTabRunOverlay(n);
            CloseableMetalTabbedPaneUI.this.runCount = 0;
            CloseableMetalTabbedPaneUI.this.selectedRun = -1;
            if (n2 == 0) {
                return;
            }
            int n9 = CloseableMetalTabbedPaneUI.this.tabPane.getSelectedIndex();
            int n10 = fontMetrics.getHeight();
            for (n4 = 0; n4 < n2; ++n4) {
                rectangle = CloseableMetalTabbedPaneUI.this.rects[n4];
                if (!bl) {
                    if (n4 > 0) {
                        rectangle.x = ((CloseableMetalTabbedPaneUI)CloseableMetalTabbedPaneUI.this).rects[n4 - 1].x + ((CloseableMetalTabbedPaneUI)CloseableMetalTabbedPaneUI.this).rects[n4 - 1].width;
                    } else {
                        ((CloseableMetalTabbedPaneUI)CloseableMetalTabbedPaneUI.this).tabRuns[0] = 0;
                        CloseableMetalTabbedPaneUI.this.runCount = 1;
                        CloseableMetalTabbedPaneUI.this.maxTabWidth = 0;
                        rectangle.x = n7;
                    }
                    rectangle.width = CloseableMetalTabbedPaneUI.this.calculateTabWidth(n, n4, fontMetrics);
                    CloseableMetalTabbedPaneUI.this.maxTabWidth = Math.max(CloseableMetalTabbedPaneUI.this.maxTabWidth, rectangle.width);
                    if (rectangle.x != 2 + insets.left && rectangle.x + rectangle.width > n5) {
                        if (CloseableMetalTabbedPaneUI.this.runCount > CloseableMetalTabbedPaneUI.this.tabRuns.length - 1) {
                            CloseableMetalTabbedPaneUI.this.expandTabRunsArray();
                        }
                        ((CloseableMetalTabbedPaneUI)CloseableMetalTabbedPaneUI.this).tabRuns[((CloseableMetalTabbedPaneUI)CloseableMetalTabbedPaneUI.this).runCount] = n4;
                        CloseableMetalTabbedPaneUI.this.runCount++;
                        rectangle.x = n7;
                    }
                    rectangle.y = n6;
                    rectangle.height = CloseableMetalTabbedPaneUI.this.maxTabHeight;
                } else {
                    if (n4 > 0) {
                        rectangle.y = ((CloseableMetalTabbedPaneUI)CloseableMetalTabbedPaneUI.this).rects[n4 - 1].y + ((CloseableMetalTabbedPaneUI)CloseableMetalTabbedPaneUI.this).rects[n4 - 1].height;
                    } else {
                        ((CloseableMetalTabbedPaneUI)CloseableMetalTabbedPaneUI.this).tabRuns[0] = 0;
                        CloseableMetalTabbedPaneUI.this.runCount = 1;
                        CloseableMetalTabbedPaneUI.this.maxTabHeight = 0;
                        rectangle.y = n6;
                    }
                    rectangle.height = CloseableMetalTabbedPaneUI.this.calculateTabHeight(n, n4, n10);
                    CloseableMetalTabbedPaneUI.this.maxTabHeight = Math.max(CloseableMetalTabbedPaneUI.this.maxTabHeight, rectangle.height);
                    if (rectangle.y != 2 + insets.top && rectangle.y + rectangle.height > n5) {
                        if (CloseableMetalTabbedPaneUI.this.runCount > CloseableMetalTabbedPaneUI.this.tabRuns.length - 1) {
                            CloseableMetalTabbedPaneUI.this.expandTabRunsArray();
                        }
                        ((CloseableMetalTabbedPaneUI)CloseableMetalTabbedPaneUI.this).tabRuns[((CloseableMetalTabbedPaneUI)CloseableMetalTabbedPaneUI.this).runCount] = n4;
                        CloseableMetalTabbedPaneUI.this.runCount++;
                        rectangle.y = n6;
                    }
                    rectangle.x = n7;
                    rectangle.width = CloseableMetalTabbedPaneUI.this.maxTabWidth;
                }
                if (n4 != n9) continue;
                CloseableMetalTabbedPaneUI.this.selectedRun = CloseableMetalTabbedPaneUI.this.runCount - 1;
            }
            if (CloseableMetalTabbedPaneUI.this.runCount > 1) {
                this.normalizeTabRuns(n, n2, bl ? n6 : n7, n5);
                CloseableMetalTabbedPaneUI.this.selectedRun = CloseableMetalTabbedPaneUI.this.getRunForTab(n2, n9);
                if (CloseableMetalTabbedPaneUI.this.shouldRotateTabRuns(n)) {
                    this.rotateTabRuns(n, CloseableMetalTabbedPaneUI.this.selectedRun);
                }
            }
            for (n4 = CloseableMetalTabbedPaneUI.this.runCount - 1; n4 >= 0; --n4) {
                int n11;
                int n12;
                n3 = CloseableMetalTabbedPaneUI.this.tabRuns[n4];
                int n13 = CloseableMetalTabbedPaneUI.this.tabRuns[n4 == CloseableMetalTabbedPaneUI.this.runCount - 1 ? 0 : n4 + 1];
                int n14 = n12 = n13 != 0 ? n13 - 1 : n2 - 1;
                if (!bl) {
                    for (n11 = n3; n11 <= n12; ++n11) {
                        rectangle = CloseableMetalTabbedPaneUI.this.rects[n11];
                        rectangle.y = n6;
                        rectangle.x += CloseableMetalTabbedPaneUI.this.getTabRunIndent(n, n4);
                    }
                    if (CloseableMetalTabbedPaneUI.this.shouldPadTabRun(n, n4)) {
                        this.padTabRun(n, n3, n12, n5);
                    }
                    if (n == 3) {
                        n6 -= CloseableMetalTabbedPaneUI.this.maxTabHeight - n8;
                        continue;
                    }
                    n6 += CloseableMetalTabbedPaneUI.this.maxTabHeight - n8;
                    continue;
                }
                for (n11 = n3; n11 <= n12; ++n11) {
                    rectangle = CloseableMetalTabbedPaneUI.this.rects[n11];
                    rectangle.x = n7;
                    rectangle.y += CloseableMetalTabbedPaneUI.this.getTabRunIndent(n, n4);
                }
                if (CloseableMetalTabbedPaneUI.this.shouldPadTabRun(n, n4)) {
                    this.padTabRun(n, n3, n12, n5);
                }
                if (n == 4) {
                    n7 -= CloseableMetalTabbedPaneUI.this.maxTabWidth - n8;
                    continue;
                }
                n7 += CloseableMetalTabbedPaneUI.this.maxTabWidth - n8;
            }
            this.padSelectedTab(n, n9);
            if (!bl2 && !bl) {
                n3 = dimension.width - (insets.right + insets2.right);
                for (n4 = 0; n4 < n2; ++n4) {
                    ((CloseableMetalTabbedPaneUI)CloseableMetalTabbedPaneUI.this).rects[n4].x = n3 - ((CloseableMetalTabbedPaneUI)CloseableMetalTabbedPaneUI.this).rects[n4].x - ((CloseableMetalTabbedPaneUI)CloseableMetalTabbedPaneUI.this).rects[n4].width;
                }
            }
        }
    }

    private class DropDownListBtnAction
    extends AbstractAction {
        private DropDownListBtnAction() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            JTabbedPane jTabbedPane = CloseableMetalTabbedPaneUI.getTabbedPane(actionEvent);
            if (null == jTabbedPane) {
                return;
            }
            if (!(jTabbedPane instanceof CloseableTabbedPane)) {
                return;
            }
            CloseableTabbedPane closeableTabbedPane = (CloseableTabbedPane)jTabbedPane;
            if (!CloseableMetalTabbedPaneUI.this.viewPortScrolled && CloseableMetalTabbedPaneUI.this.tabPane.getTabCount() > 0) {
                Rectangle rectangle = CloseableMetalTabbedPaneUI.this.closeTabScroller.viewport.getViewRect();
                CloseableMetalTabbedPaneUI.this.closeTabScroller.tabPanel.scrollRectToVisible(CloseableMetalTabbedPaneUI.this.rects[CloseableMetalTabbedPaneUI.this.rects.length - 1]);
                CloseableMetalTabbedPaneUI.this.closeTabScroller.tabPanel.scrollRectToVisible(rectangle);
                CloseableMetalTabbedPaneUI.this.viewPortScrolled = true;
            }
            closeableTabbedPane.showDropDownList((JComponent)actionEvent.getSource());
        }
    }

    private static class CloseScrollTabsBackwardAction
    extends AbstractAction {
        private CloseScrollTabsBackwardAction() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            CloseableMetalTabbedPaneUI closeableMetalTabbedPaneUI;
            JTabbedPane jTabbedPane = CloseableMetalTabbedPaneUI.getTabbedPane(actionEvent);
            if (null == jTabbedPane) {
                return;
            }
            BasicTabbedPaneUI basicTabbedPaneUI = (BasicTabbedPaneUI)jTabbedPane.getUI();
            if (basicTabbedPaneUI instanceof CloseableMetalTabbedPaneUI && (closeableMetalTabbedPaneUI = (CloseableMetalTabbedPaneUI)basicTabbedPaneUI).isScrollableAndTop()) {
                closeableMetalTabbedPaneUI.closeTabScroller.scrollBackward(jTabbedPane.getTabPlacement());
            }
        }
    }

    private static class CloseScrollTabsForwardAction
    extends AbstractAction {
        private CloseScrollTabsForwardAction() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            CloseableMetalTabbedPaneUI closeableMetalTabbedPaneUI;
            JTabbedPane jTabbedPane = CloseableMetalTabbedPaneUI.getTabbedPane(actionEvent);
            if (null == jTabbedPane) {
                return;
            }
            BasicTabbedPaneUI basicTabbedPaneUI = (BasicTabbedPaneUI)jTabbedPane.getUI();
            if (basicTabbedPaneUI instanceof CloseableMetalTabbedPaneUI && (closeableMetalTabbedPaneUI = (CloseableMetalTabbedPaneUI)basicTabbedPaneUI).isScrollableAndTop()) {
                closeableMetalTabbedPaneUI.closeTabScroller.scrollForward(jTabbedPane.getTabPlacement());
            }
        }
    }

    class BottomCloseMouseListener
    implements MouseListener {
        BottomCloseMouseListener() {
        }

        @Override
        public void mouseClicked(MouseEvent mouseEvent) {
            if (!CloseableMetalTabbedPaneUI.this.tabPane.isEnabled()) {
                return;
            }
            int n = CloseableMetalTabbedPaneUI.this.tabForCoordinate(CloseableMetalTabbedPaneUI.this.tabPane, mouseEvent.getX(), mouseEvent.getY());
            if (n >= 0 && CloseableMetalTabbedPaneUI.this.tabPane.isEnabledAt(n)) {
                if (n != CloseableMetalTabbedPaneUI.this.tabPane.getSelectedIndex()) {
                    CloseableMetalTabbedPaneUI.this.tabPane.setSelectedIndex(n);
                } else if (CloseableMetalTabbedPaneUI.this.tabPane.isRequestFocusEnabled()) {
                    CloseableMetalTabbedPaneUI.this.tabPane.requestFocus();
                }
            }
            CloseableMetalTabbedPaneUI.this.mouseListener.mouseClicked(mouseEvent);
        }

        @Override
        public void mouseEntered(MouseEvent mouseEvent) {
            CloseableMetalTabbedPaneUI.this.mouseListener.mouseEntered(mouseEvent);
        }

        @Override
        public void mouseExited(MouseEvent mouseEvent) {
            CloseableMetalTabbedPaneUI.this.mouseListener.mouseExited(mouseEvent);
        }

        @Override
        public void mousePressed(MouseEvent mouseEvent) {
        }

        @Override
        public void mouseReleased(MouseEvent mouseEvent) {
            CloseableMetalTabbedPaneUI.this.mouseListener.mouseReleased(mouseEvent);
        }
    }
}

