/*
 * Decompiled with CFR 0.152.
 */
package com.swimap.iview.templates.statusbar;

import com.swimap.iview.templates.statusbar.TimerDisplayStatusBarItem;
import com.swimap.iview.util.log.IviewLogger;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;

final class TimerDisplayStatusBarThread
extends Thread {
    private static IviewLogger logger = IviewLogger.getLogger(TimerDisplayStatusBarItem.class, "IVIEW");
    private static final int ONE_SEC = 1000;
    private int delayingMillisecondInterval = 1000;
    private boolean stopped = false;
    private ActionListener actionListener = null;

    TimerDisplayStatusBarThread(ActionListener actionListener, int n) {
        this.setActionListener(actionListener);
        this.setDelayingMillisecondInterval(n);
    }

    public void setActionListener(ActionListener actionListener) {
        this.actionListener = actionListener;
    }

    public void setDelayingMillisecondInterval(int n) {
        this.delayingMillisecondInterval = n;
    }

    public void setStopped(boolean bl) {
        this.stopped = bl;
    }

    @Override
    public void run() {
        ActionEvent actionEvent = new ActionEvent(this, 0, "StatusBarTimer");
        while (!this.stopped) {
            try {
                TimerDisplayStatusBarThread.sleep(this.delayingMillisecondInterval);
            }
            catch (InterruptedException interruptedException) {
                logger.trace(interruptedException.getMessage(), interruptedException);
            }
            if (this.actionListener != null) {
                this.actionListener.actionPerformed(actionEvent);
                continue;
            }
            this.stopped = true;
        }
        this.actionListener = null;
    }
}

