/*
 * Decompiled with CFR 0.152.
 */
package com.swimap.iview.templates.statusbar;

import com.swimap.iview.commstyle.commini.DescContainer;
import com.swimap.iview.commstyle.commini.UIObjectDescriptionNotCorrectException;
import com.swimap.iview.templates.statusbar.StatusBarItem;
import com.swimap.iview.templates.statusbar.TimerDisplayStatusBarThread;
import com.swimap.iview.templates.statusbar.TimerStatusBarGregorianCalendar;
import com.swimap.iview.util.CommonUtil;
import com.swimap.iview.util.log.IviewLogger;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;

public class TimerDisplayStatusBarItem
extends StatusBarItem {
    private static IviewLogger logger = IviewLogger.getLogger(TimerDisplayStatusBarItem.class, "IVIEW");
    private static final String DELAY_TIME_PARA = "delay";
    private static final int ONE_SEC = 1000;
    private int delayingMillisecondInterval = 1000;
    private TimerStatusBarGregorianCalendar calendar = new TimerStatusBarGregorianCalendar();
    private TimerDisplayStatusBarThread thread = new TimerDisplayStatusBarThread(new RefreshActionListener(), this.delayingMillisecondInterval);

    public TimerDisplayStatusBarItem(String string) {
        super(string);
        this.updateItem();
        this.start();
    }

    public TimerDisplayStatusBarItem(DescContainer descContainer) throws UIObjectDescriptionNotCorrectException {
        super(descContainer);
        String string;
        if (null != descContainer && null != (string = descContainer.getParasItemValue(DELAY_TIME_PARA))) {
            try {
                int n = Integer.parseInt(string);
                if (n < 1000) {
                    n = 1000;
                }
                this.delayingMillisecondInterval = n;
                this.thread.setDelayingMillisecondInterval(n);
            }
            catch (Exception exception) {
                logger.trace(exception.getMessage(), exception);
            }
        }
        this.updateItem();
        this.start();
    }

    public void setDelayTime(int n) {
        this.thread.setDelayingMillisecondInterval(n);
    }

    private void updateItem() {
        this.calendar.setTimeInMillis(System.currentTimeMillis());
        this.refreshItem(CommonUtil.convertCalendarToStr(this.calendar, (byte)3));
    }

    public boolean start() {
        this.thread = new TimerDisplayStatusBarThread(new RefreshActionListener(), this.delayingMillisecondInterval);
        this.thread.start();
        return true;
    }

    public boolean stop() {
        this.thread.setStopped(true);
        return true;
    }

    private class RefreshActionListener
    implements ActionListener {
        private RefreshActionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            TimerDisplayStatusBarItem.this.updateItem();
        }
    }
}

