/*
 * Decompiled with CFR 0.152.
 */
package com.swimap.iview.templates.statusbar;

import com.swimap.iview.commstyle.commini.CommStyleInfo;
import com.swimap.iview.commstyle.commini.DescContainer;
import com.swimap.iview.commstyle.commini.UIObjectDescriptionNotCorrectException;
import com.swimap.iview.commstyle.resource.ResourceMng;
import com.swimap.iview.commstyle.resource.i18n.ResourceUtil;
import com.swimap.iview.framework.util.FrameworkUtilities;
import com.swimap.iview.templates.statusbar.DefaultStatusBarItemEventHandler;
import com.swimap.iview.templates.statusbar.IStatusBarItemEventHandler;
import com.swimap.iview.templates.statusbar.MessageStyleInfo;
import com.swimap.iview.templates.utils.GenericListener;
import com.swimap.iview.templates.utils.MultiRowToolTip;
import com.swimap.iview.util.TypeConverter;
import com.swimap.iview.util.log.IviewLogger;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JToolTip;
import javax.swing.SwingUtilities;
import javax.swing.Timer;

public class StatusBarItem
extends JPanel {
    private static IviewLogger logger = IviewLogger.getLogger(StatusBarItem.class, "IVIEW");
    protected Timer timer = null;
    private static final int ONE_SEC = 1000;
    protected int timerDelay = 1000;
    private DescContainer desc = null;
    private transient IStatusBarItemEventHandler statusBarItemEventHandler = null;
    private int serialNo = Integer.MAX_VALUE;
    protected JLabel m_label = new JLabel(){
        private MultiRowToolTip tempTip;
        private Point retTipPoint = new Point();

        @Override
        public JToolTip createToolTip() {
            MultiRowToolTip multiRowToolTip = new MultiRowToolTip();
            multiRowToolTip.setMaxLineNumber(10);
            this.tempTip = multiRowToolTip;
            multiRowToolTip.setComponent(this);
            return multiRowToolTip;
        }

        @Override
        public Point getToolTipLocation(MouseEvent mouseEvent) {
            String string = System.getProperty("java.version");
            if (null != string && "1.5".equals(string.substring(0, 3))) {
                return this.getToolTipLocation(this, this.tempTip, mouseEvent);
            }
            return super.getToolTipLocation(mouseEvent);
        }

        private Point getToolTipLocation(JComponent jComponent, JToolTip jToolTip, MouseEvent mouseEvent) {
            if (null == jComponent) {
                return null;
            }
            if (null == jToolTip) {
                jToolTip = this.createToolTip();
            }
            if (jToolTip.isShowing()) {
                return this.retTipPoint;
            }
            Point point = jComponent.getLocationOnScreen();
            JFrame jFrame = FrameworkUtilities.getMainFrame();
            Rectangle rectangle = jFrame.getBounds();
            jToolTip.setTipText(jComponent.getToolTipText());
            Dimension dimension = jToolTip.getPreferredSize();
            int n = point.y + mouseEvent.getY() + dimension.height;
            int n2 = rectangle.y + rectangle.height;
            this.retTipPoint = n > n2 ? new Point(mouseEvent.getX(), mouseEvent.getY() - dimension.height) : new Point(mouseEvent.getX(), mouseEvent.getY());
            return this.retTipPoint;
        }
    };
    private MessageStyleInfo defaultMessageStyleInfo = new MessageStyleInfo();
    private boolean bNeedResetToDefaultStyle = false;
    private RefreshRunnable runnable = new RefreshRunnable();

    public StatusBarItem(String string) {
        this.desc = new DescContainer(string);
        this.setLayout(new GridLayout());
        this.setBorder(BorderFactory.createLoweredBevelBorder());
        this.add(this.m_label);
        this.m_label.setName(this.desc.getDescName());
        this.updateMessageStyleInfo(this.defaultMessageStyleInfo);
        this.statusBarItemEventHandler = new DefaultStatusBarItemEventHandler(this);
        this.setupCustomizableListeners();
    }

    public StatusBarItem(DescContainer descContainer) throws UIObjectDescriptionNotCorrectException {
        try {
            String string;
            this.desc = descContainer;
            CommStyleInfo commStyleInfo = (CommStyleInfo)descContainer._getRootParent();
            if (null != commStyleInfo && null != commStyleInfo.getPluginName()) {
                string = descContainer.getParasItemValue("messageIcon");
                if (null != string) {
                    this.defaultMessageStyleInfo.messageIcon = commStyleInfo.getResource().getIcon(string);
                }
            } else {
                this.defaultMessageStyleInfo.messageIcon = ResourceMng.getInstance().getIcon(descContainer.getParasItemValue("messageIcon"), false);
            }
            this.defaultMessageStyleInfo.messageFont = ResourceMng.getInstance().getFont(descContainer.getParasItemValue("messageFont"));
            this.defaultMessageStyleInfo.messageColor = ResourceMng.getInstance().getColor(descContainer.getParasItemValue("messageColor"));
            this.defaultMessageStyleInfo.bFlash = (Boolean)TypeConverter.getParameter(descContainer.getParasItemValue("flash"), Boolean.class);
            this.defaultMessageStyleInfo.iLayout = (Integer)TypeConverter.getParameter(descContainer.getParasItemValue("layout"), Integer.class);
            try {
                string = this.desc.getParasItemValue("serialnumber");
                this.serialNo = Integer.parseInt(string);
            }
            catch (NumberFormatException numberFormatException) {
                this.serialNo = Integer.MAX_VALUE;
            }
        }
        catch (Exception exception) {
            logger.trace(exception.getMessage(), exception);
            throw new UIObjectDescriptionNotCorrectException("StatusBarItem cannot be created from given DESC");
        }
        this.setLayout(new GridLayout());
        this.setBorder(BorderFactory.createLoweredBevelBorder());
        this.add(this.m_label);
        this.m_label.setName(this.desc.getDescName());
        this.updateMessageStyleInfo(this.defaultMessageStyleInfo);
        this.statusBarItemEventHandler = new DefaultStatusBarItemEventHandler(this);
        this.setupCustomizableListeners();
    }

    public void refreshItem(String string) {
        if (this.bNeedResetToDefaultStyle) {
            this.updateMessageStyleInfo(this.defaultMessageStyleInfo);
            this.bNeedResetToDefaultStyle = false;
        }
        if (!SwingUtilities.isEventDispatchThread()) {
            this.runnable.message = string;
            SwingUtilities.invokeLater(this.runnable);
        } else {
            this.setText(string);
        }
    }

    private void setText(String string) {
        if (string == null) {
            this.m_label.setVisible(false);
            this.m_label.setText("");
            this.m_label.setToolTipText(null);
        } else {
            this.m_label.setVisible(true);
            this.m_label.setText(string);
            if ("".equals(string)) {
                this.m_label.setToolTipText(null);
            } else {
                this.m_label.setToolTipText(string);
            }
        }
    }

    public String getText() {
        return this.m_label.getText();
    }

    public boolean equals(Object object) {
        if (object instanceof StatusBarItem) {
            return this.equalsWith((StatusBarItem)object);
        }
        return false;
    }

    public int hashCode() {
        String string = this.getID();
        return string == null ? 0 : string.hashCode();
    }

    private boolean equalsWith(StatusBarItem statusBarItem) {
        return ResourceUtil.areEquals(this.getID(), statusBarItem.getID());
    }

    public void refreshItem(String string, MessageStyleInfo messageStyleInfo) {
        this.refreshItem(string);
        this.refreshItemStyle(messageStyleInfo);
    }

    public void refreshItemStyle(MessageStyleInfo messageStyleInfo) {
        this.updateMessageStyleInfo(messageStyleInfo);
        this.bNeedResetToDefaultStyle = true;
    }

    public void setDefaultMessageStyleInfo(MessageStyleInfo messageStyleInfo) {
        this.defaultMessageStyleInfo = messageStyleInfo;
        this.bNeedResetToDefaultStyle = true;
    }

    private void updateMessageStyleInfo(MessageStyleInfo messageStyleInfo) {
        if (messageStyleInfo != null) {
            if (messageStyleInfo.messageIcon != null) {
                this.m_label.setIcon(messageStyleInfo.messageIcon);
            } else {
                this.m_label.setIcon(null);
            }
            this.m_label.setFont(messageStyleInfo.messageFont);
            this.m_label.setForeground(messageStyleInfo.messageColor);
            switch (messageStyleInfo.iLayout) {
                case 1: {
                    this.m_label.setHorizontalAlignment(2);
                    break;
                }
                case 0: {
                    this.m_label.setHorizontalAlignment(0);
                    break;
                }
                case -1: {
                    this.m_label.setHorizontalAlignment(4);
                    break;
                }
            }
            if (messageStyleInfo.bFlash) {
                if (this.timer == null) {
                    this.timer = new Timer(this.timerDelay, new ActionListener(){

                        @Override
                        public void actionPerformed(ActionEvent actionEvent) {
                            StatusBarItem.this.timerActionPerformed();
                        }
                    });
                }
            } else if (this.timer != null) {
                this.timer.stop();
                this.timer = null;
            }
        }
    }

    public String getID() {
        return this.desc.getDescName();
    }

    public void setupCustomizableListeners() {
        if (this.statusBarItemEventHandler != null) {
            this.m_label.addMouseListener((MouseListener)GenericListener.create(MouseListener.class, "mouseClicked", this.statusBarItemEventHandler, "mouseClickedAction"));
            this.m_label.addMouseListener((MouseListener)GenericListener.create(MouseListener.class, "mousePressed", this.statusBarItemEventHandler, "mousePressedAction"));
            this.m_label.addMouseListener((MouseListener)GenericListener.create(MouseListener.class, "mouseReleased", this.statusBarItemEventHandler, "mouseReleasedAction"));
            this.m_label.addMouseListener((MouseListener)GenericListener.create(MouseListener.class, "mouseEntered", this.statusBarItemEventHandler, "mouseEnteredAction"));
        }
    }

    public void timerActionPerformed() {
        this.m_label.setVisible(!this.m_label.isShowing());
    }

    public int getSerialNumber() {
        return this.serialNo;
    }

    @Override
    public void setToolTipText(String string) {
        super.setToolTipText(string);
        this.m_label.setToolTipText(string);
    }

    private final class RefreshRunnable
    implements Runnable {
        private String message = null;

        private RefreshRunnable() {
        }

        @Override
        public void run() {
            StatusBarItem.this.refreshItem(this.message);
        }
    }
}

