/*
 * Decompiled with CFR 0.152.
 */
package com.swimap.iview.templates.statusbar;

import com.swimap.iview.commstyle.commini.CommException;
import com.swimap.iview.commstyle.commini.CommStyleInfo;
import com.swimap.iview.commstyle.commini.DescContainer;
import com.swimap.iview.commstyle.commini.UIObjectDescriptionNotCorrectException;
import com.swimap.iview.commstyle.resource.i18n.ResourceUtil;
import com.swimap.iview.framework.classmanangement.ClassManager;
import com.swimap.iview.templates.statusbar.MessageStyleInfo;
import com.swimap.iview.templates.statusbar.StatusBarItem;
import com.swimap.iview.util.TypeConverter;
import com.swimap.iview.util.log.IviewLogger;
import java.awt.Component;
import java.awt.Dimension;
import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import java.util.concurrent.ConcurrentHashMap;
import javax.swing.BoxLayout;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;

public class StatusBar
extends JPanel {
    private static IviewLogger logger = IviewLogger.getLogger(StatusBar.class, "IVIEW");
    private Vector statusBarOrder = new Vector();
    private Hashtable statusBarItemHash = new Hashtable();
    private ConcurrentHashMap<String, Vector> statusInfoMap = new ConcurrentHashMap(10);

    public StatusBar() {
        this.setLayout(new BoxLayout(this, 0));
    }

    public StatusBar(DescContainer descContainer) throws UIObjectDescriptionNotCorrectException {
        this.setLayout(new BoxLayout(this, 0));
        this.statusbarInit(descContainer);
    }

    public void addStatusBar(CommStyleInfo commStyleInfo, String string, String string2) throws UIObjectDescriptionNotCorrectException {
        Vector vector = this.statusbarInit(commStyleInfo.getAreaDescContainer(string).getDescContainer(string2));
        if (vector.size() > 0) {
            if (this.statusInfoMap.containsKey(commStyleInfo.getFileName())) {
                Vector vector2 = this.statusInfoMap.get(commStyleInfo.getFileName());
                vector2.addAll(vector);
                vector = vector2;
            }
            this.statusInfoMap.put(commStyleInfo.getFileName(), vector);
        }
    }

    private Vector statusbarInit(DescContainer descContainer) throws UIObjectDescriptionNotCorrectException {
        Vector<Object> vector = new Vector<Object>();
        try {
            if (!"StatusBar".equals(descContainer.getParasItem("type").getValue())) {
                throw new CommException("descContainer is not StatusBar type");
            }
            int n = descContainer.getSubDescCount();
            for (int i = 0; i < n; ++i) {
                Object object = null;
                try {
                    String string = descContainer.getDescContainer(i).getParasItemValue("itemType");
                    String string2 = descContainer.getDescContainer(i).getParasItemValue("classPath");
                    DescContainer descContainer2 = descContainer.getDescContainer(i);
                    object = this.createItem(string2, string, descContainer2);
                }
                catch (Exception exception) {
                    logger.error("StatusBar Create Items");
                }
                if (object == null) continue;
                this.statusBarOrder.add(object);
                this.statusBarItemHash.put(descContainer.getDescContainer(i).getDescName(), object);
                try {
                    this.setItemSize((JPanel)object, descContainer.getDescContainer(i));
                    if ("false".equalsIgnoreCase(descContainer.getDescContainer(i).getParasItemValue("initialVisible"))) {
                        ((JComponent)object).setVisible(false);
                    }
                }
                catch (Exception exception) {
                    logger.debug(exception.getMessage());
                }
                vector.add(object);
            }
            SerialNumberComparator serialNumberComparator = new SerialNumberComparator();
            Collections.sort(this.statusBarOrder, serialNumberComparator);
            for (String string : this.statusBarOrder) {
                if (null == string || !(string instanceof StatusBarItem)) continue;
                this.add((StatusBarItem)((Object)string));
            }
            this.validate();
            this.repaint();
        }
        catch (Exception exception) {
            logger.trace(exception.getMessage(), exception);
            throw new UIObjectDescriptionNotCorrectException("MenuSet can not be create from the Description, check your Style file ");
        }
        return vector;
    }

    public boolean removeStatusBar(CommStyleInfo commStyleInfo) {
        boolean bl = false;
        if (null == commStyleInfo) {
            return bl;
        }
        String string = commStyleInfo.getFileName();
        if (this.statusInfoMap.containsKey(string)) {
            Vector vector = this.statusInfoMap.get(string);
            int n = vector.size();
            for (int i = 0; i < n; ++i) {
                this.removeStatusBarItem((StatusBarItem)vector.get(i));
            }
            this.statusInfoMap.remove(string);
            return true;
        }
        return bl;
    }

    public StatusBarItem createItem(String string, String string2, DescContainer descContainer) throws Exception {
        Class clazz = null;
        clazz = string != null && string.length() != 0 ? ClassManager.loadClass(string, string2) : Class.forName(string2);
        Class[] classArray = new Class[]{DescContainer.class};
        Object[] objectArray = new Object[]{descContainer};
        Constructor constructor = clazz.getConstructor(classArray);
        return (StatusBarItem)constructor.newInstance(objectArray);
    }

    public void setItemSize(JPanel jPanel, DescContainer descContainer) {
        jPanel.setPreferredSize(TypeConverter.toDimension(descContainer.getParasItemValue("preferredSize"), new Dimension(200, 20)));
        jPanel.setMinimumSize(TypeConverter.toDimension(descContainer.getParasItemValue("minimumSize"), new Dimension(200, 20)));
        jPanel.setMaximumSize(TypeConverter.toDimension(descContainer.getParasItemValue("maximumSize"), new Dimension(Short.MAX_VALUE, Short.MAX_VALUE)));
    }

    public List saveItemInfo() {
        ArrayList arrayList = new ArrayList(this.statusBarOrder.size());
        arrayList.addAll(this.statusBarOrder);
        return arrayList;
    }

    private String recoverItemText(List list, String string) {
        Iterator iterator = list.iterator();
        StatusBarItem statusBarItem = null;
        while (iterator.hasNext()) {
            statusBarItem = (StatusBarItem)iterator.next();
            if (!ResourceUtil.areEquals(string, statusBarItem.getID())) continue;
            return statusBarItem.getText();
        }
        return "";
    }

    public void recoverStatusBar(List list) throws Exception {
        Iterator iterator = this.statusBarOrder.iterator();
        StatusBarItem statusBarItem = null;
        String string = "";
        while (iterator.hasNext()) {
            statusBarItem = (StatusBarItem)iterator.next();
            string = this.recoverItemText(list, statusBarItem.getID());
            if (string == null || string.length() == 0) continue;
            statusBarItem.refreshItem(string);
        }
    }

    public void addStatusBarItem(final StatusBarItem statusBarItem) {
        if (this.statusBarItemHash.get(statusBarItem.getID()) == null) {
            int n = statusBarItem.getSerialNumber();
            this.statusBarItemHash.put(statusBarItem.getID(), statusBarItem);
            if (n == Integer.MAX_VALUE) {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        StatusBar.this.statusBarOrder.add(statusBarItem);
                        StatusBar.this.add(statusBarItem);
                        StatusBar.this.updateUI();
                    }
                });
            } else {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        int n = StatusBar.this.getItemPos(statusBarItem.getSerialNumber());
                        StatusBar.this.statusBarOrder.insertElementAt(statusBarItem, n);
                        StatusBar.this.add((Component)statusBarItem, n);
                    }
                });
            }
        } else {
            logger.debug("this ID is already used:" + statusBarItem.getID());
        }
    }

    public void removeStatusBarItem(StatusBarItem statusBarItem) {
        if (this.statusBarOrder.remove(statusBarItem)) {
            this.statusBarItemHash.remove(statusBarItem.getID());
            this.remove(statusBarItem);
            this.updateUI();
        }
    }

    public StatusBarItem getStatusBarItem(int n) {
        if (n >= 0 && n < this.statusBarOrder.size()) {
            return (StatusBarItem)this.statusBarOrder.elementAt(n);
        }
        return null;
    }

    public int getStatusBarItemCount() {
        return this.statusBarOrder.size();
    }

    public StatusBarItem getStatusBarItem(String string) {
        if (this.statusBarItemHash != null) {
            return (StatusBarItem)this.statusBarItemHash.get(string);
        }
        return null;
    }

    public void refreshItem(int n, String string) {
        StatusBarItem statusBarItem = this.getStatusBarItem(n);
        if (statusBarItem != null) {
            statusBarItem.refreshItem(string);
        }
    }

    public void refreshItem(String string, String string2) {
        StatusBarItem statusBarItem = this.getStatusBarItem(string);
        if (statusBarItem != null) {
            statusBarItem.refreshItem(string2);
        }
    }

    public void refreshItem(int n, String string, MessageStyleInfo messageStyleInfo) {
        StatusBarItem statusBarItem = this.getStatusBarItem(n);
        if (statusBarItem != null) {
            statusBarItem.refreshItem(string, messageStyleInfo);
        }
    }

    public void refreshItem(String string, String string2, MessageStyleInfo messageStyleInfo) {
        StatusBarItem statusBarItem = this.getStatusBarItem(string);
        if (statusBarItem != null) {
            statusBarItem.refreshItem(string2, messageStyleInfo);
        }
    }

    public void refreshItemStyle(String string, MessageStyleInfo messageStyleInfo) {
        StatusBarItem statusBarItem = this.getStatusBarItem(string);
        if (statusBarItem != null) {
            statusBarItem.refreshItemStyle(messageStyleInfo);
        }
    }

    public void refreshItemStyle(int n, MessageStyleInfo messageStyleInfo) {
        StatusBarItem statusBarItem = this.getStatusBarItem(n);
        if (statusBarItem != null) {
            statusBarItem.refreshItemStyle(messageStyleInfo);
        }
    }

    public int getItemPos(int n) {
        int n2 = this.statusBarOrder.size();
        int n3 = 0;
        for (n3 = 0; n3 < n2; ++n3) {
            int n4 = ((StatusBarItem)this.statusBarOrder.elementAt(n3)).getSerialNumber();
            if (n4 == -1 || n4 <= n) continue;
            return n3;
        }
        return n3;
    }

    private class SerialNumberComparator
    implements Comparator {
        private SerialNumberComparator() {
        }

        public int compare(Object object, Object object2) {
            int n = 0;
            if (object instanceof StatusBarItem && object2 instanceof StatusBarItem) {
                int n2;
                StatusBarItem statusBarItem = (StatusBarItem)object;
                StatusBarItem statusBarItem2 = (StatusBarItem)object2;
                int n3 = statusBarItem.getSerialNumber();
                if (n3 < (n2 = statusBarItem2.getSerialNumber())) {
                    n = -1;
                } else if (n3 > n2) {
                    n = 1;
                }
            }
            return n;
        }
    }
}

