/*
 * Decompiled with CFR 0.152.
 */
package com.swimap.iview.templates.statusbar;

import com.swimap.iview.commstyle.commini.DescContainer;
import com.swimap.iview.commstyle.commini.UIObjectDescriptionNotCorrectException;
import com.swimap.iview.commstyle.resource.ResourceMng;
import com.swimap.iview.templates.statusbar.IModelChangeListener;
import com.swimap.iview.templates.statusbar.IStopCommand;
import com.swimap.iview.templates.statusbar.StatusBarItem;
import com.swimap.iview.util.adapter.TypeConverter;
import java.awt.Dimension;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.List;
import javax.swing.BoundedRangeModel;
import javax.swing.BoxLayout;
import javax.swing.DefaultBoundedRangeModel;
import javax.swing.Icon;
import javax.swing.JLabel;
import javax.swing.JProgressBar;

public class ProgressStatusBarItem
extends StatusBarItem {
    private JLabel m_stopButton;
    private JProgressBar m_meter = new JProgressBar();
    private IStopCommand m_stop;
    private List<IModelChangeListener> listenerList = null;
    private JLabel m_popButton = null;

    public ProgressStatusBarItem(DescContainer descContainer) throws UIObjectDescriptionNotCorrectException {
        super(descContainer);
        this.setLayout(new BoxLayout(this, 0));
        this.m_label.setMinimumSize(new Dimension(10, 0));
        this.m_meter.setSize(100, 10);
        this.m_meter.setName("ProgressStatusBarItem_m_meter");
        this.m_stopButton = new JLabel("STOP");
        this.m_stopButton.setName("ProgressStatusBarItem_m_stopButton");
        this.m_stopButton.setEnabled(false);
        this.m_stopButton.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent mouseEvent) {
                IStopCommand iStopCommand = ProgressStatusBarItem.this.m_stop;
                if (iStopCommand != null) {
                    iStopCommand.stop();
                }
            }
        });
        this.m_popButton = new JLabel();
        Icon icon = ResourceMng.getInstance().getIconDirect("mainfrm/popup.gif");
        this.m_popButton.setIcon(icon);
        this.m_popButton.setVisible(false);
        this.add(this.m_meter);
        boolean bl = TypeConverter.toBoolean(descContainer.getParasItemValue("with_stop_button"), true);
        if (bl) {
            this.add(this.m_stopButton);
        }
        this.add(this.m_popButton);
    }

    public BoundedRangeModel getModel() {
        return this.m_meter.getModel();
    }

    public void setModel(BoundedRangeModel boundedRangeModel) {
        BoundedRangeModel boundedRangeModel2 = null;
        boundedRangeModel2 = boundedRangeModel == null ? new DefaultBoundedRangeModel() : boundedRangeModel;
        if (this.m_meter.getModel() != boundedRangeModel2) {
            this.m_meter.setModel(boundedRangeModel2);
            this.fireModelChanged();
        }
    }

    public void setStopCommand(IStopCommand iStopCommand) {
        if (iStopCommand == null) {
            this.setModel(null);
            this.m_stopButton.setEnabled(false);
            this.m_stopButton.repaint();
            this.m_stop = null;
        } else {
            this.m_stop = iStopCommand;
            this.setModel(iStopCommand.getModel());
            this.m_stopButton.setEnabled(true);
            this.m_stopButton.repaint();
        }
    }

    private void fireModelChanged() {
        if (null != this.listenerList) {
            for (IModelChangeListener iModelChangeListener : this.listenerList) {
                if (null == iModelChangeListener) continue;
                iModelChangeListener.modelChanged();
            }
        }
    }

    public void addModelChangeListener(IModelChangeListener iModelChangeListener) {
        if (null == this.listenerList) {
            this.listenerList = new ArrayList<IModelChangeListener>(10);
        }
        this.listenerList.add(iModelChangeListener);
    }

    public void removeModelChangeListener(IModelChangeListener iModelChangeListener) {
        if (null != this.listenerList) {
            this.listenerList.remove(iModelChangeListener);
        }
    }

    public void setValue(int n) {
        this.m_meter.setValue(n);
    }

    public JProgressBar getProgressBar() {
        return this.m_meter;
    }

    public JLabel getShowButton() {
        return this.m_popButton;
    }
}

