/*
 * Decompiled with CFR 0.152.
 */
package com.swimap.iview.templates.statusbar;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Window;
import java.io.Serializable;
import javax.swing.JInternalFrame;
import javax.swing.JLayeredPane;
import javax.swing.JPanel;
import javax.swing.JRootPane;
import javax.swing.SwingUtilities;

final class JPanelPopup
extends JPanel
implements Serializable {
    private int desiredLocationX;
    private int desiredLocationY;
    private Component invoker = null;

    JPanelPopup(Component component) {
        this.invoker = component;
        this.setLayout(new BorderLayout());
        this.setDoubleBuffered(true);
        this.setOpaque(false);
    }

    @Override
    public void paint(Graphics graphics) {
        if (this.invoker != null && this.invoker.isShowing()) {
            Point point = this.invoker.getLocationOnScreen();
            int n = point.x + this.invoker.getWidth() - this.getPreferredSize().width;
            int n2 = point.y + this.invoker.getHeight() / 2 - this.getPreferredSize().height;
            this.setLocationOnScreen(n, n2);
            super.paint(graphics);
        } else if (this.invoker == null) {
            super.paint(graphics);
        }
    }

    public void pack() {
        this.setSize(this.getPreferredSize());
    }

    public void show(Component component) {
        Serializable serializable;
        Container container = null;
        if (component != null) {
            container = component.getParent();
        }
        for (serializable = container; serializable != null; serializable = serializable.getParent()) {
            if (serializable instanceof JRootPane) {
                if (serializable.getParent() instanceof JInternalFrame) continue;
                container = ((JRootPane)serializable).getLayeredPane();
                break;
            }
            if (!(serializable instanceof Window)) continue;
            container = serializable;
            break;
        }
        serializable = this.convertScreenLocationToParent(container, this.desiredLocationX, this.desiredLocationY);
        this.setLocation(((Point)serializable).x, ((Point)serializable).y);
        if (container instanceof JLayeredPane) {
            ((JLayeredPane)container).add(this, JLayeredPane.POPUP_LAYER, 0);
        } else {
            container.add(this);
        }
        container.validate();
    }

    @Override
    public void hide() {
        Container container = this.getParent();
        Rectangle rectangle = this.getBounds();
        if (container != null) {
            container.remove(this);
            container.repaint(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
        }
    }

    private final Point convertScreenLocationToParent(Container container, int n, int n2) {
        Serializable serializable;
        Window window = null;
        for (serializable = container; serializable != null; serializable = serializable.getParent()) {
            if (!(serializable instanceof Window)) continue;
            window = (Window)serializable;
            break;
        }
        if (window != null) {
            serializable = new Point(n, n2);
            SwingUtilities.convertPointFromScreen((Point)serializable, container);
            return serializable;
        }
        throw new Error("convertScreenLocationToParent: no window ancestor found");
    }

    public void setLocationOnScreen(int n, int n2) {
        Container container = this.getParent();
        if (container != null) {
            Point point = this.convertScreenLocationToParent(container, n, n2);
            this.setLocation(point.x, point.y);
        } else {
            this.desiredLocationX = n;
            this.desiredLocationY = n2;
        }
    }
}

