/*
 * Decompiled with CFR 0.152.
 */
package com.swimap.iview.templates.statusbar;

import com.swimap.iview.commstyle.commini.AreaDescContainer;
import com.swimap.iview.commstyle.commini.CommStyleInfo;
import com.swimap.iview.commstyle.commini.CommStyleManager;
import com.swimap.iview.commstyle.commini.DescContainer;
import com.swimap.iview.commstyle.commini.UIObjectDescriptionNotCorrectException;
import com.swimap.iview.commstyle.commini.xmlbind.PARA;
import com.swimap.iview.commstyle.resource.ResourceMng;
import com.swimap.iview.templates.statusbar.Bubble;
import com.swimap.iview.templates.statusbar.JPanelPopup;
import com.swimap.iview.templates.statusbar.StatusBarItem;
import com.swimap.iview.util.IconCloseListener;
import com.swimap.iview.util.ScreenToolKit;
import com.swimap.iview.util.log.IviewLogger;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.ResourceBundle;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.SwingUtilities;
import javax.swing.Timer;

public class BubbleStatusBarItem
extends StatusBarItem {
    private static IviewLogger logger = IviewLogger.getLogger(BubbleStatusBarItem.class, "IVIEW");
    private Icon darkIcon = null;
    private Icon brightIcon = null;
    private static ResourceBundle res = ResourceMng.getInstance().getResourceBundleFromPropertyFile("mainfrm/iview/templates/statusbar/Res");
    private Icon disabledIcon = null;
    private boolean isBubbleEnable = true;
    private JPopupMenu popupMenu = null;
    private JMenuItem enableItem = null;
    private JMenuItem disabledItem = null;
    private String message = null;
    private RefreshRunnable runnable = new RefreshRunnable();
    private JPanelPopup popupWindow = null;
    private boolean enableAutoHide = true;
    private Bubble tipBubble = null;
    private static final int FIVE_SEC = 5000;
    private JComponent bubbelComponent = null;
    private boolean closeIconEnabled = false;
    private static final String BUBBLESTATUSBARITEM_INFO_FILE = "conf/mainfrm/bubblestatusbariteminfo";
    private CommStyleInfo bubbleInfo = null;
    private static final String ISENABLED = "isEnabled";
    private static final String TRUE = "true";
    private static final String FALSE = "false";
    private static final String NAME = "Bubble_StatusBar_Item";
    private Timer hideTimer = new Timer(5000, new ActionListener(){

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            BubbleStatusBarItem.this.hideBubble();
        }
    });
    private transient MouseAdapter mouseAdapter = new MouseAdapter(){

        @Override
        public void mouseClicked(MouseEvent mouseEvent) {
            BubbleStatusBarItem.this.hideBubble();
        }
    };

    public BubbleStatusBarItem(String string) {
        super(string);
        this.init();
    }

    public BubbleStatusBarItem(DescContainer descContainer) throws UIObjectDescriptionNotCorrectException {
        super(descContainer);
        this.init();
    }

    public void setBubbleEnabledFromUser() {
        this.bubbleInfo = CommStyleManager.getInstance().getUserCommonStyleFile(BUBBLESTATUSBARITEM_INFO_FILE);
        if (null == this.bubbleInfo) {
            return;
        }
        AreaDescContainer areaDescContainer = this.bubbleInfo.getAreaDescContainer(0);
        if (null != areaDescContainer) {
            DescContainer descContainer = areaDescContainer.getDescContainer(NAME);
            if (null != descContainer && null != descContainer.getParasItemValue(ISENABLED) && TRUE.equalsIgnoreCase(descContainer.getParasItemValue(ISENABLED).trim())) {
                this.enableBubble(true);
                return;
            }
            if (null != descContainer && null != descContainer.getParasItemValue(ISENABLED) && FALSE.equalsIgnoreCase(descContainer.getParasItemValue(ISENABLED).trim())) {
                this.enableBubble(false);
                return;
            }
        }
    }

    public boolean setBubbleItemInfo() {
        AreaDescContainer areaDescContainer;
        if (null == this.bubbleInfo && this.isBubbleEnable) {
            return true;
        }
        if (null == this.bubbleInfo) {
            this.bubbleInfo = new CommStyleInfo();
            areaDescContainer = new AreaDescContainer();
            this.bubbleInfo.addAreaDescContainer(areaDescContainer);
        }
        if (null != (areaDescContainer = this.bubbleInfo.getAreaDescContainer()[0])) {
            DescContainer descContainer = areaDescContainer.getDescContainer(NAME);
            String string = FALSE;
            if (this.isBubbleEnable) {
                string = TRUE;
            }
            if (null != descContainer && null != descContainer.getParasItemValue(ISENABLED) && string.equalsIgnoreCase(descContainer.getParasItemValue(ISENABLED).trim())) {
                return true;
            }
            if (null == descContainer) {
                descContainer = new DescContainer(NAME);
                areaDescContainer.addDescContainer(descContainer);
            }
            this.setPara(descContainer, ISENABLED, string);
            CommStyleManager.getInstance().writeToUser(this.bubbleInfo, BUBBLESTATUSBARITEM_INFO_FILE);
            return true;
        }
        return false;
    }

    private void setPara(DescContainer descContainer, String string, String string2) {
        String string3 = descContainer.getParasItemValue(string);
        if (null == string3) {
            PARA pARA = new PARA();
            pARA.setName(string);
            pARA.setValue(string2);
            descContainer.addParasItem(pARA);
        } else {
            descContainer.setParasItem(string, string2);
        }
    }

    private void init() {
        this.darkIcon = new ImageIcon(this.getClass().getResource("darkbubble.gif"));
        this.brightIcon = new ImageIcon(this.getClass().getResource("brightbubble.gif"));
        this.disabledIcon = new ImageIcon(this.getClass().getResource("disabledbubble.gif"));
        this.m_label.setIcon(this.darkIcon);
        this.m_label.setName("BubbleStatusBarItem_m_label");
        this.m_label.addMouseListener(new BubbleMouseAdapter());
    }

    public void setMessage(String string) {
        if (!this.isBubbleEnable) {
            return;
        }
        try {
            int n = Toolkit.getDefaultToolkit().getScreenSize().width / 2;
            string = ScreenToolKit.getLineWrapString(string, n, this.getFont(), true);
        }
        catch (Exception exception) {
            logger.trace(exception.getMessage(), exception);
        }
        if (!SwingUtilities.isEventDispatchThread()) {
            this.runnable.msg = string;
            SwingUtilities.invokeLater(this.runnable);
        } else {
            this.message = string;
            this.bubbelComponent = null;
            this.showBubble();
        }
    }

    public void setBubbleComponent(final JComponent jComponent) {
        if (jComponent.equals(this)) {
            logger.debug("component to be added inside bubble can not be bubble's parent");
            return;
        }
        if (!this.isBubbleEnable) {
            return;
        }
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                BubbleStatusBarItem.this.bubbelComponent = jComponent;
                BubbleStatusBarItem.this.showBubble();
            }
        });
    }

    @Override
    public void refreshItem(String string) {
        if (null != string && string.length() == 0) {
            if (this.popupWindow != null && this.popupWindow.isVisible()) {
                this.hideBubble();
            }
            return;
        }
        this.setMessage(string);
    }

    @Override
    public void paint(Graphics graphics) {
        super.paint(graphics);
        if (this.popupWindow != null) {
            Point point = this.getLocationOnScreen();
            int n = point.x + this.getWidth() - this.popupWindow.getPreferredSize().width;
            int n2 = point.y + this.getHeight() / 2 - this.popupWindow.getPreferredSize().height;
            this.popupWindow.setLocationOnScreen(n, n2);
        }
    }

    public String getMessage() {
        return this.message;
    }

    public void enableCloseIcon(boolean bl) {
        this.closeIconEnabled = bl;
    }

    public void setHideDelayTime(int n) {
        logger.debug("time=" + n);
        boolean bl = this.hideTimer.isRunning();
        if (bl) {
            this.hideTimer.stop();
        }
        this.hideTimer.setInitialDelay(n);
        this.hideTimer.setDelay(n);
        if (bl) {
            this.hideTimer.start();
        }
    }

    public int getHideDelayTime() {
        return this.hideTimer.getInitialDelay();
    }

    public void setEnableAutoHide(boolean bl) {
        logger.debug("enableAutoHide=" + bl);
        this.enableAutoHide = bl;
        if (this.enableAutoHide) {
            if (this.popupWindow != null) {
                this.hideTimer.stop();
                this.hideTimer.start();
            }
        } else {
            this.hideTimer.stop();
        }
    }

    public boolean isEnableAutoHide() {
        return this.enableAutoHide;
    }

    private void showBubble() {
        if (!this.isShowing()) {
            return;
        }
        if (!SwingUtilities.isEventDispatchThread()) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    BubbleStatusBarItem.this.showBubbleMethod();
                }
            });
        } else {
            this.showBubbleMethod();
        }
    }

    private void showBubbleMethod() {
        this.hideBubble();
        this.popupWindow = new JPanelPopup(this);
        this.popupWindow.setName("BubbleStatusBarItem_popupWindow");
        this.popupWindow.setLayout(new BorderLayout());
        this.tipBubble = this.bubbelComponent != null ? new Bubble(this, this.bubbelComponent) : new Bubble(this);
        if (!this.closeIconEnabled) {
            this.tipBubble.addMouseListener(this.mouseAdapter);
            this.tipBubble.textArea.addMouseListener(this.mouseAdapter);
        } else {
            this.tipBubble.addIconCloseListener(new IconCloseListener(){

                @Override
                public void close() {
                    BubbleStatusBarItem.this.hideBubble();
                }
            });
        }
        this.popupWindow.add((Component)this.tipBubble, "Center");
        Point point = this.getLocationOnScreen();
        int n = point.x + this.getWidth() - this.popupWindow.getPreferredSize().width;
        int n2 = point.y + this.getHeight() / 2 - this.popupWindow.getPreferredSize().height;
        this.popupWindow.setLocationOnScreen(n, n2);
        this.popupWindow.pack();
        this.popupWindow.show(this);
        this.m_label.setIcon(this.brightIcon);
        logger.debug("enableAutoHide =" + this.enableAutoHide + " timer.running=" + this.hideTimer.isRunning());
        if (this.enableAutoHide) {
            this.hideTimer.restart();
        }
    }

    public boolean isCloseIconEnabled() {
        return this.closeIconEnabled;
    }

    public void hideBubble() {
        if (!SwingUtilities.isEventDispatchThread()) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    BubbleStatusBarItem.this.hideBubbleMethod();
                }
            });
        } else {
            this.hideBubbleMethod();
        }
    }

    private void hideBubbleMethod() {
        logger.debug("start to hide bubble.");
        this.hideTimer.stop();
        if (this.tipBubble != null) {
            this.tipBubble.removeMouseListener(this.mouseAdapter);
            MouseListener[] mouseListenerArray = (MouseListener[])this.tipBubble.getListeners(MouseListener.class);
            for (int i = 0; i < mouseListenerArray.length; ++i) {
                this.tipBubble.removeMouseListener(mouseListenerArray[i]);
            }
            this.tipBubble.textArea.removeMouseListener(this.mouseAdapter);
            this.tipBubble = null;
        }
        if (this.popupWindow != null) {
            this.popupWindow.setVisible(false);
            if (this.getRootPane() != null && this.getRootPane().getLayeredPane() != null) {
                this.getRootPane().getLayeredPane().remove(this.popupWindow);
            }
            this.popupWindow = null;
        }
        if (this.isBubbleEnable) {
            this.m_label.setIcon(this.darkIcon);
        }
    }

    private void createPopupMenu() {
        this.popupMenu = new JPopupMenu();
        this.popupMenu.setName("BubbleStatusBarItem_popupMenu");
        this.enableItem = new JMenuItem(res.getString("Enable_MenuItem"));
        this.enableItem.setName("BubbleStatusBarItem_enableItem");
        this.enableItem.setMnemonic('E');
        this.disabledItem = new JMenuItem(res.getString("Disable_MenuItem"));
        this.disabledItem.setName("BubbleStatusBarItem_disabledItem");
        this.disabledItem.setMnemonic('D');
        this.enableItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                BubbleStatusBarItem.this.enableBubble(true);
            }
        });
        this.disabledItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                BubbleStatusBarItem.this.enableBubble(false);
            }
        });
    }

    private void enableBubble(boolean bl) {
        this.isBubbleEnable = bl;
        if (bl) {
            this.m_label.setIcon(this.darkIcon);
        } else {
            this.m_label.setIcon(this.disabledIcon);
            if (this.popupWindow != null && this.popupWindow.isVisible()) {
                this.hideBubble();
            }
        }
    }

    public void addTipBubbleMouseListener(MouseListener mouseListener) {
        if (null != this.tipBubble && null != this.tipBubble.textArea) {
            this.tipBubble.textArea.addMouseListener(mouseListener);
            this.tipBubble.addMouseListener(mouseListener);
        } else {
            logger.debug("Bubble is not initializedyet, listeners are not added");
        }
    }

    public void addProgressListener(MouseListener mouseListener) {
        if (null != this.tipBubble && null != this.tipBubble.textArea) {
            int n;
            MouseListener[] mouseListenerArray = this.tipBubble.textArea.getMouseListeners();
            for (n = 0; n < mouseListenerArray.length; ++n) {
                this.tipBubble.textArea.removeMouseListener(mouseListenerArray[n]);
                this.tipBubble.removeMouseListener(mouseListenerArray[n]);
            }
            this.tipBubble.textArea.addMouseListener(mouseListener);
            this.tipBubble.addMouseListener(mouseListener);
            for (n = 0; n < mouseListenerArray.length; ++n) {
                this.tipBubble.textArea.addMouseListener(mouseListenerArray[n]);
                this.tipBubble.addMouseListener(mouseListenerArray[n]);
            }
        } else {
            logger.debug("Bubble is not initializedyet, listeners are not added");
        }
    }

    public void removeTipBubbleMouseListener(MouseListener mouseListener) {
        if (null != this.tipBubble && null != this.tipBubble.textArea) {
            this.tipBubble.textArea.removeMouseListener(mouseListener);
            this.tipBubble.removeMouseListener(mouseListener);
        } else {
            logger.debug("Bubble is not initializedyet, failed to delete the listeners");
        }
    }

    public Timer getHideTimer() {
        return this.hideTimer;
    }

    private class BubbleMouseAdapter
    extends MouseAdapter {
        private BubbleMouseAdapter() {
        }

        @Override
        public void mouseClicked(MouseEvent mouseEvent) {
            if ((mouseEvent.getModifiers() & 4) != 0) {
                if (null == BubbleStatusBarItem.this.popupMenu) {
                    BubbleStatusBarItem.this.createPopupMenu();
                }
                BubbleStatusBarItem.this.popupMenu.removeAll();
                if (BubbleStatusBarItem.this.isBubbleEnable) {
                    BubbleStatusBarItem.this.popupMenu.add(BubbleStatusBarItem.this.disabledItem);
                } else {
                    BubbleStatusBarItem.this.popupMenu.add(BubbleStatusBarItem.this.enableItem);
                }
                ScreenToolKit.showPopupMenu(BubbleStatusBarItem.this.popupMenu, mouseEvent);
            }
        }
    }

    private final class RefreshRunnable
    implements Runnable {
        String msg = null;

        private RefreshRunnable() {
        }

        @Override
        public void run() {
            BubbleStatusBarItem.this.setMessage(this.msg);
        }
    }
}

