/*
 * Decompiled with CFR 0.152.
 */
package com.swimap.iview.templates.statusbar;

import com.swimap.iview.templates.bubble.BubbleCloseIcon;
import com.swimap.iview.templates.statusbar.BubbleStatusBarItem;
import com.swimap.iview.util.IconCloseListener;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Polygon;
import java.awt.image.BufferedImage;
import java.util.StringTokenizer;
import javax.swing.JComponent;
import javax.swing.JTextArea;
import javax.swing.UIManager;

final class Bubble
extends JComponent {
    private static final int X = 0;
    private static final int Y = 0;
    private static final int DOGEAR = 5;
    private static final int DEFAULT_WIDTH = 90;
    private static final int DEFAULT_HEIGHT = 36;
    private int width = 90;
    private int height = 36;
    private static final int NPOINTS = 11;
    private int[] xpoints = new int[11];
    private int[] ypoints = new int[11];
    private Polygon shape = null;
    private BubbleStatusBarItem parent = null;
    JTextArea textArea = new JTextArea();
    private BubbleCloseIcon closeIcon = new BubbleCloseIcon();
    private Insets insets = new Insets(10, 20, 30, 25);
    private FontMetrics stringMeasure = null;

    Bubble(BubbleStatusBarItem bubbleStatusBarItem) {
        this.parent = bubbleStatusBarItem;
        this.textArea.setName("BubbleStatusBarItem_Bubble_Text");
        this.textArea.setFont(UIManager.getFont("Label.font"));
        this.textArea.setEditable(false);
        this.textArea.setBackground(UIManager.getColor("text"));
        this.textArea.setFocusable(false);
        this.initializeComponent(this.textArea);
        this.resize();
        this.reShape();
    }

    Bubble(BubbleStatusBarItem bubbleStatusBarItem, JComponent jComponent) {
        this.parent = bubbleStatusBarItem;
        jComponent.setOpaque(false);
        jComponent.setName("BubbleStatusBarItem_Bubble_Component");
        this.initializeComponent(jComponent);
        this.resizeBubbleWithJComponent(jComponent);
        this.reShape();
    }

    private void initializeComponent(JComponent jComponent) {
        jComponent.setLocation(this.insets.left, this.insets.top);
        this.setLayout(null);
        this.setDoubleBuffered(true);
        if (this.parent.isCloseIconEnabled()) {
            this.closeIcon.setIcon(this.closeIcon);
            this.add(this.closeIcon);
        }
        this.add(jComponent);
        this.setOpaque(false);
    }

    private void resizeBubbleWithJComponent(JComponent jComponent) {
        Dimension dimension = jComponent.getPreferredSize();
        this.width = jComponent.getWidth();
        if (this.width == 0) {
            this.width = dimension.width;
            if (this.width == 0) {
                this.width = 90;
            }
        }
        this.height = jComponent.getHeight();
        if (this.height == 0) {
            this.height = dimension.height;
            if (this.height == 0) {
                this.height = 36;
            }
        }
        jComponent.setSize(this.width, this.height);
        this.resizeBubble(this.width, this.height);
    }

    @Override
    public Insets getInsets() {
        return this.insets;
    }

    private void resize() {
        int n;
        String string = this.parent.getMessage();
        if (string == null || string.length() == 0) {
            this.width = 0;
            this.height = 0;
            return;
        }
        String string2 = System.getProperty("line.separator");
        StringTokenizer stringTokenizer = new StringTokenizer(string, string2);
        int n2 = stringTokenizer.countTokens();
        String[] stringArray = new String[n2];
        for (n = 0; n < stringArray.length; ++n) {
            stringArray[n] = stringTokenizer.nextToken();
        }
        this.setFont(UIManager.getFont("Label.font"));
        n = 0;
        String string3 = null;
        string3 = String.valueOf('\n');
        int n3 = 0;
        while ((n3 = string.indexOf(string3, n3)) >= 0) {
            ++n;
            ++n3;
        }
        if (string.endsWith(string3)) {
            --n;
        }
        int n4 = this.stringMeasure.getHeight() * ++n;
        int n5 = 0;
        for (int i = 0; i < stringArray.length; ++i) {
            if (n5 >= this.stringMeasure.stringWidth(stringArray[i])) continue;
            n5 = this.stringMeasure.stringWidth(stringArray[i]);
        }
        n5 = n5 < 90 ? 90 : n5;
        n4 = n4 < 36 ? 36 : n4;
        this.textArea.setSize(new Dimension(n5 + 2, n4 + 2));
        this.textArea.setText(string);
        this.resizeBubble(n5, n4);
    }

    private void resizeBubble(int n, int n2) {
        if (this.parent.isCloseIconEnabled()) {
            this.closeIcon.setBounds(n + 28, 6, this.closeIcon.getIconWidth() + 6, this.closeIcon.getIconHeight() + 8);
        }
        this.setPreferredSize(new Dimension(n + this.insets.left + this.insets.right, n2 + this.insets.top + this.insets.bottom));
    }

    @Override
    public void setFont(Font font) {
        if (font != null) {
            super.setFont(font);
            BufferedImage bufferedImage = new BufferedImage(10, 10, 2);
            Graphics graphics = ((Image)bufferedImage).getGraphics();
            this.stringMeasure = graphics.getFontMetrics(font);
        }
    }

    private void reShape() {
        this.width = this.getPreferredSize().width;
        this.height = this.getPreferredSize().height;
        this.xpoints[0] = 5;
        this.xpoints[1] = 0;
        this.xpoints[2] = 0;
        this.xpoints[3] = 5;
        this.xpoints[4] = this.width - 33;
        this.xpoints[5] = this.width - 15;
        this.xpoints[6] = this.width - 15;
        this.xpoints[7] = this.width - 1 - 5;
        this.xpoints[8] = this.width - 1;
        this.xpoints[9] = this.width - 1;
        this.xpoints[10] = this.width - 1 - 5;
        this.ypoints[0] = 0;
        this.ypoints[1] = 5;
        this.ypoints[2] = this.height - 19 - 5;
        this.ypoints[3] = this.height - 19;
        this.ypoints[4] = this.height - 19;
        this.ypoints[5] = this.height - 1;
        this.ypoints[6] = this.height - 19;
        this.ypoints[7] = this.height - 19;
        this.ypoints[8] = this.height - 19 - 5;
        this.ypoints[9] = 5;
        this.ypoints[10] = 0;
        this.shape = new Polygon(this.xpoints, this.ypoints, 11);
    }

    @Override
    public void paint(Graphics graphics) {
        graphics.setColor(UIManager.getColor("text"));
        graphics.fillPolygon(this.shape);
        graphics.setColor(Color.black);
        graphics.drawPolygon(this.shape);
        super.paint(graphics);
    }

    @Override
    public boolean contains(int n, int n2) {
        this.shape.translate(this.getX(), this.getY());
        if (this.shape.contains(n, n2)) {
            this.shape.translate(0 - this.getX(), 0 - this.getY());
            return true;
        }
        this.shape.translate(0 - this.getX(), 0 - this.getY());
        return false;
    }

    @Override
    public boolean contains(Point point) {
        return this.contains(point.x, point.y);
    }

    public void addIconCloseListener(IconCloseListener iconCloseListener) {
        if (null != this.closeIcon) {
            this.closeIcon.addIconCloseListener(iconCloseListener);
        }
    }
}

