/*
 * Decompiled with CFR 0.152.
 */
package com.swimap.iview.templates.spinbox;

import com.swimap.iview.templates.spinbox.NumericSpinnerModel;
import com.swimap.iview.templates.spinbox.SpinnerModel;
import com.swimap.iview.templates.spinbox.SpinnerTriangleIcon;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import javax.swing.AbstractAction;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.text.Document;

public class Spinner
extends JPanel
implements ChangeListener {
    private final ArrowButtonHandler increButtonHandler = new ArrowButtonHandler("increment", false);
    private final ArrowButtonHandler decreButtonHandler = new ArrowButtonHandler("decrement", true);
    private SpinnerModel spinModel = null;
    private JComponent editor = null;
    private Component btnDecr = null;
    private Component btnIncr = null;
    private static final Dimension zeroSize = new Dimension(0, 0);
    private String toolTip = null;
    private int caretPosition = 0;

    public Spinner() {
        this(new NumericSpinnerModel());
    }

    public Spinner(SpinnerModel spinnerModel) {
        if (spinnerModel == null) {
            throw new IllegalArgumentException("model can't be null");
        }
        this.setLayout(new SpinnerLayout());
        this.spinModel = spinnerModel;
        this.spinModel.addChangeListener(this);
        this.editor = this.createEditor(this.spinModel);
        this.btnDecr = this.createDecreaseButton();
        this.btnIncr = this.createIncreaseButton();
        this.add((Component)this.editor, "Editor");
        this.add(this.btnIncr, "Next");
        this.add(this.btnDecr, "Previous");
        this.setName("Spinner");
    }

    @Override
    public void setName(String string) {
        super.setName(string);
        this.editor.setName(string + "_editor");
        this.btnDecr.setName(string + "_btnDecr");
        this.btnIncr.setName(string + "_btnIncr");
    }

    public void setModel(SpinnerModel spinnerModel) {
        if (spinnerModel == null) {
            throw new IllegalArgumentException("model can't be null.");
        }
        if (!spinnerModel.equals(this.spinModel)) {
            this.spinModel.removeChangeListener(this);
            this.spinModel = spinnerModel;
            this.spinModel.addChangeListener(this);
            JComponent jComponent = this.createEditor(spinnerModel);
            if (jComponent != null) {
                jComponent.setToolTipText(this.toolTip);
                jComponent.setName(this.editor.getName());
                this.remove(this.editor);
                this.editor = jComponent;
                this.add((Component)this.editor, "Editor");
                this.revalidate();
                this.repaint();
            }
        }
    }

    public SpinnerModel getModel() {
        return this.spinModel;
    }

    public Object spinUp() {
        return this.getModel().spinUp();
    }

    public Object spinDown() {
        return this.getModel().spinDown();
    }

    public void setValue(Object object) {
        if (object instanceof Number) {
            this.caretPosition = object.toString().length();
        }
        this.getModel().setValue(object);
    }

    public Object getValue() {
        return this.getModel().getValue();
    }

    protected Component createIncreaseButton() {
        return this.createArrowButton(1, this.increButtonHandler);
    }

    protected Component createDecreaseButton() {
        return this.createArrowButton(5, this.decreButtonHandler);
    }

    protected JComponent createEditor(SpinnerModel spinnerModel) {
        final JTextField jTextField = new JTextField();
        Document document = spinnerModel.getDocument();
        if (document != null) {
            jTextField.setDocument(document);
        }
        jTextField.setText(spinnerModel.getValue().toString());
        jTextField.addKeyListener(new KeyAdapter(){
            private Object oldValue;

            @Override
            public void keyReleased(KeyEvent keyEvent) {
                block4: {
                    this.oldValue = Spinner.this.getModel().getValue();
                    try {
                        Spinner.this.caretPosition = jTextField.getCaretPosition();
                        if (jTextField.getText().equals("") || "-".equals(jTextField.getText())) {
                            return;
                        }
                        Spinner.this.getModel().setValue(new Integer(jTextField.getText()));
                    }
                    catch (Exception exception) {
                        Spinner.this.getModel().setValue(this.oldValue);
                        if (!(Spinner.this.getModel() instanceof NumericSpinnerModel)) break block4;
                        ((NumericSpinnerModel)Spinner.this.getModel()).fireStateChanged(Spinner.this);
                    }
                }
                if (keyEvent.getKeyCode() == 38 || keyEvent.getKeyCode() == 40) {
                    keyEvent.consume();
                }
            }

            @Override
            public void keyPressed(KeyEvent keyEvent) {
                block7: {
                    this.oldValue = Spinner.this.getModel().getValue();
                    try {
                        Spinner.this.caretPosition = jTextField.getCaretPosition();
                        if (jTextField.getText().equals("") || "-".equals(jTextField.getText())) {
                            return;
                        }
                        Spinner.this.getModel().setValue(new Integer(jTextField.getText()));
                    }
                    catch (Exception exception) {
                        Spinner.this.getModel().setValue(this.oldValue);
                        if (!(Spinner.this.getModel() instanceof NumericSpinnerModel)) break block7;
                        ((NumericSpinnerModel)Spinner.this.getModel()).fireStateChanged(Spinner.this);
                    }
                }
                if (keyEvent.getKeyCode() == 38) {
                    Spinner.this.increButtonHandler.actionPerformed(null);
                } else if (keyEvent.getKeyCode() == 40) {
                    Spinner.this.decreButtonHandler.actionPerformed(null);
                }
                if (keyEvent.getKeyCode() == 38 || keyEvent.getKeyCode() == 40) {
                    keyEvent.consume();
                }
            }
        });
        jTextField.addFocusListener(new FocusListener(){
            private Object oldValue;

            @Override
            public void focusGained(FocusEvent focusEvent) {
                SpinnerModel spinnerModel = Spinner.this.getModel();
                this.oldValue = spinnerModel.getValue();
            }

            @Override
            public void focusLost(FocusEvent focusEvent) {
                Spinner.this.increButtonHandler.stopTimer();
                Spinner.this.decreButtonHandler.stopTimer();
                SpinnerModel spinnerModel = Spinner.this.getModel();
                try {
                    Spinner.this.caretPosition = jTextField.getCaretPosition();
                    Integer n = new Integer(jTextField.getText());
                    if (spinnerModel instanceof NumericSpinnerModel && !((NumericSpinnerModel)spinnerModel).isValid(n)) {
                        spinnerModel.setValue(this.oldValue);
                        return;
                    }
                    spinnerModel.setValue(n);
                }
                catch (Exception exception) {
                    Spinner.this.getModel().setValue(this.oldValue);
                    jTextField.setText(this.oldValue.toString());
                }
            }
        });
        return jTextField;
    }

    public JComponent getEditor() {
        return this.editor;
    }

    @Override
    public void stateChanged(ChangeEvent changeEvent) {
        if (this.editor instanceof JTextField) {
            ((JTextField)this.editor).setText(this.getValue().toString());
            if (null == ((JTextField)this.editor).getText() || "".equals(((JTextField)this.editor).getText())) {
                ((JTextField)this.editor).setCaretPosition(0);
            } else {
                ((JTextField)this.editor).setCaretPosition(this.caretPosition);
            }
        }
    }

    private Component createArrowButton(int n, ArrowButtonHandler arrowButtonHandler) {
        JButton jButton = null;
        jButton = n == 1 ? new JButton(new SpinnerTriangleIcon(this, Color.black, 0)) : new JButton(new SpinnerTriangleIcon(this, Color.black, 1));
        Dimension dimension = new Dimension(20, 10);
        jButton.setPreferredSize(dimension);
        jButton.setMinimumSize(new Dimension(20, 7));
        jButton.setMaximumSize(dimension);
        jButton.setFocusable(false);
        jButton.addActionListener(arrowButtonHandler);
        jButton.addMouseListener(arrowButtonHandler);
        return jButton;
    }

    @Override
    public void setEnabled(boolean bl) {
        super.setEnabled(bl);
        Component[] componentArray = this.getComponents();
        for (int i = 0; i < componentArray.length; ++i) {
            if (componentArray[i] == null) continue;
            componentArray[i].setEnabled(bl);
        }
    }

    @Override
    public void setToolTipText(String string) {
        this.toolTip = string;
        if (this.editor != null) {
            this.editor.setToolTipText(this.toolTip);
        }
    }

    private static class SpinnerLayout
    implements LayoutManager {
        private Component nextButton = null;
        private Component previousButton = null;
        private Component editor = null;

        private SpinnerLayout() {
        }

        @Override
        public void addLayoutComponent(String string, Component component) {
            if ("Next".equals(string)) {
                this.nextButton = component;
            } else if ("Previous".equals(string)) {
                this.previousButton = component;
            } else if ("Editor".equals(string)) {
                this.editor = component;
            }
        }

        @Override
        public void removeLayoutComponent(Component component) {
            if (component == this.nextButton) {
                component = null;
            } else if (component == this.previousButton) {
                this.previousButton = null;
            } else if (component == this.editor) {
                this.editor = null;
            }
        }

        private Dimension preferredSize(Component component) {
            return component == null ? zeroSize : component.getPreferredSize();
        }

        @Override
        public Dimension preferredLayoutSize(Container container) {
            Dimension dimension = this.preferredSize(this.nextButton);
            Dimension dimension2 = this.preferredSize(this.previousButton);
            Dimension dimension3 = this.preferredSize(this.editor);
            dimension3.height = (dimension3.height + 1) / 2 * 2;
            Dimension dimension4 = new Dimension(dimension3.width, dimension3.height);
            dimension4.width += Math.max(dimension.width, dimension2.width);
            Insets insets = container.getInsets();
            dimension4.width += insets.left + insets.right;
            dimension4.height += insets.top + insets.bottom;
            return dimension4;
        }

        @Override
        public Dimension minimumLayoutSize(Container container) {
            return this.preferredLayoutSize(container);
        }

        @Override
        public void layoutContainer(Container container) {
            int n;
            int n2;
            Insets insets = container.getInsets();
            int n3 = container.getHeight() - (insets.top + insets.bottom);
            int n4 = container.getWidth() - (insets.left + insets.right);
            int n5 = n3 / 2;
            int n6 = n3 - n5;
            int n7 = Math.max(this.preferredSize((Component)this.nextButton).width, this.preferredSize((Component)this.previousButton).width);
            int n8 = n4 - n7;
            if (container.getComponentOrientation().isLeftToRight()) {
                n2 = insets.left;
                n = n2 + n8;
            } else {
                n = insets.left;
                n2 = n + n7;
            }
            int n9 = insets.top + n5;
            this.setBounds(this.previousButton, n, n9, n7, n6);
            this.setBounds(this.editor, n2, insets.top, n8, n3);
            this.setBounds(this.nextButton, n, insets.top, n7, n5);
        }

        private void setBounds(Component component, int n, int n2, int n3, int n4) {
            if (null == component) {
                return;
            }
            component.setBounds(n, n2, n3, n4);
        }
    }

    private class ArrowButtonHandler
    extends AbstractAction
    implements MouseListener {
        final Timer autoRepeatTimer;
        final boolean isSpinDown;

        ArrowButtonHandler(String string, boolean bl) {
            super(string);
            this.isSpinDown = bl;
            this.autoRepeatTimer = new Timer(60, this);
            this.autoRepeatTimer.setInitialDelay(300);
        }

        public void stopTimer() {
            this.autoRepeatTimer.stop();
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            Object object;
            Spinner spinner = Spinner.this;
            Spinner.this.editor.requestFocusInWindow();
            Object object2 = object = this.isSpinDown ? spinner.spinDown() : spinner.spinUp();
            if (object != null) {
                Spinner.this.caretPosition = object.toString().length();
                spinner.setValue(object);
            }
        }

        @Override
        public void mousePressed(MouseEvent mouseEvent) {
            if (SwingUtilities.isLeftMouseButton(mouseEvent) && mouseEvent.getComponent().isEnabled()) {
                Spinner.this.editor.requestFocusInWindow();
                this.autoRepeatTimer.start();
            }
        }

        @Override
        public void mouseReleased(MouseEvent mouseEvent) {
            this.autoRepeatTimer.stop();
        }

        @Override
        public void mouseClicked(MouseEvent mouseEvent) {
        }

        @Override
        public void mouseEntered(MouseEvent mouseEvent) {
        }

        @Override
        public void mouseExited(MouseEvent mouseEvent) {
        }
    }
}

