/*
 * Decompiled with CFR 0.152.
 */
package com.swimap.iview.templates.spinbox;

import com.swimap.iview.templates.spinbox.AbstractSpinnerModel;
import com.swimap.iview.templates.textfield.IntegerDocument;
import javax.swing.text.Document;

public class NumericSpinnerModel
extends AbstractSpinnerModel {
    private Number stepSize = null;
    private Number value = null;
    private Comparable minimum = null;
    private Comparable maximum = null;
    private Document document = null;

    private NumericSpinnerModel(Number number, Comparable comparable, Comparable comparable2, Number number2) {
        if (number == null || number2 == null || comparable2 == null || comparable == null) {
            throw new IllegalArgumentException("value, minimum, maximum, stepSize can't be null.");
        }
        if (comparable.compareTo(number) > 0 || comparable2.compareTo(number) < 0) {
            throw new IllegalArgumentException("(minimum <= value <= maximum) is false");
        }
        this.stepSize = number2;
        this.value = number;
        this.minimum = comparable;
        this.maximum = comparable2;
        this.document = this.createDocument();
    }

    private Document createDocument() {
        if (this.minimum instanceof Number && this.maximum instanceof Number) {
            return new IntegerDocument(((Number)((Object)this.minimum)).intValue(), ((Number)((Object)this.maximum)).intValue());
        }
        return null;
    }

    public NumericSpinnerModel() {
        this((Number)0, Integer.valueOf(Integer.MIN_VALUE), Integer.valueOf(Integer.MAX_VALUE), (Number)1);
    }

    public NumericSpinnerModel(int n, int n2, int n3, int n4) {
        this((Number)n, Integer.valueOf(n2), Integer.valueOf(n3), (Number)n4);
    }

    @Override
    public Object spinUp() {
        return this.increase(1);
    }

    @Override
    public Object spinDown() {
        return this.increase(-1);
    }

    @Override
    public Object getValue() {
        return this.value;
    }

    private Object increase(int n) {
        Number number;
        if (this.value instanceof Float || this.value instanceof Double) {
            double d = this.value.doubleValue() + this.stepSize.doubleValue() * (double)n;
            number = this.value instanceof Float ? (Number)new Float(d) : (Number)d;
        } else {
            long l = this.value.longValue() + this.stepSize.longValue() * (long)n;
            number = this.value instanceof Long ? (Number)l : (Number)(this.value instanceof Integer ? (Number)((int)l) : (Number)(this.value instanceof Short ? (Number)((short)l) : (Number)((byte)l)));
        }
        if (null != this.maximum && this.maximum.compareTo(number) < 0) {
            number = this.minimum instanceof Number ? (Number)((Object)this.minimum) : null;
        }
        if (null != this.minimum && this.minimum.compareTo(number) > 0) {
            number = this.maximum instanceof Number ? (Number)((Object)this.maximum) : null;
        }
        return number;
    }

    @Override
    public void setValue(Object object) {
        if (object instanceof Number) {
            if (!object.equals(this.value)) {
                this.value = (Number)object;
                this.fireStateChanged();
            }
        } else {
            throw new IllegalArgumentException("Value can't be null, and must be instance of Number or String");
        }
    }

    @Override
    public Document getDocument() {
        return this.document;
    }

    boolean isValid(Number number) {
        return this.minimum.compareTo(number) <= 0 && this.maximum.compareTo(number) >= 0;
    }
}

