/*
 * Decompiled with CFR 0.152.
 */
package com.swimap.iview.templates.search;

import com.swimap.iview.commstyle.resource.ResourceMng;
import com.swimap.iview.templates.textmenu.FindDialog;
import com.swimap.iview.templates.textmenu.IFindNextListener;
import com.swimap.iview.util.OptionPane;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.Window;
import java.util.Arrays;
import java.util.List;
import java.util.ResourceBundle;
import javax.swing.JTree;
import javax.swing.SwingUtilities;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;

public class TreeSearch
implements IFindNextListener {
    private FindDialog dialog = null;
    private JTree searchTree = null;
    private boolean isSearchCaseSensitive = false;
    private boolean isWholeWordSelected = false;
    private String searchInput = "";
    private int direction = 0;
    private static ResourceBundle res = ResourceMng.getInstance().getResourceBundleFromPropertyFile("mainfrm/iview/templates/textmenu/Res");
    private TreeModel model = null;
    private TreePath selTreePath = null;
    private Object rootNode = null;

    public void showSearchDialog(Window window, String string, boolean bl, JTree jTree) {
        if (null == jTree) {
            throw new IllegalArgumentException("Tree cannot be null.");
        }
        this.searchTree = jTree;
        this.model = this.searchTree.getModel();
        if (null == this.model) {
            throw new IllegalArgumentException("Tree model is null");
        }
        this.rootNode = this.model.getRoot();
        if (null == this.rootNode) {
            throw new IllegalArgumentException("Root node must be non null.");
        }
        if (window instanceof Frame || null == window) {
            this.dialog = new FindDialog((Frame)window, string, bl);
        } else if (window instanceof Dialog) {
            this.dialog = new FindDialog((Dialog)window, string, bl);
        }
        this.dialog.addFindNextListener(this);
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                TreeSearch.this.dialog.setVisible(true);
            }
        });
    }

    @Override
    public void fireFindNextAction() {
        this.isSearchCaseSensitive = this.dialog.isMatchCaseSelected();
        this.isWholeWordSelected = this.dialog.isMatchWholeSelected();
        this.searchInput = this.dialog.getFindTextField().getText();
        this.direction = this.dialog.getFindDirection();
        this.performSearch();
        this.clear();
    }

    private void performSearch() {
        boolean bl = false;
        boolean bl2 = false;
        this.selTreePath = null;
        String string = null;
        TreePath treePath = null;
        if (null == this.searchTree.getSelectionPath()) {
            treePath = new TreePath(this.rootNode);
            if (!this.searchTree.isRootVisible() && this.model.getChildCount(this.rootNode) > 0) {
                treePath = treePath.pathByAddingChild(this.model.getChild(this.rootNode, 0));
            }
        } else {
            treePath = this.searchTree.getSelectionPath();
        }
        if (this.direction == 1) {
            while (null == this.selTreePath && treePath.getLastPathComponent() != this.rootNode) {
                this.selTreePath = this.getSibblings(treePath);
                if (null != this.selTreePath || !this.isSearchFound(string = (treePath = treePath.getParentPath()).getLastPathComponent().toString())) continue;
                this.selTreePath = treePath;
                bl = true;
                break;
            }
            bl2 = treePath.getLastPathComponent() == this.rootNode;
            treePath = this.selTreePath;
        }
        if (!bl && !bl2) {
            bl = this.findTreePath(treePath);
        }
        this.finishSearch(bl);
    }

    private boolean findTreePath(TreePath treePath) {
        boolean bl = false;
        String string = null;
        while (!bl) {
            if (this.searchTree.getSelectionPath() == treePath) {
                this.selTreePath = this.getTreeNode(treePath);
            } else {
                if (this.direction == 2 && this.isSearchFound(string = treePath.getLastPathComponent().toString())) {
                    this.selTreePath = treePath;
                    bl = true;
                    break;
                }
                this.selTreePath = this.getTreeNode(treePath);
            }
            if (null == this.selTreePath) {
                if (this.direction == 1 && this.isSearchFound(string = treePath.getLastPathComponent().toString())) {
                    this.selTreePath = treePath;
                    bl = true;
                    break;
                }
                bl = this.isNextSearchNodeFound(treePath);
                if (bl || null == this.selTreePath) break;
                treePath = this.selTreePath;
                continue;
            }
            bl = true;
            break;
        }
        return bl;
    }

    private boolean isNextSearchNodeFound(TreePath treePath) {
        while (null == this.selTreePath && treePath.getLastPathComponent() != this.rootNode) {
            String string;
            this.selTreePath = this.getSibblings(treePath);
            if (null != this.selTreePath) continue;
            TreePath treePath2 = treePath.getParentPath();
            if (this.direction == 1 && this.isSearchFound(string = treePath2.getLastPathComponent().toString())) {
                this.selTreePath = treePath2;
                return true;
            }
            treePath = treePath2;
        }
        return false;
    }

    private TreePath getSibblings(TreePath treePath) {
        TreePath treePath2 = treePath.getParentPath();
        if (null != treePath2) {
            Object object = treePath.getLastPathComponent();
            Object object2 = treePath2.getLastPathComponent();
            int n = this.model.getIndexOfChild(object2, object);
            if (this.direction == 2) {
                if (this.model.getChildCount(object2) > n + 1) {
                    return treePath2.pathByAddingChild(this.model.getChild(object2, n + 1));
                }
            } else if (n > 0) {
                return treePath2.pathByAddingChild(this.model.getChild(object2, n - 1));
            }
        }
        return null;
    }

    private TreePath getTreeNode(TreePath treePath) {
        Object object = treePath.getLastPathComponent();
        Object object2 = null;
        TreePath treePath2 = null;
        int n = -1;
        int n2 = this.model.getChildCount(object);
        for (int i = 0; i < n2; ++i) {
            object = treePath.getLastPathComponent();
            n = i;
            if (this.direction == 1) {
                n = n2 - i - 1;
            }
            if (this.isSearchFound((object2 = this.model.getChild(object, n)).toString())) {
                return treePath.pathByAddingChild(object2);
            }
            treePath2 = treePath.pathByAddingChild(object2);
            if (null == (treePath2 = this.getTreeNode(treePath2))) continue;
            return treePath2;
        }
        return null;
    }

    private void finishSearch(boolean bl) {
        if (!bl) {
            String string = null;
            string = this.searchTree.getSelectionPath() == null || !this.isSearchFound(this.searchTree.getSelectionPath().getLastPathComponent().toString()) ? res.getString("node_found") : res.getString("node_finish");
            this.promptNotFound(this.searchInput, string);
        } else if (!this.searchTree.isRootVisible() && this.selTreePath.equals(new TreePath(this.rootNode))) {
            this.finishSearch(false);
        } else {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    TreeSearch.this.searchTree.scrollPathToVisible(TreeSearch.this.selTreePath);
                    TreeSearch.this.searchTree.setSelectionPath(TreeSearch.this.selTreePath);
                }
            });
        }
    }

    private void promptNotFound(String string, String string2) {
        if (this.dialog.isVisible()) {
            OptionPane.showLineWrapOptionDialog(this.dialog, string2, 1, false);
        } else {
            OptionPane.showLineWrapOptionDialog(this.dialog.getParentWindow(), string2, 1, false);
        }
        this.dialog.getFindTextField().requestFocus();
        this.dialog.getFindTextField().selectAll();
    }

    private void clear() {
        this.isSearchCaseSensitive = false;
        this.isWholeWordSelected = false;
    }

    private boolean isSearchFound(String string) {
        return this.isMatchCaseSearch(string) && this.isMatchWholeWordSearch(string);
    }

    private boolean isMatchWholeWordSearch(String string) {
        boolean bl = false;
        if (this.isWholeWordSelected) {
            List<String> list;
            List<String> list2;
            String[] stringArray = string.toLowerCase().split(" ");
            String[] stringArray2 = this.searchInput.toLowerCase().split(" ");
            if (string.toLowerCase().indexOf(this.searchInput.toLowerCase()) != -1 && (list2 = Arrays.asList(stringArray)).containsAll(list = Arrays.asList(stringArray2))) {
                bl = true;
            }
        } else {
            bl = string.toLowerCase().indexOf(this.searchInput.toLowerCase()) != -1;
        }
        return bl;
    }

    private boolean isMatchCaseSearch(String string) {
        if (this.isSearchCaseSensitive) {
            return string.indexOf(this.searchInput) != -1;
        }
        return string.toLowerCase().indexOf(this.searchInput.toLowerCase()) != -1;
    }

    public void fireCancelAction() {
        this.dialog.dispose();
    }
}

