/*
 * Decompiled with CFR 0.152.
 */
package com.swimap.iview.templates.scrollbuttonpane;

import com.swimap.iview.templates.scrollbuttonpane.ScrollButtonPane;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.io.Serializable;
import java.util.ArrayList;
import javax.swing.JComponent;
import javax.swing.JViewport;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicArrowButton;
import javax.swing.plaf.basic.BasicScrollPaneUI;

public class ScrollButtonPaneUI
extends BasicScrollPaneUI {
    private static int EAST = 3;
    private static int WEST = 7;
    private String ARROW_RIGHT = "right";
    private String ARROW_LEFT = "left";
    private ScrollableButton rightArrow = null;
    private ScrollableButton leftArrow = null;
    private ScrollButtonPane scrollButtonPane = null;

    public static ComponentUI createUI(JComponent jComponent) {
        return new ScrollButtonPaneUI();
    }

    @Override
    public void installUI(JComponent jComponent) {
        this.scrollButtonPane = (ScrollButtonPane)jComponent;
        this.initButton();
        this.addListeners();
        this.scrollButtonPane.add(this.leftArrow);
        this.scrollButtonPane.add(this.rightArrow);
        this.leftArrow.setVisible(false);
        this.rightArrow.setVisible(false);
        this.scrollButtonPane.getViewport().addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent changeEvent) {
                JViewport jViewport = ScrollButtonPaneUI.this.scrollButtonPane.getViewport();
                Point point = jViewport.getViewPosition();
                JComponent jComponent = ScrollButtonPaneUI.this.scrollButtonPane.getButtonPanel();
                ArrayList arrayList = ScrollButtonPaneUI.this.scrollButtonPane.getButtonComps();
                if (arrayList == null || arrayList.size() <= 0) {
                    ScrollButtonPaneUI.this.leftArrow.setEnabled(false);
                    ScrollButtonPaneUI.this.rightArrow.setEnabled(false);
                    return;
                }
                Rectangle rectangle = jViewport.getViewRect();
                if (rectangle.width <= 0) {
                    ScrollButtonPaneUI.this.leftArrow.setEnabled(false);
                    ScrollButtonPaneUI.this.rightArrow.setEnabled(false);
                    return;
                }
                JComponent jComponent2 = (JComponent)arrayList.get(0);
                Point point2 = jComponent2.getLocation();
                Point point3 = SwingUtilities.convertPoint(jComponent2.getParent(), new Point(point2.x, point.y), jComponent);
                if (point.x <= point3.x) {
                    ScrollButtonPaneUI.this.leftArrow.setEnabled(false);
                } else {
                    ScrollButtonPaneUI.this.leftArrow.setEnabled(true);
                }
                int n = point.x + rectangle.width;
                JComponent jComponent3 = (JComponent)arrayList.get(arrayList.size() - 1);
                Point point4 = jComponent3.getLocation();
                Point point5 = SwingUtilities.convertPoint(jComponent3.getParent(), new Point(point4.x, point.y), jComponent);
                int n2 = point5.x + jComponent3.getSize().width;
                if (n2 > n) {
                    ScrollButtonPaneUI.this.rightArrow.setEnabled(true);
                } else {
                    ScrollButtonPaneUI.this.rightArrow.setEnabled(false);
                }
            }
        });
    }

    private void addListeners() {
        ArrayList arrayList = this.scrollButtonPane.getButtonComps();
        int n = arrayList.size();
        for (int i = 0; i < n; ++i) {
            FocusListener[] focusListenerArray;
            JComponent jComponent = (JComponent)arrayList.get(i);
            for (FocusListener focusListener : focusListenerArray = jComponent.getFocusListeners()) {
                if (!(focusListener instanceof focusHandler)) continue;
                jComponent.removeFocusListener(focusListener);
            }
            if (!jComponent.isFocusable()) continue;
            jComponent.addFocusListener(new focusHandler());
        }
    }

    @Override
    public void uninstallUI(JComponent jComponent) {
        this.removeListeners();
    }

    private void removeListeners() {
        ArrayList arrayList = this.scrollButtonPane.getButtonComps();
        for (Object e : arrayList) {
            FocusListener[] focusListenerArray;
            JComponent jComponent = (JComponent)e;
            for (FocusListener focusListener : focusListenerArray = jComponent.getFocusListeners()) {
                if (!(focusListener instanceof focusHandler)) continue;
                jComponent.removeFocusListener(focusListener);
            }
        }
    }

    private void initButton() {
        scrollBtnActionListener scrollBtnActionListener2 = new scrollBtnActionListener();
        this.rightArrow = new ScrollableButton(EAST);
        this.rightArrow.setName(this.ARROW_RIGHT);
        this.leftArrow = new ScrollableButton(WEST);
        this.leftArrow.setName(this.ARROW_LEFT);
        this.rightArrow.addActionListener(scrollBtnActionListener2);
        this.leftArrow.addActionListener(scrollBtnActionListener2);
    }

    private void scrollButtonRight() {
        Point point;
        Serializable serializable;
        Serializable serializable2;
        int n;
        JViewport jViewport = this.scrollButtonPane.getViewport();
        Point point2 = jViewport.getViewPosition();
        int n2 = point2.x;
        Dimension dimension = jViewport.getExtentSize();
        JComponent jComponent = this.scrollButtonPane.getButtonPanel();
        int n3 = n2;
        int n4 = 0;
        Component component = null;
        ArrayList arrayList = this.scrollButtonPane.getButtonComps();
        int n5 = arrayList.size();
        if (n5 > 0) {
            component = (Component)arrayList.get(0);
        }
        for (n = 0; n < n5; ++n) {
            n4 = n;
            serializable2 = (JComponent)arrayList.get(n);
            serializable = serializable2.getLocation();
            point = SwingUtilities.convertPoint(serializable2.getParent(), new Point(((Point)serializable).x, point2.y), jComponent);
            if (point.x >= n2 + dimension.width) break;
            n3 = point.x;
            component = serializable2;
        }
        if (null == component) {
            return;
        }
        n = 0;
        if (null != component.getParent() && component.equals((JComponent)component.getParent().getComponent(component.getParent().getComponentCount() - 1))) {
            n = ((JComponent)component).getParent().getInsets().right;
        }
        serializable2 = SwingUtilities.convertPoint(component.getParent(), new Point(component.getLocation().x + component.getPreferredSize().width + n, point2.y), jComponent);
        if (n3 + component.getPreferredSize().width <= n2 + dimension.width) {
            int n6;
            serializable = (JComponent)arrayList.get(n4);
            point = SwingUtilities.convertPoint(((Component)serializable).getParent(), new Point(((Component)serializable).getLocation().x, point2.y), jComponent);
            n2 = n2 + (point.x - ((Point)serializable2).x) + ((Component)serializable).getBounds().width;
            int n7 = ((Component)serializable).getParent().getComponentCount();
            if (serializable.equals((JComponent)((Component)serializable).getParent().getComponent(n7 - 1)) && (n6 = ((JComponent)serializable).getParent().getInsets().right) > 0) {
                n2 += n6;
            }
        } else {
            int n8;
            n2 = n3 + component.getPreferredSize().width - dimension.width;
            if (null != component.getParent() && component.equals((JComponent)component.getParent().getComponent(component.getParent().getComponentCount() - 1)) && (n8 = ((JComponent)component).getParent().getInsets().right) > 0) {
                n2 += n8;
            }
        }
        point2.x = n2;
        jViewport.setViewPosition(point2);
        jComponent.updateUI();
    }

    private void checkAndUpdateVisibility(JComponent jComponent) {
        if (jComponent.isVisible()) {
            int n;
            JComponent jComponent2 = this.scrollButtonPane.getButtonPanel();
            JViewport jViewport = this.scrollButtonPane.getViewport();
            Point point = jViewport.getViewPosition();
            int n2 = point.x;
            int n3 = point.y;
            Dimension dimension = jViewport.getExtentSize();
            Point point2 = jComponent.getLocation();
            Point point3 = SwingUtilities.convertPoint(jComponent.getParent(), new Point(point2.x, n3), jComponent2);
            int n4 = point3.x;
            boolean bl = false;
            double d = jComponent.getSize().getWidth();
            if (jComponent.equals((JComponent)jComponent.getParent().getComponent(0))) {
                n = jComponent.getInsets().left;
                if (n4 - n > 0) {
                    n4 -= n;
                    d += (double)n;
                } else {
                    d += (double)n4;
                    n4 = 0;
                }
            }
            if (jComponent.equals((JComponent)jComponent.getParent().getComponent(jComponent.getParent().getComponentCount() - 1))) {
                n = jComponent.getParent().getInsets().right;
                d += (double)n;
            }
            if (bl = !(dimension.getWidth() < d)) {
                if (n4 <= n2) {
                    n = n2 - n4;
                    n2 -= n;
                } else {
                    if ((double)n4 + d < (double)n2 + dimension.getWidth()) {
                        return;
                    }
                    if ((double)n4 <= (double)n2 + dimension.getWidth()) {
                        double d2 = (double)n4 + d - ((double)n2 + dimension.getWidth());
                        n2 += (int)d2;
                    } else {
                        double d3 = (double)n4 + d - ((double)n2 + dimension.getWidth());
                        n2 += (int)d3;
                    }
                }
            } else if (n4 <= n2) {
                n = n2 - n4;
                n2 -= n;
            } else {
                n = n4 - n2;
                n2 += n;
            }
            jViewport.setViewPosition(new Point(n2, n3));
            jComponent2.updateUI();
        }
    }

    private void scrollButtonleft() {
        JViewport jViewport = this.scrollButtonPane.getViewport();
        Point point = jViewport.getViewPosition();
        int n = point.x;
        JComponent jComponent = this.scrollButtonPane.getButtonPanel();
        ArrayList arrayList = this.scrollButtonPane.getButtonComps();
        int n2 = arrayList.size();
        int n3 = n;
        for (int i = 0; i < n2; ++i) {
            JComponent jComponent2 = (JComponent)arrayList.get(i);
            Point point2 = jComponent2.getLocation();
            Point point3 = SwingUtilities.convertPoint(jComponent2.getParent(), new Point(point2.x, point.y), jComponent);
            if (point3.x >= n) {
                if (point3.x != n || jComponent2.isVisible()) break;
                continue;
            }
            n3 = point3.x;
            if (i != 0) continue;
            n3 -= jComponent2.getInsets().left;
        }
        if (n3 < n) {
            n = n3 < 0 ? 0 : n3;
        }
        point.x = n;
        jViewport.setViewPosition(point);
        jComponent.updateUI();
    }

    @Override
    public void paint(Graphics graphics, JComponent jComponent) {
    }

    private class focusHandler
    implements FocusListener {
        private focusHandler() {
        }

        @Override
        public void focusGained(FocusEvent focusEvent) {
            JComponent jComponent = (JComponent)focusEvent.getComponent();
            ScrollButtonPaneUI.this.checkAndUpdateVisibility(jComponent);
        }

        @Override
        public void focusLost(FocusEvent focusEvent) {
        }
    }

    private class scrollBtnActionListener
    implements ActionListener {
        private scrollBtnActionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            if (actionEvent.getSource() == ScrollButtonPaneUI.this.rightArrow) {
                ScrollButtonPaneUI.this.scrollButtonRight();
            } else {
                ScrollButtonPaneUI.this.scrollButtonleft();
            }
        }
    }

    private class ScrollableButton
    extends BasicArrowButton {
        public ScrollableButton(int n) {
            super(n);
        }
    }
}

