/*
 * Decompiled with CFR 0.152.
 */
package com.swimap.iview.templates.scrollbuttonpane;

import com.swimap.iview.templates.scrollbuttonpane.ScrollButtonPaneUI;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.io.Serializable;
import java.util.ArrayList;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JToolBar;
import javax.swing.JViewport;
import javax.swing.plaf.ScrollPaneUI;

public class ScrollButtonPane
extends JComponent {
    private JViewport viewport = new JViewport();
    String VIEWPORT = "viewport";
    String ARROW_RIGHT = "right";
    String ARROW_LEFT = "left";
    private static final String UIClassID = "ScrollButtonPaneUI";
    private JComponent btnPanel;
    private ArrayList btnCompList = new ArrayList(10);
    private int totalWidthOfButtons = 0;

    public ScrollButtonPane(JComponent jComponent) {
        this.btnPanel = jComponent;
        this.updateCompList(this.btnPanel);
        this.setLayout(new scrollButtonPaneLayout());
        this.viewport.setName(this.VIEWPORT);
        this.viewport.add(jComponent);
        this.viewport.setOpaque(false);
        this.add(this.viewport);
        this.btnPanel.doLayout();
        if (this.btnPanel.getPreferredSize().width < this.totalWidthOfButtons) {
            int n = this.btnPanel.getPreferredSize().height;
            this.btnPanel.setPreferredSize(new Dimension(this.totalWidthOfButtons, n));
        }
        this.setPreferredSize(this.btnPanel.getPreferredSize());
        this.updateUI();
    }

    public JComponent getButtonPanel() {
        return this.btnPanel;
    }

    public ArrayList getButtonComps() {
        return (ArrayList)this.btnCompList.clone();
    }

    private void updateCompList(Component component) {
        int n = ((JComponent)component).getComponentCount();
        for (int i = 0; i < n; ++i) {
            Component component2 = ((JComponent)component).getComponent(i);
            if (!(component2 instanceof JPanel) && !(component2 instanceof JToolBar)) {
                this.btnCompList.add(component2);
                if (!component2.isVisible()) continue;
                this.totalWidthOfButtons += component2.getPreferredSize().width;
                continue;
            }
            this.updateCompList(component2);
        }
    }

    @Override
    public String getUIClassID() {
        return UIClassID;
    }

    @Override
    public ScrollButtonPaneUI getUI() {
        return (ScrollButtonPaneUI)this.ui;
    }

    public void setUI(ScrollButtonPaneUI scrollButtonPaneUI) {
        super.setUI(scrollButtonPaneUI);
    }

    @Override
    public void updateUI() {
        this.setUI((ScrollPaneUI)ScrollButtonPaneUI.createUI(this));
    }

    public JViewport getViewport() {
        return this.viewport;
    }

    class scrollButtonPaneLayout
    implements LayoutManager {
        scrollButtonPaneLayout() {
        }

        @Override
        public void removeLayoutComponent(Component component) {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void layoutContainer(Container container) {
            Object object = container.getTreeLock();
            synchronized (object) {
                Serializable serializable;
                int n = container.getBounds().width;
                int n2 = container.getComponentCount();
                Component component = null;
                Component component2 = null;
                Component component3 = null;
                for (int i = 0; i < n2; ++i) {
                    serializable = container.getComponent(i);
                    if (ScrollButtonPane.this.VIEWPORT.equals(serializable.getName())) {
                        component = serializable;
                    }
                    if (ScrollButtonPane.this.ARROW_RIGHT.equals(serializable.getName())) {
                        component2 = serializable;
                    }
                    if (!ScrollButtonPane.this.ARROW_LEFT.equals(serializable.getName())) continue;
                    component3 = serializable;
                }
                if (null == component || null == component2 || null == component3) {
                    return;
                }
                if (ScrollButtonPane.this.btnPanel.getPreferredSize().getWidth() <= (double)n) {
                    component.setSize(n, component.getPreferredSize().height);
                    component2.setVisible(false);
                    component3.setVisible(false);
                } else if (ScrollButtonPane.this.btnPanel.getPreferredSize().getWidth() > (double)n) {
                    Dimension dimension = component.getPreferredSize();
                    serializable = component2.getPreferredSize();
                    int n3 = n - ((Dimension)serializable).width * 2;
                    if (n3 < 0) {
                        n = ((Dimension)serializable).width * 2;
                    }
                    component.setSize(n - ((Dimension)serializable).width * 2, dimension.height);
                    int n4 = ((Dimension)serializable).height;
                    if (dimension.height - 2 * n4 < 0) {
                        n4 = dimension.height - ((Dimension)serializable).height;
                        n4 = n4 < 0 ? 0 : n4;
                    }
                    component2.setLocation(n - ((Dimension)serializable).width, n4);
                    component3.setLocation(n - ((Dimension)serializable).width * 2, n4);
                    component2.setSize(component2.getPreferredSize());
                    component3.setSize(component3.getPreferredSize());
                    component2.setVisible(true);
                    component3.setVisible(true);
                }
            }
        }

        @Override
        public void addLayoutComponent(String string, Component component) {
        }

        @Override
        public Dimension minimumLayoutSize(Container container) {
            Insets insets = container.getInsets();
            int n = insets.left + insets.right;
            int n2 = insets.top + insets.bottom;
            if (ScrollButtonPane.this.viewport != null) {
                Dimension dimension = ScrollButtonPane.this.viewport.getMinimumSize();
                n += dimension.width;
                n2 += dimension.height;
            }
            return new Dimension(n, n2);
        }

        @Override
        public Dimension preferredLayoutSize(Container container) {
            Insets insets = container.getInsets();
            int n = insets.left + insets.right;
            int n2 = insets.top + insets.bottom;
            Dimension dimension = null;
            if (ScrollButtonPane.this.viewport != null) {
                dimension = ScrollButtonPane.this.viewport.getPreferredSize();
            }
            if (dimension != null) {
                n += dimension.width;
                n2 += dimension.height;
            }
            return new Dimension(n, n2);
        }
    }
}

