/*
 * Decompiled with CFR 0.152.
 */
package com.swimap.iview.templates.propertyform;

import com.swimap.iview.commstyle.resource.i18n.ResourceUtil;
import com.swimap.iview.templates.propertyform.IPropertyFormStyleInterface;
import com.swimap.iview.templates.propertyform.PropertyFormStyleInformation;
import com.swimap.iview.templates.propertyform.PropertyFormStyleInformationManager;
import com.swimap.iview.templates.propertyform.xml.AssociatedProperty;
import com.swimap.iview.templates.propertyform.xml.BackgroundColor;
import com.swimap.iview.templates.propertyform.xml.ForegroundColor;
import com.swimap.iview.templates.propertyform.xml.GeneralProperties;
import com.swimap.iview.templates.propertyform.xml.IViewPropertyForm;
import com.swimap.iview.templates.propertyform.xml.PropertyAssociation;
import com.swimap.iview.templates.propertyform.xml.PropertyListener;
import com.swimap.iview.templates.propertyform.xml.SimpleProperties;
import com.swimap.iview.util.CommonUtil;
import com.swimap.iview.util.DebugTracer;
import com.swimap.iview.util.log.IviewLogger;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.net.URL;

public class PropertyFormXMLFileReader {
    private static IviewLogger logger = IviewLogger.getLogger(PropertyFormXMLFileReader.class, "IVIEW");
    private static final String debugTracerFile = "./propertyform_xml_traces.txt";
    private static final String errorMessageFile = "./propertyform_xml_errors.err";
    private boolean validity = false;
    public PropertyFormStyleInformation thePropertyFormStyleInformation = null;
    public PropertyFormStyleInformationManager thePropertyFormStyleInformationManager = null;

    public boolean readXMLFile(String string) throws IOException {
        try {
            string = CommonUtil.getAbsolutePath(string);
            File file = new File(string);
            URL uRL = file.toURL();
            IViewPropertyForm iViewPropertyForm = IViewPropertyForm.unmarshal(uRL);
            this.validity = iViewPropertyForm.isValid();
            if (this.validity) {
                SimpleProperties[] simplePropertiesArray = iViewPropertyForm.getSimpleProperties();
                GeneralProperties generalProperties = iViewPropertyForm.getGeneralProperties();
                PropertyListener[] propertyListenerArray = null;
                String[] stringArray = new String[simplePropertiesArray.length];
                String[] stringArray2 = new String[simplePropertiesArray.length];
                String[] stringArray3 = new String[simplePropertiesArray.length];
                String[] stringArray4 = new String[simplePropertiesArray.length];
                String[][] stringArray5 = new String[simplePropertiesArray.length][];
                String[] stringArray6 = new String[simplePropertiesArray.length];
                for (int i = 0; i < simplePropertiesArray.length; ++i) {
                    int n;
                    stringArray[i] = simplePropertiesArray[i].getPropertyName();
                    for (n = 0; n < i; ++n) {
                        if (!ResourceUtil.areEquals(stringArray[i], stringArray[n])) continue;
                        throw new Exception("The property form cannot contain more than one properties called " + stringArray[i]);
                    }
                    stringArray2[i] = simplePropertiesArray[i].getCellRenderer();
                    stringArray3[i] = simplePropertiesArray[i].getCellEditor();
                    stringArray4[i] = simplePropertiesArray[i].getEditable();
                    stringArray6[i] = simplePropertiesArray[i].getChangeNotification();
                    propertyListenerArray = simplePropertiesArray[i].getPropertyListener();
                    stringArray5[i] = new String[propertyListenerArray.length];
                    for (n = 0; n < propertyListenerArray.length; ++n) {
                        stringArray5[i][n] = propertyListenerArray[n].getListenerName();
                    }
                }
                this.thePropertyFormStyleInformation = new PropertyFormStyleInformation();
                this.thePropertyFormStyleInformation.setPropertyCount(stringArray.length);
                this.thePropertyFormStyleInformation.setPropertyNames(stringArray);
                this.thePropertyFormStyleInformation.setPropertyCellRenderers(stringArray2);
                this.thePropertyFormStyleInformation.setPropertyCellEditors(stringArray3);
                this.thePropertyFormStyleInformation.setPropertyEditable(stringArray4);
                this.thePropertyFormStyleInformation.setPropertyListeners(stringArray5);
                this.thePropertyFormStyleInformation.setNotificationMessages(stringArray6);
                PropertyAssociation[] propertyAssociationArray = iViewPropertyForm.getPropertyAssociation();
                AssociatedProperty[] associatedPropertyArray = null;
                String[] stringArray7 = null;
                String string2 = null;
                for (int i = 0; i < propertyAssociationArray.length; ++i) {
                    string2 = propertyAssociationArray[i].getAssociationId();
                    associatedPropertyArray = propertyAssociationArray[i].getAssociatedProperty();
                    stringArray7 = new String[associatedPropertyArray.length];
                    for (int j = 0; j < associatedPropertyArray.length; ++j) {
                        stringArray7[j] = associatedPropertyArray[j].getName();
                    }
                    this.thePropertyFormStyleInformation.addAssociation(string2, stringArray7);
                }
                if (generalProperties != null) {
                    String[] stringArray8;
                    BackgroundColor backgroundColor = generalProperties.getBackgroundColor();
                    ForegroundColor foregroundColor = generalProperties.getForegroundColor();
                    if (backgroundColor != null) {
                        stringArray8 = new String[]{backgroundColor.getR(), backgroundColor.getG(), backgroundColor.getB()};
                        this.thePropertyFormStyleInformation.setBackgroundColor(stringArray8);
                    }
                    if (foregroundColor != null) {
                        stringArray8 = new String[]{foregroundColor.getR(), foregroundColor.getG(), foregroundColor.getB()};
                        this.thePropertyFormStyleInformation.setForegroundColor(stringArray8);
                    }
                }
                if (this.thePropertyFormStyleInformation.isErrorEncountered()) {
                    logger.trace("Errors were encountered while reading the XML file. However, the style information object has been created.Check the Log files (./propertyform_xml_traces.txt  and  ./propertyform_xml_errors.err) for mode details");
                }
            }
        }
        catch (Exception exception) {
            this.validity = false;
            logger.warn("Exception while reading style information object: " + exception);
        }
        return this.validity;
    }

    public boolean isInformationValid() {
        return this.validity;
    }

    public boolean saveInformation(IPropertyFormStyleInterface iPropertyFormStyleInterface) {
        boolean bl = this.validity & iPropertyFormStyleInterface != null & this.thePropertyFormStyleInformation != null;
        if (bl) {
            try {
                iPropertyFormStyleInterface.saveInformation(this.thePropertyFormStyleInformation);
            }
            catch (NullPointerException nullPointerException) {
                bl = false;
                logger.warn("Exception while saving style information object: " + nullPointerException);
            }
            catch (Exception exception) {
                bl = false;
                logger.warn("Exception while saving style information object: " + exception);
            }
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] stringArray) throws Exception {
        PrintStream printStream = null;
        FileOutputStream fileOutputStream = null;
        try {
            fileOutputStream = new FileOutputStream(errorMessageFile);
            printStream = new PrintStream(fileOutputStream, true);
            System.setErr(printStream);
            DebugTracer.setOutputFileName(debugTracerFile);
            DebugTracer.setDisplayMode(false);
        }
        catch (Exception exception) {
        }
        finally {
            if (null != fileOutputStream) {
                try {
                    fileOutputStream.close();
                }
                catch (IOException iOException) {
                    logger.warn(iOException.getMessage(), iOException);
                }
            }
            if (null != printStream) {
                printStream.close();
            }
        }
        if (stringArray.length == 2) {
            String string = stringArray[0];
            String string2 = stringArray[1];
            logger.debug("Reading XML file: " + string);
            PropertyFormXMLFileReader propertyFormXMLFileReader = new PropertyFormXMLFileReader();
            boolean bl = propertyFormXMLFileReader.readXMLFile(string);
            if (bl) {
                logger.debug("Finished Reading the XML file");
                logger.debug("Verifying XML information...");
            } else {
                logger.warn(" failed reading the XML file" + string);
            }
            if (propertyFormXMLFileReader.isInformationValid()) {
                logger.debug("Information is valid");
                logger.debug("Saving information in " + string2);
                PropertyFormStyleInformationManager propertyFormStyleInformationManager = new PropertyFormStyleInformationManager(string2);
                if (propertyFormXMLFileReader.saveInformation(propertyFormStyleInformationManager)) {
                    logger.debug("Style information object has been saved");
                    System.out.println("Property form style information object has been saved");
                } else {
                    logger.debug("Style information object has NOT been saved");
                    System.out.println("Property form style information object has NOT been saved. Check the Log files (./propertyform_xml_traces.txt  and  ./propertyform_xml_errors.err) for mode details");
                }
            } else {
                logger.warn("Information is invalid!!");
                System.out.println("Reading FAILED. Invalid Information. Check the Log files (./propertyform_xml_traces.txt  and  ./propertyform_xml_errors.err) for mode details");
            }
        } else {
            System.out.println("Usage: java com.swimap.iview.templates.table.PropertyFormXMLFileReader <Source XML File Name> <Destination Object File name>");
        }
        System.exit(0);
    }
}

