/*
 * Decompiled with CFR 0.152.
 */
package com.swimap.iview.templates.propertyform;

import com.swimap.iview.templates.extendedtable.TableSorter;
import com.swimap.iview.templates.propertyform.ICellChangeListener;
import com.swimap.iview.templates.propertyform.IEditorInterface;
import com.swimap.iview.templates.propertyform.INotifyInterface;
import com.swimap.iview.templates.propertyform.IPropertyFormListener;
import com.swimap.iview.templates.propertyform.IPropertyFormStyleInterface;
import com.swimap.iview.templates.propertyform.IRendererInterface;
import com.swimap.iview.templates.propertyform.PropertyFormCellEditor;
import com.swimap.iview.templates.propertyform.PropertyFormCellRenderer;
import com.swimap.iview.templates.propertyform.PropertyFormDefaultEditor;
import com.swimap.iview.templates.propertyform.PropertyFormStyleInformation;
import com.swimap.iview.templates.propertyform.PropertyFormTableModelEx;
import com.swimap.iview.templates.table.TableTemplate;
import com.swimap.iview.util.log.IviewLogger;
import java.awt.Color;
import java.awt.Component;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EventObject;
import java.util.Hashtable;
import java.util.List;
import java.util.NoSuchElementException;
import javax.swing.JTable;
import javax.swing.KeyStroke;
import javax.swing.UIManager;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.JTableHeader;

public class PropertyFormTemplate
extends TableTemplate {
    private static IviewLogger logger = IviewLogger.getLogger(PropertyFormTemplate.class, "IVIEW");
    public static final int NAME_COLUMN = 0;
    public static final int VALUE_COLUMN = 1;
    private PropertyFormStyleInformation styleInformation = null;
    private INotifyInterface messageBoard = null;
    private Hashtable listeners = null;
    private List<ICellChangeListener> cellChangeListeners = null;
    protected PropertyFormCellRenderer thePropertyFormCellRenderer = null;
    protected PropertyFormCellEditor thePropertyFormCellEditor = null;
    private Hashtable necessaryPropertyName = new Hashtable(11);
    private DefaultTableCellRenderer render = new TableModelRenderer();
    private boolean isShowToolTip = false;
    private int selectedRow = 0;
    private int selectedColumn = 1;
    private boolean isHaveEditableCell = false;

    public PropertyFormTemplate(PropertyFormStyleInformation propertyFormStyleInformation) {
        this.setSurrendersFocusOnKeystroke(true);
        this.putClientProperty("JTable.autoStartsEdit", Boolean.TRUE);
        this.initializePropertyForm();
        this.setPropertyFormInformation(propertyFormStyleInformation);
        this.setFirstEditabledCellSellected();
        this.registerSelectionListener();
    }

    public PropertyFormTemplate(IPropertyFormStyleInterface iPropertyFormStyleInterface) throws ClassCastException, ClassNotFoundException, IOException, SecurityException {
        this.setSurrendersFocusOnKeystroke(true);
        this.putClientProperty("JTable.autoStartsEdit", Boolean.TRUE);
        this.initializePropertyForm();
        try {
            this.setPropertyFormInformation(iPropertyFormStyleInterface.loadInformation());
        }
        catch (NullPointerException nullPointerException) {
            logger.error("Error while loading persisted object: " + nullPointerException);
            throw nullPointerException;
        }
        catch (ClassCastException classCastException) {
            logger.error("Error while loading persisted object: " + classCastException);
            throw classCastException;
        }
        catch (ClassNotFoundException classNotFoundException) {
            logger.error("Error while loading persisted object: " + classNotFoundException);
            throw classNotFoundException;
        }
        catch (IOException iOException) {
            logger.error("Error while loading persisted object: " + iOException);
            throw iOException;
        }
        catch (SecurityException securityException) {
            logger.error("Error while loading persisted object: " + securityException);
            throw securityException;
        }
        catch (Exception exception) {
            logger.error("Error while loading persisted object: " + exception);
        }
        this.registerSelectionListener();
    }

    public void setHasFocusColor(Color color) {
        this.thePropertyFormCellRenderer.setHasFocusColor(color);
    }

    public void setFirstEditabledCellSellected() {
        this.setSelectionMode(0);
        int n = this.getRowCount();
        for (int i = 0; i < n; ++i) {
            if (!this.isCellEditable(i, 1)) continue;
            this.setColumnSelectionInterval(1, 1);
            this.setRowSelectionInterval(i, i);
            this.selectedRow = i;
            break;
        }
    }

    private void registerSelectionListener() {
        this.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                if (listSelectionEvent.getValueIsAdjusting()) {
                    PropertyFormTemplate.this.stopEditing();
                }
                if (PropertyFormTemplate.this.getSelectedColumn() < 0) {
                    PropertyFormTemplate.this.setColumnSelectionInterval(PropertyFormTemplate.this.selectedColumn, PropertyFormTemplate.this.selectedColumn);
                } else {
                    PropertyFormTemplate.this.selectedColumn = PropertyFormTemplate.this.getSelectedColumn();
                }
                if (PropertyFormTemplate.this.getSelectedRow() < 0) {
                    PropertyFormTemplate.this.setRowSelectionInterval(PropertyFormTemplate.this.selectedRow, PropertyFormTemplate.this.selectedRow);
                } else {
                    PropertyFormTemplate.this.selectedRow = PropertyFormTemplate.this.getSelectedRow();
                }
            }
        });
    }

    @Override
    protected void registerListeners() {
    }

    private void initializePropertyForm() {
        this.setModel(new PropertyFormTableModelEx());
        this.setShowConfig(false);
        this.listeners = new Hashtable(11);
        this.thePropertyFormCellRenderer = new PropertyFormCellRenderer();
        this.thePropertyFormCellEditor = new PropertyFormCellEditor(this);
        this.setRowSelectionAllowed(false);
        this.setColumnSelectionAllowed(false);
        JTableHeader jTableHeader = this.getTableHeader();
        if (jTableHeader == null) {
            jTableHeader = this.createDefaultTableHeader();
        }
        jTableHeader.setReorderingAllowed(false);
    }

    void fireCellValueChange(Object object, Object object2) {
        if (null != this.cellChangeListeners && this.cellChangeListeners.size() > 0) {
            try {
                if (TableSorter.compareTwoValues(object, object2) != 0) {
                    int n = this.cellChangeListeners.size();
                    int n2 = ((PropertyFormTableModelEx)this.getModel()).getPropertyIndexFromTableIndex(this.getSelectedRow());
                    String string = this.styleInformation.getPropertyNames()[n2];
                    for (int i = 0; i < n; ++i) {
                        logger.trace(" Notification sent  to " + this.cellChangeListeners.get(i));
                        this.cellChangeListeners.get(i).valueChanged(string, object2, object);
                    }
                }
            }
            catch (Exception exception) {
                logger.debug("Error in notification");
            }
        }
    }

    public PropertyFormStyleInformation getPropertyFormInformation() {
        return this.styleInformation;
    }

    public void setPropertyFormInformation(PropertyFormStyleInformation propertyFormStyleInformation) {
        this.styleInformation = propertyFormStyleInformation;
        String[] stringArray = propertyFormStyleInformation.getPropertyNames();
        IRendererInterface[] iRendererInterfaceArray = propertyFormStyleInformation.getPropertyCellRenderers();
        IEditorInterface[] iEditorInterfaceArray = propertyFormStyleInformation.getPropertyCellEditors();
        IPropertyFormListener[][] iPropertyFormListenerArray = propertyFormStyleInformation.getPropertyListeners();
        PropertyFormTableModelEx propertyFormTableModelEx = (PropertyFormTableModelEx)this.getModel();
        PropertyFormDefaultEditor propertyFormDefaultEditor = null;
        int n = propertyFormStyleInformation.getPropertyCount();
        for (int i = 0; i < n; ++i) {
            propertyFormTableModelEx.addProperty(stringArray[i], "", true);
            if (null != iRendererInterfaceArray[i]) {
                this.thePropertyFormCellRenderer.addCellRenderer(stringArray[i], iRendererInterfaceArray[i]);
            }
            if (null == iEditorInterfaceArray[i]) {
                if (null == propertyFormDefaultEditor) {
                    propertyFormDefaultEditor = new PropertyFormDefaultEditor();
                }
                this.thePropertyFormCellEditor.addCellEditor(stringArray[i], propertyFormDefaultEditor);
            } else {
                this.thePropertyFormCellEditor.addCellEditor(stringArray[i], iEditorInterfaceArray[i]);
            }
            this.listeners.put(stringArray[i], new ArrayList(11));
            for (int j = 0; iPropertyFormListenerArray[i] != null && j < iPropertyFormListenerArray[i].length; ++j) {
                if (iPropertyFormListenerArray[i][j] == null) continue;
                this.addListener(stringArray[i], iPropertyFormListenerArray[i][j]);
            }
        }
        this.setBackground(propertyFormStyleInformation.getBackgroundColor());
        this.setForeground(propertyFormStyleInformation.getForegroundColor());
        this.getColumnModel().getColumn(1).setCellRenderer(this.thePropertyFormCellRenderer);
        this.getColumnModel().getColumn(1).setCellEditor(this.thePropertyFormCellEditor);
    }

    public void setPropertyRenderer(String string, IRendererInterface iRendererInterface) throws NoSuchElementException {
        this.thePropertyFormCellRenderer.addCellRenderer(string, iRendererInterface);
    }

    @Override
    protected boolean processKeyBinding(KeyStroke keyStroke, KeyEvent keyEvent, int n, boolean bl) {
        int n2;
        this.isHaveEditableCell = false;
        int n3 = this.styleInformation.isPropertyEditable().length;
        for (n2 = 0; n2 < n3; ++n2) {
            if (!this.styleInformation.isPropertyEditable()[n2]) continue;
            this.isHaveEditableCell = true;
            break;
        }
        if (this.isHaveEditableCell && keyEvent.getID() == 401) {
            if (keyEvent.getKeyCode() == 9 && keyEvent.isShiftDown() || keyEvent.getKeyCode() == 38) {
                n2 = this.getSelectedRow();
                n3 = this.getSelectedColumn();
                this.stopEditing();
                this.setColumnSelectionInterval(n3, n3);
                this.setRowSelectionInterval(n2, n2);
                this.onlyMoveFocusToPreviousCell();
                return true;
            }
            if (keyEvent.getKeyCode() == 10 || keyEvent.getKeyCode() == 40 || keyEvent.getKeyCode() == 9) {
                n2 = this.getSelectedRow();
                n3 = this.getSelectedColumn();
                this.stopEditing();
                this.setColumnSelectionInterval(n3, n3);
                this.setRowSelectionInterval(n2, n2);
                this.onlyMoveFocusToNextCell();
                return true;
            }
        }
        return super.processKeyBinding(keyStroke, keyEvent, n, bl);
    }

    public void setPropertyEditor(String string, IEditorInterface iEditorInterface) throws NoSuchElementException {
        this.thePropertyFormCellEditor.addCellEditor(string, iEditorInterface);
    }

    public void addListener(String string, IPropertyFormListener iPropertyFormListener) {
        if (iPropertyFormListener != null) {
            ArrayList arrayList = (ArrayList)this.listeners.get(string);
            arrayList.add(iPropertyFormListener);
        }
    }

    public void removeListener(String string, IPropertyFormListener iPropertyFormListener) throws NoSuchElementException {
        if (this.listeners.remove(string) == null) {
            logger.error("Element " + string + "does not have any listener registered to it");
            throw new NoSuchElementException("Property named " + string + " doesn't have any listener registered to it");
        }
    }

    public void addCellChangeListener(ICellChangeListener iCellChangeListener) {
        if (null == iCellChangeListener) {
            return;
        }
        if (null == this.cellChangeListeners) {
            this.cellChangeListeners = Collections.synchronizedList(new ArrayList(10));
        }
        this.cellChangeListeners.add(iCellChangeListener);
    }

    public void removeCellChangeListener(ICellChangeListener iCellChangeListener) {
        if (null == iCellChangeListener) {
            return;
        }
        if (null != this.cellChangeListeners) {
            this.cellChangeListeners.remove(iCellChangeListener);
        }
    }

    public void setPropertyValue(String string, Object object) throws NoSuchElementException {
        this.setPropertyValue(this.styleInformation.getPropertyIndex(string), object);
    }

    public Object getPropertyValue(String string) throws NoSuchElementException {
        return this.getPropertyValue(this.styleInformation.getPropertyIndex(string));
    }

    public void setPropertyValue(int n, Object object) throws NoSuchElementException {
        if (n < 0 || n >= this.styleInformation.getPropertyCount()) {
            logger.error("Property index (" + n + ") not found in property list");
            throw new NoSuchElementException(n + " not found in property list");
        }
        PropertyFormTableModelEx propertyFormTableModelEx = (PropertyFormTableModelEx)this.dataModel;
        propertyFormTableModelEx.setPropertyValue(n, object);
    }

    public Object getPropertyValue(int n) throws NoSuchElementException {
        if (null != this.cellEditor) {
            this.cellEditor.stopCellEditing();
        }
        if (n < 0 || n >= this.styleInformation.getPropertyCount()) {
            logger.error("Property index (" + n + ") not found in property list");
            throw new NoSuchElementException(n + " not found in property list");
        }
        PropertyFormTableModelEx propertyFormTableModelEx = (PropertyFormTableModelEx)this.getModel();
        return propertyFormTableModelEx.getPropertyValue(n, 1);
    }

    public void stopEditing() {
        this.thePropertyFormCellEditor.fireEditingStopped();
        if (this.cellEditor != null) {
            this.cellEditor.stopCellEditing();
        }
    }

    public IRendererInterface getPropertyRenderer(String string) {
        return this.thePropertyFormCellRenderer.getCellRenderer(string);
    }

    public IEditorInterface getPropertyEditor(String string) {
        return this.thePropertyFormCellEditor.getCellEditor(string);
    }

    public boolean removePropertyRenderer(String string) {
        return this.thePropertyFormCellRenderer.removeCellRenderer(string);
    }

    public boolean removePropertyEditor(String string) {
        return this.thePropertyFormCellEditor.removeCellEditor(string);
    }

    @Override
    public boolean isCellEditable(int n, int n2) {
        PropertyFormTableModelEx propertyFormTableModelEx = (PropertyFormTableModelEx)this.dataModel;
        int n3 = propertyFormTableModelEx.getPropertyIndexFromTableIndex(n);
        return n2 == 1 & this.styleInformation.isPropertyEditable()[n3];
    }

    @Override
    public void setValueAt(Object object, int n, int n2) {
        int n3;
        PropertyFormTableModelEx propertyFormTableModelEx = (PropertyFormTableModelEx)this.getModel();
        Object object2 = propertyFormTableModelEx.getPropertyValue(n3 = propertyFormTableModelEx.getPropertyIndexFromTableIndex(n), n2);
        if (!(object == object2 || object != null && object.equals(object2))) {
            propertyFormTableModelEx.setValueAt(object, n, n2);
            if (n2 == 1) {
                this.firePropertyChanged(n3, object);
            }
        }
    }

    protected void firePropertyChanged(int n, Object object) {
        Object object2;
        String string = this.styleInformation.getPropertyNames()[n];
        Object v = this.listeners.get(string);
        if (v != null) {
            object2 = (ArrayList)v;
            int n2 = ((ArrayList)object2).size();
            for (int i = 0; i < n2; ++i) {
                ((IPropertyFormListener)((ArrayList)object2).get(i)).valueChanged(this, string, object);
            }
        }
        object2 = this.styleInformation.getNotificationMessages()[n];
        if (this.messageBoard != null && object2 != null && !"".equals(((String)object2).trim())) {
            this.messageBoard.displayNotificationMessage(this, (String)object2);
        }
    }

    public void setNotificationDisplay(INotifyInterface iNotifyInterface) {
        this.messageBoard = iNotifyInterface;
    }

    public INotifyInterface getNotificationDisplay() {
        return this.messageBoard;
    }

    public void addProperty(String string) {
        if (this.styleInformation.contains(string)) {
            return;
        }
        int n = this.styleInformation.getPropertyCount();
        this.thePropertyFormCellEditor.addCellEditor(string, new PropertyFormDefaultEditor());
        this.styleInformation.insertProperty(string, n);
        ((PropertyFormTableModelEx)this.dataModel).addProperty(string, null, true);
    }

    public boolean insertProperty(String string, int n) {
        boolean bl;
        boolean bl2 = bl = !this.styleInformation.contains(string);
        if (bl) {
            if (n < 0) {
                n = 0;
            } else if (n > this.styleInformation.getPropertyCount()) {
                n = this.getModel().getRowCount() - 1;
            }
            DefaultTableModel defaultTableModel = (DefaultTableModel)this.getModel();
            Object[] objectArray = new String[]{string, ""};
            defaultTableModel.insertRow(n, objectArray);
            this.thePropertyFormCellEditor.addCellEditor(string, new PropertyFormDefaultEditor());
            this.styleInformation.insertProperty(string, n);
        }
        return bl;
    }

    public boolean updateProperty(String string, String string2) throws NoSuchElementException {
        boolean bl = this.styleInformation.contains(string) & !this.styleInformation.contains(string2);
        if (bl) {
            this.setValueAt(string2, this.styleInformation.getPropertyIndex(string), 0);
            this.styleInformation.updateProperty(string, string2);
            this.thePropertyFormCellEditor.propertyNameChanged(string, string2);
            this.thePropertyFormCellRenderer.propertyNameChanged(string, string2);
        }
        return bl;
    }

    public void removeProperty(String string) throws NoSuchElementException {
        int n = this.styleInformation.getPropertyIndex(string);
        this.thePropertyFormCellEditor.removeCellEditor(string);
        this.thePropertyFormCellRenderer.removeCellRenderer(string);
        this.styleInformation.removeProperty(string);
        ((PropertyFormTableModelEx)this.dataModel).removeProperty(n);
    }

    public void setPropertyStatus(String string, boolean bl) throws NoSuchElementException {
        this.styleInformation.setPropertyEditable(string, bl);
        this.setFirstEditabledCellSellected();
    }

    public void setVisible(int n, boolean bl) {
        PropertyFormTableModelEx propertyFormTableModelEx = (PropertyFormTableModelEx)this.dataModel;
        propertyFormTableModelEx.setVisible(n, bl);
    }

    public boolean isVisible(int n) {
        return ((PropertyFormTableModelEx)this.dataModel).isVisible(n);
    }

    public int getPropertyIndex(String string) throws NoSuchElementException {
        return this.styleInformation.getPropertyIndex(string);
    }

    public void setVisible(Object object, boolean bl) {
        logger.debug("setVisible is a blank method" + object.toString() + bl);
    }

    protected void registerTabKeyListener() {
        ActionListener actionListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                PropertyFormTemplate.this.moveFocusToNextCell();
            }
        };
        KeyStroke keyStroke = KeyStroke.getKeyStroke(9, 0, false);
        this.unregisterKeyboardAction(keyStroke);
        this.registerKeyboardAction(actionListener, "TAB", keyStroke, 0);
    }

    protected void moveFocusToNextCell() {
        Rectangle rectangle;
        int n = this.getNextEditabledCellIndex();
        if (this.getAutoscrolls() && (rectangle = this.getCellRect(n, 0, false)) != null) {
            this.scrollRectToVisible(rectangle);
        }
        this.editDisplayPropertyAt(n);
    }

    private void onlyMoveFocusToNextCell() {
        Rectangle rectangle;
        int n = this.getNextEditabledCellIndex();
        if (this.getAutoscrolls() && (rectangle = this.getCellRect(n, 0, false)) != null) {
            this.scrollRectToVisible(rectangle);
        }
        this.setRowSelectionInterval(n, n);
        this.setColumnSelectionInterval(1, 1);
    }

    private void onlyMoveFocusToPreviousCell() {
        Rectangle rectangle;
        int n;
        int n2 = this.getRowCount();
        int n3 = n = this.getSelectedRow();
        for (int i = n2; i >= 0; --i) {
            if (n - 1 < 0) {
                n = n2;
            }
            if (!this.isCellEditable(--n, 1)) continue;
            n3 = n;
            break;
        }
        if (this.getAutoscrolls() && (rectangle = this.getCellRect(n3, 0, false)) != null) {
            this.scrollRectToVisible(rectangle);
        }
        this.setRowSelectionInterval(n3, n3);
        this.setColumnSelectionInterval(1, 1);
    }

    private int getNextEditabledCellIndex() {
        int n;
        int n2 = this.getRowCount();
        int n3 = this.getSelectedRow();
        int n4 = n3 = n3 == -1 ? 0 : n3;
        int n5 = n = this.getSelectedColumn() == 1 ? 1 : 0;
        while (n < n2) {
            if (this.isCellEditable((n3 + n) % n2, 1)) {
                n4 = (n3 + n) % n2;
                break;
            }
            ++n;
        }
        return n4;
    }

    protected void editDisplayPropertyAt(int n) {
        if (this.editCellAt(n, 1)) {
            this.setRowSelectionInterval(n, n);
            this.setColumnSelectionInterval(1, 1);
        }
    }

    public void editPropertyAt(int n) {
        n = ((PropertyFormTableModelEx)this.getModel()).getTableIndexFromPropertyIndex(n);
        if (n == -1) {
            return;
        }
        this.editDisplayPropertyAt(n);
    }

    public void editProperty(String string) throws NoSuchElementException {
        int n = this.styleInformation.getPropertyIndex(string);
        this.editPropertyAt(n);
    }

    @Override
    public boolean editCellAt(int n, int n2, EventObject eventObject) {
        if (super.editCellAt(n, n2, eventObject)) {
            this.setRowSelectionInterval(n, n);
            this.setColumnSelectionInterval(1, 1);
            return true;
        }
        return false;
    }

    public PropertyFormCellEditor getPropertyFormCellEditor() {
        return this.thePropertyFormCellEditor;
    }

    public void addNecessaryPropertyName(String string, Color color) {
        this.getColumnModel().getColumn(0).setCellRenderer(this.render);
        this.necessaryPropertyName.put(string, color);
    }

    public void addNecessaryPropertyName(String[] stringArray, Color[] colorArray) {
        this.getColumnModel().getColumn(0).setCellRenderer(this.render);
        for (int i = 0; i < stringArray.length; ++i) {
            this.necessaryPropertyName.put(stringArray[i], colorArray[i]);
        }
    }

    public void removeNecessaryPropertyName(String string) {
        if (this.necessaryPropertyName.containsKey(string)) {
            this.necessaryPropertyName.remove(string);
        }
    }

    public void removeNecessaryPropertyName() {
        this.necessaryPropertyName.clear();
    }

    public void setShowPropertyToolTip(boolean bl) {
        this.getColumnModel().getColumn(0).setCellRenderer(this.render);
        this.isShowToolTip = bl;
    }

    public void setSameBackground(boolean bl) {
        this.thePropertyFormCellRenderer.setSameBackground(bl);
    }

    private class TableModelRenderer
    extends DefaultTableCellRenderer {
        private TableModelRenderer() {
        }

        @Override
        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            this.setText(object.toString());
            if (PropertyFormTemplate.this.necessaryPropertyName.containsKey(object.toString())) {
                this.setForeground((Color)PropertyFormTemplate.this.necessaryPropertyName.get(object.toString()));
            } else {
                this.setForeground(Color.BLACK);
            }
            if (!PropertyFormTemplate.this.styleInformation.isPropertyEditable(object.toString())) {
                this.setForeground(Color.GRAY);
            }
            if (bl2) {
                this.setBorder(UIManager.getBorder("Table.focusCellHighlightBorder"));
            } else {
                this.setBorder(noFocusBorder);
            }
            if (PropertyFormTemplate.this.isShowToolTip) {
                this.setToolTipText(object.toString());
            }
            return this;
        }
    }
}

