/*
 * Decompiled with CFR 0.152.
 */
package com.swimap.iview.templates.propertyform;

import com.swimap.iview.templates.propertyform.IPropertyFormStyleInterface;
import com.swimap.iview.templates.propertyform.PropertyFormStyleInformation;
import com.swimap.iview.util.CommonUtil;
import com.swimap.iview.util.ObjectManager;
import com.swimap.iview.util.log.IviewLogger;
import java.io.File;
import java.io.IOException;

public class PropertyFormStyleInformationManager
implements IPropertyFormStyleInterface {
    private static IviewLogger logger = IviewLogger.getLogger(PropertyFormStyleInformationManager.class, "IVIEW");
    private File styleInformationFile;

    public PropertyFormStyleInformationManager() {
        this.styleInformationFile = null;
    }

    public PropertyFormStyleInformationManager(String string) {
        this.setStyleInformationFile(string);
    }

    @Override
    public PropertyFormStyleInformation loadInformation() throws ClassNotFoundException, SecurityException, IOException {
        if (this.styleInformationFile == null) {
            throw new NullPointerException("PropertyFormStyleInformationManager.styleFileInformation is null");
        }
        Object object = ObjectManager.loadObject(this.styleInformationFile);
        return (PropertyFormStyleInformation)object;
    }

    @Override
    public void saveInformation(PropertyFormStyleInformation propertyFormStyleInformation) throws IOException {
        if (this.styleInformationFile == null) {
            throw new NullPointerException("PropertyFormStyleInformationManager.styleFileInformation is null");
        }
        ObjectManager.saveObject(this.styleInformationFile, (Object)propertyFormStyleInformation);
    }

    public void setStyleInformationFile(String string) {
        try {
            string = CommonUtil.getAbsolutePath(string);
            this.styleInformationFile = new File(string);
        }
        catch (NullPointerException nullPointerException) {
            this.styleInformationFile = null;
            throw nullPointerException;
        }
        catch (Exception exception) {
            this.styleInformationFile = null;
            logger.warn("error encount during load the file " + string);
        }
    }
}

