/*
 * Decompiled with CFR 0.152.
 */
package com.swimap.iview.templates.propertyform;

import com.swimap.iview.commstyle.resource.i18n.ResourceUtil;
import com.swimap.iview.templates.propertyform.IEditorInterface;
import com.swimap.iview.templates.propertyform.IPropertyFormListener;
import com.swimap.iview.templates.propertyform.IRendererInterface;
import com.swimap.iview.util.ReflectionUtilities;
import com.swimap.iview.util.log.IviewLogger;
import java.awt.Color;
import java.io.Serializable;
import java.util.Hashtable;
import java.util.NoSuchElementException;

public class PropertyFormStyleInformation
implements Serializable {
    private static final long serialVersionUID = 5112829417217098846L;
    private static IviewLogger logger = IviewLogger.getLogger(PropertyFormStyleInformation.class, "IVIEW");
    private int propertyCount = 0;
    private String[] propertyNames = null;
    private String[] propertyCellRendererNames = null;
    private transient IRendererInterface[] propertyCellRenderers = null;
    private String[] propertyCellEditorNames = null;
    private transient IEditorInterface[] propertyCellEditors = null;
    private boolean[] editable = null;
    private Hashtable associations = new Hashtable(11);
    private String[][] listenerNames = null;
    private transient IPropertyFormListener[][] listeners = null;
    private Color backgroundColor = null;
    private Color foregroundColor = null;
    private String[] notificationMessages = null;
    private boolean errorEncountered = false;

    public int getPropertyCount() {
        return this.propertyCount;
    }

    public String[] getPropertyNames() {
        return this.propertyNames;
    }

    public IRendererInterface[] getPropertyCellRenderers() {
        if (this.propertyCellRenderers == null && this.propertyCellRendererNames != null) {
            this.instantiatePropertyCellRenderers(this.propertyCellRendererNames);
        }
        return this.propertyCellRenderers;
    }

    public IEditorInterface[] getPropertyCellEditors() {
        if (this.propertyCellEditors == null && this.propertyCellEditorNames != null) {
            this.instantiatePropertyCellEditors(this.propertyCellEditorNames);
        }
        return this.propertyCellEditors;
    }

    public boolean[] isPropertyEditable() {
        return this.editable;
    }

    public Hashtable getAssociations() {
        return this.associations;
    }

    public String[] getAssociations(Object object) {
        return (String[])this.associations.get(object);
    }

    public IPropertyFormListener[][] getPropertyListeners() {
        if (this.listeners == null && this.listenerNames != null) {
            this.instantiatePropertyListeners(this.listenerNames);
        }
        return this.listeners;
    }

    public String[] getNotificationMessages() {
        return this.notificationMessages;
    }

    public Color getBackgroundColor() {
        return this.backgroundColor;
    }

    public Color getForegroundColor() {
        return this.foregroundColor;
    }

    public void setNotificationMessages(String[] stringArray) {
        this.notificationMessages = stringArray;
    }

    public void setPropertyCount(int n) {
        this.propertyCount = n;
        this.propertyCellRenderers = new IRendererInterface[n];
        this.propertyCellEditors = new IEditorInterface[n];
        this.editable = new boolean[n];
        this.listeners = new IPropertyFormListener[n][];
        this.notificationMessages = new String[n];
    }

    public void setPropertyNames(String[] stringArray) {
        this.propertyNames = stringArray;
        if (stringArray.length != this.propertyCount) {
            this.setPropertyCount(stringArray.length);
        }
    }

    public void setPropertyCellRenderers(String[] stringArray) {
        this.instantiatePropertyCellRenderers(stringArray);
        this.propertyCellRendererNames = stringArray;
    }

    public void instantiatePropertyCellRenderers(String[] stringArray) {
        this.propertyCellRenderers = new IRendererInterface[stringArray.length];
        for (int i = 0; i < stringArray.length; ++i) {
            StringBuffer stringBuffer;
            if (stringArray[i] == null || "".equals(stringArray[i])) {
                this.propertyCellRenderers[i] = null;
                continue;
            }
            try {
                this.propertyCellRenderers[i] = (IRendererInterface)ReflectionUtilities.instantiateTheClass(stringArray[i]);
                continue;
            }
            catch (ClassCastException classCastException) {
                stringBuffer = new StringBuffer("ClassCastException encountered while instantiating the property form cell renderer named \"").append(stringArray[i]).append("\". DefaultCellRenderer will be used for column ").append(i).append("\nDetails of the exception is \n").append(classCastException);
                logger.warn(stringBuffer.toString());
                this.propertyCellRenderers[i] = null;
                this.errorEncountered = true;
                continue;
            }
            catch (Exception exception) {
                stringBuffer = new StringBuffer("Exception encountered while instantiating the property form cell renderer named \"").append(stringArray[i]).append("\". DefaultCellRenderer will be used for column ").append(i).append("\nDetails of the exception is \n").append(exception);
                logger.warn(stringBuffer.toString());
                this.propertyCellRenderers[i] = null;
                this.errorEncountered = true;
            }
        }
    }

    public void setPropertyCellEditors(String[] stringArray) {
        this.instantiatePropertyCellEditors(stringArray);
        this.propertyCellEditorNames = stringArray;
    }

    public void instantiatePropertyCellEditors(String[] stringArray) {
        this.propertyCellEditors = new IEditorInterface[stringArray.length];
        for (int i = 0; i < stringArray.length; ++i) {
            StringBuffer stringBuffer;
            if (stringArray[i] == null || "".equals(stringArray[i])) {
                this.propertyCellEditors[i] = null;
                continue;
            }
            try {
                this.propertyCellEditors[i] = (IEditorInterface)ReflectionUtilities.instantiateTheClass(stringArray[i]);
                continue;
            }
            catch (ClassCastException classCastException) {
                stringBuffer = new StringBuffer("ClassCastException encountered while instantiating the property form cell editor named \"").append(stringArray[i]).append("\". DefaultCellEditor will be used for column ").append(i).append("\nDetails of the exception is \n").append(classCastException);
                logger.warn(stringBuffer.toString());
                this.propertyCellEditors[i] = null;
                this.errorEncountered = true;
                continue;
            }
            catch (Exception exception) {
                stringBuffer = new StringBuffer("Exception encountered while instantiating the property form cell editor named \"").append(stringArray[i]).append("\". DefaultCellEditor will be used for column ").append(i).append("\nDetails of the exception is \n").append(exception);
                logger.warn(stringBuffer.toString());
                this.propertyCellEditors[i] = null;
                this.errorEncountered = true;
            }
        }
    }

    public void setPropertyEditable(String[] stringArray) {
        this.editable = new boolean[stringArray.length];
        for (int i = 0; i < stringArray.length; ++i) {
            this.editable[i] = Boolean.TRUE.toString().equalsIgnoreCase(stringArray[i]);
        }
    }

    public void addAssociation(Object object, String[] stringArray) {
        this.associations.put(object, stringArray);
    }

    public void removeAssociation(Object object) {
        this.associations.remove(object);
    }

    public void setPropertyListeners(String[][] stringArray) {
        this.instantiatePropertyListeners(stringArray);
        this.listenerNames = stringArray;
    }

    public void instantiatePropertyListeners(String[][] stringArray) {
        this.listeners = new IPropertyFormListener[stringArray.length][];
        for (int i = 0; i < stringArray.length; ++i) {
            this.listeners[i] = new IPropertyFormListener[stringArray[i].length];
            for (int j = 0; j < stringArray[i].length; ++j) {
                StringBuffer stringBuffer;
                try {
                    this.listeners[i][j] = (IPropertyFormListener)ReflectionUtilities.instantiateTheClass(stringArray[i][j]);
                    continue;
                }
                catch (ClassCastException classCastException) {
                    stringBuffer = new StringBuffer("ClassCastException encountered while instantiating the property form cell listener named \"").append(stringArray[i][j]).append("\". This listener will not be registered with property at ").append(i).append("\nDetails of the exception is \n").append(classCastException);
                    logger.warn(stringBuffer.toString());
                    stringArray[i][j] = null;
                    this.errorEncountered = true;
                    continue;
                }
                catch (Exception exception) {
                    stringBuffer = new StringBuffer("Exception encountered while instantiating the property form cell listener named \"").append(stringArray[i][j]).append("\". This listener will not be registered with property at ").append(i).append("\nDetails of the exception is \n").append(exception);
                    logger.warn(stringBuffer.toString());
                    stringArray[i][j] = null;
                    this.errorEncountered = true;
                }
            }
        }
    }

    public void setBackgroundColor(String[] stringArray) throws NumberFormatException {
        try {
            if (stringArray.length <= 2) {
                throw new NumberFormatException();
            }
            this.backgroundColor = new Color(Integer.parseInt(stringArray[0]), Integer.parseInt(stringArray[1]), Integer.parseInt(stringArray[2]));
        }
        catch (NumberFormatException numberFormatException) {
            logger.warn("NumberFormatException occurred while parsing the r, g and b values of background color. Error message obtained is\n " + numberFormatException);
            this.backgroundColor = null;
            throw numberFormatException;
        }
        catch (Exception exception) {
            StringBuffer stringBuffer = new StringBuffer("instantiate");
            for (int i = 0; i < stringArray.length; ++i) {
                stringBuffer.append(stringArray[i]);
                stringBuffer.append('\t');
            }
            stringBuffer.append(" to  background color error");
            logger.warn(stringBuffer.toString());
        }
    }

    public void setForegroundColor(String[] stringArray) throws NumberFormatException {
        try {
            if (stringArray.length <= 2) {
                throw new NumberFormatException();
            }
            this.foregroundColor = new Color(Integer.parseInt(stringArray[0]), Integer.parseInt(stringArray[1]), Integer.parseInt(stringArray[2]));
        }
        catch (NumberFormatException numberFormatException) {
            logger.warn("NumberFormatException occurred while parsing the r, g and b values of foreground color. Error message obtained is\n " + numberFormatException);
            this.foregroundColor = null;
            throw numberFormatException;
        }
        catch (Exception exception) {
            StringBuffer stringBuffer = new StringBuffer("instantiate");
            for (int i = 0; i < stringArray.length; ++i) {
                stringBuffer.append(stringArray[i]);
                stringBuffer.append('\t');
            }
            stringBuffer.append(" to  background color error");
            logger.warn(stringBuffer.toString());
        }
    }

    public void setPropertyEditable(String string, boolean bl) throws NoSuchElementException {
        if (this.editable == null || this.editable.length < this.propertyCount) {
            this.editable = new boolean[this.propertyCount];
        }
        this.editable[this.getPropertyIndex((String)string)] = bl;
    }

    public boolean isPropertyEditable(String string) throws NoSuchElementException {
        if (this.editable == null || this.editable.length < this.propertyCount) {
            this.editable = new boolean[this.propertyCount];
        }
        return this.editable[this.getPropertyIndex(string)];
    }

    protected int getPropertyIndex(String string) throws NoSuchElementException {
        string = string.trim();
        for (int i = 0; i < this.propertyNames.length; ++i) {
            if (!string.equalsIgnoreCase(this.propertyNames[i])) continue;
            return i;
        }
        logger.warn(string + " not found in property list");
        throw new NoSuchElementException(string + " not found in property list");
    }

    public void insertProperty(String string, int n) {
        String[] stringArray = new String[this.propertyCount + 1];
        IRendererInterface[] iRendererInterfaceArray = new IRendererInterface[this.propertyCount + 1];
        IEditorInterface[] iEditorInterfaceArray = new IEditorInterface[this.propertyCount + 1];
        boolean[] blArray = new boolean[this.propertyCount + 1];
        String[] stringArray2 = new String[this.propertyCount + 1];
        if (n > 0) {
            System.arraycopy(this.propertyNames, 0, stringArray, 0, n);
            System.arraycopy(this.propertyCellRenderers, 0, iRendererInterfaceArray, 0, n);
            System.arraycopy(this.propertyCellEditors, 0, iEditorInterfaceArray, 0, n);
            System.arraycopy(this.editable, 0, blArray, 0, n);
            System.arraycopy(this.notificationMessages, 0, stringArray2, 0, n);
        }
        stringArray[n] = string;
        iRendererInterfaceArray[n] = null;
        iEditorInterfaceArray[n] = null;
        blArray[n] = true;
        stringArray2[n] = "";
        if (n < this.propertyCount) {
            System.arraycopy(this.propertyNames, n, stringArray, n + 1, this.propertyCount - n);
            System.arraycopy(this.propertyCellRenderers, n, iRendererInterfaceArray, n + 1, this.propertyCount - n);
            System.arraycopy(this.propertyCellEditors, n, iEditorInterfaceArray, n + 1, this.propertyCount - n);
            System.arraycopy(this.editable, n, blArray, n + 1, this.propertyCount - n);
            System.arraycopy(this.notificationMessages, n, stringArray2, n + 1, this.propertyCount - n);
        }
        this.propertyNames = stringArray;
        this.propertyCellRenderers = iRendererInterfaceArray;
        this.propertyCellEditors = iEditorInterfaceArray;
        this.editable = blArray;
        this.notificationMessages = stringArray2;
        ++this.propertyCount;
    }

    public void updateProperty(String string, String string2) throws NoSuchElementException {
        this.propertyNames[this.getPropertyIndex((String)string)] = string2;
    }

    public void removeProperty(String string) throws NoSuchElementException {
        int n = this.getPropertyIndex(string);
        String[] stringArray = new String[this.propertyCount - 1];
        IRendererInterface[] iRendererInterfaceArray = new IRendererInterface[this.propertyCount - 1];
        IEditorInterface[] iEditorInterfaceArray = new IEditorInterface[this.propertyCount - 1];
        boolean[] blArray = new boolean[this.propertyCount - 1];
        String[] stringArray2 = new String[this.propertyCount - 1];
        if (n > 0) {
            System.arraycopy(this.propertyNames, 0, stringArray, 0, n);
            System.arraycopy(this.propertyCellRenderers, 0, iRendererInterfaceArray, 0, n);
            System.arraycopy(this.propertyCellEditors, 0, iEditorInterfaceArray, 0, n);
            System.arraycopy(this.editable, 0, blArray, 0, n);
            System.arraycopy(this.notificationMessages, 0, stringArray2, 0, n);
        }
        if (n < this.propertyCount - 1) {
            System.arraycopy(this.propertyNames, n + 1, stringArray, n, this.propertyCount - n - 1);
            System.arraycopy(this.propertyCellRenderers, n + 1, iRendererInterfaceArray, n, this.propertyCount - n - 1);
            System.arraycopy(this.propertyCellEditors, n + 1, iEditorInterfaceArray, n, this.propertyCount - n - 1);
            System.arraycopy(this.editable, n + 1, blArray, n, this.propertyCount - n - 1);
            System.arraycopy(this.notificationMessages, n + 1, stringArray2, n, this.propertyCount - n - 1);
        }
        this.propertyNames = stringArray;
        this.propertyCellRenderers = iRendererInterfaceArray;
        this.propertyCellEditors = iEditorInterfaceArray;
        this.editable = blArray;
        this.notificationMessages = stringArray2;
        --this.propertyCount;
    }

    public boolean contains(String string) {
        boolean bl = false;
        for (int i = 0; i < this.propertyNames.length; ++i) {
            if (!ResourceUtil.areEquals(this.propertyNames[i], string)) continue;
            bl = true;
            break;
        }
        return bl;
    }

    public boolean isErrorEncountered() {
        return this.errorEncountered;
    }
}

