/*
 * Decompiled with CFR 0.152.
 */
package com.swimap.iview.templates.propertyform;

import com.swimap.iview.templates.propertyform.IEditorInterface;
import com.swimap.iview.templates.propertyform.PropertyFormDefaultEditor;
import com.swimap.iview.templates.propertyform.PropertyFormTemplate;
import java.awt.Component;
import java.awt.DefaultKeyboardFocusManager;
import java.awt.KeyEventPostProcessor;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.util.EventObject;
import java.util.Hashtable;
import javax.swing.AbstractCellEditor;
import javax.swing.JComponent;
import javax.swing.JTable;
import javax.swing.table.TableCellEditor;

public class PropertyFormCellEditor
extends AbstractCellEditor
implements TableCellEditor {
    private Hashtable editors = new Hashtable(11);
    private Object oldValue = null;
    private KeyEventPostProcessor cellChangeKeyListener = null;
    private IEditorInterface editorInterfaceObject = null;
    private PropertyFormTemplate propertyForm = null;
    protected int clickCountToStart = 2;

    public PropertyFormCellEditor() {
    }

    public PropertyFormCellEditor(PropertyFormTemplate propertyFormTemplate) {
        this();
        this.propertyForm = propertyFormTemplate;
    }

    @Override
    public void fireEditingStopped() {
        super.fireEditingStopped();
        this.removekeyEventPostListener();
    }

    @Override
    public Object getCellEditorValue() {
        return this.editorInterfaceObject.getValue();
    }

    public void addCellEditor(String string, IEditorInterface iEditorInterface) {
        iEditorInterface.setParentEditor(this);
        this.editors.put(string, iEditorInterface);
    }

    public void propertyNameChanged(String string, String string2) {
        Object v = this.editors.remove(string);
        if (v != null) {
            this.editors.put(string2, v);
        }
    }

    public boolean removeCellEditor(String string) {
        Object v = this.editors.remove(string);
        this.editors.put(string, new PropertyFormDefaultEditor());
        return v != null;
    }

    public IEditorInterface getCellEditor(String string) {
        return (IEditorInterface)this.editors.get(string);
    }

    @Override
    public Component getTableCellEditorComponent(JTable jTable, Object object, boolean bl, int n, int n2) {
        JComponent jComponent = null;
        if (n2 == 1 && jTable instanceof PropertyFormTemplate) {
            Object v;
            this.propertyForm = (PropertyFormTemplate)jTable;
            String string = (String)jTable.getValueAt(n, 0);
            if (string != null && (v = this.editors.get(string)) != null) {
                this.editorInterfaceObject = (IEditorInterface)v;
                if (this.editorInterfaceObject != null) {
                    jComponent = this.editorInterfaceObject.getEditor(object);
                    this.oldValue = this.editorInterfaceObject.getValue();
                    if (null != this.cellChangeKeyListener) {
                        this.removekeyEventPostListener();
                    }
                    this.addKeyEventPostListener();
                }
            }
        }
        return jComponent;
    }

    private void addKeyEventPostListener() {
        DefaultKeyboardFocusManager.getCurrentKeyboardFocusManager().addKeyEventPostProcessor(this.getCellValuechangeKeyListener());
    }

    private void removekeyEventPostListener() {
        DefaultKeyboardFocusManager.getCurrentKeyboardFocusManager().removeKeyEventPostProcessor(this.cellChangeKeyListener);
    }

    private KeyEventPostProcessor getCellValuechangeKeyListener() {
        if (null == this.cellChangeKeyListener) {
            this.cellChangeKeyListener = new KeyEventPostProcessor(){

                @Override
                public boolean postProcessKeyEvent(KeyEvent keyEvent) {
                    if (keyEvent.getID() == 400 && null != PropertyFormCellEditor.this.editorInterfaceObject && null != PropertyFormCellEditor.this.oldValue) {
                        Object object = PropertyFormCellEditor.this.editorInterfaceObject.getValue();
                        PropertyFormCellEditor.this.propertyForm.fireCellValueChange(object, PropertyFormCellEditor.this.oldValue);
                    }
                    return false;
                }
            };
        }
        return this.cellChangeKeyListener;
    }

    public PropertyFormTemplate getParentPropertyForm() {
        return this.propertyForm;
    }

    @Override
    public boolean isCellEditable(EventObject eventObject) {
        if (eventObject instanceof MouseEvent) {
            return ((MouseEvent)eventObject).getClickCount() >= this.clickCountToStart;
        }
        return true;
    }

    public int getClickCountToStart() {
        return this.clickCountToStart;
    }

    public void setClickCountToStart(int n) {
        this.clickCountToStart = n;
    }
}

