/*
 * Decompiled with CFR 0.152.
 */
package com.swimap.iview.templates.progressdialog;

import com.swimap.iview.templates.progressdialog.IProgressDialogStyleInterface;
import com.swimap.iview.templates.progressdialog.ProgressDialogStyleInformation;
import com.swimap.iview.templates.progressdialog.xml.IViewProgressDialog;
import com.swimap.iview.templates.progressdialog.xml.ProgressDialogInformation;
import com.swimap.iview.util.CommonUtil;
import com.swimap.iview.util.log.IviewLogger;
import java.io.File;
import java.net.URL;

public class ProgressDialogXMLFileReader {
    private static IviewLogger logger = IviewLogger.getLogger(ProgressDialogXMLFileReader.class, "IVIEW");
    private boolean validity = false;
    public ProgressDialogStyleInformation styleInformation = null;

    public boolean readXMLFile(String string) {
        try {
            string = CommonUtil.getAbsolutePath(string);
            File file = new File(string);
            URL uRL = file.toURL();
            IViewProgressDialog iViewProgressDialog = IViewProgressDialog.unmarshal(uRL);
            this.validity = iViewProgressDialog.isValid();
            if (this.validity) {
                ProgressDialogInformation progressDialogInformation = iViewProgressDialog.getProgressDialogInformation();
                this.styleInformation = new ProgressDialogStyleInformation();
                this.styleInformation.setMinimum(Integer.parseInt(progressDialogInformation.getMinimumValue().trim()));
                this.styleInformation.setMaximum(Integer.parseInt(progressDialogInformation.getMaximumValue().trim()));
                String string2 = null;
                string2 = progressDialogInformation.getDisplayCount();
                if (string2 != null && !string2.trim().equals("")) {
                    this.styleInformation.setCountDisplayed("true".equalsIgnoreCase(string2.trim()));
                }
                if ((string2 = progressDialogInformation.getIncrementSteps()) != null && !string2.trim().equals("")) {
                    this.styleInformation.setIncrementSteps(Integer.parseInt(string2.trim()));
                }
                if ((string2 = progressDialogInformation.getDialogTitle()) != null && !string2.trim().equals("")) {
                    this.styleInformation.setTitle(string2);
                }
                if ((string2 = progressDialogInformation.getModal()) != null && !string2.trim().equals("")) {
                    this.styleInformation.setModal("true".equalsIgnoreCase(string2.trim()));
                }
                if ((string2 = progressDialogInformation.getAutoDispose()) != null && !string2.trim().equals("")) {
                    this.styleInformation.setAutoDispose("true".equalsIgnoreCase(string2.trim()));
                }
                if ((string2 = progressDialogInformation.getModel()) != null && !string2.trim().equals("")) {
                    this.styleInformation.setModel(string2.trim());
                }
            }
        }
        catch (NumberFormatException numberFormatException) {
            this.validity = false;
            logger.warn("NumberFormatException: " + numberFormatException);
        }
        catch (Exception exception) {
            this.validity = false;
            logger.warn("Exception: " + exception);
        }
        return this.validity;
    }

    public boolean isInformationValid() {
        return this.validity;
    }

    public boolean saveInformation(IProgressDialogStyleInterface iProgressDialogStyleInterface) {
        boolean bl = iProgressDialogStyleInterface != null & this.styleInformation != null;
        if (bl) {
            try {
                iProgressDialogStyleInterface.saveInformation(this.styleInformation);
            }
            catch (NullPointerException nullPointerException) {
                bl = false;
                logger.warn("NullPointerException while saving style information object: " + nullPointerException);
            }
            catch (Exception exception) {
                bl = false;
                logger.warn("Exception while saving style information object: " + exception);
            }
        }
        return bl;
    }
}

