/*
 * Decompiled with CFR 0.152.
 */
package com.swimap.iview.templates.progressdialog;

import com.swimap.iview.commstyle.resource.ResourceMng;
import com.swimap.iview.templates.progressdialog.IProgressDialogStyleInterface;
import com.swimap.iview.templates.progressdialog.IStop;
import com.swimap.iview.templates.progressdialog.ProgressDialogStyleInformation;
import com.swimap.iview.util.ScreenToolKit;
import com.swimap.iview.util.log.IviewLogger;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.IOException;
import java.util.ResourceBundle;
import javax.swing.BoundedRangeModel;
import javax.swing.DefaultBoundedRangeModel;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JProgressBar;
import javax.swing.SwingUtilities;

public class ProgressDialogTemplate
extends JDialog {
    private static IviewLogger logger = IviewLogger.getLogger(ProgressDialogTemplate.class, "IVIEW");
    private static ResourceBundle res = ResourceMng.getInstance().getResourceBundleFromPropertyFile("mainfrm/iview/templates/progressdialog/resources/Res");
    private Container rootContainer = null;
    private JButton cancelButton = null;
    private IStop m_stop = null;
    private ProgressDialogStyleInformation styleInformation;
    private JProgressBar progressBar = new JProgressBar();
    private JLabel tipLabel = new JLabel();
    private String tipText = null;
    private JLabel iconLabel = new JLabel();
    private Icon icon = null;

    public ProgressDialogTemplate(JFrame jFrame, String string, String string2, Icon icon) {
        super(jFrame, string, true);
        this.tipText = string2;
        this.icon = icon;
        this.styleInformation = new ProgressDialogStyleInformation();
        this.createDialog();
    }

    public ProgressDialogTemplate(JDialog jDialog, String string, String string2, Icon icon) {
        super(jDialog, string, true);
        this.tipText = string2;
        this.icon = icon;
        this.styleInformation = new ProgressDialogStyleInformation();
        this.createDialog();
    }

    public ProgressDialogTemplate(JFrame jFrame, IProgressDialogStyleInterface iProgressDialogStyleInterface) throws ClassNotFoundException, IOException {
        super(jFrame);
        try {
            this.setInformation(iProgressDialogStyleInterface.loadInformation());
        }
        catch (NullPointerException nullPointerException) {
            logger.warn("Error while loading persisted object: " + nullPointerException);
            throw nullPointerException;
        }
        catch (ClassCastException classCastException) {
            logger.warn("Error while loading persisted object: " + classCastException);
            throw classCastException;
        }
        catch (ClassNotFoundException classNotFoundException) {
            logger.warn("Error while loading persisted object: " + classNotFoundException);
            throw classNotFoundException;
        }
        catch (IOException iOException) {
            logger.warn("Error while loading persisted object: " + iOException);
            throw iOException;
        }
        catch (SecurityException securityException) {
            logger.warn("Error while loading persisted object: " + securityException);
            throw securityException;
        }
        catch (Exception exception) {
            logger.warn("Error while loading persisted object: " + exception);
        }
        this.createDialog();
    }

    public ProgressDialogTemplate(JDialog jDialog, IProgressDialogStyleInterface iProgressDialogStyleInterface) throws ClassNotFoundException, IOException {
        super(jDialog);
        try {
            this.setInformation(iProgressDialogStyleInterface.loadInformation());
        }
        catch (NullPointerException nullPointerException) {
            logger.warn("Error while loading persisted object: " + nullPointerException);
            throw nullPointerException;
        }
        catch (ClassCastException classCastException) {
            logger.warn("Error while loading persisted object: " + classCastException);
            throw classCastException;
        }
        catch (ClassNotFoundException classNotFoundException) {
            logger.warn("Error while loading persisted object: " + classNotFoundException);
            throw classNotFoundException;
        }
        catch (IOException iOException) {
            logger.warn("Error while loading persisted object: " + iOException);
            throw iOException;
        }
        catch (SecurityException securityException) {
            logger.warn("Error while loading persisted object: " + securityException);
            throw securityException;
        }
        catch (Exception exception) {
            logger.warn("Error while loading persisted object: " + exception);
        }
        this.createDialog();
    }

    public ProgressDialogTemplate(Frame frame, ProgressDialogStyleInformation progressDialogStyleInformation) {
        super(frame);
        this.setInformation(progressDialogStyleInformation);
        this.createDialog();
    }

    public ProgressDialogTemplate(Dialog dialog) {
        super(dialog);
        this.styleInformation = new ProgressDialogStyleInformation();
        this.createDialog();
    }

    public ProgressDialogTemplate(Frame frame) {
        super(frame);
        this.styleInformation = new ProgressDialogStyleInformation();
        this.createDialog();
    }

    public ProgressDialogStyleInformation getInformation() {
        return this.styleInformation;
    }

    public void setInformation(ProgressDialogStyleInformation progressDialogStyleInformation) {
        if (progressDialogStyleInformation == null) {
            logger.warn("progress dialog style information object is null");
            throw new NullPointerException("progress dialog style information object is null");
        }
        this.styleInformation = progressDialogStyleInformation;
        if (this.styleInformation.getModel() != null) {
            this.progressBar.setModel(this.styleInformation.getModel());
        }
        this.setTitle(this.styleInformation.getTitle());
        this.setModal(this.styleInformation.isModal());
        this.progressBar.setName("ProgressDialogTemplate_progressBar");
        this.progressBar.setMinimum(this.styleInformation.getMinimum());
        this.progressBar.setMaximum(this.styleInformation.getMaximum());
        this.progressBar.setStringPainted(this.styleInformation.isCountDisplayed());
    }

    private void createDialog() {
        this.setDefaultCloseOperation(0);
        this.rootContainer = this.getContentPane();
        this.rootContainer.setName("ProgressDialogTemplate_rootContainer");
        this.rootContainer.setLayout(new GridBagLayout());
        if (this.icon != null) {
            this.iconLabel.setIcon(this.icon);
        }
        this.iconLabel.setName("ProgressDialogTemplatge_iconLabel");
        this.progressBar.setPreferredSize(new Dimension(200, 20));
        if (this.tipText != null && this.tipText.length() > 0) {
            this.tipLabel.setText(this.tipText);
        }
        this.tipLabel.setHorizontalAlignment(0);
        this.tipLabel.setName("ProgressDialogTemplatge_tipLabel");
        this.cancelButton = new JButton(res.getString("cancelButton.text"));
        this.cancelButton.setName("ProgressDialogTemplate_cancelButton");
        this.cancelButton.setPreferredSize(new Dimension(80, 20));
        this.cancelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                IStop iStop = ProgressDialogTemplate.this.m_stop;
                if (iStop != null) {
                    iStop.stop();
                }
            }
        });
        ScreenToolKit.setDefaultButtons(null, this.cancelButton);
        if (null != this.icon) {
            this.rootContainer.add((Component)this.iconLabel, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(12, 0, 0, 0), 0, 0));
        }
        this.rootContainer.add((Component)this.progressBar, new GridBagConstraints(0, 1, 1, 1, 1.0, 1.0, 10, 2, new Insets(12, 5, 12, 5), 0, 0));
        if (this.tipText != null && this.tipText.length() > 0) {
            this.rootContainer.add((Component)this.tipLabel, new GridBagConstraints(0, 2, 1, 1, 1.0, 1.0, 10, 2, new Insets(0, 10, 12, 10), 0, 0));
        }
        this.pack();
        this.setResizable(false);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent windowEvent) {
                if (ProgressDialogTemplate.this.cancelButton != null) {
                    ProgressDialogTemplate.this.cancelButton.doClick();
                }
            }
        });
    }

    public void setCurrentValue(int n) {
        if (SwingUtilities.isEventDispatchThread()) {
            this.progressBar.setValue(n);
        } else {
            SwingUtilities.invokeLater(new UpdateRunnable(n));
        }
    }

    public void incrementValue(int n) {
        this.setCurrentValue(this.progressBar.getValue() + this.styleInformation.getIncrementSteps() * n);
    }

    public JProgressBar getProgressBar() {
        return this.progressBar;
    }

    public BoundedRangeModel getModel() {
        return this.progressBar.getModel();
    }

    public void setModel(BoundedRangeModel boundedRangeModel) {
        if (boundedRangeModel == null) {
            this.progressBar.setModel(new DefaultBoundedRangeModel());
        } else {
            this.progressBar.setModel(boundedRangeModel);
        }
    }

    public void setStop(IStop iStop) {
        if (iStop == null) {
            this.rootContainer.remove(this.cancelButton);
            this.pack();
            this.m_stop = null;
        } else {
            this.m_stop = iStop;
            this.rootContainer.add((Component)this.cancelButton, new GridBagConstraints(0, 3, 1, 1, 0.0, 1.0, 10, 0, new Insets(0, 20, 12, 20), 0, 0));
            this.getRootPane().setDefaultButton(this.cancelButton);
            this.pack();
        }
    }

    private final class UpdateRunnable
    implements Runnable {
        private int value = 0;

        public UpdateRunnable(int n) {
            this.value = n;
        }

        @Override
        public void run() {
            ProgressDialogTemplate.this.progressBar.setValue(this.value);
        }
    }
}

