/*
 * Decompiled with CFR 0.152.
 */
package com.swimap.iview.templates.progressdialog;

import com.swimap.iview.commstyle.resource.ResourceMng;
import com.swimap.iview.templates.progressdialog.IProgressFinish;
import com.swimap.iview.templates.progressdialog.IStop;
import com.swimap.iview.util.ScreenToolKit;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.ArrayList;
import java.util.List;
import java.util.ResourceBundle;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JScrollPane;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;

public class MultipleProgressDialog
extends JDialog {
    private static final long serialVersionUID = 3178101583673812573L;
    private static ResourceBundle res = ResourceMng.getInstance().getResourceBundleFromPropertyFile("mainfrm/iview/templates/progressdialog/resources/Res");
    private JButton backgroundButton = null;
    private JButton cancelAllButton = null;
    private JPanel buttonPanel = null;
    private JPanel progressPanel = null;
    private JScrollPane scrollPane = null;
    private String titleText = null;
    private List<IProgressFinish> listnerList = null;
    private List<IStop> cancelList = null;
    private Action escapeAction = new AbstractAction(){
        private static final long serialVersionUID = -8954532807566799259L;

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            if (MultipleProgressDialog.this.cancelAllButton != null) {
                MultipleProgressDialog.this.cancelAllButton.doClick();
            }
        }
    };
    private Action enterAction = new AbstractAction(){
        private static final long serialVersionUID = 6440729493238202058L;

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            if (MultipleProgressDialog.this.backgroundButton != null) {
                MultipleProgressDialog.this.backgroundButton.doClick();
            }
        }
    };

    public MultipleProgressDialog(JFrame jFrame, String string, String string2) {
        super(jFrame, string, true);
        this.titleText = string;
        this.createDialog();
    }

    public MultipleProgressDialog(JDialog jDialog, String string, String string2) {
        super(jDialog, string, true);
        this.titleText = string;
        this.createDialog();
    }

    private void createDialog() {
        this.createButtonPanel();
        this.createProgressPanel();
        this.setTitle(this.titleText);
        this.setDefaultCloseOperation(0);
        this.setLayout(new BorderLayout());
        this.add((Component)this.buttonPanel, "South");
        this.add((Component)this.scrollPane, "Center");
        this.pack();
        this.setResizable(false);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent windowEvent) {
                if (MultipleProgressDialog.this.cancelAllButton != null) {
                    MultipleProgressDialog.this.cancelAllButton.doClick();
                }
            }
        });
        this.initActionMap();
    }

    private void initActionMap() {
        KeyStroke keyStroke = KeyStroke.getKeyStroke(27, 0);
        this.getRootPane().getInputMap().put(keyStroke, "escapePressed");
        this.getRootPane().getActionMap().put("escapePressed", this.escapeAction);
        KeyStroke keyStroke2 = KeyStroke.getKeyStroke(10, 0);
        this.getRootPane().getInputMap().put(keyStroke2, "enterPressed");
        this.getRootPane().getActionMap().put("enterPressed", this.enterAction);
    }

    private void createButtonPanel() {
        this.backgroundButton = new JButton(res.getString("backGroundbutton.text"));
        this.backgroundButton.setName("MultipleProgressDialog.backgroundButton");
        this.cancelAllButton = new JButton(res.getString("cancelAllButton.text"));
        this.cancelAllButton.setName("MultipleProgressDialog.cancelAllButton");
        Dimension dimension = new Dimension(this.backgroundButton.getPreferredSize().width, 21);
        this.backgroundButton.setMargin(new Insets(2, 2, 2, 2));
        this.backgroundButton.setSize(dimension);
        this.backgroundButton.setPreferredSize(dimension);
        this.backgroundButton.setMaximumSize(dimension);
        this.backgroundButton.setMinimumSize(dimension);
        this.cancelAllButton.setPreferredSize(new Dimension(100, 21));
        this.cancelAllButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (null != MultipleProgressDialog.this.cancelList && !MultipleProgressDialog.this.cancelList.isEmpty()) {
                    for (IStop iStop : MultipleProgressDialog.this.cancelList) {
                        if (iStop == null) continue;
                        iStop.stop();
                    }
                }
            }
        });
        FlowLayout flowLayout = new FlowLayout(2);
        this.buttonPanel = new JPanel(flowLayout);
        this.buttonPanel.setName("MultipleProgressDialog.buttonPanel");
        this.buttonPanel.add(this.backgroundButton);
        this.buttonPanel.add(this.cancelAllButton);
        this.buttonPanel.setBorder(BorderFactory.createEmptyBorder(0, 0, 6, 6));
        ScreenToolKit.setDefaultButtons(null, this.backgroundButton);
    }

    private void createProgressPanel() {
        this.progressPanel = new JPanel();
        this.progressPanel.setName("MultipleProgressDialog.progressPanel");
        this.progressPanel.setLayout(new BoxLayout(this.progressPanel, 1));
        this.scrollPane = new JScrollPane(this.progressPanel, 20, 31);
        this.scrollPane.setName("MultipleProgressDialog.scrollPane");
        Border border = BorderFactory.createEmptyBorder(12, 12, 5, 10);
        Border border2 = this.scrollPane.getBorder();
        this.scrollPane.setBorder(BorderFactory.createCompoundBorder(border, border2));
    }

    public void addProgress(JProgressBar jProgressBar, final IStop iStop) {
        JPanel jPanel = new JPanel(){

            @Override
            public Insets getInsets() {
                Insets insets = super.getInsets();
                insets.top = 5;
                return insets;
            }
        };
        if (null == this.cancelList) {
            this.cancelList = new ArrayList<IStop>(10);
        }
        this.cancelList.add(iStop);
        JButton jButton = new JButton(res.getString("cancelButton.text"));
        jButton.setName("Cancel_Button");
        jButton.setPreferredSize(new Dimension(80, 21));
        jButton.setMaximumSize(new Dimension(80, 21));
        jButton.setMinimumSize(new Dimension(80, 21));
        if (null != iStop) {
            jButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    IStop iStop2 = iStop;
                    if (iStop2 != null) {
                        iStop2.stop();
                    }
                }
            });
        }
        jProgressBar.setPreferredSize(new Dimension(360, 20));
        jProgressBar.setMaximumSize(new Dimension(360, 20));
        jProgressBar.setMinimumSize(new Dimension(360, 20));
        jPanel.setLayout(new FlowLayout(0, 5, 0));
        jPanel.setPreferredSize(new Dimension(500, 28));
        jPanel.setMaximumSize(new Dimension(500, 28));
        jPanel.setMinimumSize(new Dimension(500, 28));
        jPanel.add(jProgressBar);
        jPanel.add(jButton);
        this.progressPanel.add(jPanel);
    }

    public JButton getBackgroundButton() {
        return this.backgroundButton;
    }

    public void removeProgress(JProgressBar jProgressBar) {
        final JPanel jPanel = (JPanel)jProgressBar.getParent();
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                MultipleProgressDialog.this.progressPanel.remove(jPanel);
                MultipleProgressDialog.this.validate();
                MultipleProgressDialog.this.repaint();
                if (MultipleProgressDialog.this.progressPanel.getComponentCount() == 0) {
                    MultipleProgressDialog.this.fireAllTaskFinished();
                }
            }
        });
    }

    private void fireAllTaskFinished() {
        if (null != this.listnerList) {
            for (IProgressFinish iProgressFinish : this.listnerList) {
                iProgressFinish.progressFinished();
            }
        }
    }

    public void addProgressFinishedListener(IProgressFinish iProgressFinish) {
        if (null == this.listnerList) {
            this.listnerList = new ArrayList<IProgressFinish>(10);
        }
        this.listnerList.add(iProgressFinish);
    }

    public void removeProgressFinishedListener(IProgressFinish iProgressFinish) {
        if (null != this.listnerList) {
            this.listnerList.remove(iProgressFinish);
        }
    }

    public JButton getCancelRef() {
        return this.cancelAllButton;
    }
}

