/*
 * Decompiled with CFR 0.152.
 */
package com.swimap.iview.templates.print.tools;

import com.swimap.iview.framework.util.FrameworkCommandProcessor;
import com.swimap.iview.framework.util.FrameworkUtilities;
import com.swimap.iview.templates.dialog.DetailMessageDlg;
import com.swimap.iview.templates.print.FormatCalculator;
import com.swimap.iview.templates.print.PrintSupportor;
import com.swimap.iview.templates.print.tools.ExcelSaveImpl;
import com.swimap.iview.templates.print.tools.SpreadsheetWriter;
import com.swimap.iview.templates.print.tools.TablePrintable;
import com.swimap.iview.util.CommonUtil;
import com.swimap.iview.util.format.NumberFormatUtil;
import com.swimap.iview.util.jni.Os;
import com.swimap.iview.util.jni.Solaris;
import com.swimap.iview.util.jni.Windows;
import com.swimap.iview.util.log.IviewLogger;
import java.awt.Dialog;
import java.awt.Frame;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.channels.FileLock;
import java.util.Iterator;
import java.util.LinkedList;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.SwingUtilities;

public class XLSXSaveImpl
extends ExcelSaveImpl {
    private static IviewLogger logger = IviewLogger.getLogger(XLSXSaveImpl.class, "IVIEW");
    private File file = null;
    private int index = 0;
    private int actualIndex = 0;
    private static final int ONE_SECOND = 100;
    private static final int EXTRA_INFO_ROWS = 10;
    private boolean isSaveOver = false;
    private FormatCalculator parentFormatCalculator = null;
    private int writeTotalCount = 0;
    private int x = 0;
    private int y = 0;
    private BufferedOutputStream bufferedStream = null;
    private SpreadsheetWriter xlsxWriter = null;
    private FileOutputStream lockStream = null;
    private static final int HEADER_SIZE = 10;
    private final int MAX_CELLS_PER_BATCH = 200000;
    private int sheetIndex = Integer.MIN_VALUE;
    private String templateFile = null;

    public XLSXSaveImpl(FormatCalculator formatCalculator) {
        super(formatCalculator.getXLSXFormatCalculator());
        this.parentFormatCalculator = formatCalculator;
        this.writeTotalCount = this.parentFormatCalculator.getTotalRowsCount() - this.parentFormatCalculator.getAdjustInt();
    }

    private int calculatorAllOutputRows() {
        if (this.sheetIndex > Integer.MIN_VALUE) {
            int n = this.formatCalculator.getTotalRowCount();
            int n2 = this.formatCalculator.getMaxRecordsCountPerFile();
            int n3 = n / (n2 - 10);
            int n4 = n + n3 * 10;
            return n4;
        }
        return this.formatCalculator.getTotalRowCount() + 10;
    }

    private void initWorkbook(String string) throws IOException {
        boolean bl;
        this.file = new File(CommonUtil.getAbsolutePath(string));
        if (!this.file.exists() && !(bl = this.file.createNewFile())) {
            logger.trace("The file alredy exist " + string);
        }
        this.lockStream = new FileOutputStream(string);
        FileLock fileLock = this.lockStream.getChannel().lock();
        if (null == fileLock || !fileLock.isValid()) {
            logger.trace("In initWorkbook, the file could'nt be locked: " + string);
        }
        this.bufferedStream = new BufferedOutputStream(this.lockStream);
        try {
            this.xlsxWriter = new SpreadsheetWriter(this.bufferedStream);
        }
        catch (Exception exception) {
            logger.trace("Error occured while substituting the temp file.", exception);
            this.closeCurrentStream();
            throw new IOException("Failed to create writer", exception);
        }
        String string2 = System.getProperty("file.encoding");
        this.xlsxWriter.setEncoding(string2);
        this.xlsxWriter.setColumnCount(this.formatCalculator.getTableHeaders().length);
        this.xlsxWriter.beginSheet();
    }

    @Override
    public void write() throws IOException {
        ++this.y;
        if (this.parentFormatCalculator.getTotleRecordsPosition()) {
            if (!this.parentFormatCalculator.isNormalSave()) {
                this.writeHeader();
            }
            this.writeData(true);
            ++this.y;
        }
        this.writeTotalRecordInfo();
        if (!this.parentFormatCalculator.getTotleRecordsPosition()) {
            ++this.y;
            if (!this.parentFormatCalculator.isNormalSave()) {
                this.writeHeader();
            }
            this.writeData(true);
        }
        this.sureWrite();
        if (!this.parentFormatCalculator.getDeleteFileFlag()) {
            this.showMutiFilesInfo();
        }
    }

    private void writeTotalRecordInfo() throws IOException {
        if (this.parentFormatCalculator.getTotalRecordCount() != -1) {
            this.writeTotalCount = this.parentFormatCalculator.getTotalRecordCount();
        }
        if (this.parentFormatCalculator.isTotalRecordVisible()) {
            StringBuffer stringBuffer = this.getTotalRecords(this.writeTotalCount);
            this.xlsxWriter.insertRow(this.y);
            this.xlsxWriter.createCell(this.x, stringBuffer.toString());
            this.xlsxWriter.endRow();
            ++this.y;
        }
    }

    private StringBuffer getTotalRecords(int n) {
        StringBuffer stringBuffer = new StringBuffer(22);
        stringBuffer.append(PrintSupportor.res.getString("Total"));
        stringBuffer.append(NumberFormatUtil.getFormatNumber(n));
        stringBuffer.append(' ');
        if (n > 1) {
            stringBuffer.append(PrintSupportor.res.getString("Records"));
        } else {
            stringBuffer.append(PrintSupportor.res.getString("Record"));
        }
        return stringBuffer;
    }

    public void sureWrite() throws IOException {
        this.xlsxWriter.endSheet();
        if (this.isSaveOver) {
            // empty if block
        }
        this.bufferedStream.flush();
        this.closeCurrentStream();
        System.gc();
    }

    @Override
    public void writeTitle(String string) throws IOException {
        this.fileName = string;
        this.calculatorFiles(this.calculatorAllOutputRows());
        this.initWorkbook(this.fileNames[this.index]);
        ++this.index;
        this.xlsxWriter.insertRow(this.y);
        this.xlsxWriter.createCell(this.x, this.formatCalculator.getTitle());
        this.xlsxWriter.endRow();
        ++this.y;
    }

    public void writeTotalExtraInfo() {
    }

    @Override
    public void writeExtraInfo() throws IOException {
        StringBuffer stringBuffer = new StringBuffer(PrintSupportor.res.getString("saveTime"));
        stringBuffer.append(this.formatCalculator.getTime());
        this.xlsxWriter.insertRow(this.y);
        this.xlsxWriter.createCell(this.x, stringBuffer.toString());
        this.xlsxWriter.endRow();
        ++this.y;
        stringBuffer = new StringBuffer(PrintSupportor.res.getString("userName").trim());
        stringBuffer.append(this.formatCalculator.getUserName().trim());
        this.xlsxWriter.insertRow(this.y);
        this.xlsxWriter.createCell(this.x, stringBuffer.toString());
        this.xlsxWriter.endRow();
        ++this.y;
        if (this.formatCalculator.getSummary().trim().length() > 0) {
            stringBuffer = new StringBuffer("");
            stringBuffer.append(this.formatCalculator.getSummary().trim());
            this.xlsxWriter.insertRow(this.y);
            this.xlsxWriter.createCell(this.x, stringBuffer.toString());
            this.xlsxWriter.endRow();
            ++this.y;
        }
        if (this.sheetIndex > Integer.MIN_VALUE) {
            stringBuffer = new StringBuffer(PrintSupportor.res.getString("Current_page_Total_page").trim());
            stringBuffer.append(' ');
            int n = this.totalWorkbook > 0 ? this.totalWorkbook : 1;
            stringBuffer.append(this.actualIndex + 1).append('/').append(n);
            this.xlsxWriter.insertRow(this.y);
            this.xlsxWriter.createCell(this.x, stringBuffer.toString());
            this.xlsxWriter.endRow();
            ++this.y;
        }
        if (!this.parentFormatCalculator.getTotleRecordsPosition()) {
            ++this.y;
        }
    }

    protected void writeHeader() throws IOException {
        String[] stringArray = this.formatCalculator.getTableHeaders();
        this.xlsxWriter.insertRow(this.y);
        for (int i = 0; i < stringArray.length; ++i) {
            this.xlsxWriter.createCell(this.x, stringArray[i]);
            ++this.x;
        }
        this.xlsxWriter.endRow();
        this.x = 0;
        ++this.y;
    }

    protected void writeData() throws IOException {
        this.writeData(true);
    }

    private void writeData(boolean bl) throws IOException {
        StringBuffer stringBuffer = null;
        int n = this.y + 1;
        for (int i = 0; i < this.formatCalculator.getTotalRowCount() - this.parentFormatCalculator.getAdjustInt(); ++i) {
            boolean bl2;
            int n2 = -1;
            LinkedList linkedList = null;
            LinkedList linkedList2 = null;
            while (!this.isOver()) {
                if (i >= this.formatCalculator.getTotalRowCount() - this.parentFormatCalculator.getAdjustInt()) {
                    this.writeTotalCount = this.parentFormatCalculator.getTotalRowsCount() - this.parentFormatCalculator.getAdjustInt();
                    this.parentFormatCalculator.setAdjustInt(-this.parentFormatCalculator.getAdjustInt());
                    return;
                }
                n2 = i;
                if (n2 >= 0 && n2 < this.formatCalculator.getAnalyzedRowCount()) break;
                try {
                    logger.trace("Waiting for this row index " + n2);
                    Thread.sleep(100L);
                }
                catch (InterruptedException interruptedException) {
                    logger.trace(interruptedException.getMessage(), interruptedException);
                }
            }
            if (this.isOver()) {
                this.writeTotalCount = i;
                this.parentFormatCalculator.setAdjustInt(-this.parentFormatCalculator.getAdjustInt());
                return;
            }
            linkedList = this.formatCalculator.getAndDeleteAnalyzedRowLinkList(n2);
            Iterator iterator = linkedList.iterator();
            this.xlsxWriter.insertRow(this.y);
            while (iterator.hasNext()) {
                linkedList2 = (LinkedList)iterator.next();
                if (this.parentFormatCalculator.getTableHeadersProperty() != null && this.parentFormatCalculator.getTableHeadersProperty()[this.x] == 1) {
                    try {
                        if (this.isCommaExit((String)linkedList2.getFirst())) {
                            if (this.isDecimal(((String)linkedList2.getFirst()).replace(",", ""))) {
                                this.xlsxWriter.createCell(this.x, Double.parseDouble(((String)linkedList2.getFirst()).replace(",", "")), 2);
                                ++this.x;
                                continue;
                            }
                            this.xlsxWriter.createCell(this.x, Double.parseDouble(((String)linkedList2.getFirst()).replace(",", "")), 3);
                            ++this.x;
                            continue;
                        }
                        this.xlsxWriter.createCell(this.x, Double.parseDouble((String)linkedList2.getFirst()));
                        ++this.x;
                    }
                    catch (Exception exception) {
                        this.xlsxWriter.createCell(this.x, (String)linkedList2.getFirst());
                        ++this.x;
                    }
                    continue;
                }
                this.xlsxWriter.createCell(this.x, (String)linkedList2.getFirst());
                ++this.x;
            }
            this.xlsxWriter.endRow();
            this.formatCalculator.setLastPrintedRowIndex(i);
            ++this.y;
            this.x = 0;
            boolean bl3 = bl2 = i != this.formatCalculator.getTotalRowCount() - this.parentFormatCalculator.getAdjustInt() - 1;
            if (this.y >= this.formatCalculator.getMaxRecordsCountPerFile() && bl2) {
                this.sureWrite();
                String string = this.fileName.substring(0, this.fileName.length() - 5) + "@" + this.index + ".xlsx";
                ++this.index;
                ++this.actualIndex;
                stringBuffer = new StringBuffer(20);
                while (new File(CommonUtil.getAbsolutePath(string)).exists()) {
                    stringBuffer.delete(0, stringBuffer.length());
                    stringBuffer.append(this.fileName.substring(0, this.fileName.length() - 4));
                    stringBuffer.append("@");
                    stringBuffer.append(this.index);
                    stringBuffer.append(".xlsx");
                    string = stringBuffer.toString();
                    ++this.index;
                }
                this.fileNames[this.currentFileNo] = string;
                ++this.currentFileNo;
                this.setCsvXlsorPdfFileNames(this.fileNames);
                this.initWorkbook(string);
                this.x = 0;
                this.y = 0;
                if (this.sheetIndex > Integer.MIN_VALUE && null != this.templateFile) {
                    this.writeTitle();
                    this.writeExtraInfo();
                    ++this.y;
                    this.writeTotalRecordInfo();
                    ++this.y;
                }
                this.writeHeader();
                n = this.y;
            }
            ++n;
        }
        this.isSaveOver = true;
        this.writeTotalCount = this.parentFormatCalculator.getTotalRowsCount() - this.parentFormatCalculator.getAdjustInt();
        this.parentFormatCalculator.setAdjustInt(-this.parentFormatCalculator.getAdjustInt());
    }

    @Override
    public void writeTitle() throws IOException {
        this.xlsxWriter.insertRow(this.y);
        this.xlsxWriter.createCell(this.x, this.formatCalculator.getTitle());
        this.xlsxWriter.endRow();
        ++this.y;
    }

    private void showMutiFilesInfo() {
        if (null == this.fileNames || FrameworkCommandProcessor.getInstance().isLoggingOut()) {
            return;
        }
        if (Os.getOs() instanceof Windows && this.fileNames.length > 0 && this.formatCalculator.isOpenFileEnabled()) {
            this.openXlsOrTXTFile(this.fileNames);
        } else if (this.fileNames.length > 0) {
            this.displaySave();
        }
    }

    private void displaySave() {
        int n = 0;
        for (int i = 0; i < this.fileNames.length; ++i) {
            if (this.fileNames[i] == null || this.fileNames[i].length() <= 0) continue;
            ++n;
        }
        if (n < 2 && Os.getOs() instanceof Windows) {
            return;
        }
        if (n < 2 && Os.getOs() instanceof Solaris && !this.formatCalculator.isOpenFileEnabled()) {
            return;
        }
        StringBuffer stringBuffer = new StringBuffer(10);
        if (this.fileNames.length > 1) {
            stringBuffer.append(PrintSupportor.res.getString("fileNames"));
        } else {
            stringBuffer.append(PrintSupportor.res.getString("fileName"));
        }
        stringBuffer.append(System.getProperty("line.separator"));
        for (int i = 0; i < n - 1; ++i) {
            stringBuffer.append(this.fileNames[i]);
            stringBuffer.append(", ");
        }
        stringBuffer.append(this.fileNames[n - 1]);
        stringBuffer.append(PrintSupportor.res.getString("fullStop"));
        this.showDetailMsg(stringBuffer.toString());
    }

    private void showDetailMsg(final String string) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                if (FrameworkCommandProcessor.getInstance().isLogoutInProcess()) {
                    return;
                }
                String string2 = PrintSupportor.res.getString("fileNamesInfo");
                if (XLSXSaveImpl.this.fileNames.length == 1) {
                    string2 = PrintSupportor.res.getString("fileSaveInfo");
                }
                JFrame jFrame = null;
                jFrame = XLSXSaveImpl.this.parentFrame != null ? XLSXSaveImpl.this.parentFrame : FrameworkUtilities.getMainFrame();
                DetailMessageDlg detailMessageDlg = null;
                if (jFrame instanceof JFrame || jFrame == null) {
                    detailMessageDlg = new DetailMessageDlg((Frame)jFrame, PrintSupportor.res.getString("Prompt"), (Object)string2, (Object)string);
                } else if (jFrame instanceof JDialog) {
                    detailMessageDlg = new DetailMessageDlg((Dialog)((JDialog)((Object)jFrame)), PrintSupportor.res.getString("Prompt"), (Object)string2, (Object)string);
                } else {
                    logger.trace("In XLSSaveImpl parentFrame is notJDialog or JFrame");
                    return;
                }
                detailMessageDlg.pack();
                detailMessageDlg.show();
            }
        });
    }

    @Override
    public void closeCurrentStream() throws IOException {
        if (null == this.bufferedStream) {
            return;
        }
        try {
            this.xlsxWriter.closeWriter();
        }
        catch (IOException iOException) {
            logger.trace("In close current zip output stream: " + iOException);
            throw iOException;
        }
        finally {
            try {
                this.bufferedStream.close();
            }
            catch (IOException iOException) {
                logger.trace("In closeCurrentStream bufferedStream : " + iOException);
            }
            try {
                this.lockStream.close();
            }
            catch (IOException iOException) {
                logger.trace("In closeCurrentStream lockStream : " + iOException);
            }
            this.bufferedStream = null;
        }
    }

    public int getSheetIndex() {
        return this.sheetIndex;
    }

    public void setSheetIndex(int n) {
        this.sheetIndex = n;
    }

    public String getTemplateFile() {
        return this.templateFile;
    }

    public void setTemplateFile(String string) {
        this.templateFile = string;
    }

    @Override
    public void writeInit(String string, TablePrintable[] tablePrintableArray) throws IOException {
        this.fileName = string;
        this.calculatorFiles(this.calculatorAllOutputRows(tablePrintableArray));
        this.initWorkbook(this.fileNames[this.index]);
        ++this.index;
    }

    private int calculatorAllOutputRows(TablePrintable[] tablePrintableArray) {
        int n = 0;
        for (int i = 0; i < tablePrintableArray.length; ++i) {
            n += tablePrintableArray[i].getFormatCalculator().getTotalRowCount() + 10;
        }
        return n;
    }

    @Override
    public void write(boolean bl) throws IOException {
        ++this.y;
        if (this.parentFormatCalculator.getTotleRecordsPosition()) {
            if (!this.parentFormatCalculator.isNormalSave()) {
                this.writeHeader();
            }
            this.writeData(bl);
            ++this.y;
        }
        this.writeTotalRecordInfo();
        if (!this.parentFormatCalculator.getTotleRecordsPosition()) {
            ++this.y;
            if (!this.parentFormatCalculator.isNormalSave()) {
                this.writeHeader();
            }
            this.writeData(bl);
        }
        if (bl) {
            this.sureWrite();
            if (!this.parentFormatCalculator.getDeleteFileFlag()) {
                this.showMutiFilesInfo();
            }
        } else {
            ++this.y;
        }
    }

    @Override
    public void associatePreSaveImplInfo(ExcelSaveImpl excelSaveImpl) {
        if (!(excelSaveImpl instanceof XLSXSaveImpl)) {
            logger.error("Cannot associate diffenrent impl info");
        }
        XLSXSaveImpl xLSXSaveImpl = (XLSXSaveImpl)excelSaveImpl;
        this.index = xLSXSaveImpl.index;
        this.y = xLSXSaveImpl.y;
        this.xlsxWriter = xLSXSaveImpl.xlsxWriter;
        this.bufferedStream = xLSXSaveImpl.bufferedStream;
        this.lockStream = xLSXSaveImpl.lockStream;
        this.currentFileNo = xLSXSaveImpl.currentFileNo;
        this.fileName = xLSXSaveImpl.fileName;
        this.fileNames = xLSXSaveImpl.fileNames;
    }
}

