/*
 * Decompiled with CFR 0.152.
 */
package com.swimap.iview.templates.print.tools;

import com.swimap.iview.framework.util.FrameworkCommandProcessor;
import com.swimap.iview.framework.util.FrameworkUtilities;
import com.swimap.iview.templates.dialog.DetailMessageDlg;
import com.swimap.iview.templates.print.FormatCalculator;
import com.swimap.iview.templates.print.PrintSupportor;
import com.swimap.iview.templates.print.tools.ExcelSaveImpl;
import com.swimap.iview.templates.print.tools.TablePrintable;
import com.swimap.iview.templates.print.tools.XLSXSaveImpl;
import com.swimap.iview.util.CommonUtil;
import com.swimap.iview.util.format.NumberFormatUtil;
import com.swimap.iview.util.jni.Os;
import com.swimap.iview.util.jni.Solaris;
import com.swimap.iview.util.jni.Windows;
import com.swimap.iview.util.log.IviewLogger;
import java.awt.Dialog;
import java.awt.Frame;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.channels.FileLock;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.SwingUtilities;
import jxl.Workbook;
import jxl.WorkbookSettings;
import jxl.format.CellFormat;
import jxl.read.biff.BiffException;
import jxl.write.Label;
import jxl.write.Number;
import jxl.write.NumberFormats;
import jxl.write.WritableCell;
import jxl.write.WritableCellFormat;
import jxl.write.WritableSheet;
import jxl.write.WritableWorkbook;
import jxl.write.WriteException;
import jxl.write.biff.RowsExceededException;

public class XLSSaveImpl
extends ExcelSaveImpl {
    private static IviewLogger logger = IviewLogger.getLogger(XLSSaveImpl.class, "IVIEW");
    private WritableWorkbook workbook = null;
    private WritableSheet sheet = null;
    private Label label = null;
    private Number number = null;
    private static final String DEFAULT_SHEET_NAME = "Sheet1";
    private static final String SHEET = "Sheet";
    private File file = null;
    private int index = 0;
    private int actualIndex = 0;
    private int x = 0;
    private int y = 0;
    private static final int ONE_SECOND = 1000;
    private static final int EXTRA_INFO_ROWS = 10;
    private boolean isSaveOver = false;
    private FormatCalculator parentFormatCalculator = null;
    private int writeTotalCount = 0;
    private BufferedOutputStream bufferedStream = null;
    private FileOutputStream lockStream = null;
    private static final int HEADER_SIZE = 10;
    private static final String CURR_DIR = System.getProperty("user.dir");
    private static final String TMPFOLDERNAME = CURR_DIR + "/configuration/" + "tmpbatchwrite";
    private final int MAX_CELLS_PER_BATCH = 200000;
    private int maxRowsPerBatch = 0;
    private boolean firstBatchWrite = true;
    private int sheetIndex = Integer.MIN_VALUE;
    private String templateFile = null;

    public XLSSaveImpl(FormatCalculator formatCalculator) {
        super(formatCalculator.getXLSFormatCalculator());
        this.parentFormatCalculator = formatCalculator;
        this.writeTotalCount = this.parentFormatCalculator.getTotalRowsCount() - this.parentFormatCalculator.getAdjustInt();
        int n = 200000 / formatCalculator.getRrintColCount();
        this.maxRowsPerBatch = n / 32 * 32;
    }

    private int calculatorAllOutputRows() {
        if (this.sheetIndex > Integer.MIN_VALUE) {
            int n = this.formatCalculator.getTotalRowCount();
            int n2 = this.formatCalculator.getMaxRecordsCountPerFile();
            int n3 = n / (n2 - 10);
            int n4 = n + n3 * 10;
            return n4;
        }
        return this.formatCalculator.getTotalRowCount() + 10;
    }

    private void initWorkbook(String string) throws IOException {
        File file;
        boolean bl;
        this.file = new File(CommonUtil.getAbsolutePath(string));
        if (!this.file.exists() && !(bl = this.file.createNewFile())) {
            logger.trace("The file alredy exist " + string);
        }
        this.lockStream = new FileOutputStream(string);
        FileLock fileLock = this.lockStream.getChannel().lock();
        if (null == fileLock || !fileLock.isValid()) {
            logger.trace("In initWorkbook, the file could'nt be locked: " + string);
        }
        this.bufferedStream = new BufferedOutputStream(this.lockStream);
        WorkbookSettings workbookSettings = new WorkbookSettings();
        workbookSettings.setRowsPerBatch(this.maxRowsPerBatch);
        workbookSettings.setRowsPerSheet(Math.min(this.formatCalculator.getTotalRowCount() + 10, this.formatCalculator.getMaxRecordsCountPerFile()));
        int n = Math.min(this.formatCalculator.getTotalRowCount(), this.formatCalculator.getMaxRecordsCountPerFile());
        if (this.formatCalculator.getRrintColCount() * n > 200000) {
            logger.trace("Using temporary folder to write files.");
            workbookSettings.setUseTemporaryFileDuringWrite(true);
            file = new File(TMPFOLDERNAME);
            boolean bl2 = true;
            if (!file.exists()) {
                bl2 = file.mkdir();
            }
            if (bl2) {
                workbookSettings.setTemporaryFileDuringWriteDirectory(file);
            } else {
                logger.trace("Could not create temp folder: " + file);
            }
        } else {
            workbookSettings.setArrayGrowSize(262144);
            workbookSettings.setInitialFileSize(0x100000);
        }
        if (null != this.userEncoding) {
            workbookSettings.setEncoding(this.userEncoding);
        }
        if (this.sheetIndex == Integer.MIN_VALUE) {
            this.workbook = Workbook.createWorkbook((OutputStream)this.bufferedStream, (WorkbookSettings)workbookSettings);
            this.sheet = this.workbook.createSheet(DEFAULT_SHEET_NAME, 0);
        } else {
            file = null;
            try {
                file = Workbook.getWorkbook((File)new File(this.getTemplateFile()));
            }
            catch (BiffException biffException) {
                logger.trace((Object)biffException);
            }
            this.workbook = Workbook.createWorkbook((OutputStream)this.bufferedStream, (Workbook)file);
            int n2 = this.workbook.getNumberOfSheets();
            this.setValidSheetName(n2);
        }
    }

    private void setValidSheetName(int n) {
        List<String> list = Arrays.asList(this.workbook.getSheetNames());
        if (this.sheetIndex > n || this.sheetIndex <= 0 || list.contains(SHEET + this.sheetIndex)) {
            this.sheetIndex = n + 1;
        }
        while (list.contains(SHEET + this.sheetIndex)) {
            ++this.sheetIndex;
        }
        this.sheet = this.workbook.createSheet(SHEET + this.sheetIndex, this.sheetIndex - 1);
    }

    @Override
    public void write() throws IOException, WriteException {
        ++this.y;
        if (this.parentFormatCalculator.getTotleRecordsPosition()) {
            if (!this.parentFormatCalculator.isNormalSave()) {
                this.writeHeader();
            }
            this.writeData(true);
            ++this.y;
        }
        this.writeTotalRecordInfo();
        if (!this.parentFormatCalculator.getTotleRecordsPosition()) {
            ++this.y;
            if (!this.parentFormatCalculator.isNormalSave()) {
                this.writeHeader();
            }
            this.writeData(true);
        }
        this.sureWrite();
        if (!this.parentFormatCalculator.getDeleteFileFlag()) {
            this.showMutiFilesInfo();
        }
    }

    private void writeTotalRecordInfo() throws WriteException {
        if (this.parentFormatCalculator.getTotalRecordCount() != -1) {
            this.writeTotalCount = this.parentFormatCalculator.getTotalRecordCount();
        }
        if (this.parentFormatCalculator.isTotalRecordVisible()) {
            StringBuffer stringBuffer = this.getTotalRecords(this.writeTotalCount);
            this.label = new Label(this.x, this.y, stringBuffer.toString());
            ++this.y;
            this.sheet.addCell((WritableCell)this.label);
        }
    }

    private StringBuffer getTotalRecords(int n) {
        StringBuffer stringBuffer = new StringBuffer(22);
        stringBuffer.append(PrintSupportor.res.getString("Total"));
        stringBuffer.append(NumberFormatUtil.getFormatNumber(n));
        stringBuffer.append(' ');
        if (n > 1) {
            stringBuffer.append(PrintSupportor.res.getString("Records"));
        } else {
            stringBuffer.append(PrintSupportor.res.getString("Record"));
        }
        return stringBuffer;
    }

    public void sureWrite() throws IOException {
        if (this.firstBatchWrite) {
            this.workbook.write();
        } else {
            this.workbook.appendRecords();
            this.workbook.writeTail();
        }
        try {
            this.workbook.close();
        }
        catch (WriteException writeException) {
            writeException.printStackTrace();
        }
        if (this.isSaveOver) {
            // empty if block
        }
        this.closeCurrentStream();
    }

    private void batchWrite() throws IOException {
        if (this.firstBatchWrite) {
            this.workbook.writeHead();
            this.firstBatchWrite = false;
        }
        this.workbook.appendRecords();
        System.gc();
    }

    @Override
    public void writeTitle(String string) throws IOException, WriteException {
        this.fileName = string;
        this.calculatorFiles(this.calculatorAllOutputRows());
        this.initWorkbook(this.fileNames[this.index]);
        ++this.index;
        this.label = new Label(this.x, this.y, this.formatCalculator.getTitle());
        ++this.y;
        this.sheet.addCell((WritableCell)this.label);
    }

    public void writeTotalExtraInfo() throws WriteException {
    }

    @Override
    public void writeExtraInfo() throws WriteException {
        StringBuffer stringBuffer = new StringBuffer(PrintSupportor.res.getString("saveTime"));
        stringBuffer.append(this.formatCalculator.getTime());
        this.label = new Label(this.x, this.y, stringBuffer.toString());
        ++this.y;
        this.sheet.addCell((WritableCell)this.label);
        stringBuffer = new StringBuffer(PrintSupportor.res.getString("userName").trim());
        stringBuffer.append(this.formatCalculator.getUserName().trim());
        this.label = new Label(this.x, this.y, stringBuffer.toString());
        ++this.y;
        this.sheet.addCell((WritableCell)this.label);
        if (this.formatCalculator.getSummary().trim().length() > 0) {
            stringBuffer = new StringBuffer("");
            stringBuffer.append(this.formatCalculator.getSummary().trim());
            this.label = new Label(this.x, this.y, stringBuffer.toString());
            ++this.y;
            this.sheet.addCell((WritableCell)this.label);
        }
        if (this.sheetIndex > Integer.MIN_VALUE) {
            stringBuffer = new StringBuffer(PrintSupportor.res.getString("Current_page_Total_page").trim());
            stringBuffer.append(' ');
            int n = this.totalWorkbook > 0 ? this.totalWorkbook : 1;
            stringBuffer.append(this.actualIndex + 1).append('/').append(n);
            this.label = new Label(this.x, this.y, stringBuffer.toString());
            ++this.y;
            this.sheet.addCell((WritableCell)this.label);
        }
        if (!this.parentFormatCalculator.getTotleRecordsPosition()) {
            ++this.y;
        }
    }

    protected void writeHeader() throws WriteException {
        String[] stringArray = this.formatCalculator.getTableHeaders();
        for (int i = 0; i < stringArray.length; ++i) {
            this.label = new Label(this.x, this.y, stringArray[i]);
            ++this.x;
            this.sheet.addCell((WritableCell)this.label);
        }
        this.x = 0;
        ++this.y;
    }

    protected void writeData() throws IOException, WriteException {
        this.writeData(true);
    }

    private void writeData(boolean bl) throws IOException, WriteException {
        StringBuffer stringBuffer = null;
        int n = this.y + 1;
        for (int i = 0; i < this.formatCalculator.getTotalRowCount() - this.parentFormatCalculator.getAdjustInt(); ++i) {
            boolean bl2;
            int n2 = -1;
            LinkedList linkedList = null;
            LinkedList linkedList22 = null;
            while (!this.isOver()) {
                if (i >= this.formatCalculator.getTotalRowCount() - this.parentFormatCalculator.getAdjustInt()) {
                    this.writeTotalCount = this.parentFormatCalculator.getTotalRowsCount() - this.parentFormatCalculator.getAdjustInt();
                    this.parentFormatCalculator.setAdjustInt(-this.parentFormatCalculator.getAdjustInt());
                    return;
                }
                n2 = i;
                if (n2 >= 0 && n2 < this.formatCalculator.getAnalyzedRowCount()) break;
                try {
                    logger.trace("Waiting for this row index " + n2);
                    Thread.sleep(1000L);
                }
                catch (InterruptedException interruptedException) {
                    logger.trace(interruptedException.getMessage(), interruptedException);
                }
            }
            if (this.isOver()) {
                this.writeTotalCount = i;
                this.parentFormatCalculator.setAdjustInt(-this.parentFormatCalculator.getAdjustInt());
                return;
            }
            linkedList = this.formatCalculator.getAndDeleteAnalyzedRowLinkList(n2);
            for (LinkedList linkedList22 : linkedList) {
                if (this.parentFormatCalculator.getTableHeadersProperty() != null && this.parentFormatCalculator.getTableHeadersProperty()[this.x] == 1) {
                    try {
                        WritableCellFormat writableCellFormat = null;
                        if (this.isCommaExit((String)linkedList22.getFirst())) {
                            if (this.isDecimal(((String)linkedList22.getFirst()).replace(",", ""))) {
                                writableCellFormat = new WritableCellFormat(NumberFormats.THOUSANDS_FLOAT);
                                this.number = new Number(this.x, this.y, Double.parseDouble(((String)linkedList22.getFirst()).replace(",", "")), (CellFormat)writableCellFormat);
                                ++this.x;
                                this.sheet.addCell((WritableCell)this.number);
                                continue;
                            }
                            writableCellFormat = new WritableCellFormat(NumberFormats.THOUSANDS_INTEGER);
                            this.number = new Number(this.x, this.y, Double.parseDouble(((String)linkedList22.getFirst()).replace(",", "")), (CellFormat)writableCellFormat);
                            ++this.x;
                            this.sheet.addCell((WritableCell)this.number);
                            continue;
                        }
                        this.number = new Number(this.x, this.y, Double.parseDouble((String)linkedList22.getFirst()));
                        ++this.x;
                        this.sheet.addCell((WritableCell)this.number);
                    }
                    catch (Exception exception) {
                        this.label = new Label(this.x, this.y, (String)linkedList22.getFirst());
                        ++this.x;
                        this.sheet.addCell((WritableCell)this.label);
                    }
                    continue;
                }
                this.label = new Label(this.x, this.y, (String)linkedList22.getFirst());
                ++this.x;
                this.sheet.addCell((WritableCell)this.label);
            }
            this.formatCalculator.setLastPrintedRowIndex(i);
            ++this.y;
            this.x = 0;
            boolean bl3 = bl2 = i != this.formatCalculator.getTotalRowCount() - this.parentFormatCalculator.getAdjustInt() - 1;
            if (this.y >= this.formatCalculator.getMaxRecordsCountPerFile() && bl2) {
                this.sureWrite();
                String string = this.fileName.substring(0, this.fileName.length() - 4) + "@" + this.index + ".xls";
                ++this.index;
                ++this.actualIndex;
                stringBuffer = new StringBuffer(20);
                while (new File(CommonUtil.getAbsolutePath(string)).exists()) {
                    stringBuffer.delete(0, stringBuffer.length());
                    stringBuffer.append(this.fileName.substring(0, this.fileName.length() - 4));
                    stringBuffer.append("@");
                    stringBuffer.append(this.index);
                    stringBuffer.append(".xls");
                    string = stringBuffer.toString();
                    ++this.index;
                }
                this.fileNames[this.currentFileNo] = string;
                ++this.currentFileNo;
                this.setCsvXlsorPdfFileNames(this.fileNames);
                this.initWorkbook(string);
                this.x = 0;
                this.y = 0;
                if (this.sheetIndex > Integer.MIN_VALUE && null != this.templateFile) {
                    this.writeTitle();
                    this.writeExtraInfo();
                    ++this.y;
                    this.writeTotalRecordInfo();
                    ++this.y;
                }
                this.writeHeader();
                this.firstBatchWrite = true;
                n = this.y;
            } else if (n >= this.maxRowsPerBatch && bl2) {
                this.batchWrite();
                n = 0;
            }
            ++n;
        }
        this.isSaveOver = true;
        this.writeTotalCount = this.parentFormatCalculator.getTotalRowsCount() - this.parentFormatCalculator.getAdjustInt();
        this.parentFormatCalculator.setAdjustInt(-this.parentFormatCalculator.getAdjustInt());
    }

    @Override
    public void writeTitle() throws RowsExceededException, WriteException {
        this.label = new Label(this.x, this.y, this.formatCalculator.getTitle());
        this.sheet.addCell((WritableCell)this.label);
        ++this.y;
    }

    private void showMutiFilesInfo() {
        if (null == this.fileNames || FrameworkCommandProcessor.getInstance().isLoggingOut()) {
            return;
        }
        if (Os.getOs() instanceof Windows && this.fileNames.length > 0 && this.formatCalculator.isOpenFileEnabled()) {
            this.openXlsOrTXTFile(this.fileNames);
        } else if (this.fileNames.length > 0) {
            this.displaySave();
        }
    }

    private void displaySave() {
        int n = 0;
        for (int i = 0; i < this.fileNames.length; ++i) {
            if (this.fileNames[i] == null || this.fileNames[i].length() <= 0) continue;
            ++n;
        }
        if (n < 2 && Os.getOs() instanceof Windows) {
            return;
        }
        if (n < 2 && Os.getOs() instanceof Solaris && !this.formatCalculator.isOpenFileEnabled()) {
            return;
        }
        StringBuffer stringBuffer = new StringBuffer(10);
        if (this.fileNames.length > 1) {
            stringBuffer.append(PrintSupportor.res.getString("fileNames"));
        } else {
            stringBuffer.append(PrintSupportor.res.getString("fileName"));
        }
        stringBuffer.append(System.getProperty("line.separator"));
        for (int i = 0; i < n - 1; ++i) {
            stringBuffer.append(this.fileNames[i]);
            stringBuffer.append(", ");
        }
        stringBuffer.append(this.fileNames[n - 1]);
        stringBuffer.append(PrintSupportor.res.getString("fullStop"));
        this.showDetailMsg(stringBuffer.toString());
    }

    private void showDetailMsg(final String string) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                if (FrameworkCommandProcessor.getInstance().isLogoutInProcess()) {
                    return;
                }
                String string2 = PrintSupportor.res.getString("fileNamesInfo");
                if (XLSSaveImpl.this.fileNames.length == 1) {
                    string2 = PrintSupportor.res.getString("fileSaveInfo");
                }
                JFrame jFrame = null;
                jFrame = XLSSaveImpl.this.parentFrame != null ? XLSSaveImpl.this.parentFrame : FrameworkUtilities.getMainFrame();
                DetailMessageDlg detailMessageDlg = null;
                if (jFrame instanceof JFrame || jFrame == null) {
                    detailMessageDlg = new DetailMessageDlg((Frame)jFrame, PrintSupportor.res.getString("Prompt"), (Object)string2, (Object)string);
                } else if (jFrame instanceof JDialog) {
                    detailMessageDlg = new DetailMessageDlg((Dialog)((JDialog)((Object)jFrame)), PrintSupportor.res.getString("Prompt"), (Object)string2, (Object)string);
                } else {
                    logger.trace("In XLSSaveImpl parentFrame is notJDialog or JFrame");
                    return;
                }
                detailMessageDlg.pack();
                detailMessageDlg.show();
            }
        });
    }

    @Override
    public void closeCurrentStream() {
        if (null == this.bufferedStream) {
            return;
        }
        try {
            this.bufferedStream.close();
        }
        catch (IOException iOException) {
            logger.trace("In closeCurrentStream bufferedStream : " + iOException);
        }
        try {
            this.lockStream.close();
        }
        catch (IOException iOException) {
            logger.trace("In closeCurrentStream lockStream : " + iOException);
        }
        this.bufferedStream = null;
    }

    public int getSheetIndex() {
        return this.sheetIndex;
    }

    public void setSheetIndex(int n) {
        this.sheetIndex = n;
    }

    public String getTemplateFile() {
        return this.templateFile;
    }

    public void setTemplateFile(String string) {
        this.templateFile = string;
    }

    @Override
    public void writeInit(String string, TablePrintable[] tablePrintableArray) throws IOException, WriteException {
        this.fileName = string;
        this.calculatorFiles(this.calculatorAllOutputRows(tablePrintableArray));
        this.initWorkbook(this.fileNames[this.index]);
        ++this.index;
    }

    private int calculatorAllOutputRows(TablePrintable[] tablePrintableArray) {
        int n = 0;
        for (int i = 0; i < tablePrintableArray.length; ++i) {
            n += tablePrintableArray[i].getFormatCalculator().getTotalRowCount() + 10;
        }
        return n;
    }

    @Override
    public void write(boolean bl) throws IOException, WriteException {
        ++this.y;
        if (this.parentFormatCalculator.getTotleRecordsPosition()) {
            if (!this.parentFormatCalculator.isNormalSave()) {
                this.writeHeader();
            }
            this.writeData(bl);
            ++this.y;
        }
        this.writeTotalRecordInfo();
        if (!this.parentFormatCalculator.getTotleRecordsPosition()) {
            ++this.y;
            if (!this.parentFormatCalculator.isNormalSave()) {
                this.writeHeader();
            }
            this.writeData(bl);
        }
        if (bl) {
            this.sureWrite();
            if (!this.parentFormatCalculator.getDeleteFileFlag()) {
                this.showMutiFilesInfo();
            }
        } else {
            ++this.y;
        }
    }

    @Override
    public void associatePreSaveImplInfo(ExcelSaveImpl excelSaveImpl) {
        if (!(excelSaveImpl instanceof XLSXSaveImpl)) {
            logger.error("Cannot associate diffenrent impl info");
        }
        XLSSaveImpl xLSSaveImpl = (XLSSaveImpl)excelSaveImpl;
        this.index = xLSSaveImpl.index;
        this.y = xLSSaveImpl.y;
        this.sheet = xLSSaveImpl.sheet;
        this.workbook = xLSSaveImpl.workbook;
        this.bufferedStream = xLSSaveImpl.bufferedStream;
        this.lockStream = xLSSaveImpl.lockStream;
        this.currentFileNo = xLSSaveImpl.currentFileNo;
        this.fileName = xLSSaveImpl.fileName;
        this.fileNames = xLSSaveImpl.fileNames;
    }
}

