/*
 * Decompiled with CFR 0.152.
 */
package com.swimap.iview.templates.print.tools;

import com.swimap.iview.templates.print.FormatCalculator;
import com.swimap.iview.templates.print.PreViewFormatCalculator;
import com.swimap.iview.templates.print.PrintSupportor;
import com.swimap.iview.templates.print.PrintableTool;
import com.swimap.iview.templates.print.SavePrintable;
import com.swimap.iview.util.format.NumberFormatUtil;
import com.swimap.iview.util.log.IviewLogger;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.print.PageFormat;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;

public class TablePrintImpl
extends PrintableTool
implements SavePrintable {
    private static IviewLogger logger = IviewLogger.getLogger(TablePrintImpl.class, "IVIEW");
    protected int realTimePageIndex = 1;
    private FormatCalculator formatCalculator;
    private boolean bFirstForRealTimePrint = false;
    private LinkedList lastPageDataForFirstRealTimePrint = new LinkedList();
    private boolean bFirstPrintPage = true;
    private HashSet hashset = new HashSet(20);
    int columnCount = 0;
    private int columnStart = 0;
    private int allWidth = 0;
    private int i = 0;
    private static final int ONE_SECOND = 1000;
    private static final int WAIT_COUNTS = 300;
    private static final int THREE_lINE = 3;
    private static final int EXTRA_HEIGHT = 10;
    private static final int THREE_MILLISECOND = 3;
    private boolean isNeedSleep = true;
    Font dataFont = FormatCalculator.DATA_FONT;
    private int printedPageIndex = 1;
    private boolean bRealTimePrint = false;
    private int pageNum = 0;

    public TablePrintImpl(boolean bl, FormatCalculator formatCalculator) {
        super(formatCalculator.getTitle(), formatCalculator.getUserName());
        this.bRealTimePrint = bl;
        this.formatCalculator = formatCalculator;
        if (bl) {
            this.setHeadInfoEnabled(this.formatCalculator.getRealTimePrintControler().getHeadInfoEnabled());
            this.formatCalculator.setBRealTimePrint(true);
        }
    }

    @Override
    public boolean isOver() {
        return this.isDataOver();
    }

    @Override
    public FormatCalculator getFormatCalculator() {
        return this.formatCalculator;
    }

    @Override
    protected void drawHeadInfo(Graphics2D graphics2D, PageFormat pageFormat, int n) {
        if (this.bRealTimePrint && this.printedPageIndex != n && this.formatCalculator != null && this.formatCalculator.getRealTimePrintControler() != null) {
            this.realTimePageIndex = this.formatCalculator.getRealTimePageIndex();
            ++this.realTimePageIndex;
            this.pageNum = this.realTimePageIndex - 1;
            this.formatCalculator.setRealTimePageIndex(this.realTimePageIndex);
            this.printedPageIndex = n;
        } else if (!this.bRealTimePrint) {
            this.pageNum = n;
        }
        super.drawHeadInfo(graphics2D, pageFormat, this.pageNum);
    }

    @Override
    protected void drawPage(Graphics2D graphics2D, PageFormat pageFormat, int n) {
        if (this.bFirstPrintPage) {
            this.formatCalculator.setPageFormatWithCompute(pageFormat);
            if (this.bFirstForRealTimePrint && this.formatCalculator.getTablePageHashMap().size() > 1) {
                int n2 = this.formatCalculator.getLastPageRowCount();
                this.lastPageDataForFirstRealTimePrint.clear();
                int n3 = this.formatCalculator.getSourceDataArrayList().size();
                if (n2 < this.formatCalculator.getSourceDataArrayList().size()) {
                    this.formatCalculator.getTablePageHashMap().remove(this.formatCalculator.getTablePageHashMap().size() - 1);
                    for (int i = n3 - n2; i < n3; ++i) {
                        this.lastPageDataForFirstRealTimePrint.add(this.formatCalculator.getSourceDataArrayList().get(i));
                    }
                }
            }
            this.bFirstPrintPage = false;
        }
        this.drawTablePage(graphics2D, pageFormat, n);
    }

    private void drawTablePage(Graphics2D graphics2D, PageFormat pageFormat, int n) {
        if (!this.isReady(n)) {
            return;
        }
        int n2 = 0;
        n2 = this.formatCalculator.getTotleRecordsPosition() || this.formatCalculator.isBRealTimePrint() ? this.getHeadHeight() + 10 : this.getHeadHeight() + 10 + TablePrintImpl.getFontHeight(FormatCalculator.TABLE_HEADER_FONT) * 3;
        if (this.formatCalculator.getSummaryPageCount() > 0 && (!this.formatCalculator.isBRealTimePrint() || this.isBFirstForRealTimePrint())) {
            if (n < this.formatCalculator.getSummaryPageCount() - 1) {
                this.drawSummaryPage(graphics2D, pageFormat, n);
                return;
            }
            if (n == this.formatCalculator.getSummaryPageCount() - 1) {
                this.drawSummaryPage(graphics2D, pageFormat, n);
                n2 = this.formatCalculator.getSummaryLastPrintingY();
                if (!this.formatCalculator.getTotleRecordsPosition() && !this.formatCalculator.isBRealTimePrint() && this.formatCalculator.isTotalRecordVisible()) {
                    if (!this.formatCalculator.getPrintCountInNewPage()) {
                        this.drawTotalCount(graphics2D, n2);
                    }
                    n2 += TablePrintImpl.getFontHeight(FormatCalculator.TABLE_HEADER_FONT) * 3;
                }
            }
        } else if (!this.formatCalculator.isBRealTimePrint()) {
            n2 = this.getHeadHeight() + this.startY + 10;
            if (!this.formatCalculator.getTotleRecordsPosition() && this.formatCalculator.isTotalRecordVisible()) {
                if (!this.formatCalculator.getPrintCountInNewPage() && n == 0) {
                    this.drawTotalCount(graphics2D, n2);
                }
                n2 += TablePrintImpl.getFontHeight(FormatCalculator.TABLE_HEADER_FONT) * 3;
            }
        }
        int n3 = 0;
        Object v = this.formatCalculator.getTablePageHashMap().get(this.formatCalculator.getPageHashMapIndex(n));
        if (null != v) {
            n3 = (Integer)v;
        }
        if (n3 <= 0) {
            return;
        }
        this.computeColumnInfo(n);
        if (n == this.formatCalculator.getSummaryPageCount() && this.formatCalculator.getPrintCountInNewPage() && (!this.formatCalculator.isBRealTimePrint() || this.isBFirstForRealTimePrint())) {
            n2 = this.getHeadHeight() + 10;
            if (!this.formatCalculator.getTotleRecordsPosition() && this.formatCalculator.isTotalRecordVisible()) {
                this.drawTotalCount(graphics2D, n2);
                n2 += TablePrintImpl.getFontHeight(FormatCalculator.TABLE_HEADER_FONT) * 3;
            }
        }
        int n4 = this.computeRealIndex(n);
        if ((!this.formatCalculator.getTotleRecordsPosition() || n4 < this.formatCalculator.getAnalyzedRowCount() - 1 || !this.formatCalculator.isTotalRecordVisible() && this.formatCalculator.getTotleRecordsPosition()) && !this.formatCalculator.isNormalSave()) {
            this.drawTableHeader(graphics2D, n2);
            n2 += this.formatCalculator.getTableHeaderHeight();
        }
        n2 = this.drawRow(graphics2D, pageFormat, n4, n3, n2);
        Integer n5 = n4;
        if (this.hashset.contains(n5)) {
            ++this.i;
            if (this.i == 2 * this.formatCalculator.pageCountHTable.size() - 1) {
                this.formatCalculator.setLastPrintedRowIndex(n4);
                this.hashset.remove(n5);
                this.i = 0;
            }
        } else {
            this.hashset.add(n5);
        }
        if (this.formatCalculator.getTotleRecordsPosition() && this.isTimetodrawTotalCount(n) && this.formatCalculator.isTotalRecordVisible()) {
            this.drawTotalCount(graphics2D, n2);
            this.endY = n2 + TablePrintImpl.getFontHeight(FormatCalculator.TABLE_HEADER_FONT) * 2 - TablePrintImpl.getFontDescent(FormatCalculator.TABLE_HEADER_FONT);
            return;
        }
        this.endY = n2;
    }

    private boolean isTimetodrawTotalCount(int n) {
        return n == this.formatCalculator.getPageCount() - 1;
    }

    private int computeRealIndex(int n) {
        int n2 = this.formatCalculator.getPageHashMapIndex(n);
        if (this.formatCalculator instanceof PreViewFormatCalculator) {
            PreViewFormatCalculator preViewFormatCalculator = (PreViewFormatCalculator)this.formatCalculator;
            int n3 = 0;
            for (int i = preViewFormatCalculator.getStartPage(); i < n2; ++i) {
                Integer n4 = (Integer)this.formatCalculator.getTablePageHashMap().get(i);
                n3 += n4.intValue();
            }
            return n3;
        }
        int n5 = 0;
        for (int i = 0; i < n2; ++i) {
            Integer n6 = (Integer)this.formatCalculator.getTablePageHashMap().get(i);
            n5 += n6.intValue();
        }
        return n5;
    }

    private boolean isReady(int n) {
        if (this.formatCalculator instanceof PreViewFormatCalculator) {
            return this.formatCalculator.getTablePageHashMap().containsKey(this.formatCalculator.getPageHashMapIndex(n));
        }
        if (!this.formatCalculator.isBRealTimePrint()) {
            while (n == this.formatCalculator.getMaxPageCount() - this.formatCalculator.pageCountHTable.size() && !this.formatCalculator.isComputeOver()) {
                if (this.isDataOver()) {
                    return false;
                }
                try {
                    Thread.sleep(1000L);
                }
                catch (InterruptedException interruptedException) {
                    logger.trace(interruptedException.getMessage(), interruptedException);
                }
            }
        }
        int n2 = 0;
        StringBuffer stringBuffer = null;
        while (n > this.formatCalculator.getMaxPageCount() - 1 && n2 <= 300 && !this.formatCalculator.isComputeOver()) {
            try {
                if (this.isDataOver()) {
                    return false;
                }
                Thread.sleep(2000L);
                ++n2;
                stringBuffer = new StringBuffer(170);
                stringBuffer.append(" tablePageIndex > formatCalculator.getTablePageHashMap().size() -1 :");
                stringBuffer.append(" tablePageIndex =  ");
                stringBuffer.append(n);
                stringBuffer.append(" formatCalculator.getTablePageHashMap().size() = ");
                stringBuffer.append(this.formatCalculator.getTablePageHashMap().size());
                stringBuffer.append("counter = ");
                stringBuffer.append(n2);
                logger.trace(stringBuffer.toString());
            }
            catch (InterruptedException interruptedException) {
                logger.trace(interruptedException.getMessage(), interruptedException);
            }
        }
        if (n > this.formatCalculator.getMaxPageCount() - 1) {
            this.setDataOver(true);
            stringBuffer = new StringBuffer(120);
            stringBuffer.append("There has setDataOver in print module!!!");
            stringBuffer.append(" tablePageIndex =  ");
            stringBuffer.append(n);
            stringBuffer.append(" formatCalculator.getTablePageHashMap().size() = ");
            stringBuffer.append(this.formatCalculator.getTablePageHashMap().size());
            logger.trace(stringBuffer.toString());
            return false;
        }
        return true;
    }

    private void computeColumnInfo(int n) {
        int n2;
        this.columnStart = 0;
        this.allWidth = 0;
        int n3 = (n - this.formatCalculator.getOnlySummaryPageCount()) % this.formatCalculator.pageCountHTable.size();
        this.columnCount = Integer.parseInt((String)this.formatCalculator.pageCountHTable.get(Integer.toString(n3 + 1)));
        for (n2 = 0; n2 < n3; ++n2) {
            this.columnStart += Integer.parseInt((String)this.formatCalculator.pageCountHTable.get(Integer.toString(n2 + 1)));
        }
        for (n2 = 0; n2 < this.columnCount; ++n2) {
            this.allWidth += this.formatCalculator.getColumnWidths()[this.columnStart + n2];
        }
    }

    void drawTableHeader(Graphics2D graphics2D, int n) {
        graphics2D.setFont(FormatCalculator.TABLE_HEADER_FONT);
        int n2 = 0;
        graphics2D.drawLine(0, n, this.allWidth, n);
        LinkedList linkedList = null;
        Iterator iterator = null;
        String string2 = null;
        for (int i = 0; i < this.columnCount; ++i) {
            linkedList = (LinkedList)this.formatCalculator.getAnalyzedTableHeaderLinkedList().get(this.columnStart + i);
            int n3 = 1;
            for (String string2 : linkedList) {
                graphics2D.drawString(string2, n2 + 2, n + 3 + TablePrintImpl.getFontHeight(FormatCalculator.TABLE_HEADER_FONT) * n3 - TablePrintImpl.getFontDescent(FormatCalculator.TABLE_HEADER_FONT));
                ++n3;
            }
            graphics2D.drawLine(n2, n, n2, n + this.formatCalculator.getTableHeaderHeight());
            n2 += this.formatCalculator.getColumnWidths()[this.columnStart + i];
        }
        graphics2D.drawLine(this.allWidth, n, this.allWidth, n + this.formatCalculator.getTableHeaderHeight());
    }

    int drawRow(Graphics2D graphics2D, PageFormat pageFormat, int n, int n2, int n3) {
        int n4 = n;
        graphics2D.setFont(this.dataFont);
        int n5 = n3;
        String string2 = null;
        LinkedList linkedList = null;
        LinkedList linkedList2 = null;
        Font font = this.formatCalculator.getDataFont();
        List list = this.formatCalculator.getExtraRowIndices();
        for (int i = 0; !(i >= n2 || this.formatCalculator.getTotleRecordsPosition() && n4 >= this.formatCalculator.getAnalyzedRowCount() - 1 && this.formatCalculator.isTotalRecordVisible()); ++n4, ++i) {
            int n6 = 0;
            int n7 = this.formatCalculator.calculateRowHeight(n4, (int)pageFormat.getImageableHeight());
            graphics2D.drawLine(0, n5, this.allWidth, n5);
            linkedList = this.formatCalculator.getAnalyzedRowLinkList(n4);
            boolean bl = list.contains(n4);
            for (int j = 0; j < this.columnCount; ++j) {
                linkedList2 = (LinkedList)linkedList.get(this.columnStart + j);
                int n8 = n5 + (n7 + TablePrintImpl.getFontHeight(font)) / 2;
                int n9 = linkedList2.size();
                int n10 = 0;
                n10 = bl ? n5 + TablePrintImpl.getFontHeight(font) + 1 : n8 - TablePrintImpl.getFontHeight(font) * (n9 - 1) / 2 - TablePrintImpl.getFontDescent(font);
                for (String string2 : linkedList2) {
                    if (this.isNeedSleep) {
                        TablePrintImpl.sleep(3);
                    }
                    graphics2D.drawString(string2, n6 + 2, n10);
                    n10 += TablePrintImpl.getFontHeight(font);
                }
                if (this.isNeedSleep) {
                    TablePrintImpl.sleep(3);
                }
                graphics2D.drawLine(n6, n5, n6, n5 + n7);
                n6 += this.formatCalculator.getColumnWidths()[this.columnStart + j];
            }
            graphics2D.drawLine(this.allWidth, n5, this.allWidth, n5 + n7);
            n5 += n7;
        }
        if (!this.formatCalculator.getTotleRecordsPosition() || n < this.formatCalculator.getAnalyzedRowCount() - 1 || !this.formatCalculator.isTotalRecordVisible() && this.formatCalculator.getTotleRecordsPosition()) {
            graphics2D.drawLine(0, n5, this.allWidth, n5);
        }
        return n5;
    }

    static final void sleep(int n) {
        try {
            Thread.sleep(n);
        }
        catch (InterruptedException interruptedException) {
            logger.trace(interruptedException.getMessage(), interruptedException);
        }
    }

    private void drawTotalCount(Graphics2D graphics2D, int n) {
        graphics2D.setFont(this.formatCalculator.getDataFont());
        String string = null;
        if (this.formatCalculator.getIsOrdinaryTable()) {
            int n2 = 0;
            if (this.formatCalculator.getTotleRecordsPosition()) {
                n2 = this.formatCalculator.getTotalRecordCount() != -1 ? this.formatCalculator.getTotalRecordCount() : this.formatCalculator.getTotalRowCount() - this.formatCalculator.getAdjustInt() - 1;
                string = PrintSupportor.res.getString("Total") + NumberFormatUtil.getFormatNumber(n2 - this.formatCalculator.getExtraRowsAfterSplit());
            } else {
                n2 = this.formatCalculator.getTotalRecordCount() != -1 ? this.formatCalculator.getTotalRecordCount() : this.formatCalculator.getTotalRowCount() - this.formatCalculator.getAdjustInt();
                string = PrintSupportor.res.getString("Total") + NumberFormatUtil.getFormatNumber(n2 - this.formatCalculator.getExtraRowsAfterSplit());
            }
            string = n2 > 1 ? new StringBuffer(string).append(' ').append(PrintSupportor.res.getString("Records")).toString() : new StringBuffer(string).append(' ').append(PrintSupportor.res.getString("Record")).toString();
        } else {
            int n3 = 0;
            n3 = this.formatCalculator.getTotalRecordCount() != -1 ? this.formatCalculator.getTotalRecordCount() : this.formatCalculator.getTotalRowsCount();
            string = PrintSupportor.res.getString("Total") + NumberFormatUtil.getFormatNumber(n3);
            string = this.formatCalculator.getRrintColCount() - 1 > 1 ? new StringBuffer(string).append(' ').append(PrintSupportor.res.getString("Records")).toString() : new StringBuffer(string).append(' ').append(PrintSupportor.res.getString("Record")).toString();
        }
        graphics2D.drawString(string, 1, n + TablePrintImpl.getFontHeight(FormatCalculator.TABLE_HEADER_FONT) * 2 - TablePrintImpl.getFontDescent(FormatCalculator.TABLE_HEADER_FONT));
    }

    private void drawSummaryPage(Graphics2D graphics2D, PageFormat pageFormat, int n) {
        Font font = this.formatCalculator.getDataFont();
        int n2 = (int)pageFormat.getImageableHeight();
        int n3 = PrintableTool.getFontHeight(font);
        int n4 = (n2 - this.getHeadHeight()) / PrintableTool.getFontHeight(font) - 1;
        int n5 = n4 * n;
        int n6 = 0;
        int n7 = n4 - this.startYbackup / PrintableTool.getFontHeight(font);
        boolean bl = false;
        if (this.startYbackup != 0 && n7 != n4) {
            boolean bl2 = bl = this.formatCalculator.getSummaryLineList().size() > n7;
        }
        if (bl && n > 0) {
            n5 = n7 + (n - 1) * n4;
        }
        n6 = this.formatCalculator.getSummaryLineList().size() - n5 > n4 ? n4 : this.formatCalculator.getSummaryLineList().size() - n5;
        if (bl && n == 0) {
            n6 = n7;
        }
        graphics2D.setFont(font);
        FontMetrics fontMetrics = graphics2D.getFontMetrics(font);
        double d = pageFormat.getImageableWidth() - 2.0;
        double d2 = this.getHeadHeight() + n3 / 2 - TablePrintImpl.getFontDescent(font) + this.startY;
        String string = null;
        double d3 = 0.0;
        for (int i = 0; i < n6; ++i) {
            string = (String)this.formatCalculator.getSummaryLineList().get(n5 + i);
            d2 += (double)n3;
            d3 = graphics2D.getFontMetrics().stringWidth(string);
            while (d3 > d && string.length() != 0) {
                string = string.substring(0, string.length() - 1);
                d3 = fontMetrics.stringWidth(string);
            }
            graphics2D.drawString(string, 2, (int)d2);
        }
    }

    @Override
    public int getPageCount() {
        return this.formatCalculator.getPageCount();
    }

    public boolean isBFirstForRealTimePrint() {
        return this.bFirstForRealTimePrint;
    }

    public void setBFirstForRealTimePrint(boolean bl) {
        this.bFirstForRealTimePrint = bl;
    }

    public LinkedList getLastPageDataForFirstRealTimePrint() {
        return this.lastPageDataForFirstRealTimePrint;
    }

    public void reset() {
        this.bFirstPrintPage = true;
        this.lastPageDataForFirstRealTimePrint.clear();
        this.bFirstForRealTimePrint = false;
        this.getFormatCalculator().reset();
        this.hashset.clear();
        this.startYbackup = 0;
        this.startY = 0;
    }

    public void setIsNeedSleep(boolean bl) {
        this.isNeedSleep = bl;
    }

    public boolean getIsNeedSleep() {
        return this.isNeedSleep;
    }

    public void setDataFont(Font font) {
        this.dataFont = font;
        this.formatCalculator.setDataFont(font);
    }
}

