/*
 * Decompiled with CFR 0.152.
 */
package com.swimap.iview.templates.print.tools;

import com.lowagie.text.Document;
import com.lowagie.text.DocumentException;
import com.lowagie.text.Element;
import com.lowagie.text.Font;
import com.lowagie.text.FontFactory;
import com.lowagie.text.PageSize;
import com.lowagie.text.Paragraph;
import com.lowagie.text.Phrase;
import com.lowagie.text.Rectangle;
import com.lowagie.text.RectangleReadOnly;
import com.lowagie.text.pdf.BaseFont;
import com.lowagie.text.pdf.PdfPCell;
import com.lowagie.text.pdf.PdfPTable;
import com.lowagie.text.pdf.PdfPageEvent;
import com.lowagie.text.pdf.PdfPageEventHelper;
import com.lowagie.text.pdf.PdfWriter;
import com.swimap.iview.framework.util.FrameworkCommandProcessor;
import com.swimap.iview.framework.util.FrameworkUtilities;
import com.swimap.iview.templates.dialog.DetailMessageDlg;
import com.swimap.iview.templates.print.FormatCalculator;
import com.swimap.iview.templates.print.PrintSupportor;
import com.swimap.iview.templates.print.tools.PDFSaveImpl;
import com.swimap.iview.templates.print.tools.UnsupportedPDFHeaderException;
import com.swimap.iview.util.CommonUtil;
import com.swimap.iview.util.format.NumberFormatUtil;
import com.swimap.iview.util.log.IviewLogger;
import java.awt.Color;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.Window;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Iterator;
import java.util.LinkedList;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.SwingUtilities;

class TablePDFGenerator
extends PdfPageEventHelper {
    private static IviewLogger logger = IviewLogger.getLogger(PDFSaveImpl.class, "IVIEW");
    private FormatCalculator formatCalculator;
    private FormatCalculator parentPdfFormatCalculator;
    private PDFSaveImpl pdfSaver;
    private PdfPTable pdftable;
    private Document document;
    private PdfWriter writer;
    private FileOutputStream lockStream;
    private static final String PDF_FONT_FILE = "unifont.ttf";
    private static final String PDF_FONT_NAME = "GNU Unifont";
    private static final int PDF_MAX_WIDTH = 14400;
    private static final String PDF_FONT_ENCODING = "Identity-H";
    private static final boolean IS_FONT_EMBEDDED = true;
    private BaseFont bfUniCode = null;
    private static final int DOC_MARGIN = 30;
    private static final float MIN_COLUMN_WIDTH = 60.0f;
    private static final int FONT_SIZE = 10;
    private int nextFileNumber = 0;
    private int fileNumberIndex = 0;
    private String originalFileName = "";
    private String[] pdfFileNames = null;
    private int writeTotalCount = 0;
    private String currentSavingFileName = "";

    TablePDFGenerator(String string, FormatCalculator formatCalculator, FormatCalculator formatCalculator2, PDFSaveImpl pDFSaveImpl) throws UnsupportedPDFHeaderException {
        this.formatCalculator = formatCalculator;
        this.pdfSaver = pDFSaveImpl;
        this.originalFileName = string;
        this.parentPdfFormatCalculator = formatCalculator2;
        this.writeTotalCount = this.parentPdfFormatCalculator.getTotalRowsCount() - this.parentPdfFormatCalculator.getAdjustInt();
        this.initFileNames();
        this.init();
    }

    private void initFileNames() {
        int n = this.parentPdfFormatCalculator.getTotalRowCount() + 8;
        int n2 = 0;
        n2 = n % this.parentPdfFormatCalculator.getMaxRecordsCountPerFile() == 0 ? n / this.parentPdfFormatCalculator.getMaxRecordsCountPerFile() : n / this.parentPdfFormatCalculator.getMaxRecordsCountPerFile() + 1;
        this.pdfFileNames = new String[n2];
    }

    public String getMultiFileNamesInfo() {
        StringBuffer stringBuffer = new StringBuffer("");
        for (int i = 0; i < this.pdfFileNames.length; ++i) {
            if (null == this.pdfFileNames[i]) continue;
            File file = new File(this.pdfFileNames[i]);
            stringBuffer.append(file.getAbsolutePath()).append(", ");
        }
        return stringBuffer.toString();
    }

    public boolean isInMultipleFiles() {
        return this.fileNumberIndex != 0;
    }

    public void showMutiFilesInfos(String string) {
        StringBuffer stringBuffer = new StringBuffer(PrintSupportor.res.getString("fileNames"));
        stringBuffer.append(System.getProperty("line.separator"));
        stringBuffer.append(string);
        final String string2 = stringBuffer.toString();
        final Window window = this.pdfSaver.parentFrame;
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                if (FrameworkCommandProcessor.getInstance().isLogoutInProcess()) {
                    return;
                }
                Window window2 = null;
                window2 = window != null ? window : FrameworkUtilities.getMainFrame();
                DetailMessageDlg detailMessageDlg = null;
                if (window2 instanceof JFrame || window2 == null) {
                    detailMessageDlg = new DetailMessageDlg((Frame)window2, PrintSupportor.res.getString("Prompt"), (Object)PrintSupportor.res.getString("fileNamesInfo"), (Object)string2);
                } else if (window2 instanceof JDialog) {
                    detailMessageDlg = new DetailMessageDlg((Dialog)((JDialog)window2), PrintSupportor.res.getString("Prompt"), (Object)PrintSupportor.res.getString("fileNamesInfo"), (Object)string2);
                } else {
                    logger.trace("In PDFSaveImpl parentFrame is notJDialog or JFrame");
                    return;
                }
                detailMessageDlg.pack();
                detailMessageDlg.show();
            }
        });
    }

    public void showFileSaveSuccessInfo(String string, int n) {
        StringBuffer stringBuffer = new StringBuffer(30);
        if (n > 1) {
            stringBuffer.append(PrintSupportor.res.getString("fileNames"));
        } else {
            stringBuffer.append(PrintSupportor.res.getString("fileName"));
        }
        stringBuffer.append(System.getProperty("line.separator"));
        stringBuffer.append(string);
        final String string2 = stringBuffer.toString();
        final Window window = this.pdfSaver.parentFrame;
        final int n2 = n;
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                String string = PrintSupportor.res.getString("fileNamesInfo");
                if (n2 == 1) {
                    string = PrintSupportor.res.getString("fileSaveInfo");
                }
                Window window2 = null;
                window2 = window != null ? window : FrameworkUtilities.getMainFrame();
                DetailMessageDlg detailMessageDlg = null;
                if (window2 instanceof JFrame || window2 == null) {
                    detailMessageDlg = new DetailMessageDlg((Frame)window2, PrintSupportor.res.getString("Prompt"), (Object)string, (Object)string2);
                } else if (window2 instanceof JDialog) {
                    detailMessageDlg = new DetailMessageDlg((Dialog)((JDialog)window2), PrintSupportor.res.getString("Prompt"), (Object)string, (Object)string2);
                } else {
                    logger.trace("In PDFSaveImpl parentFrame is notJDialog or JFrame");
                    return;
                }
                detailMessageDlg.pack();
                detailMessageDlg.show();
            }
        });
    }

    private void init() throws UnsupportedPDFHeaderException {
        this.registerPDFFont();
        float f = this.getDocumentPageWidth();
        if (f > 14400.0f) {
            throw new UnsupportedPDFHeaderException("");
        }
        this.pdftable = new PdfPTable(this.formatCalculator.getTableHeaders().length);
        this.pdftable.setSplitLate(false);
        float[] fArray = this.getTableColumnWidths();
        try {
            this.pdftable.setLockedWidth(true);
            this.pdftable.setTotalWidth(fArray);
        }
        catch (DocumentException documentException) {
            logger.debug("Failed to set the pdf table column widths : " + documentException.getStackTrace());
        }
        this.pdftable.setHorizontalAlignment(0);
        this.initPdfDocument(f);
    }

    private void initPdfDocument(float f) {
        RectangleReadOnly rectangleReadOnly = new RectangleReadOnly(f, PageSize.A4.getHeight());
        this.document = new Document((Rectangle)rectangleReadOnly, 30.0f, 30.0f, 30.0f, 30.0f);
        String string = null;
        try {
            string = this.getNextPdfFileName();
            this.lockStream = new FileOutputStream(CommonUtil.getAbsolutePath(string));
            this.writer = PdfWriter.getInstance((Document)this.document, (OutputStream)this.lockStream);
            this.writer.setPageEvent((PdfPageEvent)this);
            this.lockStream.getChannel().lock();
        }
        catch (IOException iOException) {
            logger.trace(iOException.getMessage(), iOException);
        }
        catch (DocumentException documentException) {
            logger.trace(documentException.getMessage(), documentException);
        }
        this.document.open();
        this.initPdfFilenames(string);
    }

    private void initPdfFilenames(String string) {
        this.pdfFileNames[this.fileNumberIndex] = string;
        this.pdfSaver.setCsvXlsorPdfFileNames(this.pdfFileNames);
    }

    public synchronized String getNextPdfFileName() {
        String string = "";
        File file = null;
        if (this.fileNumberIndex == 0) {
            string = this.originalFileName;
        } else {
            StringBuffer stringBuffer = new StringBuffer("");
            do {
                ++this.nextFileNumber;
                stringBuffer.delete(0, stringBuffer.length());
                stringBuffer.append(this.originalFileName.substring(0, this.originalFileName.length() - ".pdf".length()));
                stringBuffer.append("@").append(this.nextFileNumber).append(".pdf");
            } while ((file = new File(CommonUtil.getAbsolutePath(stringBuffer.toString()))).exists());
            string = stringBuffer.toString();
        }
        this.currentSavingFileName = string;
        return string;
    }

    public String getCurrentSavingFileName() {
        return this.currentSavingFileName;
    }

    private float getTotalTableWidth() {
        float[] fArray = this.getTableColumnWidths();
        float f = 0.0f;
        for (int i = 0; i < fArray.length; ++i) {
            f += fArray[i];
        }
        return f;
    }

    private float getWidthPoint(String string, int n) {
        return this.bfUniCode.getWidthPoint(string, (float)n);
    }

    private float getDocumentPageWidth() {
        float f = this.getTotalTableWidth();
        if (f < PageSize.A4.getWidth()) {
            f = PageSize.A4.getWidth();
        }
        return f += 60.0f;
    }

    private void registerPDFFont() {
        if (!FontFactory.isRegistered((String)"unifont")) {
            FontFactory.register((String)PDF_FONT_FILE);
        }
        try {
            this.bfUniCode = BaseFont.createFont((String)PDF_FONT_FILE, (String)PDF_FONT_ENCODING, (boolean)true);
        }
        catch (DocumentException documentException) {
            logger.trace(documentException.getMessage(), documentException);
        }
        catch (IOException iOException) {
            logger.trace(iOException.getMessage(), iOException);
        }
    }

    protected void save() {
        this.document.close();
        this.writer.close();
        try {
            this.lockStream.close();
        }
        catch (IOException iOException) {
            logger.trace(iOException.getMessage(), iOException);
        }
    }

    private void writeTextData(String string, int n) {
        this.writeTextData(string, 0, 0, n);
    }

    private void writeTextData(String string, int n, int n2, int n3) {
        Font font = FontFactory.getFont((String)PDF_FONT_NAME, (String)PDF_FONT_ENCODING, (boolean)true, (float)10.0f);
        font.setSize((float)(10 + n2));
        font.setStyle(n);
        try {
            Paragraph paragraph = new Paragraph(string, font);
            paragraph.setAlignment(n3);
            this.document.add((Element)paragraph);
        }
        catch (DocumentException documentException) {
            logger.trace(documentException.getMessage(), documentException);
        }
    }

    protected void writeTotalRecords() {
        if (!this.parentPdfFormatCalculator.isTotalRecordVisible()) {
            return;
        }
        int n = this.writeTotalCount;
        if (this.parentPdfFormatCalculator.getTotalRecordCount() != -1) {
            n = this.parentPdfFormatCalculator.getTotalRecordCount();
        }
        StringBuffer stringBuffer = new StringBuffer(PrintSupportor.res.getString("Total")).append(NumberFormatUtil.getFormatNumber(n));
        if (n > 1) {
            stringBuffer.append(" ").append(PrintSupportor.res.getString("Records"));
        } else {
            stringBuffer.append(" ").append(PrintSupportor.res.getString("Record"));
        }
        stringBuffer.append(FormatCalculator.LINE_CHANGER).append(FormatCalculator.LINE_CHANGER);
        this.writeTextData(stringBuffer.toString(), 0);
    }

    protected void writeExtraInformations() {
        StringBuffer stringBuffer = new StringBuffer(PrintSupportor.res.getString("saveTime"));
        stringBuffer.append(this.formatCalculator.getTime());
        stringBuffer.append("  ");
        stringBuffer.append(PrintSupportor.res.getString("userName"));
        stringBuffer.append(this.formatCalculator.getUserName());
        String string = stringBuffer.toString();
        this.writeTextData(string + FormatCalculator.LINE_CHANGER + FormatCalculator.LINE_CHANGER, 1);
        if (this.formatCalculator.getSummary().length() > 0) {
            this.writeTextData(this.formatCalculator.getSummary() + FormatCalculator.LINE_CHANGER + FormatCalculator.LINE_CHANGER, 0);
        }
    }

    protected void writeTableDatas() {
        Font font = FontFactory.getFont((String)PDF_FONT_NAME, (String)PDF_FONT_ENCODING, (boolean)true, (float)10.0f);
        font.setSize(10.0f);
        int n = this.formatCalculator.getTotalRowCount();
        int n2 = -1;
        LinkedList linkedList = null;
        Iterator iterator = null;
        LinkedList linkedList22 = null;
        Iterator iterator2 = null;
        String string2 = "";
        PdfPCell pdfPCell = null;
        int n3 = this.formatCalculator.getMaxRecordsCountPerFile();
        for (int i = 0; i < n; ++i) {
            if (i > n3 - 1 && i % n3 == 0) {
                this.save();
                ++this.fileNumberIndex;
                try {
                    this.init();
                }
                catch (UnsupportedPDFHeaderException unsupportedPDFHeaderException) {
                    logger.trace(unsupportedPDFHeaderException);
                }
                System.gc();
                this.writeTableHeaders();
            }
            linkedList = null;
            iterator = null;
            linkedList22 = null;
            iterator2 = null;
            string2 = "";
            n2 = i;
            while (!this.pdfSaver.isOver()) {
                if (i >= this.formatCalculator.getTotalRowCount() - this.parentPdfFormatCalculator.getAdjustInt()) {
                    this.writeTotalCount = this.parentPdfFormatCalculator.getTotalRowsCount() - this.parentPdfFormatCalculator.getAdjustInt();
                    this.parentPdfFormatCalculator.setAdjustInt(-this.parentPdfFormatCalculator.getAdjustInt());
                    return;
                }
                n2 = i;
                if (n2 >= 0 && n2 < this.formatCalculator.getAnalyzedRowCount()) break;
                try {
                    logger.trace("Waiting for this row index " + n2);
                    Thread.sleep(1000L);
                }
                catch (InterruptedException interruptedException) {
                    logger.trace(interruptedException.getMessage(), interruptedException);
                }
            }
            if (this.pdfSaver.isOver()) {
                this.writeTotalCount = i;
                this.parentPdfFormatCalculator.setAdjustInt(-this.parentPdfFormatCalculator.getAdjustInt());
                return;
            }
            linkedList = this.formatCalculator.getAndDeleteAnalyzedRowLinkList(n2);
            for (LinkedList linkedList22 : linkedList) {
                if (linkedList22.size() == 0) continue;
                for (String string2 : linkedList22) {
                    pdfPCell = new PdfPCell((Phrase)new Paragraph(string2, font));
                    pdfPCell.setUseBorderPadding(true);
                    pdfPCell.setVerticalAlignment(5);
                    this.pdftable.addCell(pdfPCell);
                }
            }
            try {
                this.document.add((Element)this.pdftable);
                this.pdftable.deleteBodyRows();
                this.pdftable.setSkipFirstHeader(true);
                continue;
            }
            catch (DocumentException documentException) {
                logger.trace(documentException.getMessage(), documentException);
            }
        }
        this.writeTotalCount = this.parentPdfFormatCalculator.getTotalRowsCount() - this.parentPdfFormatCalculator.getAdjustInt();
        this.parentPdfFormatCalculator.setAdjustInt(-this.parentPdfFormatCalculator.getAdjustInt());
    }

    protected void writeTitleInfo() {
        this.writeTextData(this.formatCalculator.getTitle() + FormatCalculator.LINE_CHANGER + FormatCalculator.LINE_CHANGER, 1, 4, 1);
    }

    private float[] getTableColumnWidths() {
        String[] stringArray = this.formatCalculator.getTableHeaders();
        float[] fArray = new float[stringArray.length];
        float f = 0.0f;
        float f2 = 0.0f;
        for (int i = 0; i < stringArray.length; ++i) {
            f = this.getWidthPoint(stringArray[i], 10);
            fArray[i] = 60.0f > (f += 10.0f) ? 60.0f : f;
            f2 += fArray[i];
        }
        if (f2 < PageSize.A4.getWidth() && f2 > 0.0f) {
            this.resizeColumns(fArray, PageSize.A4.getWidth() / f2);
        }
        return fArray;
    }

    private void resizeColumns(float[] fArray, float f) {
        if (f > 1.0f) {
            int n = 0;
            while (n < fArray.length) {
                int n2 = n++;
                fArray[n2] = fArray[n2] * f;
            }
        }
    }

    protected void writeTableHeaders() {
        if (this.parentPdfFormatCalculator.isNormalSave()) {
            return;
        }
        Font font = FontFactory.getFont((String)PDF_FONT_NAME, (String)PDF_FONT_ENCODING, (boolean)true, (float)10.0f);
        font.setSize(10.0f);
        font.setStyle(1);
        String[] stringArray = this.formatCalculator.getTableHeaders();
        this.pdftable.setHeaderRows(1);
        PdfPCell pdfPCell = null;
        String string = null;
        for (int i = 0; i < stringArray.length; ++i) {
            string = stringArray[i];
            pdfPCell = new PdfPCell((Phrase)new Paragraph(string, font));
            pdfPCell.setUseBorderPadding(true);
            pdfPCell.setHorizontalAlignment(5);
            pdfPCell.setBackgroundColor(Color.LIGHT_GRAY);
            this.pdftable.addCell(pdfPCell);
        }
        this.pdftable.getDefaultCell().setBorderWidth(1.0f);
    }

    public void onEndPage(PdfWriter pdfWriter, Document document) {
        Font font = FontFactory.getFont((String)PDF_FONT_NAME, (String)PDF_FONT_ENCODING, (boolean)true, (float)10.0f);
        font.setSize(10.0f);
        font.setStyle(1);
        String string = String.valueOf(document.getPageNumber());
        String string2 = PrintSupportor.res.getString("currentPage") + string;
        PdfPCell pdfPCell = new PdfPCell((Phrase)new Paragraph(string2, font));
        pdfPCell.setUseBorderPadding(true);
        pdfPCell.setHorizontalAlignment(2);
        pdfPCell.disableBorderSide(4);
        pdfPCell.disableBorderSide(8);
        pdfPCell.disableBorderSide(1);
        pdfPCell.disableBorderSide(2);
        pdfPCell.setColspan(1);
        PdfPTable pdfPTable = new PdfPTable(1);
        pdfPTable.addCell(pdfPCell);
        pdfPTable.setTotalWidth(document.getPageSize().getWidth() - document.leftMargin() - document.rightMargin());
        pdfPTable.writeSelectedRows(0, -1, document.leftMargin(), document.bottomMargin(), pdfWriter.getDirectContent());
    }
}

