/*
 * Decompiled with CFR 0.152.
 */
package com.swimap.iview.templates.print.tools;

import com.swimap.iview.framework.Main;
import com.swimap.iview.framework.util.FrameworkCommandProcessor;
import com.swimap.iview.framework.util.FrameworkUtilities;
import com.swimap.iview.templates.dialog.DetailMessageDlg;
import com.swimap.iview.templates.print.FormatCalculator;
import com.swimap.iview.templates.print.PrintSupportor;
import com.swimap.iview.templates.print.tools.AbstractSaveImpl;
import com.swimap.iview.templates.utils.FileUtil;
import com.swimap.iview.util.CommonUtil;
import com.swimap.iview.util.log.IviewLogger;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.Window;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.charset.Charset;
import java.util.Iterator;
import java.util.LinkedList;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.SwingUtilities;

public class TXTSaveImpl
extends AbstractSaveImpl {
    private static IviewLogger logger = IviewLogger.getLogger(TXTSaveImpl.class, "IVIEW");
    private StringBuffer columnData = new StringBuffer(30);
    private boolean txtSnapLeft = false;
    private String saveEncoding = null;
    private String fileName = null;
    private boolean isCloseStream = false;
    private int filesCount = 1;
    private String[] fileNames = null;
    private int currentFileNo = 1;
    private int filenameEx = 1;
    private static final int ONE_SECOND = 1000;
    private boolean multiFiles = false;
    private int writeTotalCount = this.formatCalculator.getTotalRowsCount() - this.formatCalculator.getAdjustInt();
    private BufferedWriter _out = null;

    public TXTSaveImpl(FormatCalculator formatCalculator) {
        super(formatCalculator);
    }

    public boolean isCloseStream() {
        return this.isCloseStream;
    }

    @Override
    public void setCloseStream(boolean bl) {
        this.isCloseStream = bl;
    }

    @Override
    public void setFileName(String string) {
        this.fileName = string;
    }

    @Override
    public boolean isFiles() {
        this.calculatorFiles(this.formatCalculator.getTotalRowCount());
        return this.fileNames.length > 1;
    }

    @Override
    public void write(BufferedWriter bufferedWriter) throws IOException {
        this._out = bufferedWriter;
        this._out.write(FormatCalculator.LINE_CHANGER);
        if (this.formatCalculator.getTotleRecordsPosition()) {
            if (!this.formatCalculator.isNormalSave()) {
                this.writeHeader(this._out);
            }
            this.writeData(this._out);
        } else {
            this._out.write(FormatCalculator.LINE_CHANGER);
        }
        if (this.formatCalculator.getTotalRecordCount() != -1) {
            this.writeTotalCount = this.formatCalculator.getTotalRecordCount();
        }
        if (this.formatCalculator.isTotalRecordVisible()) {
            this.writeTotalRecords(this._out, this.writeTotalCount);
            this._out.write(FormatCalculator.LINE_CHANGER);
            this._out.write(FormatCalculator.LINE_CHANGER);
        }
        if (!this.formatCalculator.getTotleRecordsPosition()) {
            if (!this.formatCalculator.isNormalSave()) {
                this.writeHeader(this._out);
            }
            this.writeData(this._out);
        } else {
            this._out.write(FormatCalculator.LINE_CHANGER);
            this._out.write(FormatCalculator.LINE_CHANGER);
        }
        if (this.isCloseStream()) {
            bufferedWriter.close();
            this._out.close();
        }
    }

    @Override
    public void writeTitle(BufferedWriter bufferedWriter) throws IOException {
        if (this.multiFiles) {
            bufferedWriter.write(FormatCalculator.LINE_CHANGER);
            bufferedWriter.write(FormatCalculator.LINE_CHANGER);
        }
        String string = this.formatCalculator.getTxtSeparatorLine();
        int n = FormatCalculator.getTxtTextWidth(this.formatCalculator.getTitle());
        if (!this.isTxtSnapLeft()) {
            bufferedWriter.write(FormatCalculator.getTxtBlackText((string.length() - n) / 2));
        }
        bufferedWriter.write(this.formatCalculator.getTitle());
    }

    @Override
    public void writeTotalExtraInfo(BufferedWriter bufferedWriter, String string) throws IOException {
        String string2 = this.formatCalculator.getTxtSeparatorLine();
        int n = FormatCalculator.getTxtTextWidth(string);
        if (!this.isTxtSnapLeft()) {
            bufferedWriter.write(FormatCalculator.getTxtBlackText((string2.length() - n) / 2));
        }
        bufferedWriter.write(string);
        bufferedWriter.write(FormatCalculator.LINE_CHANGER);
        int n2 = FormatCalculator.getTxtTextWidth(this.formatCalculator.getTitle());
        String string3 = this.formatCalculator.getTxtSeparatorLine();
        if (!this.isTxtSnapLeft()) {
            bufferedWriter.write(FormatCalculator.getTxtBlackText((string3.length() - n2) / 2));
        }
        bufferedWriter.write(FormatCalculator.LINE_CHANGER);
        StringBuffer stringBuffer = new StringBuffer(PrintSupportor.res.getString("saveTime"));
        stringBuffer.append(this.formatCalculator.getTime());
        stringBuffer.append("    ");
        stringBuffer.append(PrintSupportor.res.getString("userName"));
        stringBuffer.append(this.formatCalculator.getUserName());
        String string4 = stringBuffer.toString();
        int n3 = FormatCalculator.getTxtTextWidth(string4);
        if (!this.isTxtSnapLeft()) {
            bufferedWriter.write(FormatCalculator.getTxtBlackText((string3.length() - n3) / 2));
        }
        bufferedWriter.write(string4);
        if (!this.isTxtSnapLeft()) {
            bufferedWriter.write(FormatCalculator.getTxtBlackText((string3.length() - n3) / 2));
        }
        bufferedWriter.write(FormatCalculator.LINE_CHANGER);
        bufferedWriter.write(FormatCalculator.LINE_CHANGER);
        bufferedWriter.write(FormatCalculator.LINE_CHANGER);
    }

    @Override
    public void writeExtraInfo(BufferedWriter bufferedWriter) throws IOException {
        bufferedWriter.write(FormatCalculator.LINE_CHANGER);
        int n = FormatCalculator.getTxtTextWidth(this.formatCalculator.getTitle());
        String string = this.formatCalculator.getTxtSeparatorLine();
        bufferedWriter.write(FormatCalculator.getTxtBlackText((string.length() - n) / 2));
        bufferedWriter.write(FormatCalculator.LINE_CHANGER);
        StringBuffer stringBuffer = new StringBuffer(PrintSupportor.res.getString("saveTime"));
        stringBuffer.append(this.formatCalculator.getTime());
        stringBuffer.append("    ");
        stringBuffer.append(PrintSupportor.res.getString("userName"));
        stringBuffer.append(this.formatCalculator.getUserName());
        String string2 = stringBuffer.toString();
        int n2 = FormatCalculator.getTxtTextWidth(string2);
        if (!this.isTxtSnapLeft()) {
            bufferedWriter.write(FormatCalculator.getTxtBlackText((string.length() - n2) / 2));
        }
        bufferedWriter.write(string2);
        bufferedWriter.write(FormatCalculator.getTxtBlackText((string.length() - n2) / 2));
        bufferedWriter.write(FormatCalculator.LINE_CHANGER);
        bufferedWriter.write(FormatCalculator.LINE_CHANGER);
        if (this.formatCalculator.getSummary().length() > 0) {
            String[] stringArray = this.formatCalculator.getSummaryLines();
            for (int i = 0; i < stringArray.length; ++i) {
                bufferedWriter.write(stringArray[i]);
                bufferedWriter.write(FormatCalculator.LINE_CHANGER);
            }
        }
    }

    private void writeHeaderForElseFiles(BufferedWriter bufferedWriter) throws IOException {
        LinkedList linkedList = this.formatCalculator.getAnalyzeHeadData();
        int n = 0;
        Iterator iterator = linkedList.iterator();
        LinkedList linkedList2 = null;
        String string = null;
        while (iterator.hasNext()) {
            linkedList2 = (LinkedList)iterator.next();
            if (n >= linkedList2.size()) continue;
            n = linkedList2.size();
        }
        StringBuffer stringBuffer = new StringBuffer(30);
        LinkedList linkedList3 = null;
        int n2 = 0;
        int n3 = 0;
        for (int i = 0; i < n; ++i) {
            iterator = linkedList.iterator();
            stringBuffer.delete(0, stringBuffer.length());
            for (n2 = 0; n2 < this.formatCalculator.getColumnWidths().length; ++n2) {
                if (n2 == 0) {
                    stringBuffer.append('|');
                }
                stringBuffer.append("\t");
                linkedList3 = (LinkedList)iterator.next();
                n3 = this.formatCalculator.getColumnWidths()[n2];
                if (i < linkedList3.size()) {
                    string = (String)linkedList3.get(i);
                    stringBuffer.append(string);
                    stringBuffer.append(FormatCalculator.getTxtBlackText(n3 - FormatCalculator.getTxtTextWidth(string)));
                } else {
                    stringBuffer.append(FormatCalculator.getTxtBlackText(n3));
                }
                stringBuffer.append("\t");
                stringBuffer.append('|');
            }
            stringBuffer.append(FormatCalculator.LINE_CHANGER);
            bufferedWriter.write(stringBuffer.toString());
            bufferedWriter.flush();
        }
        this.writeSeparatorLine(bufferedWriter);
    }

    protected void writeHeader(BufferedWriter bufferedWriter) throws IOException {
        this.writeSeparatorLine(bufferedWriter);
        this.writeHeaderForElseFiles(bufferedWriter);
    }

    protected void writeData(BufferedWriter bufferedWriter) throws IOException {
        int n = -1;
        int n2 = 0;
        int n3 = 0;
        LinkedList linkedList = null;
        Iterator iterator = null;
        LinkedList linkedList22 = null;
        LinkedList<String> linkedList3 = null;
        String string = null;
        StringBuffer stringBuffer = null;
        int n4 = 0;
        for (int i = 0; i < this.formatCalculator.getTotalRowCount() - this.formatCalculator.getAdjustInt(); ++i) {
            n = -1;
            while (!this.isOver()) {
                if (i >= this.formatCalculator.getTotalRowCount() - this.formatCalculator.getAdjustInt()) {
                    this.writeTotalCount = this.formatCalculator.getTotalRowsCount() - this.formatCalculator.getAdjustInt();
                    this.formatCalculator.setAdjustInt(-this.formatCalculator.getAdjustInt());
                    if (this.isCloseStream() && !this.formatCalculator.getTotleRecordsPosition()) {
                        bufferedWriter.close();
                    }
                    if (!this.formatCalculator.getDeleteFileFlag()) {
                        this.showMutiFilesInfo();
                    }
                    return;
                }
                n = i;
                if (n >= 0 && n < this.formatCalculator.getAnalyzedRowCount()) break;
                try {
                    logger.trace("Waiting for this row index " + n);
                    Thread.sleep(1000L);
                }
                catch (InterruptedException interruptedException) {
                    logger.trace(interruptedException.getMessage(), interruptedException);
                }
            }
            if (this.isOver()) {
                this.writeTotalCount = i;
                this.formatCalculator.setAdjustInt(-this.formatCalculator.getAdjustInt());
                if (!this.formatCalculator.getDeleteFileFlag()) {
                    this.showMutiFilesInfo();
                }
                return;
            }
            linkedList = this.formatCalculator.getAndDeleteAnalyzedRowLinkList(n);
            n2 = 0;
            for (LinkedList linkedList22 : linkedList) {
                if (n2 >= linkedList22.size()) continue;
                n2 = linkedList22.size();
            }
            for (int j = 0; j < n2; ++j) {
                iterator = linkedList.iterator();
                this.columnData.delete(0, this.columnData.length());
                for (n3 = 0; n3 < this.formatCalculator.getColumnWidths().length; ++n3) {
                    if (n3 == 0) {
                        this.columnData.append('|');
                    }
                    this.columnData.append("\t");
                    try {
                        linkedList3 = (LinkedList<String>)iterator.next();
                    }
                    catch (Exception exception) {
                        logger.trace("Should contain column index: " + n3 + ". Total column size is " + this.formatCalculator.getColumnWidths().length);
                        logger.trace(exception.getMessage(), exception);
                        linkedList3 = new LinkedList<String>();
                        linkedList3.add("-");
                    }
                    int n5 = this.formatCalculator.getColumnWidths()[n3];
                    if (j < linkedList3.size()) {
                        string = (String)linkedList3.get(j);
                        this.columnData.append(string);
                        this.columnData.append(FormatCalculator.getTxtBlackText(n5 - FormatCalculator.getTxtTextWidth(string)));
                    } else {
                        this.columnData.append(FormatCalculator.getTxtBlackText(n5));
                    }
                    this.columnData.append("\t");
                    this.columnData.append('|');
                }
                this.columnData.append(FormatCalculator.LINE_CHANGER);
                bufferedWriter.write(this.columnData.toString());
                bufferedWriter.flush();
            }
            this.writeSeparatorLine(bufferedWriter);
            bufferedWriter.flush();
            this.formatCalculator.setLastPrintedRowIndex(i);
            ++n4;
            if (i + 1 < this.formatCalculator.getMaxRecordsCountPerFile() * this.currentFileNo - this.lastFileRecordCount || i == this.formatCalculator.getTotalRowCount() - this.formatCalculator.getAdjustInt() - 1) continue;
            ++this.currentFileNo;
            bufferedWriter.close();
            String string2 = this.fileName.substring(0, this.fileName.length() - 4) + "@" + this.filenameEx + ".txt";
            ++this.filenameEx;
            stringBuffer = new StringBuffer(20);
            while (new File(CommonUtil.getAbsolutePath(string2)).exists()) {
                stringBuffer.delete(0, stringBuffer.length());
                stringBuffer.append(this.fileName.substring(0, this.fileName.length() - 4));
                stringBuffer.append("@");
                stringBuffer.append(this.filenameEx);
                stringBuffer.append(".txt");
                string2 = stringBuffer.toString();
                ++this.filenameEx;
            }
            this.fileNames[this.currentFileNo - 1] = string2;
            this.mergeFileNames(this.fileNames);
            OutputStreamWriter outputStreamWriter = null;
            FileOutputStream fileOutputStream = new FileOutputStream(CommonUtil.getAbsolutePath(string2));
            if (null != this.saveEncoding && Charset.isSupported(this.saveEncoding)) {
                logger.trace(this.saveEncoding + " Encoding used for file " + string2);
                if (this.saveEncoding.equalsIgnoreCase("UTF-8")) {
                    this.writeBOM(fileOutputStream);
                }
                outputStreamWriter = new OutputStreamWriter((OutputStream)fileOutputStream, this.saveEncoding);
            } else {
                logger.trace("encoding not used for file " + string2);
                outputStreamWriter = new OutputStreamWriter(fileOutputStream);
            }
            this._out = bufferedWriter = new BufferedWriter(outputStreamWriter);
            this.setLastStream(bufferedWriter);
            n4 = 0;
            this.writeSeparatorLine(bufferedWriter);
            if (this.formatCalculator.isNormalSave()) continue;
            this.writeHeaderForElseFiles(bufferedWriter);
        }
        if (this.isCloseStream() && !this.formatCalculator.getTotleRecordsPosition()) {
            bufferedWriter.close();
        }
        this.writeTotalCount = this.formatCalculator.getTotalRowsCount() - this.formatCalculator.getAdjustInt();
        this.formatCalculator.setAdjustInt(-this.formatCalculator.getAdjustInt());
        this.lastFileRecordCount = n4;
        if (!this.formatCalculator.getDeleteFileFlag()) {
            this.showMutiFilesInfo();
        }
    }

    private void showMutiFilesInfo() {
        if (!this.showMultiFileInfo || FrameworkCommandProcessor.getInstance().isLoggingOut()) {
            return;
        }
        String[] stringArray = this.getCsvXlsorPdfFileNames();
        if (null == stringArray) {
            return;
        }
        if (stringArray.length > 0 && this.formatCalculator.isOpenFileEnabled()) {
            this.openXlsOrTXTFile(stringArray);
        } else if (stringArray.length > 1) {
            this.displayMultiSave();
        }
    }

    private void displayMultiSave() {
        StringBuffer stringBuffer = new StringBuffer(10);
        stringBuffer.append(PrintSupportor.res.getString("fileNames"));
        stringBuffer.append(FileUtil.lineSeparator);
        int n = this.getValidFileCount(this.fileNames);
        if (n < 2) {
            return;
        }
        for (int i = 0; i < n - 1; ++i) {
            stringBuffer.append(this.fileNames[i]);
            stringBuffer.append(", ");
        }
        stringBuffer.append(this.fileNames[n - 1]);
        stringBuffer.append(PrintSupportor.res.getString("fullStop"));
        this.showDetailMsg(stringBuffer.toString());
    }

    private void showDetailMsg(final String string) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                if (FrameworkCommandProcessor.getInstance().isLogoutInProcess()) {
                    return;
                }
                JFrame jFrame = null;
                jFrame = TXTSaveImpl.this.parentFrame != null ? TXTSaveImpl.this.parentFrame : FrameworkUtilities.getMainFrame();
                DetailMessageDlg detailMessageDlg = null;
                if (jFrame instanceof JFrame || jFrame == null) {
                    detailMessageDlg = new DetailMessageDlg((Frame)jFrame, PrintSupportor.res.getString("Prompt"), (Object)PrintSupportor.res.getString("fileNamesInfo"), (Object)string);
                } else if (jFrame instanceof JDialog) {
                    detailMessageDlg = new DetailMessageDlg((Dialog)((JDialog)((Object)jFrame)), PrintSupportor.res.getString("Prompt"), (Object)PrintSupportor.res.getString("fileNamesInfo"), (Object)string);
                } else {
                    logger.trace("In TXTSaveImpl parentFrame is notJDialog or JFrame");
                    return;
                }
                detailMessageDlg.pack();
                detailMessageDlg.show();
            }
        });
    }

    protected void writeSeparatorLine(BufferedWriter bufferedWriter) throws IOException {
        String string = this.formatCalculator.getTxtSeparatorLine();
        bufferedWriter.write(string);
        bufferedWriter.write(FormatCalculator.LINE_CHANGER);
    }

    private void calculatorFiles(int n) {
        if ((n += this.lastFileRecordCount) > this.formatCalculator.getMaxRecordsCountPerFile()) {
            this.filesCount = n % this.formatCalculator.getMaxRecordsCountPerFile() == 0 ? n / this.formatCalculator.getMaxRecordsCountPerFile() : n / this.formatCalculator.getMaxRecordsCountPerFile() + 1;
            this.fileNames = new String[this.filesCount];
            this.fileNames[0] = this.fileName;
        } else {
            this.fileNames = new String[]{this.fileName};
        }
        this.mergeFileNames(this.fileNames);
    }

    public String getCurrentFileName() {
        String string = this.fileName;
        try {
            string = this.fileNames[this.currentFileNo - 1];
        }
        catch (Exception exception) {
            string = this.fileName;
        }
        if (string == null || string.length() == 0) {
            string = this.fileName;
        }
        return string;
    }

    public void setTxtSnapLeft(boolean bl) {
        this.txtSnapLeft = bl;
    }

    public boolean isTxtSnapLeft() {
        return this.txtSnapLeft;
    }

    public void setMultiFiles(boolean bl) {
        this.multiFiles = bl;
    }

    public boolean isMultiFiles() {
        return this.multiFiles;
    }

    protected void openXlsOrTXTFile(final String[] stringArray) {
        int n = this.getValidFileCount(stringArray);
        final String string = this.getDetailMessage(stringArray, n);
        if (null == string) {
            return;
        }
        String string2 = null;
        string2 = n > 1 ? PrintSupportor.res.getString("openMulFile") : PrintSupportor.res.getString("openFile");
        final String string3 = string2;
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                if (Main.instance().isCallExit()) {
                    return;
                }
                JFrame jFrame = null;
                jFrame = TXTSaveImpl.this.parentFrame != null ? TXTSaveImpl.this.parentFrame : FrameworkUtilities.getMainFrame();
                DetailMessageDlg detailMessageDlg = null;
                if (!(jFrame instanceof Window) && jFrame != null) {
                    logger.trace("In TXTSaveImpl parentFrame is not Window");
                    return;
                }
                detailMessageDlg = new DetailMessageDlg((Window)jFrame, PrintSupportor.res.getString("confirmTitle"), (Object)string3, 3, 1, (Object)string, false);
                detailMessageDlg.pack();
                int n = detailMessageDlg.confirmShow();
                if (n == 0) {
                    TXTSaveImpl.this.openFilesAfterSave(stringArray);
                }
            }
        });
    }

    private String getDetailMessage(String[] stringArray, int n) {
        if (n < 1) {
            return null;
        }
        StringBuffer stringBuffer = new StringBuffer(10);
        stringBuffer.append(PrintSupportor.res.getString("openFiles"));
        stringBuffer.append(FileUtil.lineSeparator);
        for (int i = 0; i < n - 1; ++i) {
            stringBuffer.append(stringArray[i]);
            stringBuffer.append(", ");
        }
        stringBuffer.append(stringArray[n - 1]);
        stringBuffer.append(PrintSupportor.res.getString("fullStop"));
        return stringBuffer.toString();
    }

    private int getValidFileCount(String[] stringArray) {
        int n = 0;
        for (int i = 0; i < stringArray.length; ++i) {
            if (stringArray[i] == null || stringArray[i].length() <= 0) continue;
            ++n;
        }
        return n;
    }

    public void openFilesAfterSave(final String[] stringArray) {
        Thread thread = new Thread(new Runnable(){

            @Override
            public void run() {
                String string = System.getProperty("os.name");
                if (0 <= string.indexOf("Solaris") || 0 <= string.indexOf("SunOS")) {
                    FileUtil.openFiles(stringArray, false, TXTSaveImpl.this.parentFrame);
                } else if (string.indexOf("Windows") >= 0) {
                    FileUtil.openFiles(stringArray, true, TXTSaveImpl.this.parentFrame);
                } else {
                    logger.trace("File open is not supported for this OS :" + string);
                }
            }
        });
        thread.start();
    }

    public void setSaveEncoding(String string) {
        this.saveEncoding = string;
    }

    void writeBOM(FileOutputStream fileOutputStream) {
        byte[] byArray = new byte[]{-17, -69, -65};
        try {
            fileOutputStream.write(byArray);
        }
        catch (IOException iOException) {
            logger.trace("Exception while Writing BOM" + iOException.getMessage());
        }
    }
}

