/*
 * Decompiled with CFR 0.152.
 */
package com.swimap.iview.templates.print.tools;

import com.swimap.iview.framework.securitymanagement.SecurityService;
import com.swimap.iview.framework.util.FrameworkGlobalInfo;
import com.swimap.iview.framework.util.FrameworkUtilities;
import com.swimap.iview.util.log.IviewLogger;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Enumeration;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import java.util.zip.ZipOutputStream;

class SpreadsheetWriter {
    private static IviewLogger logger = IviewLogger.getLogger(SpreadsheetWriter.class, "IVIEW");
    private static final String sheetReference = "xl/worksheets/sheet1.xml";
    private static File templateXMLFile;
    private String encoding = "UTF-8";
    private ZipOutputStream zipOutputStream;
    private int rowTracker;
    private int columnCount;
    private String xmlVersionInfo = "";

    public SpreadsheetWriter(OutputStream outputStream) throws IOException {
        this.zipOutputStream = new ZipOutputStream(outputStream);
        this.substitueTemplateXMLContent();
    }

    private void substitueTemplateXMLContent() throws IOException {
        this.createTemplateXMLFile();
        ZipFile zipFile = new ZipFile(templateXMLFile);
        Enumeration<? extends ZipEntry> enumeration = zipFile.entries();
        while (enumeration.hasMoreElements()) {
            ZipEntry zipEntry = enumeration.nextElement();
            this.zipOutputStream.putNextEntry(new ZipEntry(zipEntry.getName()));
            InputStream inputStream = zipFile.getInputStream(zipEntry);
            this.copyStream(inputStream, this.zipOutputStream);
            inputStream.close();
        }
        zipFile = null;
        this.zipOutputStream.flush();
        this.zipOutputStream.putNextEntry(new ZipEntry(sheetReference));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void createTemplateXMLFile() throws IOException {
        File file = new File(System.getProperty("java.io.tmpdir") + "iView_template_" + System.currentTimeMillis() + ".xlsx");
        if (file.exists()) {
            boolean bl = file.delete();
            logger.trace("template.xlsx file exist in tmp directory and deleted from configuration = " + bl);
        }
        file.createNewFile();
        FileOutputStream fileOutputStream = null;
        InputStream inputStream = null;
        try {
            fileOutputStream = new FileOutputStream(file);
            inputStream = SpreadsheetWriter.class.getResource("template.xlsx").openStream();
            this.copyStream(inputStream, fileOutputStream);
            fileOutputStream.flush();
        }
        finally {
            if (null != fileOutputStream) {
                try {
                    fileOutputStream.close();
                }
                catch (IOException iOException) {
                    logger.trace("Failed to close tmp o/p stream : " + iOException);
                }
            }
            if (null != inputStream) {
                try {
                    inputStream.close();
                }
                catch (IOException iOException) {
                    logger.trace("Failed to close tmp i/p stream : " + iOException);
                }
            }
        }
        templateXMLFile = file;
    }

    private void copyStream(InputStream inputStream, OutputStream outputStream) throws IOException {
        int n;
        byte[] byArray = new byte[1024];
        while ((n = inputStream.read(byArray)) >= 0) {
            outputStream.write(byArray, 0, n);
        }
    }

    public void beginSheet() throws IOException {
        this.xmlVersionInfo = "<?xml version=\"1.0\" encoding=\"UTF-8\"  standalone=\"yes\"?>\n";
        this.zipOutputStream.write((this.xmlVersionInfo + "<worksheet xmlns=\"http://" + "schemas.openxmlformats.org/spreadsheetml/2006/main\">" + "<sheetData>").getBytes(this.encoding));
    }

    public void endSheet() throws IOException {
        this.zipOutputStream.write("</sheetData></worksheet>".getBytes(this.encoding));
    }

    public void insertRow(int n) throws IOException {
        this.zipOutputStream.write(("\n<row r=\"" + (n + 1) + "\"" + " spans=\"1:" + this.columnCount + "\">").getBytes(this.encoding));
        this.rowTracker = n;
    }

    public void endRow() throws IOException {
        this.zipOutputStream.write("</row>".getBytes(this.encoding));
    }

    public void createCell(int n, String string, int n2) throws IOException {
        String string2 = this.escapeSpecialXMLChars(string);
        String string3 = SpreadsheetWriter.convertNumToColString(n) + (this.rowTracker + 1);
        StringBuilder stringBuilder = new StringBuilder("<c r=\"").append(string3).append("\" t=\"inlineStr\"");
        if (n2 != -1) {
            stringBuilder.append(" s=\"").append(n2).append("\"");
        }
        stringBuilder.append(">");
        if (string2.startsWith(" ") || string2.endsWith(" ")) {
            stringBuilder.append("<is><t xml:space=\"preserve\">");
        } else {
            stringBuilder.append("<is><t>");
        }
        stringBuilder.append(string2).append("</t></is>").append("</c>");
        this.zipOutputStream.write(stringBuilder.toString().getBytes(this.encoding));
    }

    void createCell(int n, double d, int n2) throws IOException {
        String string = SpreadsheetWriter.convertNumToColString(n) + (this.rowTracker + 1);
        StringBuilder stringBuilder = new StringBuilder("<c r=\"").append(string + "\"");
        stringBuilder.append(" s=\"").append(n2).append("\"");
        stringBuilder.append(">");
        stringBuilder.append("<v>").append(d).append("</v>");
        stringBuilder.append("</c>");
        this.zipOutputStream.write(stringBuilder.toString().getBytes());
    }

    private String escapeSpecialXMLChars(String string) {
        if (string == null) {
            return null;
        }
        boolean bl = false;
        StringBuffer stringBuffer = new StringBuffer(32);
        int n = string.length();
        for (int i = 0; i < n; ++i) {
            boolean bl2;
            char c = string.charAt(i);
            boolean bl3 = c < ' ';
            boolean bl4 = c > '~';
            boolean bl5 = bl2 = '<' == c || '&' == c || '>' == c;
            if (bl2 || bl4 || bl3) {
                stringBuffer.append("&#" + c + ";");
                bl = true;
                continue;
            }
            stringBuffer.append(c);
        }
        if (bl) {
            return stringBuffer.toString();
        }
        return string;
    }

    public void createCell(int n, String string) throws IOException {
        this.createCell(n, string, -1);
    }

    public void createCell(int n, double d) throws IOException {
        String string = SpreadsheetWriter.convertNumToColString(n) + (this.rowTracker + 1);
        StringBuilder stringBuilder = new StringBuilder("<c r=\"").append(string + "\"");
        stringBuilder.append(" s=\"").append(1).append("\"");
        stringBuilder.append(">");
        stringBuilder.append("<v>").append(d).append("</v>");
        stringBuilder.append("</c>");
        this.zipOutputStream.write(stringBuilder.toString().getBytes(this.encoding));
    }

    public static String convertNumToColString(int n) {
        int n2 = n + 1;
        String string = "";
        int n3 = n2;
        while (n3 > 0) {
            int n4 = n3 % 26;
            if (n4 == 0) {
                n4 = 26;
            }
            n3 = (n3 - n4) / 26;
            char c = (char)(n4 + 64);
            string = c + string;
        }
        return string;
    }

    public void closeWriter() throws IOException {
        try {
            this.writeDocProperties();
        }
        catch (IOException iOException) {
            logger.debug("Failed to write doc properties to .xlsx file");
            throw iOException;
        }
        finally {
            try {
                this.zipOutputStream.flush();
            }
            catch (IOException iOException) {
                logger.trace("Exception while flushing zip stream = " + iOException);
            }
            try {
                this.zipOutputStream.close();
            }
            catch (IOException iOException) {
                logger.trace("Exception while closing zip stream = " + iOException);
            }
            if (null != templateXMLFile && templateXMLFile.exists()) {
                boolean bl = templateXMLFile.delete();
                logger.trace("Temporary template file: " + templateXMLFile.getName() + " deleted = " + bl);
            }
            System.gc();
        }
    }

    private void writeDocProperties() throws IOException {
        this.zipOutputStream.putNextEntry(new ZipEntry("docProps/core.xml"));
        this.zipOutputStream.write(this.xmlVersionInfo.getBytes(this.encoding));
        this.zipOutputStream.write("<cp:coreProperties xmlns:cp=\"http://schemas.openxmlformats.org/package/2006/metadata/core-properties\" xmlns:dc=\"http://purl.org/dc/elements/1.1/\" xmlns:dcterms=\"http://purl.org/dc/terms/\" xmlns:dcmitype=\"http://purl.org/dc/dcmitype/\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"><dc:creator>".getBytes(this.encoding));
        SecurityService securityService = null;
        try {
            securityService = (SecurityService)FrameworkUtilities.getTerminalManager().getReference(FrameworkGlobalInfo.ModuleName.SECURITY_MANAGER_NAME, "");
        }
        catch (Exception exception) {
            logger.trace("Failed to get the module = " + exception);
        }
        if (null != securityService && null != securityService.getUsername()) {
            String string = this.escapeSpecialXMLChars(securityService.getUsername());
            this.zipOutputStream.write(string.getBytes(this.encoding));
        } else {
            this.zipOutputStream.write("IView".getBytes(this.encoding));
        }
        this.zipOutputStream.write("</dc:creator></cp:coreProperties>".getBytes(this.encoding));
    }

    public String getEncoding() {
        return this.encoding;
    }

    public void setEncoding(String string) {
        this.encoding = string;
    }

    public int getColumnCount() {
        return this.columnCount;
    }

    public void setColumnCount(int n) {
        this.columnCount = n;
    }
}

