/*
 * Decompiled with CFR 0.152.
 */
package com.swimap.iview.templates.print.tools;

import com.swimap.iview.commstyle.resource.ResourceMng;
import com.swimap.iview.framework.util.FrameworkUtilities;
import com.swimap.iview.templates.print.PrintServiceUI;
import com.swimap.iview.templates.print.PrintSupportor;
import com.swimap.iview.templates.print.tools.OutputTablePrintImpl;
import com.swimap.iview.templates.print.tools.TablePrintImpl;
import com.swimap.iview.templates.print.tools.TablePrintable;
import com.swimap.iview.util.OptionPane;
import com.swimap.iview.util.log.IviewLogger;
import java.awt.Font;
import java.awt.print.PageFormat;
import java.awt.print.PrinterJob;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.ResourceBundle;
import java.util.Timer;
import java.util.TimerTask;
import javax.print.DocFlavor;
import javax.print.PrintService;
import javax.print.PrintServiceLookup;
import javax.print.attribute.HashPrintRequestAttributeSet;
import javax.print.attribute.PrintRequestAttributeSet;
import javax.swing.JFrame;

public class RealTimePrintControler {
    private static IviewLogger logger = IviewLogger.getLogger(RealTimePrintControler.class, "IVIEW");
    private static ResourceBundle res = ResourceMng.getInstance().getResourceBundleFromPropertyFile("mainfrm/iview/templates/print/Res");
    private String[] tableHeaders = null;
    private static final int ONE_SECOND = 1000;
    private static final int TWO_MINUTES_TO_SECOND = 120;
    private int timeOutValue = 120000;
    private static final int POINT_X_OR_Y = 100;
    private static final int DEFAULT_LENGTH = 15;
    private static final int THIRTY = 30;
    private TimeOutThread timeOutTask = null;
    private Timer timeOutTimer = null;
    private TimeOutThreadForFirst timeOutThreadForFirst = null;
    private boolean taskOver = false;
    private PrinterJob printerJob = null;
    private DocFlavor docFlavor = DocFlavor.SERVICE_FORMATTED.PAGEABLE;
    private PrintRequestAttributeSet attributeSet = new HashPrintRequestAttributeSet();
    private LinkedList leftSourceData = new LinkedList();
    private final Object lock = new Object();
    private PageFormat pageFormat = null;
    private boolean bFirst = true;
    private LinkedList tempDataForFirst = new LinkedList();
    private int[] columnWidthProportion = null;
    private boolean printOutputInfo = false;
    private Font dataFont = new Font("Dialog", 0, 8);
    private int realTimePageIndex = 0;
    private boolean headInfoEnabled = false;
    private String title = "";
    private String userName = "";
    private String summary = "";

    public RealTimePrintControler() {
    }

    public RealTimePrintControler(String[] stringArray) {
        this.tableHeaders = stringArray;
    }

    public RealTimePrintControler(String[] stringArray, int n) {
        this.tableHeaders = stringArray;
        this.timeOutValue = n;
    }

    public RealTimePrintControler(String[] stringArray, int[] nArray, int n) {
        this.tableHeaders = stringArray;
        this.timeOutValue = n;
        this.columnWidthProportion = nArray;
    }

    private void setHeadInfoEnabled(boolean bl) {
        this.headInfoEnabled = bl;
    }

    public boolean getHeadInfoEnabled() {
        return this.headInfoEnabled;
    }

    public void setRealTimePageIndex(int n) {
        this.realTimePageIndex = n;
    }

    public int getRealTimePageIndex() {
        return this.realTimePageIndex;
    }

    public boolean isBFirst() {
        return this.bFirst;
    }

    public void setHeadInfo(String string, String string2, String string3) {
        this.title = string;
        this.userName = string2;
        this.summary = string3;
        this.setHeadInfoEnabled(true);
    }

    private TablePrintable tablePrintableMaker(Collection collection) {
        TablePrintable tablePrintable = null;
        tablePrintable = new TablePrintable(this.title, this.userName, this.summary, this.tableHeaders, this.columnWidthProportion, collection, collection.size(), false);
        tablePrintable.setRealTimePrintControler(this);
        tablePrintable.setRealTimePageIndex(this.realTimePageIndex);
        return tablePrintable;
    }

    public boolean startRealTimePrintJob() {
        Object object;
        JFrame jFrame = FrameworkUtilities.getMainFrame();
        this.printerJob = PrinterJob.getPrinterJob();
        Object object2 = null;
        try {
            object2 = PrintServiceLookup.lookupPrintServices(this.docFlavor, this.attributeSet);
        }
        catch (Exception exception) {
            logger.trace(exception.getMessage(), exception);
            OptionPane.showMessageDialog(jFrame, res.getString("ZeroPrinter"));
            return false;
        }
        int n = ((PrintService[])object2).length;
        for (int i = 0; i < ((PrintService[])object2).length; ++i) {
            if (object2[i].getClass().toString().indexOf("sun.print.Win32PrintService") == -1) continue;
            try {
                Class<?> clazz = object2[i].getClass();
                try {
                    object = clazz.getDeclaredMethod("getPort", null);
                    ((Method)object).setAccessible(true);
                    ((Method)object).invoke((Object)object2[i], (Object[])null);
                }
                catch (Exception exception) {
                    logger.trace("PrintSupportor:No getPort() method");
                }
                object = clazz.getDeclaredField("port");
                ((Field)object).setAccessible(true);
                if (!((Field)object).get(object2[i]).equals("Microsoft Document Imaging Writer Port:") && !"Microsoft Office Document Image Writer".equals(object2[i].getName())) continue;
                object2[i] = null;
                --n;
                continue;
            }
            catch (Exception exception) {
                logger.trace(exception.getMessage(), exception);
            }
        }
        PrintService printService = PrintServiceLookup.lookupDefaultPrintService();
        int n2 = n - 1;
        object = new PrintService[n];
        int n3 = 0;
        for (int i = 0; i < ((PrintService[])object2).length; ++i) {
            if (object2[i] == null) continue;
            object[n3] = object2[i];
            if (((Object)object2[i]).equals(printService)) {
                n2 = n3;
            }
            ++n3;
        }
        object2 = object;
        if (((PrintService[])object2).length == 0) {
            logger.trace("RealTimePrintControler || printServices.length == 0");
            OptionPane.showMessageDialog(jFrame, res.getString("ZeroPrinter"));
            return false;
        }
        PrintService printService2 = null;
        try {
            printService2 = PrintServiceUI.printDialog(null, 100, 100, object2, object2[n2], this.docFlavor, this.attributeSet, jFrame);
            if (printService2 == null) {
                return false;
            }
            this.printerJob.setPrintService(printService2);
            PrintSupportor.modifyAttributeSet(this.attributeSet);
        }
        catch (Exception exception) {
            logger.trace(exception.getMessage(), exception);
            OptionPane.showMessageDialog(jFrame, res.getString("ZeroPrinter"));
            return false;
        }
        this.timeOutTimer = new Timer();
        this.timeOutTask = new TimeOutThread();
        this.timeOutTimer.schedule((TimerTask)this.timeOutTask, this.timeOutValue, (long)this.timeOutValue);
        return true;
    }

    public void endReadTimePrintJob() {
        this.taskOver = true;
        if (this.timeOutTimer != null) {
            this.timeOutTimer.cancel();
            this.timeOutTimer = null;
            this.timeOutTask = null;
        }
    }

    public void setTableHeaders(String[] stringArray) {
        this.tableHeaders = stringArray;
    }

    public boolean isReady() {
        return !this.taskOver;
    }

    public void setPrintOutputInfo(boolean bl) {
        this.printOutputInfo = bl;
    }

    public boolean isPrintOutputInfo() {
        return this.printOutputInfo;
    }

    public void setDataFont(Font font) {
        this.dataFont = font;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void append(Collection collection) {
        if (!this.taskOver) {
            Object object = this.lock;
            synchronized (object) {
                if (this.timeOutTimer != null) {
                    this.timeOutTimer.cancel();
                    this.timeOutTimer = new Timer();
                    this.timeOutTask = new TimeOutThread();
                    this.timeOutTimer.schedule((TimerTask)this.timeOutTask, this.timeOutValue, (long)this.timeOutValue);
                }
                if (this.bFirst) {
                    this.tempDataForFirst.addAll(collection);
                    if (this.tempDataForFirst.size() > 15) {
                        this.leftSourceData = this.print(this.tempDataForFirst);
                        this.bFirst = false;
                        return;
                    }
                    if (this.timeOutThreadForFirst == null) {
                        this.timeOutThreadForFirst = new TimeOutThreadForFirst();
                        this.timeOutThreadForFirst.start();
                    }
                    return;
                }
                this.leftSourceData.addAll(collection);
                TablePrintable tablePrintable = this.tablePrintableMaker(this.leftSourceData);
                tablePrintable.getFormatCalculator().setDataFont(this.dataFont);
                tablePrintable.getFormatCalculator().setPageFormatWithCompute(this.pageFormat);
                int n = tablePrintable.getFormatCalculator().getLastPageRowCount();
                if (n < this.leftSourceData.size()) {
                    LinkedList linkedList = new LinkedList();
                    int n2 = this.leftSourceData.size() - n;
                    Iterator iterator = this.leftSourceData.iterator();
                    for (int i = 0; i < n2; ++i) {
                        linkedList.add(iterator.next());
                        iterator.remove();
                    }
                    this.print(linkedList);
                }
            }
        } else {
            logger.trace("In RealTimePrintController endReadTimePrint is already called");
        }
    }

    private LinkedList print(Collection collection) {
        TablePrintable tablePrintable = this.tablePrintableMaker(collection);
        TablePrintImpl tablePrintImpl = null;
        tablePrintImpl = this.printOutputInfo ? new OutputTablePrintImpl(true, tablePrintable.getFormatCalculator()) : new TablePrintImpl(true, tablePrintable.getFormatCalculator());
        tablePrintImpl.setDataFont(this.dataFont);
        if (!this.bFirst) {
            tablePrintable.getFormatCalculator().setPageFormatWithCompute(this.pageFormat);
        }
        tablePrintImpl.setBFirstForRealTimePrint(this.bFirst);
        this.printerJob.setPrintable(tablePrintImpl);
        try {
            this.printerJob.print(this.attributeSet);
            if (tablePrintable.getFormatCalculator().getHeaderError()) {
                logger.trace("HeaderError");
                this.endReadTimePrintJob();
                return null;
            }
        }
        catch (Exception exception) {
            logger.trace(exception.getMessage(), exception);
        }
        if (this.bFirst) {
            this.pageFormat = tablePrintable.getFormatCalculator().getPageFormat();
            return tablePrintImpl.getLastPageDataForFirstRealTimePrint();
        }
        return null;
    }

    private class TimeOutThreadForFirst
    extends Thread {
        private TimeOutThreadForFirst() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            int n = 0;
            while (n < 30) {
                ++n;
                try {
                    Thread.sleep(1000L);
                }
                catch (InterruptedException interruptedException) {
                    logger.trace(interruptedException.getMessage(), interruptedException);
                }
            }
            Object object = RealTimePrintControler.this.lock;
            synchronized (object) {
                if (RealTimePrintControler.this.bFirst) {
                    RealTimePrintControler.this.leftSourceData = RealTimePrintControler.this.print(RealTimePrintControler.this.tempDataForFirst);
                    RealTimePrintControler.this.bFirst = false;
                }
            }
        }
    }

    private class TimeOutThread
    extends TimerTask {
        private TimeOutThread() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            Object object = RealTimePrintControler.this.lock;
            synchronized (object) {
                if (RealTimePrintControler.this.leftSourceData.size() != 0) {
                    RealTimePrintControler.this.print(RealTimePrintControler.this.leftSourceData);
                    RealTimePrintControler.this.leftSourceData.clear();
                }
            }
        }
    }
}

